/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.shift;

import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.DirectoryOperation;
import com.sshtools.j2ssh.FileTransferProgress;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.TransferCancelledException;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.shift.FileTransferDialog_cancel_actionAdapter;
import com.sshtools.shift.ShiftSessionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class FileTransferDialog
extends JFrame
implements FileTransferProgress {
    boolean cancelled = false;
    boolean completed = false;
    long lastUpdate = System.currentTimeMillis();
    long bytesTransfered = 0L;
    long currentTime;
    long elaspedTime;
    double transfer;
    long fileSize = 0L;
    long bytesSoFar = 0L;
    long completedTransfers = 0L;
    int filesTransfered = 0;
    long totalBytes;
    JPanel mainPanel = new JPanel();
    JPanel informationPanel = new JPanel();
    JLabel lblEstimatedTime = new JLabel();
    JLabel lblTargetAction = new JLabel();
    JLabel lblTransferRate = new JLabel();
    JLabel lblTimeLeftValue = new JLabel();
    JLabel lblTargetValue = new JLabel();
    JLabel lblPathValue = new JLabel();
    JLabel lblTransferRateValue = new JLabel();
    JLabel lblAction = new JLabel("Saving:");
    JButton btnCancel = new JButton();
    JProgressBar progressbar = new JProgressBar();
    JCheckBox chkClose = new JCheckBox();
    Object lock = new Object();
    NumberFormat formatMb = NumberFormat.getNumberInstance();
    NumberFormat formatKb = NumberFormat.getNumberInstance();
    NumberFormat formatKb1 = NumberFormat.getNumberInstance();
    Timer lblTimeLeftValuer;
    String formattedTotal = "";
    String title;
    List files;
    List dirs;
    SftpClient sftp;
    String source;
    DirectoryOperation op;

    public FileTransferDialog(Frame frame, String title, int fileCount) {
        super("0% Complete - " + title);
        this.setIconImage(ShiftSessionPanel.FILE_BROWSER_ICON.getImage());
        this.title = title;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (FileTransferDialog.this.cancelled || FileTransferDialog.this.completed) {
                    FileTransferDialog.this.setVisible(false);
                } else if (JOptionPane.showConfirmDialog(FileTransferDialog.this, "Cancel the file operation(s)?", "Close Window", 0, 0) == 0) {
                    FileTransferDialog.this.cancelOperation();
                    FileTransferDialog.this.hide();
                }
            }
        });
    }

    public FileTransferDialog() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void notifyWaiting() {
        this.notifyAll();
    }

    public synchronized void waitForCompletion() throws InterruptedException {
        while (this.isVisible() && !this.cancelled) {
            this.wait(5000L);
        }
    }

    public synchronized void cancelOperation() {
        this.cancelled = true;
        this.setVisible(false);
        this.notifyAll();
    }

    public void putFiles(SftpClient sftp, final File localdir, final List files) throws IOException {
        this.files = files;
        this.sftp = sftp;
        this.totalBytes = 0L;
        this.lblTargetAction.setText("Uploading to:");
        for (int i = 0; i < files.size(); ++i) {
            File f = new File(localdir, (String)files.get(i));
            this.totalBytes += f.length();
        }
        this.progressbar.setMaximum((int)this.totalBytes / 1024);
        this.formattedTotal = this.totalBytes / 0x100000L > 0L ? this.formatMb.format((double)this.totalBytes / 1048576.0) + " MB" : this.formatKb.format((double)this.totalBytes / 1024.0) + " KB";
        sftp.lcd(localdir.getAbsolutePath());
        Thread thread = new Thread(new Runnable(){

            public void run() {
                block3: {
                    try {
                        for (int i = 0; i < FileTransferDialog.this.files.size(); ++i) {
                            FileTransferDialog.this.setSource(localdir.getAbsolutePath() + File.separator + files.get(i));
                            FileTransferDialog.this.setTarget(FileTransferDialog.this.sftp.pwd() + "/" + FileTransferDialog.this.files.get(i));
                            FileTransferDialog.this.sftp.put((String)FileTransferDialog.this.files.get(i), FileTransferDialog.this);
                        }
                        FileTransferDialog.this.notifyWaiting();
                    }
                    catch (IOException ex) {
                        if (FileTransferDialog.this.cancelled) break block3;
                        SshToolsApplicationPanel.showErrorMessage(FileTransferDialog.this, "The file operation failed!\n" + ex.getMessage(), "File Transfer", ex);
                        FileTransferDialog.this.setVisible(false);
                    }
                }
            }
        });
        thread.start();
        this.setVisible(true);
    }

    public void copyLocalDirectory(final SftpClient sftp, final List localfiles, final List localdirs, final String remotedir, final boolean recurse, final boolean sync) throws IOException {
        this.sftp = sftp;
        this.dirs = localdirs;
        this.files = localfiles;
        this.lblTargetAction.setText("Uploading to:");
        this.lblAction.setText(sync ? "Synchronizing Directory:" : "Copying Directory:");
        this.lblPathValue.setText("Gathering file information from remote server");
        this.show();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    int i;
                    File f;
                    int i2;
                    for (i2 = 0; i2 < localfiles.size(); ++i2) {
                        f = (File)localfiles.get(i2);
                        FileTransferDialog.this.totalBytes += f.length();
                    }
                    FileTransferDialog.this.op = new DirectoryOperation();
                    for (i2 = 0; i2 < localdirs.size(); ++i2) {
                        f = (File)localdirs.get(i2);
                        FileTransferDialog.this.op.addDirectoryOperation(sftp.copyLocalDirectory(f.getAbsolutePath(), remotedir, recurse, sync, false, null), remotedir + (remotedir.endsWith("/") ? "" : "/") + f.getName());
                    }
                    FileTransferDialog.this.totalBytes += FileTransferDialog.this.op.getTransferSize();
                    FileTransferDialog.this.progressbar.setMaximum((int)FileTransferDialog.this.totalBytes / 1024);
                    FileTransferDialog.this.formattedTotal = FileTransferDialog.this.totalBytes / 0x100000L > 0L ? FileTransferDialog.this.formatMb.format((double)FileTransferDialog.this.totalBytes / 1048576.0) + " MB" : FileTransferDialog.this.formatKb.format((double)FileTransferDialog.this.totalBytes / 1024.0) + " KB";
                    for (i = 0; i < localdirs.size(); ++i) {
                        f = (File)localdirs.get(i);
                        FileTransferDialog.this.setSource(f.getAbsolutePath());
                        FileTransferDialog.this.setTarget(remotedir + (remotedir.endsWith("/") ? "" : "/") + f.getName());
                        sftp.copyLocalDirectory(f.getAbsolutePath(), remotedir, recurse, sync, true, FileTransferDialog.this);
                    }
                    for (i = 0; i < localfiles.size(); ++i) {
                        f = (File)localfiles.get(i);
                        FileTransferDialog.this.setSource(f.getAbsolutePath());
                        FileTransferDialog.this.setTarget(remotedir + (remotedir.endsWith("/") ? "" : "/") + f.getName());
                        sftp.put(f.getAbsolutePath(), remotedir + (remotedir.endsWith("/") ? "" : "/") + f.getName(), (FileTransferProgress)FileTransferDialog.this);
                    }
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (TransferCancelledException e) {
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (IOException ex) {
                    SshToolsApplicationPanel.showErrorMessage(FileTransferDialog.this, "An error occurred", "Copy Directories", ex);
                }
            }
        }, "Copying Directory");
        thread.start();
    }

    public void copyRemoteDirectory(final SftpClient sftp, final List remotedirs, final List remotefiles, final String localdir, final boolean recurse, final boolean sync) throws IOException {
        this.sftp = sftp;
        this.dirs = remotedirs;
        this.files = remotefiles;
        this.lblTargetAction.setText("Downloading to:");
        this.lblAction.setText(sync ? "Synchronizing Directory:" : "Copying Directory:");
        this.lblPathValue.setText("Gathering file information from remote server");
        this.show();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    int i;
                    int i2;
                    for (i2 = 0; i2 < remotefiles.size(); ++i2) {
                        FileAttributes attrs = sftp.stat((String)remotefiles.get(i2));
                        FileTransferDialog.this.totalBytes += attrs.getSize().longValue();
                    }
                    FileTransferDialog.this.op = new DirectoryOperation();
                    for (i2 = 0; i2 < remotedirs.size(); ++i2) {
                        FileTransferDialog.this.op.addDirectoryOperation(sftp.copyRemoteDirectory((String)remotedirs.get(i2), localdir, recurse, sync, false, null), new File(localdir));
                    }
                    FileTransferDialog.this.totalBytes += FileTransferDialog.this.op.getTransferSize();
                    FileTransferDialog.this.progressbar.setMaximum((int)FileTransferDialog.this.totalBytes / 1024);
                    FileTransferDialog.this.formattedTotal = FileTransferDialog.this.totalBytes / 0x100000L > 0L ? FileTransferDialog.this.formatMb.format((double)FileTransferDialog.this.totalBytes / 1048576.0) + " MB" : FileTransferDialog.this.formatKb.format((double)FileTransferDialog.this.totalBytes / 1024.0) + " KB";
                    for (i = 0; i < remotedirs.size(); ++i) {
                        String s = (String)remotedirs.get(i);
                        FileTransferDialog.this.setSource(FileTransferDialog.this.sftp.pwd() + "/" + s);
                        FileTransferDialog.this.setTarget(localdir + File.separator + s);
                        sftp.copyRemoteDirectory(s, localdir, recurse, sync, true, FileTransferDialog.this);
                    }
                    for (i = 0; i < remotefiles.size(); ++i) {
                        String s = (String)remotefiles.get(i);
                        FileTransferDialog.this.setSource(FileTransferDialog.this.sftp.pwd() + "/" + s);
                        FileTransferDialog.this.setTarget(localdir + File.separator + s);
                        sftp.get(s, FileTransferDialog.this);
                    }
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (TransferCancelledException e) {
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (IOException ex) {
                    SshToolsApplicationPanel.showErrorMessage(FileTransferDialog.this, "An error occurred", "Copy Directories", ex);
                }
            }
        }, "Copying Directory");
        thread.start();
    }

    public void getRemoteFiles(SftpClient sftp, List files, long totalBytes) {
        this.files = files;
        this.totalBytes = totalBytes;
        this.sftp = sftp;
        this.lblTargetAction.setText("Downloading to:");
        this.progressbar.setMaximum((int)totalBytes / 1024);
        this.formattedTotal = totalBytes / 0x100000L > 0L ? this.formatMb.format((double)totalBytes / 1048576.0) + " MB" : this.formatKb.format((double)totalBytes / 1024.0) + " KB";
        Thread thread = new Thread(new Runnable(){
            int i;

            public void run() {
                try {
                    this.i = 0;
                    while (this.i < FileTransferDialog.this.files.size()) {
                        File file = new File(FileTransferDialog.this.sftp.lpwd() + File.separator + FileTransferDialog.this.files.get(this.i));
                        if (file.exists()) {
                            int result = JOptionPane.showConfirmDialog(FileTransferDialog.this, "This file already exists are you sure you wish to overwrite?\n\n" + file.getName(), "Confirm File Overwrite", 1);
                            if (result == 1) {
                                if (this.i == FileTransferDialog.this.files.size() - 1) {
                                    FileTransferDialog.this.cancelOperation();
                                } else {
                                    ++this.i;
                                }
                            }
                            if (result == 2) {
                                FileTransferDialog.this.cancelOperation();
                            }
                        }
                        FileTransferDialog.this.setSource(FileTransferDialog.this.sftp.pwd() + "/" + FileTransferDialog.this.files.get(this.i));
                        FileTransferDialog.this.setTarget(FileTransferDialog.this.sftp.lpwd() + File.separator + FileTransferDialog.this.files.get(this.i));
                        if (!FileTransferDialog.this.cancelled) {
                            FileTransferDialog.this.sftp.get((String)FileTransferDialog.this.files.get(this.i), FileTransferDialog.this);
                        }
                        ++this.i;
                    }
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (IOException ex) {
                    File file;
                    if (!FileTransferDialog.this.cancelled) {
                        SshToolsApplicationPanel.showErrorMessage(FileTransferDialog.this, "The file operation failed!\n" + ex.getMessage(), "File Transfer", ex);
                    }
                    if ((file = new File(FileTransferDialog.this.sftp.lpwd() + File.separator + FileTransferDialog.this.files.get(this.i))).exists()) {
                        file.delete();
                    }
                    FileTransferDialog.this.setVisible(false);
                }
            }
        });
        thread.start();
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.progressbar.setToolTipText("");
        this.progressbar.setValue(0);
        try {
            Method m = this.progressbar.getClass().getMethod("setIndeterminate", Boolean.TYPE);
            Object[] args = new Object[]{new Boolean(true)};
            m.invoke((Object)this.progressbar, args);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        this.progressbar.setBounds(new Rectangle(8, 45, 336, 22));
        this.lblEstimatedTime.setText("Estimated time left: ");
        this.lblEstimatedTime.setBounds(new Rectangle(8, 74, 114, 17));
        this.lblTimeLeftValue.setText("");
        this.lblTimeLeftValue.setBounds(new Rectangle(109, 74, 235, 17));
        this.lblTargetAction.setText("Downloading to:");
        this.lblTargetAction.setBounds(new Rectangle(8, 92, 96, 17));
        this.lblTargetValue.setText("");
        this.lblTargetValue.setBounds(new Rectangle(109, 92, 235, 17));
        this.lblTransferRate.setText("Transfer rate: ");
        this.lblTransferRate.setBounds(new Rectangle(8, 110, 96, 17));
        this.lblTransferRateValue.setText("");
        this.lblTransferRateValue.setBounds(new Rectangle(109, 110, 235, 17));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new FileTransferDialog_cancel_actionAdapter(this));
        this.chkClose.setText("Close this window when the transfer completes");
        this.chkClose.setBounds(new Rectangle(8, 132, 307, 18));
        this.chkClose.setSelected(true);
        JPanel p = new JPanel(null);
        this.lblAction.setBounds(new Rectangle(9, 5, 334, 21));
        this.lblPathValue.setText("");
        this.lblPathValue.setBounds(new Rectangle(10, 22, 329, 22));
        p.add(this.progressbar);
        p.add(this.lblEstimatedTime);
        p.add(this.lblTimeLeftValue);
        p.add(this.lblTargetAction);
        p.add(this.lblTransferRate);
        p.add(this.lblTransferRateValue);
        p.add(this.lblTargetValue);
        p.add(this.lblAction);
        p.add(this.lblPathValue);
        p.add(this.chkClose);
        JPanel b = new JPanel(new FlowLayout(2));
        b.add(this.btnCancel);
        p.setMaximumSize(new Dimension(350, 185));
        p.setMinimumSize(new Dimension(350, 185));
        p.setPreferredSize(new Dimension(350, 185));
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)b, "South");
        this.elaspedTime = 0L;
        this.formatMb.setMaximumFractionDigits(2);
        this.formatKb.setMaximumFractionDigits(0);
        this.formatKb1.setMaximumFractionDigits(1);
        this.setResizable(true);
        this.setSize(new Dimension(350, 184));
        UIUtil.positionComponent(0, this);
    }

    public void setTarget(String lblTargetValue) {
        this.lblTargetValue.setText(lblTargetValue);
        this.lblTargetValue.setToolTipText(lblTargetValue);
    }

    public static void main(String[] args) {
        FileTransferDialog dialog = new FileTransferDialog();
        dialog.show();
    }

    public void setSource(String lblTargetValue) {
        this.source = lblTargetValue;
    }

    private int getFileCount() {
        return (this.files == null ? 0 : this.files.size()) + (this.op == null ? 0 : this.op.getFileCount());
    }

    public void started(long fileSize, String from) {
        try {
            Method m = this.progressbar.getClass().getMethod("setIndeterminate", Boolean.TYPE);
            Object[] args = new Object[]{new Boolean(false)};
            m.invoke((Object)this.progressbar, args);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        String str = this.source + (this.getFileCount() <= 1 ? "" : " (" + String.valueOf(this.filesTransfered + 1) + " of " + String.valueOf(this.getFileCount()) + " files)");
        this.lblPathValue.setText(str);
        this.lastUpdate = System.currentTimeMillis();
        this.fileSize = fileSize;
        this.lblTimeLeftValuer = new Timer(1000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                Object object = FileTransferDialog.this.lock;
                synchronized (object) {
                    FileTransferDialog.this.transfer = FileTransferDialog.this.elaspedTime < 1000L ? (double)(FileTransferDialog.this.bytesSoFar + FileTransferDialog.this.completedTransfers) : (double)((FileTransferDialog.this.bytesSoFar + FileTransferDialog.this.completedTransfers) / (FileTransferDialog.this.elaspedTime / 1000L));
                    FileTransferDialog.this.lblTransferRateValue.setText(FileTransferDialog.this.formatKb1.format(FileTransferDialog.this.transfer / 1024.0) + " KB/Sec");
                    long bytesLeft = FileTransferDialog.this.totalBytes - (FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar);
                    long secondsLeft = (long)((double)bytesLeft / FileTransferDialog.this.transfer);
                    FileTransferDialog.this.setTitle(FileTransferDialog.this.formatKb.format((double)(FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar) / (double)FileTransferDialog.this.totalBytes * 100.0) + "% Complete - " + FileTransferDialog.this.title);
                    String estimatedTime = secondsLeft < 60L ? String.valueOf(secondsLeft) + " sec" : (secondsLeft < 3600L ? String.valueOf(secondsLeft / 60L) + " min " + String.valueOf(secondsLeft % 60L) + " sec" : String.valueOf(secondsLeft / 3600L) + " hrs " + String.valueOf(secondsLeft % 3600L / 60L) + " min " + String.valueOf(secondsLeft % 3600L % 60L) + " sec");
                    if (FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar / 0x100000L > 0L) {
                        FileTransferDialog.this.lblTimeLeftValue.setText(estimatedTime + " (" + FileTransferDialog.this.formatMb.format((double)(FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar) / 1048576.0) + " MB of " + FileTransferDialog.this.formattedTotal + " copied)");
                    } else {
                        FileTransferDialog.this.lblTimeLeftValue.setText(estimatedTime + " (" + FileTransferDialog.this.formatKb.format((double)(FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar) / 1024.0) + " KB of " + FileTransferDialog.this.formattedTotal + " copied)");
                    }
                }
            }
        });
        this.lblTimeLeftValuer.start();
    }

    public boolean isCancelled() {
        if (this.cancelled) {
            this.setVisible(false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressed(long bytesSoFar) {
        Object object = this.lock;
        synchronized (object) {
            this.bytesSoFar = bytesSoFar;
        }
        this.progressbar.setValue((int)(this.completedTransfers + this.bytesSoFar) / 1024);
        this.currentTime = System.currentTimeMillis();
        this.elaspedTime += this.currentTime - this.lastUpdate;
        this.lastUpdate = this.currentTime;
    }

    public void completed() {
        ++this.filesTransfered;
        this.completedTransfers += this.bytesSoFar;
        this.bytesSoFar = 0L;
        if (this.getFileCount() == this.filesTransfered) {
            this.setTitle("100% Complete - " + this.title);
            this.lblTimeLeftValue.setText("Completed (" + this.formattedTotal + " of " + this.formattedTotal + " copied)");
            this.btnCancel.setText("Close");
            this.lblTimeLeftValuer.stop();
            this.completed = true;
            if (this.chkClose.isSelected()) {
                this.setVisible(false);
            }
        }
    }

    void cancel_actionPerformed(ActionEvent e) {
        if (this.btnCancel.getText().equals("Cancel")) {
            this.cancelled = true;
        } else {
            this.setVisible(false);
        }
    }
}

