/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.XmlConfigurationContext;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.sshterm.SshTermFrame;
import com.sshtools.sshterm.SshTermOptionsTab;
import com.sshtools.sshterm.SshTerminalPanel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class SshTerm
extends SshToolsApplication {
    public static File PREF_DIR;
    protected OptionsTab[] additionalOptions;

    public SshTerm() {
        this(SshTermFrame.class);
    }

    public SshTerm(Class containerClass) {
        super(SshTerminalPanel.class, containerClass);
    }

    public void exit() {
        super.exit();
    }

    public String getApplicationName() {
        return "SSHTerm";
    }

    public String getApplicationVersion() {
        return "sshterm.properties";
    }

    public Icon getApplicationLargeIcon() {
        return new ResourceIcon("/com/sshtools/sshterm/largessh.png");
    }

    public String getAboutLicenseDetails() {
        return "SshTerm is licensed under the GPL (http://www.gnu.org/licenses)\n";
    }

    public String getAboutURL() {
        return "http://www.sshtools.com";
    }

    public File getApplicationPreferencesDirectory() {
        return PREF_DIR;
    }

    public String getAboutAuthors() {
        return "Lee David Painter\nRichard Pernavas\nBrett Smith";
    }

    public void init(String[] args) throws SshToolsApplicationException {
        super.init(args);
        try {
            this.addAdditionalOptionsTab(new SshTermOptionsTab());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void main(String[] args) {
        try {
            if (System.getProperty("log4j.properties") != null) {
                try {
                    Properties properties = new Properties();
                    properties.load(ConfigurationLoader.loadFile(System.getProperty("log4j.properties")));
                    try {
                        Class<?> cls = Class.forName("org.apache.log4j.PropertyConfigurator");
                        Object obj = cls.newInstance();
                        Method method = cls.getMethod("configure", Properties.class);
                        method.invoke(obj, properties);
                    }
                    catch (Throwable ex) {
                    }
                }
                catch (IOException ex) {
                    SshTerm.configureBasicLogging();
                }
            } else {
                SshTerm.configureBasicLogging();
            }
            XmlConfigurationContext context = new XmlConfigurationContext();
            context.setAutomationConfigurationResource("automation.xml");
            context.setFailOnError(false);
            ConfigurationLoader.initialize(false, context);
            SshTerm term = new SshTerm();
            term.init(args);
            term.newContainer();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            System.exit(0);
        }
    }

    private static void configureBasicLogging() {
        try {
            Class<?> cls = Class.forName("org.apache.log4j.BasicConfigurator");
            Method method = cls.getMethod("configure", null);
            method.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        String val = ConfigurationLoader.checkAndGetProperty("user.home", null);
        if (val != null) {
            PREF_DIR = new File(val + File.separator + ".sshterm");
        }
    }
}

