/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshTermCommandTab
extends JPanel
implements SshToolsConnectionTab {
    public static final String COMMANDS_ICON = "/com/sshtools/common/ui/commands.png";
    protected JCheckBox requestPseudoTerminal = new JCheckBox("Don't allocate a pseudo terminal");
    protected JCheckBox disconnectOnSessionClose = new JCheckBox("Disconnect when session is closed");
    protected JLabel onceAuthenticated = new JLabel("Once authenticated..");
    protected JRadioButton doNothing = new JRadioButton("Do nothing");
    protected JRadioButton startShell = new JRadioButton("Start the user's shell");
    protected JRadioButton executeCommands = new JRadioButton("Execute the following commands:");
    protected ButtonGroup group = new ButtonGroup();
    protected JTextArea commands = new JTextArea();
    protected SshToolsConnectionProfile profile;
    protected Log log = LogFactory.getLog(SshTermCommandTab.class);

    public SshTermCommandTab() {
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(0, 2, 2, 2);
        Insets ins2 = new Insets(2, 24, 2, 2);
        gbc.weightx = 1.0;
        this.requestPseudoTerminal.getModel().setSelected(false);
        this.disconnectOnSessionClose.getModel().setSelected(true);
        UIUtil.jGridBagAdd(main, this.requestPseudoTerminal, gbc, 0);
        UIUtil.jGridBagAdd(main, this.disconnectOnSessionClose, gbc, 0);
        UIUtil.jGridBagAdd(main, new JSeparator(0), gbc, 0);
        UIUtil.jGridBagAdd(main, this.onceAuthenticated, gbc, 0);
        this.group.add(this.doNothing);
        this.group.add(this.startShell);
        this.group.add(this.executeCommands);
        this.startShell.setSelected(true);
        UIUtil.jGridBagAdd(main, this.doNothing, gbc, 0);
        UIUtil.jGridBagAdd(main, this.startShell, gbc, 0);
        UIUtil.jGridBagAdd(main, this.executeCommands, gbc, 0);
        gbc.fill = 1;
        gbc.insets = ins2;
        gbc.weighty = 1.0;
        this.commands.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane scroll = new JScrollPane(this.commands);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(30);
        UIUtil.jGridBagAdd(main, scroll, gbc, 0);
        IconWrapperPanel iconProxyDetailsPanel = new IconWrapperPanel(new ResourceIcon(COMMANDS_ICON), main);
        this.commands.setRows(8);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        this.add((Component)iconProxyDetailsPanel, "North");
    }

    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        this.requestPseudoTerminal.getModel().setSelected(!profile.requiresPseudoTerminal());
        this.disconnectOnSessionClose.getModel().setSelected(profile.disconnectOnSessionClose());
        if (profile.getOnceAuthenticatedCommand() == 1) {
            this.doNothing.setSelected(true);
        } else if (profile.getOnceAuthenticatedCommand() == 3) {
            this.executeCommands.setSelected(true);
            this.commands.setText(profile.getCommandsToExecute());
        } else {
            this.startShell.setSelected(true);
        }
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Commands";
    }

    public String getTabToolTipText() {
        return "Configure the commands to be executed";
    }

    public int getTabMnemonic() {
        return 112;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        this.profile.setRequiresPseudoTerminal(!this.requestPseudoTerminal.getModel().isSelected());
        if (!this.doNothing.isSelected()) {
            this.profile.setDisconnectOnSessionClose(this.disconnectOnSessionClose.getModel().isSelected());
        } else {
            this.profile.setDisconnectOnSessionClose(false);
        }
        if (this.doNothing.isSelected()) {
            this.profile.setOnceAuthenticatedCommand(1);
        } else if (this.executeCommands.isSelected()) {
            this.profile.setOnceAuthenticatedCommand(3);
            this.profile.setCommandsToExecute(this.commands.getText());
        } else {
            this.profile.setOnceAuthenticatedCommand(2);
        }
    }

    public void tabSelected() {
    }
}

