/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.ColorComboBox;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SshTermTerminalTab
extends JPanel
implements SshToolsConnectionTab,
ActionListener {
    static final String DEFAULT = "<Default>";
    static final String TERM_ICON = "/com/sshtools/sshterm/largeterminal.png";
    protected SshToolsConnectionProfile profile;
    protected JComboBox jComboTerm = new JComboBox();
    protected JComboBox jComboResizeStrategy = new JComboBox<String>(new String[]{"None", "Font", "Screen"});
    protected JComboBox jComboEOL = new JComboBox<String>(new String[]{"Default", "CR+LF", "CR"});
    protected JComboBox jComboScreenSize = new JComboBox<String>(new String[]{"640x480", "800x600", "1024x768"});
    protected JComboBox fontSize = new JComboBox<String>(new String[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "16", "18", "20", "22", "24", "26", "28", "32", "36", "40", "48", "56", "64", "8", "72"});
    protected JCheckBox antialias = new JCheckBox("Antialias (may be slow)");
    protected ColorComboBox backgroundColor = new ColorComboBox();
    protected ColorComboBox foregroundColor = new ColorComboBox();
    protected JLabel fontLabel;
    protected JCheckBox colorPrinting = new JCheckBox("Color printing");

    public SshTermTerminalTab() {
        Insets ins = new Insets(2, 2, 2, 2);
        JPanel colorPanel = new JPanel(new GridBagLayout());
        colorPanel.setBorder(BorderFactory.createTitledBorder("Colors"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 2;
        gbc1.anchor = 11;
        gbc1.insets = ins;
        gbc1.weightx = 1.0;
        gbc1.weightx = 0.0;
        UIUtil.jGridBagAdd(colorPanel, new JLabel("Background Color"), gbc1, -1);
        gbc1.weightx = 1.0;
        UIUtil.jGridBagAdd(colorPanel, this.backgroundColor, gbc1, 0);
        gbc1.weightx = 0.0;
        UIUtil.jGridBagAdd(colorPanel, new JLabel("Foreground Color"), gbc1, -1);
        gbc1.weightx = 1.0;
        UIUtil.jGridBagAdd(colorPanel, this.foregroundColor, gbc1, 0);
        gbc1.weightx = 2.0;
        gbc1.weighty = 1.0;
        gbc1.anchor = 10;
        UIUtil.jGridBagAdd(colorPanel, this.colorPrinting, gbc1, 0);
        JPanel terminalPanel = new JPanel(new GridBagLayout());
        terminalPanel.setBorder(BorderFactory.createTitledBorder("General"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = ins;
        gbc.weightx = 1.0;
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(terminalPanel, new JLabel("Terminal type"), gbc, -1);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(terminalPanel, this.jComboTerm, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(terminalPanel, new JLabel("Resize strategy"), gbc, -1);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(terminalPanel, this.jComboResizeStrategy, gbc, 0);
        this.jComboResizeStrategy.addActionListener(this);
        gbc.weightx = 0.0;
        gbc.insets = new Insets(2, 26, 2, 2);
        this.fontLabel = new JLabel("Default font size");
        UIUtil.jGridBagAdd(terminalPanel, this.fontLabel, gbc, -1);
        gbc.weightx = 1.0;
        gbc.insets = ins;
        this.fontSize.setEditable(true);
        UIUtil.jGridBagAdd(terminalPanel, this.fontSize, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(terminalPanel, new JLabel("EOL Type"), gbc, -1);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(terminalPanel, this.jComboEOL, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(terminalPanel, new JLabel("Screen Size"), gbc, -1);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(terminalPanel, this.jComboScreenSize, gbc, 0);
        this.antialias.setMnemonic('c');
        gbc.weighty = 1.0;
        gbc.weightx = 2.0;
        gbc.insets = new Insets(18, 26, 2, 2);
        UIUtil.jGridBagAdd(terminalPanel, this.antialias, gbc, 0);
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)terminalPanel, "Center");
        main.add((Component)colorPanel, "South");
        IconWrapperPanel iconTerminalPanel = new IconWrapperPanel(new ResourceIcon(TERM_ICON), main);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)iconTerminalPanel, "Center");
        this.loadList(TerminalEmulation.getSupportedEmulations(), this.jComboTerm, false);
        this.setAvailableActions();
    }

    private void setAvailableActions() {
        this.fontLabel.setEnabled(this.jComboResizeStrategy.getSelectedIndex() == 2);
        this.fontSize.setEnabled(this.jComboResizeStrategy.getSelectedIndex() == 2);
    }

    public void actionPerformed(ActionEvent evt) {
        this.setAvailableActions();
    }

    private void loadList(List list, JComboBox combo, boolean addDefault) {
        Iterator it = list.iterator();
        if (addDefault) {
            combo.addItem(DEFAULT);
        }
        while (it.hasNext()) {
            combo.addItem(it.next());
        }
    }

    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        String term = profile.getApplicationProperty("TERM", "vt100");
        for (int i = 0; i < this.jComboTerm.getItemCount(); ++i) {
            if (!this.jComboTerm.getItemAt(i).equals(term)) continue;
            this.jComboTerm.setSelectedIndex(i);
            break;
        }
        this.jComboResizeStrategy.setSelectedIndex(profile.getApplicationPropertyInt("RESIZE_STRATEGY", 2));
        this.jComboEOL.setSelectedIndex(profile.getApplicationPropertyInt("EOL", 0));
        this.jComboScreenSize.setSelectedIndex(profile.getApplicationPropertyInt("TERM_SCREEN_SIZE", 1));
        int sz = profile.getApplicationPropertyInt("FONT_SIZE", 12);
        for (int i = 0; i < this.fontSize.getItemCount(); ++i) {
            if (!this.fontSize.getItemAt(i).equals(String.valueOf(sz))) continue;
            this.fontSize.setSelectedIndex(i);
            break;
        }
        this.antialias.setSelected(profile.getApplicationPropertyBoolean("ANTIALIAS", false));
        this.backgroundColor.setColor(profile.getApplicationPropertyColor("BACKGROUND_COLOR", Color.black));
        this.foregroundColor.setColor(profile.getApplicationPropertyColor("FOREGROUND_COLOR", Color.white));
        this.colorPrinting.setSelected(profile.getApplicationPropertyBoolean("COLOR_PRINTING", false));
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Terminal";
    }

    public String getTabToolTipText() {
        return "Terminal related properties.";
    }

    public int getTabMnemonic() {
        return 116;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        this.profile.setApplicationProperty("sshterm.configured", true);
        this.profile.setApplicationProperty("TERM", (String)this.jComboTerm.getSelectedItem());
        this.profile.setApplicationProperty("RESIZE_STRATEGY", this.jComboResizeStrategy.getSelectedIndex());
        this.profile.setApplicationProperty("EOL", this.jComboEOL.getSelectedIndex());
        this.profile.setApplicationProperty("TERM_SCREEN_SIZE", this.jComboScreenSize.getSelectedIndex());
        try {
            this.profile.setApplicationProperty("FONT_SIZE", Integer.parseInt(String.valueOf(this.fontSize.getSelectedItem())));
        }
        catch (NumberFormatException nfe) {
            this.profile.setApplicationProperty("FONT_SIZE", 12);
        }
        this.profile.setApplicationProperty("ANTIALIAS", this.antialias.isSelected());
        this.profile.setApplicationProperty("BACKGROUND_COLOR", this.backgroundColor.getColor());
        this.profile.setApplicationProperty("FOREGROUND_COLOR", this.foregroundColor.getColor());
        this.profile.setApplicationProperty("COLOR_PRINTING", this.colorPrinting.isSelected());
    }

    public void tabSelected() {
    }
}

