/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm.emulation;

import com.sshtools.j2ssh.io.DynamicBuffer;
import com.sshtools.j2ssh.session.PseudoTerminal;
import com.sshtools.sshterm.emulation.VDUBuffer;
import com.sshtools.sshterm.emulation.VDUInput;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TerminalEmulation
extends VDUBuffer
implements VDUInput,
PseudoTerminal {
    private static Log log = LogFactory.getLog(TerminalEmulation.class);
    private static final int debug = 0;
    public static final String VT320 = "vt320";
    public static final String VT220 = "vt220";
    public static final String VT100 = "vt100";
    public static final String ANSI = "ansi";
    public static final int EOL_DEFAULT = 0;
    public static final int EOL_CR_LF = 1;
    public static final int EOL_CR = 2;
    private static final char ESC = '\u001b';
    private static final char IND = '\u0084';
    private static final char NEL = '\u0085';
    private static final char RI = '\u008d';
    private static final char SS2 = '\u008e';
    private static final char SS3 = '\u008f';
    private static final char DCS = '\u0090';
    private static final char HTS = '\u0088';
    private static final char CSI = '\u009b';
    private static final char OSC = '\u009d';
    private static final int TSTATE_DATA = 0;
    private static final int TSTATE_ESC = 1;
    private static final int TSTATE_CSI = 2;
    private static final int TSTATE_DCS = 3;
    private static final int TSTATE_DCEQ = 4;
    private static final int TSTATE_ESCSQUARE = 5;
    private static final int TSTATE_OSC = 6;
    private static final int TSTATE_SETG0 = 7;
    private static final int TSTATE_SETG1 = 8;
    private static final int TSTATE_SETG2 = 9;
    private static final int TSTATE_SETG3 = 10;
    private static final int TSTATE_CSI_DOLLAR = 11;
    private static final int TSTATE_CSI_EX = 12;
    private static final int TSTATE_ESCSPACE = 13;
    private static final int TSTATE_VT52X = 14;
    private static final int TSTATE_VT52Y = 15;
    private static final int TSTATE_CSI_TICKS = 16;
    private static final String scoansi_acs = "Tm7k3x4u?kZl@mYjEnB\u2566DqCtAvM\u2550:\u2551N\u2557I\u2554;\u2557H\u255a0a<\u255d";
    private static char[] DECSPECIAL = new char[]{'@', '\u2666', '\u2592', '\u2409', '\u240c', '\u240d', '\u240a', '\u00ba', '\u00b1', '\u2424', '\u240b', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '\u2594', '\u2580', '\u2500', '\u25ac', '_', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265', '\u00b6', '\u2260', '\u00a3', '\u00b7'};
    private static final char[] unimap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00c7', '\u00fc', '\u00e9', '\u00e2', '\u00e4', '\u00e0', '\u00e5', '\u00e7', '\u00ea', '\u00eb', '\u00e8', '\u00ef', '\u00ee', '\u00ec', '\u00c4', '\u00c5', '\u00c9', '\u00e6', '\u00c6', '\u00f4', '\u00f6', '\u00f2', '\u00fb', '\u00f9', '\u00ff', '\u00d6', '\u00dc', '\u00a2', '\u00a3', '\u00a5', '\u20a7', '\u0192', '\u00e1', '\u00ed', '\u00f3', '\u00fa', '\u00f1', '\u00d1', '\u00aa', '\u00ba', '\u00bf', '\u2310', '\u00ac', '\u00bd', '\u00bc', '\u00a1', '\u00ab', '\u00bb', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561', '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255d', '\u255c', '\u255b', '\u2510', '\u2514', '\u2534', '\u252c', '\u251c', '\u2500', '\u253c', '\u255e', '\u255f', '\u255a', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256c', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553', '\u256b', '\u256a', '\u2518', '\u250c', '\u2588', '\u2584', '\u258c', '\u2590', '\u2580', '\u03b1', '\u00df', '\u0393', '\u03c0', '\u03a3', '\u03c3', '\u00b5', '\u03c4', '\u03a6', '\u0398', '\u03a9', '\u03b4', '\u221e', '\u03c6', '\u03b5', '\u2229', '\u2261', '\u00b1', '\u2265', '\u2264', '\u2320', '\u2321', '\u00f7', '\u2248', '\u00b0', '\u2219', '\u00b7', '\u221a', '\u207f', '\u00b2', '\u25a0', '\u00a0'};
    private Object consoleLock = new Object();
    private TerminalOutputStream tout;
    private DynamicBuffer in;
    private DynamicBuffer out;
    private boolean localecho = false;
    private String terminalID = "vt320";
    private String answerBack = "Use Terminal.answerback to set ...\n";
    private int eol;
    int R;
    int C;
    int attributes = 0;
    int Sc;
    int Sr;
    int Sa;
    int Stm;
    int Sbm;
    char Sgr;
    char Sgl;
    char[] Sgx;
    int insertmode = 0;
    int statusmode = 0;
    boolean vt52mode = false;
    boolean keypadmode = false;
    boolean output8bit = false;
    int normalcursor = 0;
    boolean moveoutsidemargins = true;
    boolean wraparound = true;
    boolean sendcrlf = true;
    boolean capslock = false;
    boolean numlock = false;
    int mouserpt = 0;
    byte mousebut = 0;
    boolean useibmcharset = false;
    int lastwaslf = 0;
    boolean usedcharsets = false;
    char[] gx = new char[]{'B', '0', 'B', 'B'};
    char gl = '\u0000';
    char gr = (char)2;
    int onegl = -1;
    private String[] Numpad;
    private String[] FunctionKey;
    private String[] FunctionKeyShift;
    private String[] FunctionKeyCtrl;
    private String[] FunctionKeyAlt;
    private String[] TabKey;
    private String[] KeyUp;
    private String[] KeyDown;
    private String[] KeyLeft;
    private String[] KeyRight;
    private String KPMinus;
    private String KPComma;
    private String KPPeriod;
    private String KPEnter;
    private String PF1;
    private String PF2;
    private String PF3;
    private String PF4;
    private String Help;
    private String Do;
    private String Find;
    private String Select;
    private String[] KeyHome;
    private String[] KeyEnd;
    private String[] Insert;
    private String[] Remove;
    private String[] PrevScn;
    private String[] NextScn;
    private String[] Escape;
    private String[] BackSpace;
    private String[] NUMDot;
    private String[] NUMPlus;
    private String osc;
    private String dcs;
    private int term_state = 0;
    private boolean vms = false;
    private byte[] Tabs;
    private int[] DCEvars = new int[30];
    private int DCEvar;

    public TerminalEmulation(String term, int width, int height) throws IOException {
        super(width, height);
        int i;
        this.terminalID = term;
        this.reset();
        this.setVMS(false);
        this.setIBMCharset(false);
        this.setBufferSize(100);
        int nw = this.getColumns();
        if (nw < 132) {
            nw = 132;
        }
        this.Tabs = new byte[nw];
        for (i = 0; i < nw; i += 8) {
            this.Tabs[i] = 1;
        }
        this.PF1 = "\u001bOP";
        this.PF2 = "\u001bOQ";
        this.PF3 = "\u001bOR";
        this.PF4 = "\u001bOS";
        this.Insert = new String[4];
        this.Remove = new String[4];
        this.KeyHome = new String[4];
        this.KeyEnd = new String[4];
        this.NextScn = new String[4];
        this.PrevScn = new String[4];
        this.Escape = new String[4];
        this.BackSpace = new String[4];
        this.TabKey = new String[4];
        this.Insert[3] = "\u001b[2~";
        this.Insert[2] = "\u001b[2~";
        this.Insert[1] = "\u001b[2~";
        this.Insert[0] = "\u001b[2~";
        this.Remove[3] = "\u001b[3~";
        this.Remove[2] = "\u001b[3~";
        this.Remove[1] = "\u001b[3~";
        this.Remove[0] = "\u001b[3~";
        this.PrevScn[3] = "\u001b[5~";
        this.PrevScn[2] = "\u001b[5~";
        this.PrevScn[1] = "\u001b[5~";
        this.PrevScn[0] = "\u001b[5~";
        this.NextScn[3] = "\u001b[6~";
        this.NextScn[2] = "\u001b[6~";
        this.NextScn[1] = "\u001b[6~";
        this.NextScn[0] = "\u001b[6~";
        this.KeyHome[3] = "\u001b[H";
        this.KeyHome[2] = "\u001b[H";
        this.KeyHome[1] = "\u001b[H";
        this.KeyHome[0] = "\u001b[H";
        this.KeyEnd[3] = "\u001b[F";
        this.KeyEnd[2] = "\u001b[F";
        this.KeyEnd[1] = "\u001b[F";
        this.KeyEnd[0] = "\u001b[F";
        this.Escape[3] = "\u001b";
        this.Escape[2] = "\u001b";
        this.Escape[1] = "\u001b";
        this.Escape[0] = "\u001b";
        if (this.vms) {
            this.BackSpace[1] = "\n";
            this.BackSpace[2] = "\u0018";
            this.BackSpace[3] = "\u007f";
            this.BackSpace[0] = "\u007f";
        } else {
            this.BackSpace[3] = "\b";
            this.BackSpace[2] = "\b";
            this.BackSpace[1] = "\b";
            this.BackSpace[0] = "\b";
        }
        this.Find = "\u001b[1~";
        this.Select = "\u001b[4~";
        this.Help = "\u001b[28~";
        this.Do = "\u001b[29~";
        this.FunctionKey = new String[21];
        this.FunctionKey[0] = "";
        this.FunctionKey[1] = this.PF1;
        this.FunctionKey[2] = this.PF2;
        this.FunctionKey[3] = this.PF3;
        this.FunctionKey[4] = this.PF4;
        this.FunctionKey[5] = "\u001b[15~";
        this.FunctionKey[6] = "\u001b[17~";
        this.FunctionKey[7] = "\u001b[18~";
        this.FunctionKey[8] = "\u001b[19~";
        this.FunctionKey[9] = "\u001b[20~";
        this.FunctionKey[10] = "\u001b[21~";
        this.FunctionKey[11] = "\u001b[23~";
        this.FunctionKey[12] = "\u001b[24~";
        this.FunctionKey[13] = "\u001b[25~";
        this.FunctionKey[14] = "\u001b[26~";
        this.FunctionKey[15] = this.Help;
        this.FunctionKey[16] = this.Do;
        this.FunctionKey[17] = "\u001b[31~";
        this.FunctionKey[18] = "\u001b[32~";
        this.FunctionKey[19] = "\u001b[33~";
        this.FunctionKey[20] = "\u001b[34~";
        this.FunctionKeyShift = new String[21];
        this.FunctionKeyAlt = new String[21];
        this.FunctionKeyCtrl = new String[21];
        for (i = 0; i < 20; ++i) {
            this.FunctionKeyShift[i] = "";
            this.FunctionKeyAlt[i] = "";
            this.FunctionKeyCtrl[i] = "";
        }
        this.FunctionKeyShift[15] = this.Find;
        this.FunctionKeyShift[16] = this.Select;
        this.TabKey[0] = "\t";
        this.TabKey[1] = "\u001bOP\t";
        this.TabKey[3] = "";
        this.TabKey[2] = "";
        this.KeyUp = new String[4];
        this.KeyUp[0] = "\u001b[A";
        this.KeyDown = new String[4];
        this.KeyDown[0] = "\u001b[B";
        this.KeyRight = new String[4];
        this.KeyRight[0] = "\u001b[C";
        this.KeyLeft = new String[4];
        this.KeyLeft[0] = "\u001b[D";
        this.Numpad = new String[10];
        this.Numpad[0] = "\u001bOp";
        this.Numpad[1] = "\u001bOq";
        this.Numpad[2] = "\u001bOr";
        this.Numpad[3] = "\u001bOs";
        this.Numpad[4] = "\u001bOt";
        this.Numpad[5] = "\u001bOu";
        this.Numpad[6] = "\u001bOv";
        this.Numpad[7] = "\u001bOw";
        this.Numpad[8] = "\u001bOx";
        this.Numpad[9] = "\u001bOy";
        this.KPMinus = this.PF4;
        this.KPComma = "\u001bOl";
        this.KPPeriod = "\u001bOn";
        this.KPEnter = "\u001bOM";
        this.NUMPlus = new String[4];
        this.NUMPlus[0] = "+";
        this.NUMDot = new String[4];
        this.NUMDot[0] = ".";
    }

    public TerminalEmulation(String term) throws IOException {
        this(term, 80, 24);
    }

    public static List getSupportedEmulations() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ANSI);
        list.add(VT100);
        list.add(VT220);
        list.add(VT320);
        return list;
    }

    private void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    private void write(byte[] b, int off, int len) {
        try {
            this.in.getOutputStream().write(b, off, len);
        }
        catch (IOException ioe) {
            log.error("Terminal emulation attempted to write", ioe);
        }
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void setEOL(int eol) {
        this.eol = eol;
    }

    public int getEOL() {
        return this.eol;
    }

    public void setTerminalType(String term) {
        this.terminalID = term;
    }

    private void putString(String s) {
        int len = s.length();
        if (len > 0) {
            this.markLine(this.R, 1);
            for (int i = 0; i < len; ++i) {
                this.putChar(s.charAt(i), false);
            }
            this.setCursorPosition(this.C, this.R);
            this.redraw();
        }
    }

    protected void sendTelnetCommand(byte cmd) {
    }

    public OutputStream getOutputStream() {
        return this.in.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.out.getInputStream();
    }

    public OutputStream getTerminalOutputStream() {
        return this.tout;
    }

    public InputStream getTerminalInputStream() {
        return this.in.getInputStream();
    }

    public String getTerm() {
        return this.terminalID;
    }

    public void clearScreen() {
        this.charArray = new char[this.getBufferSize()][this.width];
        this.charAttributes = new int[this.getBufferSize()][this.width];
        this.setCursorPosition(0, 0);
        this.R = 0;
        this.C = 0;
    }

    public void mousePressed(int x, int y, int modifiers) {
        if (this.mouserpt == 0) {
            return;
        }
        int mods = modifiers;
        this.mousebut = (byte)3;
        if ((mods & 0x10) == 16) {
            this.mousebut = 0;
        }
        if ((mods & 8) == 8) {
            this.mousebut = 1;
        }
        if ((mods & 4) == 4) {
            this.mousebut = (byte)2;
        }
        int mousecode = this.mouserpt == 9 ? 0x20 | this.mousebut : this.mousebut | 0x20 | (mods & 7) << 2;
        byte[] b = new byte[]{27, 91, 77, (byte)mousecode, (byte)(32 + x + 1), (byte)(32 + y + 1)};
        this.write(b);
    }

    public void mouseReleased(int x, int y, int modifiers) {
        if (this.mouserpt == 0) {
            return;
        }
        int mousecode = this.mouserpt == 9 ? 32 + this.mousebut : 35;
        byte[] b = new byte[]{27, 91, 77, (byte)mousecode, (byte)(32 + x + 1), (byte)(32 + y + 1)};
        this.write(b);
        this.mousebut = 0;
    }

    public void setLocalEcho(boolean echo) {
        this.localecho = echo;
    }

    public void setVMS(boolean vms) {
        this.vms = vms;
    }

    public void setIBMCharset(boolean ibm) {
        this.useibmcharset = ibm;
    }

    public void setKeyCodes(Properties codes) {
        String res;
        int i;
        String[] prefixes = new String[]{"", "S", "C", "A"};
        for (i = 0; i < 10; ++i) {
            res = codes.getProperty("NUMPAD" + i);
            if (res == null) continue;
            this.Numpad[i] = TerminalEmulation.unEscape(res);
        }
        for (i = 1; i < 20; ++i) {
            res = codes.getProperty("F" + i);
            if (res != null) {
                this.FunctionKey[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty("SF" + i)) != null) {
                this.FunctionKeyShift[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty("CF" + i)) != null) {
                this.FunctionKeyCtrl[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty("AF" + i)) == null) continue;
            this.FunctionKeyAlt[i] = TerminalEmulation.unEscape(res);
        }
        for (i = 0; i < 4; ++i) {
            res = codes.getProperty(prefixes[i] + "PGUP");
            if (res != null) {
                this.PrevScn[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "PGDOWN")) != null) {
                this.NextScn[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "END")) != null) {
                this.KeyEnd[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "HOME")) != null) {
                this.KeyHome[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "INSERT")) != null) {
                this.Insert[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "REMOVE")) != null) {
                this.Remove[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "UP")) != null) {
                this.KeyUp[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "DOWN")) != null) {
                this.KeyDown[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "LEFT")) != null) {
                this.KeyLeft[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "RIGHT")) != null) {
                this.KeyRight[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "ESCAPE")) != null) {
                this.Escape[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "BACKSPACE")) != null) {
                this.BackSpace[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "TAB")) != null) {
                this.TabKey[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "NUMPLUS")) != null) {
                this.NUMPlus[i] = TerminalEmulation.unEscape(res);
            }
            if ((res = codes.getProperty(prefixes[i] + "NUMDECIMAL")) == null) continue;
            this.NUMDot[i] = TerminalEmulation.unEscape(res);
        }
    }

    public void setAnswerBack(String ab) {
        this.answerBack = TerminalEmulation.unEscape(ab);
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public String getEncodedTerminalModes() {
        return "";
    }

    private boolean write(String s, boolean doecho) {
        if (s == null) {
            return true;
        }
        byte[] arr = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            arr[i] = (byte)s.charAt(i);
        }
        this.write(arr);
        if (doecho) {
            this.putString(s);
        }
        return true;
    }

    private boolean write(String s) {
        return this.write(s, this.localecho);
    }

    static String unEscape(String tmp) {
        int idx = 0;
        int oldidx = 0;
        String cmd = "";
        while ((idx = tmp.indexOf(92, oldidx)) >= 0 && ++idx <= tmp.length()) {
            cmd = cmd + tmp.substring(oldidx, idx - 1);
            if (idx == tmp.length()) {
                return cmd;
            }
            switch (tmp.charAt(idx)) {
                case 'b': {
                    cmd = cmd + "\b";
                    break;
                }
                case 'e': {
                    cmd = cmd + "\u001b";
                    break;
                }
                case 'n': {
                    cmd = cmd + "\n";
                    break;
                }
                case 'r': {
                    cmd = cmd + "\r";
                    break;
                }
                case 't': {
                    cmd = cmd + "\t";
                    break;
                }
                case 'v': {
                    cmd = cmd + "\u000b";
                    break;
                }
                case 'a': {
                    cmd = cmd + "\u0012";
                    break;
                }
                default: {
                    if (tmp.charAt(idx) >= '0' && tmp.charAt(idx) <= '9') {
                        int i;
                        for (i = idx; i < tmp.length() && tmp.charAt(i) >= '0' && tmp.charAt(i) <= '9'; ++i) {
                        }
                        cmd = cmd + (char)Integer.parseInt(tmp.substring(idx, i));
                        idx = i - 1;
                        break;
                    }
                    cmd = cmd + tmp.substring(idx++, idx);
                }
            }
            oldidx = ++idx;
        }
        if (oldidx <= tmp.length()) {
            cmd = cmd + tmp.substring(oldidx);
        }
        return cmd;
    }

    private boolean writeSpecial(String s) {
        if (s == null) {
            return true;
        }
        if (s.length() >= 3 && s.charAt(0) == '\u001b' && s.charAt(1) == 'O') {
            if (this.vt52mode) {
                s = s.charAt(2) >= 'P' && s.charAt(2) <= 'S' ? "\u001b" + s.substring(2) : "\u001b?" + s.substring(2);
            } else if (this.output8bit) {
                s = "\u008f" + s.substring(2);
            }
        }
        if (s.length() >= 3 && s.charAt(0) == '\u001b' && s.charAt(1) == '[' && this.output8bit) {
            s = "\u009b" + s.substring(2);
        }
        return this.write(s, false);
    }

    public void keyPressed(int keyCode, char keyChar, int modifiers) {
        boolean control = (modifiers & 1) != 0;
        boolean shift = (modifiers & 2) != 0;
        boolean alt = (modifiers & 4) != 0;
        int xind = 0;
        String[] fmap = this.FunctionKey;
        if (shift) {
            fmap = this.FunctionKeyShift;
            xind = 1;
        }
        if (control) {
            fmap = this.FunctionKeyCtrl;
            xind = 2;
        }
        if (alt) {
            fmap = this.FunctionKeyAlt;
            xind = 3;
        }
        switch (keyCode) {
            case 19: {
                if (!shift && !control) break;
                this.sendTelnetCommand((byte)-13);
                break;
            }
            case 27: {
                this.writeSpecial(this.Escape[xind]);
                break;
            }
            case 112: {
                this.writeSpecial(fmap[1]);
                break;
            }
            case 113: {
                this.writeSpecial(fmap[2]);
                break;
            }
            case 114: {
                this.writeSpecial(fmap[3]);
                break;
            }
            case 115: {
                this.writeSpecial(fmap[4]);
                break;
            }
            case 116: {
                this.writeSpecial(fmap[5]);
                break;
            }
            case 117: {
                this.writeSpecial(fmap[6]);
                break;
            }
            case 118: {
                this.writeSpecial(fmap[7]);
                break;
            }
            case 119: {
                this.writeSpecial(fmap[8]);
                break;
            }
            case 120: {
                this.writeSpecial(fmap[9]);
                break;
            }
            case 121: {
                this.writeSpecial(fmap[10]);
                break;
            }
            case 122: {
                this.writeSpecial(fmap[11]);
                break;
            }
            case 123: {
                this.writeSpecial(fmap[12]);
                break;
            }
            case 38: {
                this.writeSpecial(this.KeyUp[xind]);
                break;
            }
            case 40: {
                this.writeSpecial(this.KeyDown[xind]);
                break;
            }
            case 37: {
                this.writeSpecial(this.KeyLeft[xind]);
                break;
            }
            case 39: {
                this.writeSpecial(this.KeyRight[xind]);
                break;
            }
            case 34: {
                this.writeSpecial(this.NextScn[xind]);
                break;
            }
            case 33: {
                this.writeSpecial(this.PrevScn[xind]);
                break;
            }
            case 155: {
                this.writeSpecial(this.Insert[xind]);
                break;
            }
            case 127: {
                this.writeSpecial(this.Remove[xind]);
                break;
            }
            case 8: {
                this.writeSpecial(this.BackSpace[xind]);
                if (!this.localecho) break;
                if (this.BackSpace[xind] == "\b") {
                    this.putString("\b \b");
                    break;
                }
                this.putString(this.BackSpace[xind]);
                break;
            }
            case 36: {
                this.writeSpecial(this.KeyHome[xind]);
                break;
            }
            case 35: {
                this.writeSpecial(this.KeyEnd[xind]);
                break;
            }
            case 144: {
                if (this.vms && control) {
                    this.writeSpecial(this.PF1);
                }
                if (control) break;
                this.numlock = !this.numlock;
                break;
            }
            case 20: {
                this.capslock = !this.capslock;
                return;
            }
            case 16: 
            case 17: 
            case 18: {
                return;
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(int keyCode, char keyChar, int modifiers) {
        boolean alt;
        if (this.display != null && this.display.getScrollBar() != null && this.display.getScrollBar().getValue() != this.display.getScrollBar().getMaximum()) {
            this.display.getScrollBar().setValue(this.display.getScrollBar().getMaximum());
        }
        boolean control = (modifiers & 1) != 0;
        boolean shift = (modifiers & 2) != 0;
        boolean bl = alt = (modifiers & 4) != 0;
        if (keyChar == '\t') {
            if (shift) {
                this.write(this.TabKey[1], false);
            } else if (control) {
                this.write(this.TabKey[2], false);
            } else if (alt) {
                this.write(this.TabKey[3], false);
            } else {
                this.write(this.TabKey[0], false);
            }
            return;
        }
        if (alt) {
            this.write("" + (char)(keyChar | 0x80));
            return;
        }
        if (!(keyCode != 10 && keyChar != '\n' || control)) {
            if (this.eol == 0 && this.sendcrlf || this.eol == 1) {
                this.write("\r\n", false);
                if (this.localecho) {
                    this.putString("\r\n");
                }
            } else {
                this.write("\r", false);
                if (this.localecho) {
                    this.putString("\r");
                }
            }
            return;
        }
        if (keyCode == 10 && !control) {
            System.out.println("Sending \\r");
            this.write("\r", false);
            return;
        }
        if ((!this.vms && keyChar == '2' || keyChar == ' ') && control) {
            this.write("\u0000");
        }
        if (this.vms) {
            if (keyChar == '\u007f' && !control) {
                if (shift) {
                    this.writeSpecial(this.Insert[0]);
                } else {
                    this.writeSpecial(this.Remove[0]);
                }
                return;
            }
            if (control) {
                switch (keyChar) {
                    case '0': {
                        this.writeSpecial(this.Numpad[0]);
                        return;
                    }
                    case '1': {
                        this.writeSpecial(this.Numpad[1]);
                        return;
                    }
                    case '2': {
                        this.writeSpecial(this.Numpad[2]);
                        return;
                    }
                    case '3': {
                        this.writeSpecial(this.Numpad[3]);
                        return;
                    }
                    case '4': {
                        this.writeSpecial(this.Numpad[4]);
                        return;
                    }
                    case '5': {
                        this.writeSpecial(this.Numpad[5]);
                        return;
                    }
                    case '6': {
                        this.writeSpecial(this.Numpad[6]);
                        return;
                    }
                    case '7': {
                        this.writeSpecial(this.Numpad[7]);
                        return;
                    }
                    case '8': {
                        this.writeSpecial(this.Numpad[8]);
                        return;
                    }
                    case '9': {
                        this.writeSpecial(this.Numpad[9]);
                        return;
                    }
                    case '.': {
                        this.writeSpecial(this.KPPeriod);
                        return;
                    }
                    case '\u001f': 
                    case '-': {
                        this.writeSpecial(this.KPMinus);
                        return;
                    }
                    case '+': {
                        this.writeSpecial(this.KPComma);
                        return;
                    }
                    case '\n': {
                        this.writeSpecial(this.KPEnter);
                        return;
                    }
                    case '/': {
                        this.writeSpecial(this.PF2);
                        return;
                    }
                    case '*': {
                        this.writeSpecial(this.PF3);
                        return;
                    }
                }
            }
        }
        int xind = 0;
        String[] fmap = this.FunctionKey;
        if (shift) {
            fmap = this.FunctionKeyShift;
            xind = 1;
        }
        if (control) {
            fmap = this.FunctionKeyCtrl;
            xind = 2;
        }
        if (alt) {
            fmap = this.FunctionKeyAlt;
            xind = 3;
        }
        if (keyCode == 27) {
            this.writeSpecial(this.Escape[xind]);
            return;
        }
        if ((modifiers & 8) != 0) {
            switch (keyCode) {
                case 96: {
                    this.writeSpecial(this.Numpad[0]);
                    return;
                }
                case 97: {
                    this.writeSpecial(this.Numpad[1]);
                    return;
                }
                case 98: {
                    this.writeSpecial(this.Numpad[2]);
                    return;
                }
                case 99: {
                    this.writeSpecial(this.Numpad[3]);
                    return;
                }
                case 100: {
                    this.writeSpecial(this.Numpad[4]);
                    return;
                }
                case 101: {
                    this.writeSpecial(this.Numpad[5]);
                    return;
                }
                case 102: {
                    this.writeSpecial(this.Numpad[6]);
                    return;
                }
                case 103: {
                    this.writeSpecial(this.Numpad[7]);
                    return;
                }
                case 104: {
                    this.writeSpecial(this.Numpad[8]);
                    return;
                }
                case 105: {
                    this.writeSpecial(this.Numpad[9]);
                    return;
                }
                case 110: {
                    this.writeSpecial(this.NUMDot[xind]);
                    return;
                }
                case 107: {
                    this.writeSpecial(this.NUMPlus[xind]);
                    return;
                }
            }
        }
        if (keyChar != '\b' && keyChar != '\u007f' && keyChar != '\r' && keyChar != '\n') {
            this.write("" + keyChar);
            return;
        }
    }

    private void handle_dcs(String dcs) {
        System.out.println("DCS: " + dcs);
    }

    private void handle_osc(String osc) {
        System.out.println("OSC: " + osc);
    }

    public char map_cp850_unicode(char x) {
        if (x >= '\u0100') {
            return x;
        }
        return unimap[x];
    }

    private void _SetCursor(int row, int col) {
        int maxr = this.getRows();
        int tm = this.getTopMargin();
        this.R = row < 0 ? 0 : row;
        int n = this.C = col < 0 ? 0 : col;
        if (!this.moveoutsidemargins) {
            this.R += tm;
            maxr = this.getBottomMargin();
        }
        if (this.R > maxr) {
            this.R = maxr;
        }
    }

    private void putChar(char c, boolean doshowcursor) {
        int rows = this.getRows();
        int columns = this.getColumns();
        int tm = this.getTopMargin();
        int bm = this.getBottomMargin();
        boolean mapped = false;
        this.markLine(this.R, 1);
        if (c > '\u00ff') {
            // empty if block
        }
        block4 : switch (this.term_state) {
            case 0: {
                if (!this.useibmcharset) {
                    boolean doneflag = true;
                    switch (c) {
                        case '\u009d': {
                            this.osc = "";
                            this.term_state = 6;
                            break;
                        }
                        case '\u008d': {
                            if (this.R > tm) {
                                --this.R;
                                break;
                            }
                            this.insertLine(this.R, 1, true);
                            break;
                        }
                        case '\u0084': {
                            if (this.R == bm || this.R == rows - 1) {
                                this.insertLine(this.R, 1, false);
                                break;
                            }
                            ++this.R;
                            break;
                        }
                        case '\u0085': {
                            if (this.R == bm || this.R == rows - 1) {
                                this.insertLine(this.R, 1, false);
                            } else {
                                ++this.R;
                            }
                            this.C = 0;
                            break;
                        }
                        case '\u0088': {
                            this.Tabs[this.C] = 1;
                            break;
                        }
                        case '\u0090': {
                            this.dcs = "";
                            this.term_state = 3;
                            break;
                        }
                        default: {
                            doneflag = false;
                        }
                    }
                    if (doneflag) break;
                }
                switch (c) {
                    case '\u008f': {
                        this.onegl = 3;
                        break;
                    }
                    case '\u008e': {
                        this.onegl = 2;
                        break;
                    }
                    case '\u009b': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case '\u001b': {
                        this.term_state = 1;
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\u0005': {
                        this.write(this.answerBack, false);
                        break;
                    }
                    case '\f': {
                        this.deleteArea(0, 0, columns, rows, this.attributes);
                        this.R = 0;
                        this.C = 0;
                        break;
                    }
                    case '\b': {
                        --this.C;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\t': {
                        try {
                            this.out.getOutputStream().write(c);
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        do {
                            ++this.C;
                        } while (this.C < columns && this.Tabs[this.C] == 0);
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\r': {
                        try {
                            this.out.getOutputStream().write(c);
                        }
                        catch (IOException ex1) {
                            // empty catch block
                        }
                        this.C = 0;
                        break;
                    }
                    case '\n': {
                        try {
                            this.out.getOutputStream().write(c);
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                        if (!this.vms) {
                            if (this.lastwaslf != 0 && this.lastwaslf != c) break;
                            this.lastwaslf = c;
                        }
                        if (this.R == bm || this.R >= rows - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case '\u0007': {
                        this.beep();
                        break;
                    }
                    case '\u000e': {
                        this.gl = '\u0001';
                        this.usedcharsets = true;
                        break;
                    }
                    case '\u000f': {
                        this.gl = '\u0000';
                        this.usedcharsets = true;
                        break;
                    }
                    default: {
                        int thisgl = this.gl;
                        if (this.onegl >= 0) {
                            thisgl = this.onegl;
                            this.onegl = -1;
                        }
                        this.lastwaslf = 0;
                        if (c < ' ') {
                            if (c != '\u0000') {
                                // empty if block
                            }
                            if (c == '\u0000') break;
                        }
                        if (this.C >= columns) {
                            if (this.wraparound) {
                                if (this.R < rows - 1) {
                                    ++this.R;
                                } else {
                                    this.insertLine(this.R, 1, false);
                                }
                                this.C = 0;
                            } else {
                                this.C = columns - 1;
                            }
                        }
                        if (this.usedcharsets) {
                            if (c >= ' ' && c <= '\u007f') {
                                switch (this.gx[thisgl]) {
                                    case '0': {
                                        if (this.terminalID.equals("scoansi") || this.terminalID.equals(ANSI)) {
                                            for (int i = 0; i < scoansi_acs.length(); i += 2) {
                                                if (c != scoansi_acs.charAt(i)) continue;
                                                c = scoansi_acs.charAt(i + 1);
                                                break;
                                            }
                                        }
                                        if (c < '_' || c > '~') break;
                                        c = DECSPECIAL[(short)c - 95];
                                        mapped = true;
                                        break;
                                    }
                                    case '<': {
                                        c = (char)(c & 0x7F | 0x80);
                                        mapped = true;
                                        break;
                                    }
                                    case 'A': 
                                    case 'B': {
                                        mapped = true;
                                        break;
                                    }
                                    default: {
                                        System.out.println("Unsupported GL mapping: " + this.gx[thisgl]);
                                    }
                                }
                            }
                            if (!mapped && c >= '\u0080' && c <= '\u00ff') {
                                switch (this.gx[this.gr]) {
                                    case '0': {
                                        if (c < '\u00df' || c > '\u00fe') break;
                                        c = DECSPECIAL[c - 223];
                                        mapped = true;
                                        break;
                                    }
                                    case '<': 
                                    case 'A': 
                                    case 'B': {
                                        mapped = true;
                                        break;
                                    }
                                    default: {
                                        System.out.println("Unsupported GR mapping: " + this.gx[this.gr]);
                                    }
                                }
                            }
                        }
                        if (!mapped && this.useibmcharset) {
                            c = this.map_cp850_unicode(c);
                        }
                        if (this.insertmode == 1) {
                            this.insertChar(this.C, this.R, c, this.attributes);
                        } else {
                            try {
                                this.out.getOutputStream().write(c);
                                this.putChar(this.C, this.R, c, this.attributes);
                            }
                            catch (IOException ex3) {
                                // empty catch block
                            }
                        }
                        ++this.C;
                        break;
                    }
                }
                break;
            }
            case 6: {
                if (c < ' ' && c != '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                if (c == '\\' && this.osc.charAt(this.osc.length() - 1) == '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                this.osc = this.osc + c;
                break;
            }
            case 13: {
                this.term_state = 0;
                switch (c) {
                    case 'F': {
                        this.output8bit = false;
                        break block4;
                    }
                    case 'G': {
                        this.output8bit = true;
                        break block4;
                    }
                }
                System.out.println("ESC <space> " + c + " unhandled.");
                break;
            }
            case 1: {
                this.term_state = 0;
                switch (c) {
                    case ' ': {
                        this.term_state = 13;
                        break;
                    }
                    case '#': {
                        this.term_state = 5;
                        break;
                    }
                    case 'c': {
                        this.gx[0] = 66;
                        this.gx[1] = 48;
                        this.gx[2] = 66;
                        this.gx[3] = 66;
                        this.gl = '\u0000';
                        this.gr = '\u0001';
                        int nw = this.getColumns();
                        if (nw < 132) {
                            nw = 132;
                        }
                        this.Tabs = new byte[nw];
                        for (int i = 0; i < nw; i += 8) {
                            this.Tabs[i] = 1;
                        }
                        break block4;
                    }
                    case '[': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case ']': {
                        this.osc = "";
                        this.term_state = 6;
                        break;
                    }
                    case 'P': {
                        this.dcs = "";
                        this.term_state = 3;
                        break;
                    }
                    case 'A': {
                        --this.R;
                        if (this.R >= 0) break block4;
                        this.R = 0;
                        break;
                    }
                    case 'B': {
                        ++this.R;
                        if (this.R <= rows - 1) break block4;
                        this.R = rows - 1;
                        break;
                    }
                    case 'C': {
                        ++this.C;
                        if (this.C < columns) break block4;
                        this.C = columns - 1;
                        break;
                    }
                    case 'I': {
                        this.insertLine(this.R, 1, true);
                        break;
                    }
                    case 'E': {
                        if (this.R == bm || this.R == rows - 1) {
                            this.insertLine(this.R, 1, false);
                        } else {
                            ++this.R;
                        }
                        this.C = 0;
                        break;
                    }
                    case 'D': {
                        if (this.R == bm || this.R == rows - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case 'J': {
                        if (this.R < rows - 1) {
                            this.deleteArea(0, this.R + 1, columns, rows - this.R - 1, this.attributes);
                        }
                        if (this.C >= columns - 1) break block4;
                        this.deleteArea(this.C, this.R, columns - this.C, 1, this.attributes);
                        break;
                    }
                    case 'K': {
                        if (this.C >= columns - 1) break block4;
                        this.deleteArea(this.C, this.R, columns - this.C, 1, this.attributes);
                        break;
                    }
                    case 'M': {
                        if (this.R > bm) break;
                        if (this.R > tm) {
                            --this.R;
                            break;
                        }
                        this.insertLine(this.R, 1, true);
                        break;
                    }
                    case 'H': {
                        if (this.C >= columns) {
                            this.C = columns - 1;
                        }
                        this.Tabs[this.C] = 1;
                        break;
                    }
                    case 'N': {
                        this.onegl = 2;
                        break;
                    }
                    case 'O': {
                        this.onegl = 3;
                        break;
                    }
                    case '=': {
                        this.keypadmode = true;
                        break;
                    }
                    case '<': {
                        this.vt52mode = false;
                        break;
                    }
                    case '>': {
                        this.keypadmode = false;
                        break;
                    }
                    case '7': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sgl = this.gl;
                        this.Sgr = this.gr;
                        this.Sa = this.attributes;
                        this.Sgx = new char[4];
                        for (int i = 0; i < 4; ++i) {
                            this.Sgx[i] = this.gx[i];
                        }
                        this.Stm = this.getTopMargin();
                        this.Sbm = this.getBottomMargin();
                        break;
                    }
                    case '8': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.gl = this.Sgl;
                        this.gr = this.Sgr;
                        for (int i = 0; i < 4; ++i) {
                            this.gx[i] = this.Sgx[i];
                        }
                        this.setTopMargin(this.Stm);
                        this.setBottomMargin(this.Sbm);
                        this.attributes = this.Sa;
                        break;
                    }
                    case '(': {
                        this.term_state = 7;
                        this.usedcharsets = true;
                        break;
                    }
                    case ')': {
                        this.term_state = 8;
                        this.usedcharsets = true;
                        break;
                    }
                    case '*': {
                        this.term_state = 9;
                        this.usedcharsets = true;
                        break;
                    }
                    case '+': {
                        this.term_state = 10;
                        this.usedcharsets = true;
                        break;
                    }
                    case '~': {
                        this.gr = '\u0001';
                        this.usedcharsets = true;
                        break;
                    }
                    case 'n': {
                        this.gl = (char)2;
                        this.usedcharsets = true;
                        break;
                    }
                    case '}': {
                        this.gr = (char)2;
                        this.usedcharsets = true;
                        break;
                    }
                    case 'o': {
                        this.gl = (char)3;
                        this.usedcharsets = true;
                        break;
                    }
                    case '|': {
                        this.gr = (char)3;
                        this.usedcharsets = true;
                        break;
                    }
                    case 'Y': {
                        this.term_state = 15;
                        break;
                    }
                    default: {
                        System.out.println("ESC unknown letter: " + c + " (" + c + ")");
                        break;
                    }
                }
                break;
            }
            case 14: {
                this.C = c - 37;
                this.term_state = 15;
                break;
            }
            case 15: {
                this.R = c - 37;
                this.term_state = 0;
                break;
            }
            case 7: {
                if (c != '0' && c != 'A' && c != 'B' && c != '<') {
                    System.out.println("ESC ( " + c + ": G0 char set?  (" + c + ")");
                } else {
                    this.gx[0] = c;
                }
                this.term_state = 0;
                break;
            }
            case 8: {
                if (c != '0' && c != 'A' && c != 'B' && c != '<') {
                    System.out.println("ESC ) " + c + " (" + c + ") :G1 char set?");
                } else {
                    this.gx[1] = c;
                }
                this.term_state = 0;
                break;
            }
            case 9: {
                if (c != '0' && c != 'A' && c != 'B' && c != '<') {
                    System.out.println("ESC*:G2 char set?  (" + c + ")");
                } else {
                    this.gx[2] = c;
                }
                this.term_state = 0;
                break;
            }
            case 10: {
                if (c != '0' && c != 'A' && c != 'B' && c != '<') {
                    System.out.println("ESC+:G3 char set?  (" + c + ")");
                } else {
                    this.gx[3] = c;
                }
                this.term_state = 0;
                break;
            }
            case 5: {
                switch (c) {
                    case '8': {
                        for (int i = 0; i < columns; ++i) {
                            for (int j = 0; j < rows; ++j) {
                                this.putChar(i, j, 'E', 0);
                            }
                        }
                        break;
                    }
                    default: {
                        System.out.println("ESC # " + c + " not supported.");
                    }
                }
                this.term_state = 0;
                break;
            }
            case 3: {
                if (c == '\\' && this.dcs.charAt(this.dcs.length() - 1) == '\u001b') {
                    this.handle_dcs(this.dcs);
                    this.term_state = 0;
                    break;
                }
                this.dcs = this.dcs + c;
                break;
            }
            case 4: {
                this.term_state = 0;
                block97 : switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 4;
                        break;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 4;
                        break;
                    }
                    case 's': {
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " s unimplemented!");
                        break;
                    }
                    case 'r': {
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " r");
                        block248: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 3: {
                                    this.setScreenSize(80, this.getRows());
                                    continue block248;
                                }
                                case 4: {
                                    continue block248;
                                }
                                case 5: {
                                    continue block248;
                                }
                                case 6: {
                                    this.moveoutsidemargins = true;
                                    continue block248;
                                }
                                case 7: {
                                    this.wraparound = false;
                                    continue block248;
                                }
                                case 12: {
                                    continue block248;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = this.DCEvars[i];
                                    continue block248;
                                }
                                default: {
                                    System.out.println("ESC [ ? " + this.DCEvars[0] + " r, unimplemented!");
                                }
                            }
                        }
                        break block4;
                    }
                    case 'h': {
                        block249: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 1: {
                                    this.KeyUp[0] = "\u001bOA";
                                    this.KeyDown[0] = "\u001bOB";
                                    this.KeyRight[0] = "\u001bOC";
                                    this.KeyLeft[0] = "\u001bOD";
                                    continue block249;
                                }
                                case 2: {
                                    this.vt52mode = false;
                                    continue block249;
                                }
                                case 3: {
                                    this.setScreenSize(132, this.getRows());
                                    continue block249;
                                }
                                case 6: {
                                    this.moveoutsidemargins = false;
                                    continue block249;
                                }
                                case 7: {
                                    this.wraparound = true;
                                    continue block249;
                                }
                                case 25: {
                                    this.showCursor(true);
                                    this.redraw();
                                    continue block249;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = this.DCEvars[i];
                                    continue block249;
                                }
                                default: {
                                    System.out.println("ESC [ ? " + this.DCEvars[0] + " h, unsupported.");
                                }
                            }
                        }
                        break block4;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 1: {
                                break block97;
                            }
                            case 4: {
                                break block97;
                            }
                        }
                        break;
                    }
                    case 'l': {
                        block250: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 1: {
                                    this.KeyUp[0] = "\u001b[A";
                                    this.KeyDown[0] = "\u001b[B";
                                    this.KeyRight[0] = "\u001b[C";
                                    this.KeyLeft[0] = "\u001b[D";
                                    continue block250;
                                }
                                case 2: {
                                    this.vt52mode = true;
                                    continue block250;
                                }
                                case 3: {
                                    this.setScreenSize(80, this.getRows());
                                    continue block250;
                                }
                                case 6: {
                                    this.moveoutsidemargins = true;
                                    continue block250;
                                }
                                case 7: {
                                    this.wraparound = false;
                                    continue block250;
                                }
                                case 25: {
                                    this.showCursor(false);
                                    this.redraw();
                                    continue block250;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = 0;
                                    continue block250;
                                }
                                default: {
                                    System.out.println("ESC [ ? " + this.DCEvars[0] + " l, unsupported.");
                                }
                            }
                        }
                        break block4;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 15: {
                                this.write("\u001b[?13n", false);
                                System.out.println("ESC[5n");
                                break block97;
                            }
                        }
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " n, unsupported.");
                        break;
                    }
                    default: {
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " " + c + ", unsupported.");
                        break;
                    }
                }
                break;
            }
            case 12: {
                this.term_state = 0;
                switch (c) {
                    case '\u001b': {
                        this.term_state = 1;
                        break block4;
                    }
                }
                System.out.println("Unknown character ESC[! character is " + c);
                break;
            }
            case 16: {
                this.term_state = 0;
                switch (c) {
                    case 'p': {
                        System.out.println("Conformance level: " + this.DCEvars[0] + " (unsupported)," + this.DCEvars[1]);
                        if (this.DCEvars[0] == 61) {
                            this.output8bit = false;
                            break block4;
                        }
                        if (this.DCEvars[1] == 1) {
                            this.output8bit = false;
                            break block4;
                        }
                        this.output8bit = true;
                        break block4;
                    }
                }
                System.out.println("Unknown ESC [...  \"" + c);
                break;
            }
            case 11: {
                this.term_state = 0;
                switch (c) {
                    case '}': {
                        System.out.println("Active Status Display now " + this.DCEvars[0]);
                        this.statusmode = this.DCEvars[0];
                        break block4;
                    }
                    case '~': {
                        System.out.println("Status Line mode now " + this.DCEvars[0]);
                        break block4;
                    }
                }
                System.out.println("UNKNOWN Status Display code " + c + ", with Pn=" + this.DCEvars[0]);
                break;
            }
            case 2: {
                this.term_state = 0;
                block151 : switch (c) {
                    case '\"': {
                        this.term_state = 16;
                        break;
                    }
                    case '$': {
                        this.term_state = 11;
                        break;
                    }
                    case '!': {
                        this.term_state = 12;
                        break;
                    }
                    case '?': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.term_state = 4;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 2;
                        break;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case 'c': {
                        String subcode = "";
                        if (this.terminalID.equals(VT320)) {
                            subcode = "63;";
                        }
                        if (this.terminalID.equals(VT220)) {
                            subcode = "62;";
                        }
                        if (this.terminalID.equals(VT100)) {
                            subcode = "61;";
                        }
                        this.write("\u001b[?" + subcode + "1;2c", false);
                        break;
                    }
                    case 'q': {
                        break;
                    }
                    case 'g': {
                        switch (this.DCEvars[0]) {
                            case 3: {
                                this.Tabs = new byte[this.getColumns()];
                                break block151;
                            }
                            case 0: {
                                this.Tabs[this.C] = 0;
                            }
                        }
                        break;
                    }
                    case 'h': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 1;
                                break block151;
                            }
                            case 20: {
                                System.out.println("Setting CRLF to TRUE");
                                this.sendcrlf = true;
                                break block151;
                            }
                        }
                        System.out.println("unsupported: ESC [ " + this.DCEvars[0] + " h");
                        break;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                break block151;
                            }
                            case 4: {
                                break block151;
                            }
                            case 5: {
                                break block151;
                            }
                        }
                        System.out.println("ESC [ " + this.DCEvars[0] + " i, unimplemented!");
                        break;
                    }
                    case 'l': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 0;
                                break block151;
                            }
                            case 20: {
                                System.out.println("Setting CRLF to FALSE");
                                this.sendcrlf = false;
                                break block151;
                            }
                        }
                        System.out.println("ESC [ " + this.DCEvars[0] + " l, unimplemented!");
                        break;
                    }
                    case 'A': {
                        int limit = this.R > bm ? bm + 1 : (this.R >= tm ? tm : 0);
                        this.R = this.DCEvars[0] == 0 ? --this.R : (this.R -= this.DCEvars[0]);
                        if (this.R >= limit) break block4;
                        this.R = limit;
                        break;
                    }
                    case 'B': {
                        int limit = this.R < tm ? tm - 1 : (this.R <= bm ? bm : rows - 1);
                        this.R = this.DCEvars[0] == 0 ? ++this.R : (this.R += this.DCEvars[0]);
                        if (this.R <= limit) break block4;
                        this.R = limit;
                        break;
                    }
                    case 'C': {
                        this.C = this.DCEvars[0] == 0 ? ++this.C : (this.C += this.DCEvars[0]);
                        if (this.C <= columns - 1) break block4;
                        this.C = columns - 1;
                        break;
                    }
                    case 'd': {
                        this.R = this.DCEvars[0];
                        break;
                    }
                    case 'D': {
                        this.C = this.DCEvars[0] == 0 ? --this.C : (this.C -= this.DCEvars[0]);
                        if (this.C >= 0) break block4;
                        this.C = 0;
                        break;
                    }
                    case 'r': {
                        if (this.DCEvar > 0) {
                            this.R = this.DCEvars[1] - 1;
                            if (this.R < 0) {
                                this.R = rows - 1;
                            } else if (this.R >= rows) {
                                this.R = rows - 1;
                            }
                        } else {
                            this.R = rows - 1;
                        }
                        this.setBottomMargin(this.R);
                        if (this.R >= this.DCEvars[0]) {
                            this.R = this.DCEvars[0] - 1;
                            if (this.R < 0) {
                                this.R = 0;
                            }
                        }
                        this.setTopMargin(this.R);
                        this._SetCursor(0, 0);
                        break;
                    }
                    case 'G': {
                        this.C = this.DCEvars[0];
                        break;
                    }
                    case 'H': {
                        this._SetCursor(this.DCEvars[0] - 1, this.DCEvars[1] - 1);
                        break;
                    }
                    case 'f': {
                        this.R = this.DCEvars[0] - 1;
                        this.C = this.DCEvars[1] - 1;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        if (this.R >= 0) break block4;
                        this.R = 0;
                        break;
                    }
                    case 'S': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(rows - 1, false);
                            break;
                        }
                        this.insertLine(rows - 1, this.DCEvars[0], false);
                        break;
                    }
                    case 'L': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(this.R, true);
                            break;
                        }
                        this.insertLine(this.R, this.DCEvars[0], true);
                        break;
                    }
                    case 'T': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(0, true);
                            break;
                        }
                        this.insertLine(0, this.DCEvars[0], true);
                        break;
                    }
                    case 'M': {
                        if (this.DCEvars[0] == 0) {
                            this.deleteLine(this.R);
                            break;
                        }
                        for (int i = 0; i < this.DCEvars[0]; ++i) {
                            this.deleteLine(this.R);
                        }
                        break block4;
                    }
                    case 'K': {
                        switch (this.DCEvars[0]) {
                            case 0: 
                            case 6: {
                                if (this.C >= columns - 1) break;
                                this.deleteArea(this.C, this.R, columns - this.C, 1, this.attributes);
                                break block151;
                            }
                            case 1: {
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C + 1, 1, this.attributes);
                                break block151;
                            }
                            case 2: {
                                this.deleteArea(0, this.R, columns, 1, this.attributes);
                            }
                        }
                        break;
                    }
                    case 'J': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                if (this.R < rows - 1) {
                                    this.deleteArea(0, this.R + 1, columns, rows - this.R - 1, this.attributes);
                                }
                                if (this.C >= columns - 1) break;
                                this.deleteArea(this.C, this.R, columns - this.C, 1, this.attributes);
                                break block151;
                            }
                            case 1: {
                                if (this.R > 0) {
                                    this.deleteArea(0, 0, columns, this.R, this.attributes);
                                }
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C + 1, 1, this.attributes);
                                break block151;
                            }
                            case 2: {
                                this.deleteArea(0, 0, columns, rows, this.attributes);
                            }
                        }
                        break;
                    }
                    case '@': {
                        for (int i = 0; i < this.DCEvars[0]; ++i) {
                            this.insertChar(this.C, this.R, ' ', this.attributes);
                        }
                        break block4;
                    }
                    case 'X': {
                        int toerase = this.DCEvars[0];
                        if (toerase == 0) {
                            toerase = 1;
                        }
                        if (toerase + this.C > columns) {
                            toerase = columns - this.C;
                        }
                        this.deleteArea(this.C, this.R, toerase, 1, this.attributes);
                        break;
                    }
                    case 'P': {
                        if (this.DCEvars[0] == 0) {
                            this.DCEvars[0] = 1;
                        }
                        for (int i = 0; i < this.DCEvars[0]; ++i) {
                            this.deleteChar(this.C, this.R);
                        }
                        break block4;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 5: {
                                this.writeSpecial("\u001b[0n");
                                break block151;
                            }
                            case 6: {
                                this.writeSpecial("\u001b[" + this.R + ";" + this.C + "R");
                                break block151;
                            }
                        }
                        break;
                    }
                    case 's': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sa = this.attributes;
                        break;
                    }
                    case 'u': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.attributes = this.Sa;
                        break;
                    }
                    case 'm': {
                        if (this.DCEvar == 0 && this.DCEvars[0] == 0) {
                            this.attributes = 0;
                        }
                        block254: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 0: {
                                    if (this.DCEvar <= 0) continue block254;
                                    if (this.terminalID.equals("scoansi")) {
                                        this.attributes &= 0xFF0;
                                        continue block254;
                                    }
                                    this.attributes = 0;
                                    continue block254;
                                }
                                case 1: {
                                    this.attributes |= 1;
                                    this.attributes &= 0xFFFFFFF7;
                                    continue block254;
                                }
                                case 2: {
                                    if (this.terminalID.equals("scoansi") && this.DCEvar - i >= 2) {
                                        this.attributes &= 0xFFFFF00E;
                                        int ncolor = this.DCEvars[i + 1];
                                        if ((ncolor & 8) == 8) {
                                            this.attributes |= 1;
                                        }
                                        ncolor = (ncolor & 1) << 2 | ncolor & 2 | (ncolor & 4) >> 2;
                                        this.attributes |= ncolor + 1 << 4;
                                        ncolor = this.DCEvars[i + 2];
                                        ncolor = (ncolor & 1) << 2 | ncolor & 2 | (ncolor & 4) >> 2;
                                        this.attributes |= ncolor + 1 << 8;
                                        i += 2;
                                        continue block254;
                                    }
                                    this.attributes |= 8;
                                    continue block254;
                                }
                                case 4: {
                                    this.attributes |= 2;
                                    continue block254;
                                }
                                case 7: {
                                    this.attributes |= 4;
                                    continue block254;
                                }
                                case 5: {
                                    continue block254;
                                }
                                case 10: {
                                    this.gl = '\u0000';
                                    this.usedcharsets = true;
                                    continue block254;
                                }
                                case 11: 
                                case 12: {
                                    this.gl = '\u0001';
                                    this.usedcharsets = true;
                                    continue block254;
                                }
                                case 21: {
                                    this.attributes &= 0xFFFFFFF6;
                                    continue block254;
                                }
                                case 25: {
                                    continue block254;
                                }
                                case 27: {
                                    this.attributes &= 0xFFFFFFFB;
                                    continue block254;
                                }
                                case 24: {
                                    this.attributes &= 0xFFFFFFFD;
                                    continue block254;
                                }
                                case 22: {
                                    this.attributes &= 0xFFFFFFFE;
                                    continue block254;
                                }
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: {
                                    this.attributes &= 0xFFFFFF0F;
                                    this.attributes |= this.DCEvars[i] - 30 + 1 << 4;
                                    continue block254;
                                }
                                case 39: {
                                    this.attributes &= 0xFFFFFF0F;
                                    continue block254;
                                }
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: {
                                    this.attributes &= 0xFFFFF0FF;
                                    this.attributes |= this.DCEvars[i] - 40 + 1 << 8;
                                    continue block254;
                                }
                                case 49: {
                                    this.attributes &= 0xFFFFF0FF;
                                    continue block254;
                                }
                                default: {
                                    System.out.println("ESC [ " + this.DCEvars[i] + " m unknown...");
                                }
                            }
                        }
                        break block4;
                    }
                    default: {
                        System.out.println("ESC [ unknown letter:" + c + " (" + c + ")");
                        break;
                    }
                }
                break;
            }
            default: {
                this.term_state = 0;
            }
        }
        if (this.C > columns) {
            this.C = columns;
        }
        if (this.R > rows) {
            this.R = rows;
        }
        if (this.C < 0) {
            this.C = 0;
        }
        if (this.R < 0) {
            this.R = 0;
        }
        if (doshowcursor) {
            this.setCursorPosition(this.C, this.R);
        }
        this.markLine(this.R, 1);
    }

    public void reset() {
        try {
            if (this.in != null) {
                this.in.getOutputStream().close();
            }
            if (this.out != null) {
                this.out.getOutputStream().close();
            }
            if (this.tout != null) {
                this.tout.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.tout = new TerminalOutputStream();
        this.in = new DynamicBuffer();
        this.out = new DynamicBuffer();
        this.gx[0] = 66;
        this.gx[1] = 48;
        this.gx[2] = 66;
        this.gx[3] = 66;
        this.gl = '\u0000';
        this.gr = '\u0001';
        int nw = this.getColumns();
        if (nw < 132) {
            nw = 132;
        }
        this.Tabs = new byte[nw];
        for (int i = 0; i < nw; i += 8) {
            this.Tabs[i] = 1;
        }
        this.term_state = 0;
    }

    class TerminalOutputStream
    extends OutputStream {
        private Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                byte[] buf = new byte[]{(byte)b};
                TerminalEmulation.this.putString(new String(buf, 0, 1, "latin1"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int off, int len) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                TerminalEmulation.this.putString(new String(buf, off, len, "latin1"));
            }
        }
    }
}

