/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.tunnel;

import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PortForwardEditorPane
extends JPanel
implements ActionListener {
    private static int id = 1000;
    private JRadioButton local;
    private JRadioButton remote;
    private NumericTextField localPort;
    private NumericTextField remotePort;
    private JComboBox bindAddress;
    private XTextField host;
    private XTextField name;
    private CardLayout bindLayout;
    private JPanel bindPanel;
    private XTextField bindRemoteAddress;
    private ForwardingConfiguration config;

    public PortForwardEditorPane() {
        super(new GridBagLayout());
        this.init();
    }

    public PortForwardEditorPane(ForwardingConfiguration config) {
        super(new GridBagLayout());
        this.config = config;
        this.init();
        this.name.setText(config.getName());
        this.localPort.setValue(new Integer(config.getPortToBind()));
        this.remotePort.setValue(new Integer(config.getPortToConnect()));
        this.host.setText(config.getHostToConnect());
        this.bindAddress.setSelectedItem(config.getAddressToBind());
    }

    void init() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        Insets normal = new Insets(2, 2, 2, 2);
        Insets indented = new Insets(2, 26, 2, 2);
        gbc.insets = normal;
        gbc.fill = 2;
        ButtonGroup type = new ButtonGroup();
        this.local = new JRadioButton("Outgoing", true);
        this.local.setMnemonic('o');
        this.local.addActionListener(this);
        gbc.weightx = 2.0;
        type.add(this.local);
        UIUtil.jGridBagAdd(this, this.local, gbc, 0);
        this.remote = new JRadioButton("Incoming");
        this.remote.setMnemonic('i');
        this.remote.addActionListener(this);
        type.add(this.remote);
        UIUtil.jGridBagAdd(this, this.remote, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(this, new JLabel("Name "), gbc, -1);
        gbc.weightx = 1.0;
        this.name = new XTextField(this.getNextAutoId(), 10);
        UIUtil.jGridBagAdd(this, this.name, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(this, new JLabel("Local port "), gbc, -1);
        gbc.weightx = 1.0;
        this.localPort = new NumericTextField(new Integer(0), new Integer(65535), new Integer(0));
        UIUtil.jGridBagAdd(this, this.localPort, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(this, new JLabel("Remote port "), gbc, -1);
        gbc.weightx = 1.0;
        this.remotePort = new NumericTextField(new Integer(0), new Integer(65535), new Integer(0));
        UIUtil.jGridBagAdd(this, this.remotePort, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(this, new JLabel("Destination Host "), gbc, -1);
        gbc.weightx = 1.0;
        this.host = new XTextField("localhost", 10);
        UIUtil.jGridBagAdd(this, this.host, gbc, 0);
        Vector interaceList = new Vector();
        try {
            this.getClass();
            Method method = Class.forName("java.net.NetworkInterface").getMethod("getNetworkInterfaces", null);
            Enumeration e = (Enumeration)method.invoke(null, null);
            while (e.hasMoreElements()) {
                Object ni = e.nextElement();
                Method method2 = ni.getClass().getMethod("getInetAddresses", null);
                Enumeration z = (Enumeration)method2.invoke(ni, null);
                while (z.hasMoreElements()) {
                    interaceList.add(z.nextElement());
                }
            }
        }
        catch (Exception e) {
            try {
                interaceList.add(InetAddress.getLocalHost());
                interaceList.add(InetAddress.getByName("127.0.0.1"));
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
        }
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        this.bindAddress = new JComboBox(interaceList);
        this.bindRemoteAddress = new XTextField("0.0.0.0", 10);
        this.bindPanel = new JPanel();
        this.bindLayout = new CardLayout();
        this.bindPanel.setLayout(this.bindLayout);
        this.bindPanel.add("local", this.bindAddress);
        this.bindPanel.add("remote", this.bindRemoteAddress);
        UIUtil.jGridBagAdd(this, new JLabel("Bind to "), gbc, -1);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(this, this.bindPanel, gbc, 0);
        this.bindAddress.setRenderer(new InetAddressRenderer());
        this.setBindPanel();
    }

    public void actionPerformed(ActionEvent evt) {
        this.setBindPanel();
    }

    private void setBindPanel() {
        this.bindLayout.show(this.bindPanel, this.local.isSelected() ? "local" : "remote");
    }

    protected String getNextAutoId() {
        return "#".concat(String.valueOf(++id));
    }

    public boolean isLocal() {
        return this.local.isSelected();
    }

    public boolean isRemote() {
        return this.remote.isSelected();
    }

    public String getForwardName() {
        return this.name.getText();
    }

    public int getLocalPort() {
        return (Integer)this.localPort.getValue();
    }

    public String getBindAddress() {
        try {
            return this.bindAddress.getSelectedItem() == null ? InetAddress.getLocalHost().getHostName() : ((InetAddress)this.bindAddress.getSelectedItem()).getHostName();
        }
        catch (UnknownHostException uhe) {
            return "127.0.0.1";
        }
    }

    public int getRemotePort() {
        return (Integer)this.remotePort.getValue();
    }

    public String getHost() {
        return this.host.getText();
    }

    public class InetAddressRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            InetAddress ni = (InetAddress)value;
            this.setText(ni.getHostAddress());
            this.setToolTipText(ni.getHostName());
            return this;
        }
    }
}

