/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.tunnel;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.tunnel.ActiveChannelPane;
import com.sshtools.tunnel.ActiveTunnelsSessionPanel;
import com.sshtools.tunnel.PortForwardEditorPane;
import com.sshtools.tunnel.PortForwardingModel;
import com.sshtools.tunnel.PortForwardingTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortForwardingPane
extends JPanel {
    protected static final Log log = LogFactory.getLog(PortForwardingPane.class);
    SshToolsConnectionProfile profile;
    protected PortForwardingTable table;
    protected ForwardingClient client;
    protected PortForwardingModel model;
    private boolean activeChannelDisplay = true;
    private ActiveChannelPane active;
    private JSplitPane split;
    private ActiveTunnelsSessionPanel sessionPanel;

    public PortForwardingPane(ActiveTunnelsSessionPanel sessionPanel) {
        super(new BorderLayout());
        this.sessionPanel = sessionPanel;
        JPanel north = new JPanel(new BorderLayout());
        this.model = new PortForwardingModel();
        this.table = new PortForwardingTable(this.model);
        this.table.setShowGrid(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setColumnSelectionAllowed(false);
        this.table.getColumnModel().getColumn(0).setMaxWidth(25);
        this.table.getColumnModel().getColumn(0).setMinWidth(25);
        this.table.getColumnModel().getColumn(2).setMaxWidth(60);
        this.table.getColumnModel().getColumn(2).setMinWidth(60);
        this.table.getColumnModel().getColumn(3).setMaxWidth(150);
        this.table.getColumnModel().getColumn(3).setMinWidth(80);
        this.table.getColumnModel().getColumn(4).setMaxWidth(150);
        this.table.getColumnModel().getColumn(4).setMinWidth(80);
        this.table.setAutoResizeMode(2);
        JScrollPane scroller = new JScrollPane(this.table){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 164);
            }
        };
        this.active = new ActiveChannelPane();
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)north, "North");
        top.add((Component)scroller, "Center");
        this.split = new JSplitPane(0, top, this.active);
        this.split.setOneTouchExpandable(true);
        this.split.setDividerSize(7);
        this.add((Component)this.split, "Center");
        this.toggleActiveChannelDisplay();
        this.setClient(null);
    }

    protected boolean isSelectedTunnelStarted() {
        if (this.table.getSelectedRow() > -1) {
            try {
                ForwardingConfiguration conf = this.model.getForwardingConfigurationAt(this.table.getSelectedRow());
                return conf.isForwarding();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void applyForwardingToProfile(SshToolsConnectionProfile profile) {
        Iterator it = this.client.getLocalForwardings().values().iterator();
        profile.removeAllForwardings();
        while (it.hasNext()) {
            ForwardingConfiguration config = (ForwardingConfiguration)it.next();
            profile.addLocalForwarding(config);
        }
        for (ForwardingConfiguration config : this.client.getRemoteForwardings().values()) {
            if (config.getName().equals("X")) continue;
            profile.addRemoteForwarding(config);
        }
    }

    public void setDividerLocation(double div) {
        this.split.setDividerLocation(div);
    }

    public void setDividerLocation(int div) {
        this.split.setDividerLocation(div);
    }

    public int getDividerLocation() {
        return this.split.getDividerLocation();
    }

    public ActiveChannelPane getActiveChannelPane() {
        return this.active;
    }

    public PortForwardingTable getPortForwardingTable() {
        return this.table;
    }

    public void setClient(ForwardingClient client) {
        this.client = client;
        this.model.setClient(client == null ? null : client);
        this.table.repaint();
        this.active.setConfiguration(null);
        this.setAvailableActions();
        this.updateActiveDisplay();
    }

    public void refreshTable() {
        this.model.refresh();
        this.table.repaint();
        this.updateActiveDisplay();
    }

    private void setAvailableActions() {
    }

    protected void toggleActiveChannelDisplay() {
        if (this.activeChannelDisplay) {
            this.split.remove(this.active);
            this.activeChannelDisplay = false;
        } else {
            this.split.add(this.active);
            this.split.setDividerLocation(this.sessionPanel.getHeight() / 2);
            this.activeChannelDisplay = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPortForward() {
        PortForwardEditorPane editor = new PortForwardEditorPane();
        int option = JOptionPane.showConfirmDialog(this, editor, "Add New Tunnel", 2, 3);
        if (option != 2) {
            try {
                block8: {
                    try {
                        ForwardingClient forwardingClient = this.client;
                        String id = editor.getForwardName();
                        if (id.equals("x11")) {
                            throw new Exception("The id of x11 is reserved.");
                        }
                        int i = this.model.getRowCount();
                        if (editor.isLocal()) {
                            ForwardingConfiguration f = forwardingClient.addLocalForwarding(id, editor.getBindAddress(), editor.getLocalPort(), editor.getHost(), editor.getRemotePort());
                            forwardingClient.startLocalForwarding(id);
                            this.active.addConfiguration(f);
                        } else {
                            forwardingClient.addRemoteForwarding(id, editor.getBindAddress(), editor.getLocalPort(), editor.getHost(), editor.getRemotePort());
                            forwardingClient.startRemoteForwarding(id);
                        }
                        if (i >= this.model.getRowCount()) break block8;
                        this.table.getSelectionModel().addSelectionInterval(i, i);
                    }
                    catch (Exception e) {
                        this.sessionPanel.setAvailableActions();
                        JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                        Object var8_9 = null;
                        this.model.refresh();
                        this.sessionPanel.setAvailableActions();
                    }
                }
                Object var8_8 = null;
                this.model.refresh();
                this.sessionPanel.setAvailableActions();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.model.refresh();
                this.sessionPanel.setAvailableActions();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void editPortForward() {
        ForwardingConfiguration config = this.model.getForwardingConfigurationAt(this.table.getSelectedRow());
        PortForwardEditorPane editor = new PortForwardEditorPane(config);
        int option = JOptionPane.showConfirmDialog(this, editor, "Edit Tunnel", 2, 3);
        if (option != 2) {
            try {
                block8: {
                    try {
                        ForwardingClient forwardingClient = this.client;
                        String id = editor.getForwardName();
                        if (id.equals("x11")) {
                            throw new Exception("The id of x11 is reserved.");
                        }
                        int i = this.model.getRowCount();
                        if (editor.isLocal()) {
                            forwardingClient.removeLocalForwarding(config.getName());
                            forwardingClient.addLocalForwarding(id, editor.getBindAddress(), editor.getLocalPort(), editor.getHost(), editor.getRemotePort());
                            forwardingClient.startLocalForwarding(id);
                        } else {
                            forwardingClient.removeRemoteForwarding(config.getName());
                            forwardingClient.addRemoteForwarding(id, editor.getBindAddress(), editor.getLocalPort(), editor.getHost(), editor.getRemotePort());
                            forwardingClient.startRemoteForwarding(id);
                        }
                        if (i >= this.model.getRowCount()) break block8;
                        this.table.getSelectionModel().addSelectionInterval(i, i);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                        Object var8_9 = null;
                        this.model.refresh();
                        this.sessionPanel.setAvailableActions();
                    }
                }
                Object var8_8 = null;
                this.model.refresh();
                this.sessionPanel.setAvailableActions();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.model.refresh();
                this.sessionPanel.setAvailableActions();
                throw throwable;
            }
        }
    }

    public void updateActiveDisplay() {
        Vector<ForwardingConfiguration> v = new Vector<ForwardingConfiguration>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            v.add(this.model.getForwardingConfigurationAt(i));
        }
        this.active.setConfiguration(v);
    }

    public void startForwarding() {
        ForwardingConfiguration conf = null;
        int failCount = 0;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.table.isRowSelected(i)) continue;
            try {
                conf = this.model.getForwardingConfigurationAt(i);
                if (conf.isForwarding()) continue;
                if (conf instanceof ForwardingClient.ClientForwardingListener) {
                    this.client.startLocalForwarding(conf.getName());
                } else {
                    this.client.startRemoteForwarding(conf.getName());
                }
                this.active.addConfiguration(conf);
                continue;
            }
            catch (ForwardingConfigurationException fce) {
                ++failCount;
                this.sessionPanel.setAvailableActions();
                if (conf == null) continue;
                conf.getState().setValue(3);
                continue;
            }
            catch (Exception e) {
                ++failCount;
                this.sessionPanel.setAvailableActions();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
        }
        this.model.refresh();
        this.sessionPanel.setAvailableActions();
        if (failCount > 0) {
            JOptionPane.showMessageDialog(this, String.valueOf(failCount) + " tunnel(s) failed to start:  " + "This port is already in use!", "Tunneling Error", 0);
        }
    }

    public void stopForwarding() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.table.isRowSelected(i)) continue;
            try {
                ForwardingConfiguration conf = this.model.getForwardingConfigurationAt(i);
                if (!conf.isForwarding()) continue;
                if (conf instanceof ForwardingClient.ClientForwardingListener) {
                    this.client.stopLocalForwarding(conf.getName());
                    continue;
                }
                this.client.stopRemoteForwarding(conf.getName());
                continue;
            }
            catch (Exception e) {
                this.sessionPanel.setAvailableActions();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
        }
        this.model.refresh();
        this.sessionPanel.setAvailableActions();
    }

    public void closeForwardingChannel() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.table.isRowSelected(i)) continue;
            try {
                ForwardingConfiguration conf = this.model.getForwardingConfigurationAt(i);
                List activeChannels = conf.getActiveForwardingSocketChannels();
                for (Channel channel : activeChannels) {
                    if (channel.isClosed()) continue;
                    channel.close();
                }
                if (!conf.isForwarding()) continue;
                if (conf instanceof ForwardingClient.ClientForwardingListener) {
                    this.client.stopLocalForwarding(conf.getName());
                    continue;
                }
                this.client.stopRemoteForwarding(conf.getName());
                continue;
            }
            catch (Exception e) {
                this.sessionPanel.setAvailableActions();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
        }
        this.model.refresh();
        this.sessionPanel.setAvailableActions();
    }
}

