/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import com.cisco.hfr.cwi.installer.InstallerUtil;
import com.cisco.hfr.cwi.installer.Preferences;
import com.cisco.hfr.mgbl.model.IConnectionParams;
import com.cisco.hfr.mgbl.model.IConnectionParams2;
import com.cisco.hfr.mgbl.model.ILoginScriptParams;
import com.cisco.hfr.mgbl.model.ILoginScriptStep;
import com.cisco.hfr.mgbl.model.ILoginScriptStepSend;
import de.mud.jta.HostUnreachableException;
import de.mud.jta.ICliSession;
import de.mud.jta.ICliSessionDelegatee;
import de.mud.jta.IRawSession;
import de.mud.jta.ITTYEventSubscriber;
import de.mud.jta.SSHv2Session;
import de.mud.jta.ScriptHandler;
import de.mud.jta.Utilities;
import de.mud.ssh.SshWrapper;
import de.mud.telnet.TelnetWrapper;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CliSessionProxy
implements ICliSession {
    private Log log = LogFactory.getLog(CliSessionProxy.class);
    private static final int SSH_PORT = 22;
    private static final int TELNET_PORT = 23;
    private static final int WAKEUP_DELAY = 2000;
    private static final String LOGIN_TIMEOUT_PROP = "login.timeout";
    private static final String DEFAULT_LOGIN_TIMEOUT = "20000";
    private static final String RAW_CLI_TIMEOUT_PROP = "rawclitimeout";
    private static final String DEFAULT_RAW_TIMEOUT = "300";
    private static final String ROMMON_PROMPT = "rommon";
    private static final String ENTER_USERNAME_PROMPT = "Enter root-system username:";
    private static final String IOX_ADMIN_PROMPT = "(admin)#";
    private static final String PROMPT_SESSION_TIMEOUT = "Press RETURN to get started";
    private static final String WAKEUP_SEQUENCE = "\r";
    private static final Pattern SPURIOUS_OUTPUT_REGEX = Pattern.compile("\\x0d\\x00");
    private static final String SCRIPTED_MACRO_USERNAME = "%USERNAME%";
    private ICliSessionDelegatee mDelegatee = null;
    private int mTimeout = 0;
    private int mRawTimeout = 0;
    private int mLoginTimeout = 0;
    private int mSessionType = -1;
    private String mPrompt = null;
    private boolean mIsRommon = true;
    private boolean mIsEnterUserName = true;
    private static final String SSH_LOGIN_FAILED_STR = "% Authentication failed";

    public CliSessionProxy(int type, String hostname, String username, String password, HashMap properties) throws HostUnreachableException {
        this(type, hostname, username, password, null, properties);
    }

    public CliSessionProxy(int type, String hostname, String username, String password, IConnectionParams connParams, HashMap properties) throws HostUnreachableException {
        this.mSessionType = type;
        this.initTimeouts();
        try {
            switch (type) {
                case 0: {
                    this.mDelegatee = this.createSSHv2Session(hostname, username, password, properties);
                    break;
                }
                case 1: {
                    this.mDelegatee = this.createSSHv1Session(hostname, username, password, properties);
                    break;
                }
                case 2: {
                    this.mDelegatee = this.createTelnetSession(hostname, username, password, properties);
                    break;
                }
                case 3: {
                    this.mDelegatee = this.createSerialSession(hostname, username, password, properties);
                    break;
                }
                default: {
                    this.log.error("Session type : " + type + " not supported");
                }
            }
            if (this.mDelegatee != null) {
                this.initCliSessionDelegatee(this.mDelegatee, username, password, properties, connParams);
            }
        }
        catch (UnknownHostException e) {
            this.log.error("Error during proxy creation", e);
            this.forceDisconnect();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("%HOST%", hostname);
            String msg = HostUnreachableException.getParametrizedMessage("No route to host %HOST%.", params);
            throw new HostUnreachableException(msg, "Verify that hostname/IP address is correct.");
        }
        catch (HostUnreachableException e) {
            this.log.error("Error during proxy creation", e);
            this.forceDisconnect();
            throw e;
        }
        catch (ConnectException ce) {
            this.log.error("Error during proxy creation", ce);
            this.forceDisconnect();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("%HOST%", hostname);
            String st = type == 0 || type == 1 ? "SSH" : "Telnet";
            params.put("%TYPE%", st);
            String msg = HostUnreachableException.getParametrizedMessage("Unable to establish a %TYPE% session with %HOST%.", params);
            throw new HostUnreachableException(msg, "Please verify connectivity and ensure that Telnet/SSH is enabled");
        }
        catch (Exception e) {
            this.log.error("Error during proxy creation", e);
            this.forceDisconnect();
            throw new HostUnreachableException(e.getMessage(), "");
        }
    }

    private void initTimeouts() {
        Preferences prefs = Preferences.getPreferenceInstance(InstallerUtil.getCWIPreferenceFileName());
        String rawTimeoutString = null;
        try {
            rawTimeoutString = prefs.getProperty("cwi", RAW_CLI_TIMEOUT_PROP, DEFAULT_RAW_TIMEOUT);
            if (rawTimeoutString.length() != 0) {
                this.mRawTimeout = Integer.parseInt(rawTimeoutString);
                if (this.mRawTimeout <= 0) {
                    this.log.error("Timeout specified in .ini file is invalid : " + this.mRawTimeout);
                    this.mRawTimeout = Integer.parseInt(DEFAULT_RAW_TIMEOUT);
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.log.error("CLI Raw timeout not an integer : " + rawTimeoutString, nfe);
            this.mRawTimeout = Integer.parseInt(DEFAULT_RAW_TIMEOUT);
        }
        this.log.debug("Raw timeout for this connection is : " + this.mRawTimeout);
        String loginTimeoutString = null;
        try {
            loginTimeoutString = prefs.getProperty("cwi", LOGIN_TIMEOUT_PROP, DEFAULT_LOGIN_TIMEOUT);
            if (loginTimeoutString.length() != 0) {
                this.mLoginTimeout = Integer.parseInt(loginTimeoutString);
                if (this.mLoginTimeout <= 0) {
                    this.log.error("Timeout specified in .ini file is invalid : " + this.mLoginTimeout);
                    this.mLoginTimeout = Integer.parseInt(DEFAULT_LOGIN_TIMEOUT);
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.log.error("Login timeout not an integer : " + loginTimeoutString, nfe);
            this.mLoginTimeout = Integer.parseInt(DEFAULT_LOGIN_TIMEOUT);
        }
        this.log.debug("Login timeout for this connection is : " + this.mLoginTimeout);
    }

    private void forceDisconnect() {
        if (this.mDelegatee != null) {
            try {
                this.disconnect();
                this.mDelegatee = null;
            }
            catch (IOException ioe) {
                this.log.debug("Error disconnecting delegatee", ioe);
            }
        }
    }

    public void connect(String host, int port) throws IOException {
        this.mDelegatee.connect(host, port);
    }

    private String getPrompt() {
        return this.mPrompt;
    }

    private String[] getAllPrompts() {
        String[] prompts = new String[5];
        String tempPrompt = this.mPrompt.substring(0, this.mPrompt.length() - "#".length());
        prompts[0] = this.getPrompt();
        prompts[1] = tempPrompt + "(config)#";
        prompts[2] = tempPrompt + IOX_ADMIN_PROMPT;
        prompts[3] = tempPrompt + "(admin-config)#";
        prompts[4] = PROMPT_SESSION_TIMEOUT;
        return prompts;
    }

    protected void setPrompt(String prompt) {
        this.mPrompt = prompt;
    }

    public void login(String username, String password, HashMap properties) throws IOException {
        this.login(username, password, properties, null);
    }

    private void login(String username, String password, HashMap properties, IConnectionParams connParams) throws IOException {
        try {
            String ret;
            this.mDelegatee.setReadTimeout(this.mLoginTimeout);
            this.mDelegatee.setTimeoutAcceptable(false);
            String delegateeUsername = username;
            String delegateePassword = password;
            boolean isScriptedLogin = false;
            IConnectionParams2 connParams2 = null;
            if (connParams != null && connParams instanceof IConnectionParams2 && (connParams2 = (IConnectionParams2)connParams).getConnectionCategory() == 3) {
                delegateeUsername = connParams2.getScriptedUserName();
                delegateePassword = connParams2.getScriptedPassword();
                isScriptedLogin = true;
            }
            this.mDelegatee.login(delegateeUsername, delegateePassword);
            if (isScriptedLogin) {
                ILoginScriptParams scriptParams = null;
                HashMap connProps = connParams2.getProperties();
                if (connProps != null && (scriptParams = (ILoginScriptParams)connProps.get("ScriptedLoginParams")) != null) {
                    if (scriptParams.sendWakeUpOnConnect()) {
                        properties.put("ConsoleData", null);
                    }
                    this.scriptedLogin(connParams2, scriptParams);
                }
            }
            if ((ret = this.login("Username:", username, "Password:", password, "#", 0, properties, isScriptedLogin)) == null) {
                throw new HostUnreachableException("Wrong UserName/Password combination.", "Login with correct UserName and Password.");
            }
            this.setSessionTimeout(this.mTimeout);
        }
        catch (SocketTimeoutException ste) {
            this.log.debug("SocketTimeoutException: " + ste);
            throw new HostUnreachableException("Device unreachable.", "Please verify device connectivity and configuration.");
        }
    }

    private void scriptedLogin(IConnectionParams2 connParams, ILoginScriptParams scriptParams) throws IOException {
        StringBuffer output = new StringBuffer();
        try {
            ILoginScriptStep[] steps = scriptParams.getSteps();
            block6: for (int ii = 0; ii < steps.length; ++ii) {
                String waitFor = steps[ii].getWaitFor();
                if (waitFor != null) {
                    this.logAndAppend("Waiting for : " + waitFor, output);
                    String result = this.waitfor(new String[]{waitFor}, false, null, true);
                    if (result.indexOf(waitFor) != -1) {
                        this.logAndAppend("   . . . Done\n", output);
                    } else {
                        this.logAndAppend("\n\n" + waitFor + " not found.\n\nReceived : " + result + "\n", output);
                        throw new IOException("Read timed-out");
                    }
                }
                ILoginScriptStepSend send = steps[ii].getSend();
                int actionType = send.getActionType();
                switch (actionType) {
                    case 0: {
                        int action = send.getPreDefAction();
                        if (action == 1) {
                            this.logAndAppend("Sending Scripted Username", output);
                            this.send(connParams.getScriptedUserName());
                            this.logAndAppend("   . . . Done\n", output);
                            continue block6;
                        }
                        if (action != 2) continue block6;
                        if (scriptParams.promptUserForPassword()) {
                            this.logAndAppend("Sending Prompted Password", output);
                        } else {
                            this.logAndAppend("Sending Scripted Password", output);
                        }
                        this.send(connParams.getScriptedPassword());
                        this.logAndAppend("   . . . Done\n", output);
                        continue block6;
                    }
                    case 1: {
                        String text = send.getUserText();
                        this.logAndAppend("Sending user text : " + text, output);
                        text = this.parseEscapeChars(text);
                        text = this.substituteMacros(text, connParams);
                        this.send(text);
                        this.logAndAppend("   . . . Done\n", output);
                        continue block6;
                    }
                    default: {
                        this.log.error("Unknown action type : " + actionType);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error doing scripted login", e);
            throw new HostUnreachableException(e.toString() + "\n\n" + output);
        }
    }

    private String parseEscapeChars(String input) {
        input = input.replaceAll("\\\\n", "\n");
        input = input.replaceAll("\\\\r", WAKEUP_SEQUENCE);
        input = input.replaceAll("\\\\t", "\t");
        return input;
    }

    private String substituteMacros(String input, IConnectionParams2 connParams) {
        input = input.replaceAll(SCRIPTED_MACRO_USERNAME, connParams.getUserName());
        return input;
    }

    private void logAndAppend(String message, StringBuffer buffer) {
        this.log.debug(message);
        buffer.append(message);
    }

    private String login(String login_prompt, String user, String pwd_prompt, String pwd, String prompt_postfix, int interval, HashMap properties, boolean isScriptedLogin) throws IOException {
        boolean isConsole;
        this.setPrompt(null);
        this.mIsRommon = false;
        this.mIsEnterUserName = false;
        boolean usernameCheck = user != null && user.trim().length() > 0;
        boolean pwdCheck = pwd != null && pwd.trim().length() > 0;
        boolean bl = isConsole = properties != null && properties.containsKey("ConsoleData");
        if (isConsole) {
            this.log.debug("Properties indicate this is a console connection");
            this.doWakeupProcessing();
        }
        boolean passwordSent = false;
        String result = null;
        if (usernameCheck || pwdCheck) {
            this.log.debug("Doing login check");
            result = this.waitfor(new String[]{login_prompt, pwd_prompt, ROMMON_PROMPT, ENTER_USERNAME_PROMPT}, false, null, true);
            if (result.indexOf(login_prompt) != -1) {
                this.log.debug("Found login prompt - sending username");
                this.send(user, interval);
                this.waitfor(pwd_prompt, false);
                this.log.debug("Found password prompt - sending password");
                this.send(pwd, interval);
                passwordSent = true;
            } else if (result.indexOf(pwd_prompt) != -1) {
                this.log.debug("Found password prompt - sending password");
                this.send(pwd, interval);
                passwordSent = true;
            } else if (result.indexOf(ROMMON_PROMPT) != -1) {
                this.log.debug("Device is in ROMMON mode");
                this.mIsRommon = true;
                pwdCheck = false;
            } else if (result.indexOf(ENTER_USERNAME_PROMPT) != -1) {
                this.log.debug("Device is waiting for 'Enter root-system username:'");
                this.mIsEnterUserName = true;
                pwdCheck = false;
            } else if (result.indexOf("#") != -1 || result.indexOf(">") != -1) {
                pwdCheck = false;
            } else {
                throw new IOException("Connection attempt failed - device login or exec prompt not received");
            }
        }
        if (pwdCheck && !passwordSent) {
            this.log.debug("Password not sent yet - waiting for password prompt");
            this.waitfor(pwd_prompt, false);
            this.log.debug("Found password prompt - sending password");
            this.send(pwd, interval);
            passwordSent = true;
        }
        if (passwordSent) {
            this.log.debug("Password was sent");
            String failedLoginPrompt = login_prompt;
            String[] outcome = new String[]{failedLoginPrompt, SSH_LOGIN_FAILED_STR, pwd_prompt, ">", "#"};
            this.log.debug("Waiting for a prompt");
            result = this.waitfor(outcome, false);
            if (result == null) {
                return null;
            }
            result = this.removeNewLinePrefix(result.trim(), false);
        }
        if (!this.mIsRommon && !this.mIsEnterUserName) {
            if (!result.endsWith(">") && !result.endsWith("#")) {
                return null;
            }
            if (result.endsWith(">")) {
                this.log.debug("Prompt is not in enable mode");
                this.send("enable", interval);
                String[] outcome = new String[]{pwd_prompt, ">", "#", prompt_postfix};
                this.log.debug("Waiting for a prompt");
                result = this.waitfor(outcome, false);
                if (result == null) {
                    this.log.error("Result is null");
                    return null;
                }
                if (result.indexOf(pwd_prompt) != -1) {
                    this.log.debug("Found password prompt - sending enable password");
                    String enablePwd = null;
                    if (properties != null) {
                        enablePwd = (String)properties.get("EnablePassword");
                    }
                    if (enablePwd == null) {
                        enablePwd = "";
                    }
                    this.send(enablePwd, interval);
                    result = this.waitfor(outcome, false);
                    if (result == null || result.indexOf(pwd_prompt) != -1) {
                        this.log.error("Result is : " + result + " from sending enable pwd");
                        return null;
                    }
                }
            }
            if (isConsole) {
                this.log.debug("This is console connection so ensure we are at root prompt");
                result = this.resetPrompt(interval, prompt_postfix);
            }
            if (!(result = this.removeNewLinePrefix(result.trim(), false)).endsWith(prompt_postfix)) {
                this.log.error("Received data does not end with a prompt postfix");
                return null;
            }
        }
        this.setPrompt(result);
        return result;
    }

    private String resetPrompt(int interval, String promptPostfix) throws IOException {
        this.send("clear", interval);
        this.waitfor(promptPostfix, false);
        this.send("end", interval);
        String result = this.waitfor(promptPostfix, false);
        if (result != null && result.indexOf(IOX_ADMIN_PROMPT) != -1) {
            this.log.debug("Admin prompt detected, sending exit command");
            this.send("exit", interval);
            result = this.waitfor(promptPostfix, false);
        }
        return result;
    }

    private void doWakeupProcessing() throws IOException {
        this.log.debug("Doing wakeup processing");
        try {
            this.log.debug("Sleeping for 2000 ms");
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.debug("Sending wakeup sequence : \r");
        this.send(WAKEUP_SEQUENCE, 0, true);
        this.log.debug("Wakeup processing complete");
    }

    private void send(String cmd) throws IOException {
        this.send(cmd, 0);
    }

    private void send(String cmd, int interval) throws IOException {
        this.send(cmd, interval, false);
    }

    private void send(String cmd, int interval, boolean raw) throws IOException {
        if (!raw) {
            cmd = cmd + "\n";
        }
        this.log.debug("Sending : " + cmd);
        this.mDelegatee.write(cmd.getBytes());
        if (interval > 0) {
            try {
                Thread.sleep(interval);
            }
            catch (Exception e) {
                this.log.debug("Interval interrupted: " + e);
            }
        }
    }

    public boolean sendCommand(String cmd, String[] expectedPrompts, String[] goodNews, String[] badNews, int interval, String[] output, HashMap props) throws IOException {
        int endIndex;
        int i;
        String ret;
        boolean rawOutput = false;
        boolean inputEchoed = true;
        String[] propsExpectedPrompts = null;
        if (this.mIsRommon || this.mIsEnterUserName) {
            return false;
        }
        if (props != null) {
            rawOutput = props.containsKey("RawOutput");
            inputEchoed = !props.containsKey("TTYXMLMode");
            propsExpectedPrompts = (String[])props.get("ExpectedPrompts");
        }
        this.log.debug("Sending cmd [" + cmd + "]");
        this.send(cmd, interval, rawOutput);
        ArrayList outcomeList = new ArrayList();
        this.addStrings(propsExpectedPrompts, outcomeList);
        this.addStrings(expectedPrompts, outcomeList);
        this.addStrings(this.getAllPrompts(), outcomeList);
        String[] outcome = outcomeList.toArray(new String[outcomeList.size()]);
        String preamble = null;
        if (inputEchoed) {
            preamble = Utilities.createPreamble(cmd);
        }
        if ((ret = this.waitfor(outcome, rawOutput, preamble, false)) == null) {
            return false;
        }
        if (ret.lastIndexOf(PROMPT_SESSION_TIMEOUT) != -1) {
            throw new HostUnreachableException("Session timed-out - data took too long to receive", "Increase session timeout or use faster connection method");
        }
        if (rawOutput) {
            output[0] = ret;
            return true;
        }
        int newPromptIdx = -1;
        for (int i2 = 0; i2 < outcome.length; ++i2) {
            newPromptIdx = ret.lastIndexOf(outcome[i2]);
            if (newPromptIdx == -1) continue;
            int startIndex = 0;
            int endIndex2 = newPromptIdx != -1 ? newPromptIdx : ret.length();
            output[0] = ret.substring(startIndex, endIndex2).trim();
            break;
        }
        Object buff = null;
        int idx = 0;
        boolean returnSet = false;
        boolean isSuccess = true;
        if (badNews != null) {
            for (i = 0; i < badNews.length; ++i) {
                if (badNews[i].trim().equals(this.getPrompt())) {
                    if (output[0].length() != 0) continue;
                    isSuccess = false;
                    returnSet = true;
                    break;
                }
                idx = ret.indexOf(badNews[i]);
                if (idx == -1) continue;
                endIndex = newPromptIdx != -1 ? newPromptIdx : ret.length();
                output[1] = ret.substring(idx, endIndex);
                isSuccess = false;
                returnSet = true;
                break;
            }
        }
        if (!returnSet && goodNews != null && goodNews.length > 0) {
            isSuccess = false;
            for (i = 0; i < goodNews.length; ++i) {
                idx = ret.indexOf(goodNews[i]);
                if (idx == -1) continue;
                endIndex = newPromptIdx != -1 ? newPromptIdx : ret.length();
                output[2] = ret.substring(idx, endIndex);
                isSuccess = true;
                returnSet = true;
                break;
            }
        }
        return isSuccess;
    }

    private void addStrings(String string, ArrayList list) {
        if (string != null) {
            list.add(string);
        }
    }

    private void addStrings(String[] strings, ArrayList list) {
        if (strings != null) {
            for (int ii = 0; ii < strings.length; ++ii) {
                this.addStrings(strings[ii], list);
            }
        }
    }

    public String waitfor(String[] searchElements, boolean raw) throws IOException {
        return this.waitfor(searchElements, raw, null, false);
    }

    public String waitfor(String match, boolean raw) throws IOException {
        String[] matches = new String[]{match};
        return this.waitfor(matches, raw);
    }

    public String waitfor(String[] searchElements, boolean raw, String preamble, boolean returnResult) throws IOException {
        this.log.debug("Waitfor - Raw : " + raw + ", preamble : " + preamble);
        String result = null;
        PreambleResult preambleResult = this.skipPreamble(preamble);
        result = raw ? this.rawWaitFor(preambleResult.getExtraData()) : this.exactWaitFor(searchElements, preambleResult.getExtraData(), returnResult);
        this.logTelnetData("Result from delegated waitfor is : ", result);
        String prependString = null;
        if (raw) {
            prependString = preambleResult.getTotalData();
        } else if (preambleResult.getExtraData() != null) {
            prependString = new String(preambleResult.getExtraData());
        }
        if (prependString != null) {
            result = result == null ? prependString : prependString + result;
        }
        result = this.postProcessOutput(result);
        this.logTelnetData("End of waitfor - returning : ", result);
        return result;
    }

    private String postProcessOutput(String output) {
        return SPURIOUS_OUTPUT_REGEX.matcher(output).replaceAll("");
    }

    private PreambleResult skipPreamble(String preamble) throws IOException {
        StringBuffer totalDataBuffer = new StringBuffer();
        byte[] extraData = null;
        String totalData = null;
        if (preamble != null) {
            ScriptHandler[] preambleHandlers = Utilities.getScriptHandlers(new String[]{preamble});
            boolean receivedPreamble = false;
            byte[] b = new byte[256];
            while (!receivedPreamble) {
                int n = this.mDelegatee.read(b);
                if (n <= 0) continue;
                String current = new String(b, 0, n);
                totalDataBuffer.append(current);
                this.logTelnetData("Received : ", b, n);
                for (int i = 0; i < preambleHandlers.length; ++i) {
                    if (!preambleHandlers[i].match(b, n)) continue;
                    receivedPreamble = true;
                    this.log.debug("Received preamble!");
                    extraData = Utilities.dataAfterPreamble(totalDataBuffer.toString(), preambleHandlers[i].getMatchString());
                }
            }
            if (extraData != null) {
                this.logTelnetData("Extra data after preamble : ", extraData, extraData.length);
            } else {
                this.log.debug("No extra data after preamble");
            }
            if (totalDataBuffer.length() > 0) {
                totalData = totalDataBuffer.toString();
                this.logTelnetData("Total data : ", totalDataBuffer.toString());
            }
        }
        return new PreambleResult(extraData, totalData);
    }

    private String rawWaitFor(byte[] extraData) throws IOException {
        StringBuffer ret = new StringBuffer();
        byte[] b = new byte[256];
        this.log.debug("Setting timeout to " + this.mRawTimeout);
        this.mDelegatee.setReadTimeout(this.mRawTimeout);
        int n = 1;
        boolean receivedHash = false;
        if (extraData != null) {
            String extraDataString = new String(extraData);
            receivedHash = extraDataString.indexOf("#") != -1;
            this.log.debug("Received hash during preamble processing : " + receivedHash);
        }
        while (n > 0 || !receivedHash) {
            n = this.mDelegatee.read(b);
            if (n <= 0) continue;
            String current = new String(b, 0, n);
            ret.append(current);
            if (current.indexOf("#") != -1) {
                receivedHash = true;
                this.log.debug("Found hash character in response");
            }
            this.logTelnetData("Received : ", b, n);
        }
        this.log.debug("Setting timeout back to " + this.mTimeout);
        this.mDelegatee.setReadTimeout(this.mTimeout);
        return ret.toString();
    }

    private String exactWaitFor(String[] searchElements, byte[] extraData, boolean returnResult) throws IOException {
        StringBuffer ret = new StringBuffer();
        byte[] b = new byte[256];
        for (int ii = 0; ii < searchElements.length; ++ii) {
            this.log.debug("   Element " + ii + " : " + searchElements[ii]);
        }
        ScriptHandler[] searchHandlers = Utilities.getScriptHandlers(searchElements);
        boolean matched = false;
        if (extraData != null) {
            for (int i = 0; i < searchHandlers.length; ++i) {
                if (!searchHandlers[i].match(extraData, extraData.length)) continue;
                this.log.debug("Matched search element : " + searchHandlers[i].getMatchString());
                matched = true;
                break;
            }
        }
        int n = 1;
        block4: while (!matched) {
            try {
                n = this.mDelegatee.read(b);
            }
            catch (IOException ioe) {
                this.log.warn("IOException received during read", ioe);
                if (!returnResult) {
                    throw ioe;
                }
                matched = true;
            }
            if (n <= 0) continue;
            String current = new String(b, 0, n);
            this.logTelnetData("Received : ", b, n);
            ret.append(current);
            for (int i = 0; i < searchHandlers.length; ++i) {
                if (!searchHandlers[i].match(b, n) && current.indexOf("#") == -1) continue;
                this.log.debug("Matched search element : " + searchHandlers[i].getMatchString() + " or got" + " the Prompt " + "#");
                matched = true;
                continue block4;
            }
        }
        return ret.toString();
    }

    private void logTelnetData(String prefix, byte[] b, int n) {
        StringBuffer buffer = new StringBuffer();
        for (int ii = 0; ii < n; ++ii) {
            if (b[ii] == 0) continue;
            buffer.append((char)b[ii]);
        }
        this.log.debug(prefix + "[" + buffer + "]");
    }

    private void logTelnetData(String prefix, String data) {
        this.logTelnetData(prefix, data.getBytes(), data.length());
    }

    private String removeNewLinePrefix(String str, boolean first) {
        int CR = first ? str.indexOf(10) : str.lastIndexOf(10);
        return str.substring(CR + 1, str.length()).trim();
    }

    public void disconnect() throws IOException {
        this.mDelegatee.disconnect();
    }

    public void setSessionTimeout(int millisecs) {
        this.log.debug("Session timeout set to : " + millisecs);
        this.mTimeout = millisecs;
        this.mDelegatee.setReadTimeout(millisecs);
        if (millisecs > 0) {
            this.mDelegatee.setTimeoutAcceptable(false);
        } else {
            this.mDelegatee.setTimeoutAcceptable(true);
        }
    }

    public boolean isClosed() {
        return this.mDelegatee.isClosed();
    }

    private static String getHostnameOnly(String hostname) {
        int colonIndex = hostname.indexOf(":");
        if (colonIndex != -1) {
            hostname = hostname.substring(0, colonIndex);
        } else {
            int bracketIndex = hostname.indexOf("(");
            if (bracketIndex != -1) {
                hostname = hostname.substring(0, bracketIndex);
            }
        }
        return hostname;
    }

    private static int getPortOnly(String hostname, int defaultPort) {
        int port = defaultPort;
        String portOnly = "";
        int colonIndex = hostname.indexOf(":");
        if (colonIndex != -1) {
            portOnly = hostname.substring(colonIndex + 1);
            int bracketIndex = portOnly.indexOf("(");
            if (bracketIndex != -1) {
                portOnly = portOnly.substring(0, bracketIndex);
            }
            port = Integer.parseInt(portOnly);
        }
        return port;
    }

    public ICliSessionDelegatee createSerialSession(String hostname, String userName, String password, HashMap properties) throws Exception {
        this.log.debug("Trying serial to " + hostname);
        this.log.debug("Serial connection support removed from this library, throwing exception");
        throw new Exception("Serial connection feature not supported.");
    }

    private ICliSessionDelegatee createTelnetSession(String hostname, String userName, String password, HashMap properties) throws Exception {
        this.log.debug("Trying telnet to " + hostname);
        TelnetWrapper delegatee = new TelnetWrapper();
        delegatee.connect(CliSessionProxy.getHostnameOnly(hostname), CliSessionProxy.getPortOnly(hostname, 23));
        this.log.debug("Successfully connected using Telnet to " + hostname);
        return delegatee;
    }

    private ICliSessionDelegatee createSSHv2Session(String hostname, String userName, String password, HashMap properties) throws Exception {
        this.log.debug("Trying SSHv2 to " + hostname);
        SSHv2Session delegatee = new SSHv2Session();
        delegatee.connect(CliSessionProxy.getHostnameOnly(hostname), CliSessionProxy.getPortOnly(hostname, 22));
        this.log.debug("Successfully connected using SSH to " + hostname);
        return delegatee;
    }

    private ICliSessionDelegatee createSSHv1Session(String hostname, String userName, String password, HashMap properties) throws Exception {
        this.log.debug("Trying SSHv1 to " + hostname);
        SshWrapper delegatee = new SshWrapper();
        delegatee.connect(CliSessionProxy.getHostnameOnly(hostname), CliSessionProxy.getPortOnly(hostname, 22));
        this.log.debug("Successfully connected using SSHv1 to " + hostname);
        return delegatee;
    }

    private void initCliSessionDelegatee(ICliSessionDelegatee delegatee, String userName, String password, HashMap properties, IConnectionParams connParams) throws HostUnreachableException {
        try {
            this.login(userName, password, properties, connParams);
            if (!this.mIsRommon && !this.mIsEnterUserName) {
                String[] output = new String[1];
                this.sendCommand("terminal length 0", null, null, null, 0, output, properties);
                this.sendCommand("terminal width 512", null, null, null, 0, output, properties);
            }
        }
        catch (HostUnreachableException ex) {
            this.log.warn("Host unreachable exception received during initCliSessionDelegatee()", ex);
            throw ex;
        }
        catch (IOException ex) {
            this.log.warn("IO Exception received during initCliSessionDelegatee()", ex);
            throw new HostUnreachableException(ex.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void subscribeNotifications(ITTYEventSubscriber subscriber) throws IOException {
        cmd = "<?xml version='1.0' encoding=\"UTF-8\"?><Request><Alarm><Register/></Alarm></Request>";
        this.send(cmd);
        ret = this.waitfor("XML>", false);
        eventBuffer = new StringBuffer();
        block0: while (true) {
            if ((ret = this.waitfor("XML>", false)) == null) {
                continue;
            }
            eventBuffer = eventBuffer.append(ret);
            promptIndex = eventBuffer.indexOf("XML>");
            while (true) {
                if (promptIndex != -1) ** break;
                continue block0;
                eventData = eventBuffer.substring(0, promptIndex).trim();
                this.log.debug("EventTEXT = " + eventData);
                subscriber.eventReceived(eventData);
                eventBuffer.delete(0, promptIndex + "XML>".length());
                promptIndex = eventBuffer.indexOf("XML>");
            }
            break;
        }
    }

    public void sendKeepAlive() throws IOException {
        this.mDelegatee.write("\n".getBytes());
    }

    public IRawSession getRawSession() {
        return this.mDelegatee;
    }

    public int getSessionType() {
        return this.mSessionType;
    }

    private class PreambleResult {
        private byte[] mExtraData;
        private String mTotalData;

        public PreambleResult(byte[] extraData, String totalData) {
            this.mExtraData = extraData;
            this.mTotalData = totalData;
        }

        public byte[] getExtraData() {
            return this.mExtraData;
        }

        public String getTotalData() {
            return this.mTotalData;
        }
    }
}

