/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.Cipher;
import de.mud.ssh.SshMisc;
import java.math.BigInteger;

class SshCrypto {
    private Cipher sndCipher;
    private Cipher rcvCipher;

    public SshCrypto(String type, byte[] key) {
        this.sndCipher = Cipher.getInstance(type);
        this.rcvCipher = Cipher.getInstance(type);
        this.sndCipher.setKey(key);
        this.rcvCipher.setKey(key);
    }

    public byte[] encrypt(byte[] block) {
        return this.sndCipher.encrypt(block);
    }

    public byte[] decrypt(byte[] block) {
        return this.rcvCipher.decrypt(block);
    }

    public static byte[] encrypteRSAPkcs1Twice(byte[] clearData, byte[] server_key_public_exponent, byte[] server_key_public_modulus, byte[] host_key_public_exponent, byte[] host_key_public_modulus) {
        byte[] EncryptionBlock;
        if (host_key_public_modulus.length > server_key_public_modulus.length) {
            EncryptionBlock = SshCrypto.encryptData(clearData, server_key_public_modulus, server_key_public_exponent);
            EncryptionBlock = SshCrypto.encryptData(EncryptionBlock, host_key_public_modulus, host_key_public_exponent);
        } else {
            EncryptionBlock = SshCrypto.encryptData(clearData, host_key_public_modulus, host_key_public_exponent);
            EncryptionBlock = SshCrypto.encryptData(EncryptionBlock, server_key_public_modulus, server_key_public_exponent);
        }
        byte[] encrypted_session_key = new byte[EncryptionBlock.length + 2];
        encrypted_session_key[1] = (byte)(8 * EncryptionBlock.length & 0xFF);
        encrypted_session_key[0] = (byte)(8 * EncryptionBlock.length >> 8 & 0xFF);
        for (int i = 0; i < EncryptionBlock.length; ++i) {
            encrypted_session_key[i + 2] = EncryptionBlock[i];
        }
        return encrypted_session_key;
    }

    private static byte[] encryptData(byte[] clearData, byte[] modulus, byte[] exponent) {
        int i;
        byte[] EncryptionBlock = new byte[modulus.length];
        EncryptionBlock[0] = 0;
        EncryptionBlock[1] = 2;
        int offset = 2;
        for (i = 2; i < EncryptionBlock.length - clearData.length - 1; ++i) {
            EncryptionBlock[offset++] = SshMisc.getNotZeroRandomByte();
        }
        EncryptionBlock[offset++] = 0;
        for (i = 0; i < clearData.length; ++i) {
            EncryptionBlock[offset++] = clearData[i];
        }
        BigInteger m = new BigInteger(1, modulus);
        BigInteger e = new BigInteger(1, exponent);
        BigInteger message = new BigInteger(1, EncryptionBlock);
        message = message.modPow(e, m);
        byte[] messageByteTemp = message.toByteArray();
        byte[] messageByte = new byte[modulus.length];
        int tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        for (int i2 = messageByte.length - messageByteTemp.length + tempOffset; i2 < messageByte.length; ++i2) {
            messageByte[i2] = messageByteTemp[tempOffset++];
        }
        return messageByte;
    }
}

