/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BannerPanel
extends JPanel {
    protected String _title;
    protected String _subtitle;
    protected ImageIcon _titleIcon;
    public static final String TITLE_PROPERTY = "title";
    public static final String SUBTITLE_PROPERTY = "subTitle";
    public static final String ICON_PROPERTY = "icon";
    public static final String ICON_COMPONENT_PROPERTY = "iconComponent";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    public static final String PROPERTY_SUBTITLE_FONT = "subTitleFont";
    public static final String PROPERTY_TITLE_ICON_LOCATION = "titleIconLocation";
    private JComponent _iconComponent;
    protected int _subTitleIndent = 20;
    protected Font _titleFont;
    protected Color _titleColor;
    protected Font _subTitleFont;
    protected Color _subTitleColor;
    protected Paint _backgroundPaint;
    protected PropertyChangeListener _propertyListener;
    private JLabel _titleLabel;
    private MultilineLabel _subtitleLabel;
    protected Color _startColor;
    protected Color _endColor;
    protected boolean _isVertical;
    private int _titleIconLocation = 11;
    public JPanel _textPanel;

    public BannerPanel() {
        this.lazyInitialize();
    }

    public BannerPanel(String string) {
        this.setTitle(string);
        this.lazyInitialize();
    }

    public BannerPanel(String string, String string2) {
        this.setTitle(string);
        this.setSubtitle(string2);
        this.lazyInitialize();
    }

    public BannerPanel(String string, String string2, ImageIcon imageIcon) {
        this.setTitle(string);
        this.setSubtitle(string2);
        this.setTitleIcon(imageIcon);
        this.lazyInitialize();
    }

    public BannerPanel(String string, String string2, JComponent jComponent) {
        this.setTitle(string);
        this.setSubtitle(string2);
        this._iconComponent = jComponent;
        this.lazyInitialize();
    }

    public void lazyInitialize() {
        this.removeAll();
        this._textPanel = new JPanel(new BorderLayout(5, 5));
        this._textPanel.setOpaque(false);
        this._textPanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 2, 10));
        if (this.getSubTitleFont() == null) {
            this.setSubTitleFont(this.getFont());
        }
        this._subtitleLabel = new MultilineLabel(this.getSubtitle());
        this._subtitleLabel.setFont(this.getSubTitleFont());
        if (this.getSubTitleColor() == null) {
            this.setSubTitleColor(this.getForeground());
        }
        this._subtitleLabel.setForeground(this.getSubTitleColor());
        this._subtitleLabel.setBorder(BorderFactory.createEmptyBorder(0, this.getSubTitleIndent(), 0, 0));
        this._textPanel.add((Component)this._subtitleLabel, "Center");
        this._titleLabel = new JLabel(this.getTitle());
        if (this.getTitleFont() == null) {
            this.setTitleFont(SecurityUtils.createFont(this.getFont().getFontName(), 1, this.getFont().getSize() + 2));
        }
        this._titleLabel.setFont(this.getTitleFont());
        if (this.getTitleColor() == null) {
            this.setTitleColor(this.getForeground());
        }
        this._titleLabel.setForeground(this.getTitleColor());
        if (this.getSubtitle() != null && this.getSubtitle().length() != 0) {
            this._textPanel.add((Component)this._titleLabel, "First");
        } else {
            this._textPanel.add((Component)this._titleLabel, "Center");
        }
        if (this.getTitleIcon() == null && this._iconComponent == null) {
            this._iconComponent = new JLabel("");
        } else if (this.getTitleIcon() != null || this._iconComponent == null) {
            this._iconComponent = new JLabel(this.getTitleIcon());
        }
        this._iconComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 0));
        this.add((Component)this._textPanel, "Center");
        this.addIconComponent(this._iconComponent);
        this._propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (BannerPanel.this._titleLabel != null && BannerPanel.TITLE_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    BannerPanel.this._titleLabel.setText((String)propertyChangeEvent.getNewValue());
                } else if (BannerPanel.this._subtitleLabel != null && BannerPanel.SUBTITLE_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    BannerPanel.this._subtitleLabel.setText(string);
                    if (string != null && string.length() != 0) {
                        BannerPanel.this._textPanel.add((Component)BannerPanel.this._titleLabel, "First");
                        BannerPanel.this._textPanel.add((Component)BannerPanel.this._subtitleLabel, "Center");
                    } else {
                        BannerPanel.this._textPanel.add((Component)BannerPanel.this._titleLabel, "Center");
                    }
                } else if (BannerPanel.ICON_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    if (BannerPanel.this._iconComponent instanceof JLabel) {
                        ((JLabel)BannerPanel.this._iconComponent).setIcon(BannerPanel.this.getTitleIcon());
                    }
                } else if (BannerPanel.ICON_COMPONENT_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getOldValue() instanceof JComponent) {
                        BannerPanel.this._textPanel.remove((JComponent)propertyChangeEvent.getOldValue());
                    }
                    if (propertyChangeEvent.getNewValue() instanceof JComponent) {
                        BannerPanel.this.addIconComponent((JComponent)propertyChangeEvent.getNewValue());
                    }
                } else if (BannerPanel.PROPERTY_TITLE_FONT.equals(propertyChangeEvent.getPropertyName())) {
                    if (BannerPanel.this._titleLabel != null) {
                        BannerPanel.this._titleLabel.setFont((Font)propertyChangeEvent.getNewValue());
                    }
                } else if (BannerPanel.PROPERTY_SUBTITLE_FONT.equals(propertyChangeEvent.getPropertyName())) {
                    if (BannerPanel.this._subtitleLabel != null) {
                        BannerPanel.this._subtitleLabel.setFont((Font)propertyChangeEvent.getNewValue());
                    }
                } else if (BannerPanel.PROPERTY_TITLE_ICON_LOCATION.equals(propertyChangeEvent.getPropertyName())) {
                    BannerPanel.this.addIconComponent(BannerPanel.this._iconComponent);
                }
            }
        };
        this.addPropertyChangeListener(this._propertyListener);
    }

    private void addIconComponent(JComponent jComponent) {
        if (jComponent != null) {
            switch (this.getTitleIconLocation()) {
                case 3: {
                    this.add((Component)jComponent, "East");
                    break;
                }
                case 7: {
                    this.add((Component)jComponent, "West");
                    break;
                }
                case 10: {
                    this.add((Component)jComponent, "Before");
                    break;
                }
                case 11: {
                    this.add((Component)jComponent, "After");
                }
            }
        }
    }

    protected ImageIcon prepareTitleIcon(ImageIcon imageIcon) {
        return imageIcon;
    }

    public Paint getBackgroundPaint() {
        return this._backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this._backgroundPaint = paint;
    }

    public void setGradientPaint(Color color, Color color2, boolean bl) {
        this.setStartColor(color);
        this.setEndColor(color2);
        this.setVertical(bl);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getStartColor() != null && this.getEndColor() != null) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), this.getStartColor(), this.getEndColor(), this.isVertical());
        } else if (this.getBackgroundPaint() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.getBackgroundPaint());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        String string2 = this._title;
        this._title = string;
        this.firePropertyChange(TITLE_PROPERTY, string2, this._title);
    }

    public String getSubtitle() {
        return this._subtitle;
    }

    public void setSubtitle(String string) {
        String string2 = this._subtitle;
        this._subtitle = string;
        this.firePropertyChange(SUBTITLE_PROPERTY, string2, this._subtitle);
    }

    public ImageIcon getTitleIcon() {
        return this._titleIcon;
    }

    public void setTitleIcon(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = this._titleIcon;
        this._titleIcon = this.prepareTitleIcon(imageIcon);
        this.firePropertyChange(ICON_PROPERTY, imageIcon2, this._titleIcon);
    }

    public JComponent getIconComponent() {
        return this._iconComponent;
    }

    public void setIconComponent(JComponent jComponent) {
        JComponent jComponent2 = this._iconComponent;
        this._iconComponent = jComponent;
        this.firePropertyChange(ICON_COMPONENT_PROPERTY, jComponent2, this._iconComponent);
    }

    public Font getSubTitleFont() {
        return this._subTitleFont;
    }

    public void setSubTitleFont(Font font) {
        Font font2 = this._subTitleFont;
        this._subTitleFont = font;
        this.firePropertyChange(PROPERTY_SUBTITLE_FONT, font2, this._subTitleFont);
    }

    public Font getTitleFont() {
        return this._titleFont;
    }

    public void setTitleFont(Font font) {
        Font font2 = this._titleFont;
        this._titleFont = font;
        this.firePropertyChange(PROPERTY_TITLE_FONT, font2, this._titleFont);
    }

    public int getSubTitleIndent() {
        return this._subTitleIndent;
    }

    public void setSubTitleIndent(int n) {
        this._subTitleIndent = n;
    }

    public Color getTitleColor() {
        return this._titleColor;
    }

    public void setTitleColor(Color color) {
        this._titleColor = color;
        if (this._titleLabel != null) {
            this._titleLabel.setForeground(color);
        }
    }

    public Color getSubTitleColor() {
        return this._subTitleColor;
    }

    public void setSubTitleColor(Color color) {
        this._subTitleColor = color;
        if (this._subtitleLabel != null) {
            this._subtitleLabel.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._titleLabel != null) {
            this._titleLabel.setBackground(color);
        }
        if (this._subtitleLabel != null) {
            this._subtitleLabel.setBackground(color);
        }
        if (this._iconComponent != null) {
            this._iconComponent.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setTitleColor(color);
        this.setSubTitleColor(color);
        if (this._iconComponent != null) {
            this._iconComponent.setForeground(color);
        }
    }

    public Color getStartColor() {
        return this._startColor;
    }

    public void setStartColor(Color color) {
        this._startColor = color;
    }

    public Color getEndColor() {
        return this._endColor;
    }

    public void setEndColor(Color color) {
        this._endColor = color;
    }

    public boolean isVertical() {
        return this._isVertical;
    }

    public void setVertical(boolean bl) {
        this._isVertical = bl;
    }

    public int getTitleIconLocation() {
        return this._titleIconLocation;
    }

    public void setTitleIconLocation(int n) {
        int n2 = this._titleIconLocation;
        if (n2 != n) {
            this._titleIconLocation = n;
            this.firePropertyChange(PROPERTY_TITLE_ICON_LOCATION, n2, this._titleIconLocation);
        }
    }

    public JComponent getTitleLabel() {
        return this._titleLabel;
    }

    public JComponent getSubtitleLabel() {
        return this._subtitleLabel;
    }
}

