/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class EclipseMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;
    private static final boolean DEBUG = false;
    protected Color shadowColor;
    protected int defaultAccelEndGap;
    protected int defaultShadowWidth;
    private Color borderColor;
    private Color backgroundColor;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    protected ThemePainter _painter;
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new EclipseMenuItemUI();
    }

    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIDefaultsLookup.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIDefaultsLookup.getInsets(string + ".margin"));
        }
        this.defaultTextIconGap = UIDefaultsLookup.getInt("MenuItem.textIconGap");
        this.defaultAccelEndGap = UIDefaultsLookup.getInt("MenuItem.accelEndGap");
        this.defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
        this.borderColor = UIDefaultsLookup.getColor("MenuItem.selectionBorderColor");
        this.backgroundColor = UIDefaultsLookup.getColor("MenuItem.background");
        this.shadowColor = UIDefaultsLookup.getColor("MenuItem.shadowColor");
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        Object object = UIDefaultsLookup.get(string + ".borderPainted");
        this.menuItem.setBorderPainted(object instanceof Boolean ? (Boolean)object : false);
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIDefaultsLookup.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIDefaultsLookup.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIDefaultsLookup.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIDefaultsLookup.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIDefaultsLookup.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIDefaultsLookup.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIDefaultsLookup.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIDefaultsLookup.getIcon(string + ".checkIcon");
        }
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent jComponent2 = (JComponent)container;
            jComponent2.putClientProperty(MAX_ACC_WIDTH, null);
            jComponent2.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        this._painter = null;
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        String string2 = string + ".actionMap";
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get(string2);
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(string2, actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("doClick", new ClickAction());
        return actionMapUIResource;
    }

    InputMap createInputMap(int n) {
        if (n == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (keyStroke != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(keyStroke, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Serializable serializable;
        Container container;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n2;
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n3);
                string2 = string2 + this.acceleratorDelimiter;
            }
            string2 = (n2 = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n2) : string2 + keyStroke.getKeyChar();
        }
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : n, this.defaultAccelEndGap);
        r.setBounds(textRect);
        if (!iconRect.isEmpty()) {
            r = SwingUtilities.computeUnion(EclipseMenuItemUI.iconRect.x, EclipseMenuItemUI.iconRect.y, EclipseMenuItemUI.iconRect.width, EclipseMenuItemUI.iconRect.height, r);
        }
        if (!((container = this.menuItem.getParent()) == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int n4;
            serializable = (JComponent)container;
            Integer n5 = (Integer)((JComponent)serializable).getClientProperty(MAX_TEXT_WIDTH);
            Integer n6 = (Integer)((JComponent)serializable).getClientProperty(MAX_ACC_WIDTH);
            int n7 = n5 != null ? n5 : 0;
            int n8 = n4 = n6 != null ? n6 : 0;
            if (EclipseMenuItemUI.r.width < n7) {
                EclipseMenuItemUI.r.width = n7;
            } else {
                ((JComponent)serializable).putClientProperty(MAX_TEXT_WIDTH, EclipseMenuItemUI.r.width);
            }
            if (EclipseMenuItemUI.acceleratorRect.width > n4) {
                n4 = EclipseMenuItemUI.acceleratorRect.width;
                ((JComponent)serializable).putClientProperty(MAX_ACC_WIDTH, EclipseMenuItemUI.acceleratorRect.width);
            }
            EclipseMenuItemUI.r.width += n4;
            EclipseMenuItemUI.r.width += n;
            EclipseMenuItemUI.r.width += this.defaultAccelEndGap;
        }
        if (icon3 != null) {
            EclipseMenuItemUI.r.width += n;
        }
        serializable = jMenuItem.getInsets();
        if (this.useCheckAndArrow()) {
            serializable = UIDefaultsLookup.getInsets("MenuItem.margin");
            EclipseMenuItemUI.r.width += 5;
        }
        if (serializable != null) {
            EclipseMenuItemUI.r.width += ((Insets)serializable).left + ((Insets)serializable).right;
            EclipseMenuItemUI.r.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (EclipseMenuItemUI.r.width % 2 == 0) {
            ++EclipseMenuItemUI.r.width;
        }
        if (EclipseMenuItemUI.r.height % 2 == 0) {
            ++EclipseMenuItemUI.r.height;
        }
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            return r.getSize();
        }
        return new Dimension(EclipseMenuItemUI.r.height, EclipseMenuItemUI.r.width);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        Serializable serializable;
        Object object;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n2 = 0;
        int n3 = 0;
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            n2 = jMenuItem.getWidth();
            n3 = jMenuItem.getHeight();
        } else {
            n2 = jMenuItem.getHeight();
            n3 = jMenuItem.getWidth();
            object = (Graphics2D)graphics;
            serializable = ((Graphics2D)object).getTransform();
            ((Graphics2D)object).rotate(1.5707963267948966);
            ((Graphics2D)object).translate(0, -n3 + 1);
        }
        object = jComponent.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n2, n3);
        EclipseMenuItemUI.viewRect.x += ((Insets)object).left;
        EclipseMenuItemUI.viewRect.y += ((Insets)object).top;
        EclipseMenuItemUI.viewRect.width -= ((Insets)object).right + EclipseMenuItemUI.viewRect.x;
        EclipseMenuItemUI.viewRect.height -= ((Insets)object).bottom + EclipseMenuItemUI.viewRect.y;
        serializable = graphics.getFont();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.acceleratorFont);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n4;
            int n5 = keyStroke.getModifiers();
            if (n5 > 0) {
                string = KeyEvent.getKeyModifiersText(n5);
                string = string + this.acceleratorDelimiter;
            }
            string = (n4 = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n4) : string + keyStroke.getKeyChar();
        }
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n);
        this.paintBackground(graphics, jMenuItem, color);
        Color color3 = graphics.getColor();
        if ((jComponent.getUIClassID().indexOf("CheckBoxMenu") >= 0 || jComponent.getUIClassID().indexOf("RadioButtonMenu") >= 0) && icon != null) {
            this.paintCheckBox(jMenuItem, graphics, icon);
            graphics.setColor(color3);
        }
        this.paintIcon(jMenuItem, graphics);
        if (string2 != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, jMenuItem, textRect, string2);
            }
        }
        if (string != null && !string.equals("")) {
            int n6 = 0;
            Container container = this.menuItem.getParent();
            if (container != null && container instanceof JComponent) {
                JComponent jComponent2 = (JComponent)container;
                Integer n7 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
                int n8 = n7 != null ? n7 : EclipseMenuItemUI.acceleratorRect.width;
                n6 = n8 - EclipseMenuItemUI.acceleratorRect.width;
            }
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    JideSwingUtilities.drawString(this.menuItem, graphics, string, EclipseMenuItemUI.acceleratorRect.x - n6, EclipseMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    JideSwingUtilities.drawString(this.menuItem, graphics, string, EclipseMenuItemUI.acceleratorRect.x - n6, EclipseMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    JideSwingUtilities.drawString(this.menuItem, graphics, string, EclipseMenuItemUI.acceleratorRect.x - n6 - 1, EclipseMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                JideSwingUtilities.drawString(this.menuItem, graphics, string, EclipseMenuItemUI.acceleratorRect.x - n6, EclipseMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (this.useCheckAndArrow()) {
                icon2.paintIcon(jComponent, graphics, EclipseMenuItemUI.arrowIconRect.x, EclipseMenuItemUI.arrowIconRect.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont((Font)serializable);
    }

    private void paintCheckBox(JMenuItem jMenuItem, Graphics graphics, Icon icon) {
        boolean bl = false;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem instanceof JCheckBoxMenuItem) {
            bl = jMenuItem.isSelected();
        } else if (jMenuItem instanceof JRadioButtonMenuItem) {
            bl = jMenuItem.isSelected();
        }
        if (bl && jMenuItem.getIcon() == null) {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                if (icon instanceof ImageIcon) {
                    ImageIcon imageIcon = IconsFactory.createMaskImage(jMenuItem, icon, Color.BLACK, this.selectionForeground);
                    imageIcon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.checkIconRect.x, EclipseMenuItemUI.checkIconRect.y);
                } else {
                    ImageIcon imageIcon = IconsFactory.createNegativeImage(jMenuItem, icon);
                    imageIcon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.checkIconRect.x, EclipseMenuItemUI.checkIconRect.y);
                }
            } else if (icon instanceof ImageIcon) {
                ImageIcon imageIcon = IconsFactory.createMaskImage(jMenuItem, icon, Color.BLACK, jMenuItem.getForeground());
                imageIcon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.checkIconRect.x, EclipseMenuItemUI.checkIconRect.y);
            } else {
                icon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.checkIconRect.x, EclipseMenuItemUI.checkIconRect.y);
            }
        }
    }

    private void paintIcon(JMenuItem jMenuItem, Graphics graphics) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.getIcon() != null) {
            Icon icon;
            if (!buttonModel.isEnabled()) {
                icon = jMenuItem.getDisabledIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                    icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(jMenuItem, icon);
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = jMenuItem.getPressedIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                }
            } else {
                icon = jMenuItem.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.iconRect.x, EclipseMenuItemUI.iconRect.y);
            }
        }
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getBackground() instanceof UIResource) {
                graphics.setColor(this.backgroundColor);
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n, n2);
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(1, 1, n - 2, n2 - 2);
            }
            graphics.setColor(color2);
        }
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!buttonModel.isEnabled()) {
            WindowsGraphicsUtils.paintText((Graphics)graphics, (AbstractButton)jMenuItem, (Rectangle)rectangle, (String)string, (int)0);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = jMenuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                n = -1;
            }
            Color color = graphics.getColor();
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(color);
        }
    }

    private String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        rectangle.y = 0;
        rectangle.x = 0;
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            rectangle.height = this.menuItem.getHeight();
            rectangle.width = this.menuItem.getWidth();
        } else {
            rectangle.height = this.menuItem.getWidth();
            rectangle.width = this.menuItem.getHeight();
        }
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (string == null || string.equals("")) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            boolean bl = string == null || string.equals("");
            boolean bl2 = false;
            View view = null;
            View view2 = view = this.menuItem != null ? (View)this.menuItem.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = (int)view.getPreferredSpan(0);
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        if (icon == null) {
            if (this.useCheckAndArrow()) {
                rectangle2.height = 16;
                rectangle2.width = 16;
            } else {
                rectangle2.height = 0;
                rectangle2.width = 0;
            }
        } else {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        }
        if (icon3 == null) {
            rectangle6.height = 0;
            rectangle6.width = 0;
        } else {
            rectangle6.width = icon3.getIconWidth();
            rectangle6.height = icon3.getIconHeight();
        }
        if (icon2 == null) {
            rectangle5.height = 0;
            rectangle5.width = 0;
        } else {
            rectangle5.width = icon2.getIconWidth();
            rectangle5.height = icon2.getIconHeight();
        }
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            if (this.useCheckAndArrow()) {
                rectangle2.x = this.defaultShadowWidth - rectangle2.width >> 1;
                rectangle3.x = this.defaultShadowWidth + n5;
            } else if (icon != null) {
                rectangle2.x = this.menuItem.getInsets().left;
                rectangle3.x = rectangle2.x + rectangle2.width + n5;
            } else {
                rectangle3.x = this.menuItem.getInsets().left;
            }
            rectangle4.x = rectangle.x + rectangle.width - this.defaultAccelEndGap - rectangle4.width;
            if (this.useCheckAndArrow()) {
                rectangle5.x = this.defaultShadowWidth - rectangle5.width >> 1;
                rectangle6.x = rectangle.x + rectangle.width - n6 - rectangle6.width;
            }
        }
        if (n3 == 0) {
            rectangle3.y = (rectangle.height - rectangle3.height >> 1) + 1;
            rectangle2.y = (rectangle.height - rectangle2.height >> 1) + 1;
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        rectangle4.y = rectangle7.y + (rectangle7.height >> 1) - (rectangle4.height >> 1);
        if (this.useCheckAndArrow()) {
            rectangle6.y = (rectangle.height - rectangle6.height >> 1) + 1;
            rectangle5.y = (rectangle.height - rectangle5.height >> 1) + 1;
        }
        return string;
    }

    private boolean useCheckAndArrow() {
        boolean bl = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n = menuElementArray2.length;
        if (n == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n);
            menuElementArray[n] = this.menuItem;
        } else {
            int n2;
            for (n2 = menuElementArray2.length - 1; n2 >= 0 && menuElementArray2[n2].getComponent() != container; --n2) {
            }
            menuElementArray = new MenuElement[n2 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2 + 1);
            menuElementArray[n2 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected boolean isDownArrowVisible(Container container) {
        if (container instanceof TopLevelMenuContainer && ((TopLevelMenuContainer)((Object)container)).isMenuBar()) {
            return false;
        }
        if (container instanceof TopLevelMenuContainer && !((TopLevelMenuContainer)((Object)container)).isMenuBar()) {
            return true;
        }
        return !(container instanceof JMenuBar);
    }

    private static class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
                MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
                Point point = menuDragMouseEvent.getPoint();
                if (point.x >= 0 && point.x < EclipseMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < EclipseMenuItemUI.this.menuItem.getHeight()) {
                    EclipseMenuItemUI.this.doClick(menuSelectionManager);
                } else {
                    menuSelectionManager.clearSelectedPath();
                }
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                int n = EclipseMenuItemUI.this.menuItem.getMnemonic();
                if (n == 0 || menuKeyEvent.getPath().length != 2) {
                    return;
                }
                if (this.lower((char)n) == this.lower(menuKeyEvent.getKeyChar())) {
                    MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                    EclipseMenuItemUI.this.doClick(menuSelectionManager);
                    menuKeyEvent.consume();
                }
            }
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private char lower(char c2) {
            return Character.toLowerCase(c2);
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                Point point = mouseEvent.getPoint();
                if (point.x >= 0 && point.x < EclipseMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < EclipseMenuItemUI.this.menuItem.getHeight()) {
                    EclipseMenuItemUI.this.doClick(menuSelectionManager);
                } else {
                    menuSelectionManager.processMouseEvent(mouseEvent);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                int n = mouseEvent.getModifiers();
                if ((n & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
                } else {
                    menuSelectionManager.setSelectedPath(EclipseMenuItemUI.this.getPath());
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                int n = mouseEvent.getModifiers();
                if ((n & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
                } else {
                    MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                    if (menuElementArray.length > 1) {
                        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                        int n2 = menuElementArray.length - 1;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            menuElementArray2[i2] = menuElementArray[i2];
                        }
                        menuSelectionManager.setSelectedPath(menuElementArray2);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("labelFor") || string.equals("displayedMnemonic") || string.equals("accelerator")) {
                EclipseMenuItemUI.this.updateAcceleratorBinding();
            } else if (string.equals("text") || "font".equals(string) || "foreground".equals(string)) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            }
        }
    }
}

