/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.eclipse.EclipseMenuItemUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class EclipseMenuUI
extends EclipseMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private static boolean crossMenuMnemonic = true;
    private boolean isMouseOver = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new EclipseMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIDefaultsLookup.getBoolean("Menu.crossMenuMnemonic");
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            return;
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = 0;
        int n2 = 0;
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        Color color3 = UIDefaultsLookup.getColor("controlDkShadow");
        Color color4 = UIDefaultsLookup.getColor("Menu.mouseHoverBackground");
        Border border = UIDefaultsLookup.getBorder("Menu.mouseHoverBorder");
        Border border2 = UIDefaultsLookup.getBorder("Menu.mouseSelectedBorder");
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground());
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n, n2);
        }
        if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            if (border2 != null) {
                border2.paintBorder(jMenuItem, graphics, 0, 0, n - 1, n2);
            }
            graphics.setColor(color4);
            graphics.fillRect(1, 1, n - 3, n2 - 2);
        } else if (this.isMouseOver() && buttonModel.isEnabled()) {
            if (border != null) {
                border.paintBorder(jMenuItem, graphics, 0, 0, n - 1, n2);
            }
            graphics.setColor(color4);
            graphics.fillRect(1, 1, n - 3, n2 - 2);
        }
        if (this.isDownArrowVisible(jMenuItem.getParent())) {
            int n3 = n - 9;
            if (buttonModel.isSelected() || buttonModel.isArmed() || buttonModel.isPressed() || this.isMouseOver()) {
                JideSwingUtilities.paintArrow(graphics, this.selectionForeground, n3 - 2, n2 / 2 - 1, 5, 0);
            } else {
                JideSwingUtilities.paintArrow(graphics, jMenuItem.getForeground(), n3 - 2, n2 / 2 - 1, 5, 0);
            }
        }
        graphics.setColor(color2);
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    void updateMnemonicBinding() {
        int n = this.menuItem.getModel().getMnemonic();
        int[] nArray = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
        if (n == this.lastMnemonic || nArray == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            for (int n2 : nArray) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, n2, false));
            }
        }
        if (n != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            for (int n2 : nArray) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n, n2, false), "selectMenu");
            }
        }
        this.lastMnemonic = n;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMap actionMap = super.createActionMap();
        if (actionMap != null) {
            actionMap.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
        }
        return actionMap;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return new MenuHandler();
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    public static void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    protected static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    static JPopupMenu getActivePopupMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
            MenuElement menuElement = menuElementArray[i2];
            if (!(menuElement instanceof JPopupMenu)) continue;
            return (JPopupMenu)menuElement;
        }
        return null;
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        int n;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!(jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu() || !jMenuItem.getComponentOrientation().isLeftToRight())) {
            int n2 = UIDefaultsLookup.getInt("MenuItem.textIconGap");
            n = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
            rectangle.x = n + n2;
        }
        if (!buttonModel.isEnabled()) {
            ++rectangle.y;
            WindowsGraphicsUtils.paintText((Graphics)graphics, (AbstractButton)jMenuItem, (Rectangle)rectangle, (String)string, (int)0);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = jMenuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                n = -1;
            }
            Color color = graphics.getColor();
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected() || this.isMouseOver()) {
                graphics.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent() - 1);
            graphics.setColor(color);
        }
    }

    protected void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
        this.menuItem.getModel().setRollover(this.isMouseOver);
    }

    protected boolean isMouseOver() {
        return this.isMouseOver;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu() && this.isDownArrowVisible(this.menuItem.getParent())) {
            if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
                dimension.width += 11;
            } else {
                dimension.height += 11;
            }
        }
        return dimension;
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public EclipseMenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu jMenu, EclipseMenuUI eclipseMenuUI2) {
            this.menu = jMenu;
            this.ui = eclipseMenuUI2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            if (!EclipseMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < EclipseMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < EclipseMenuUI.this.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)EclipseMenuUI.this.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                        EclipseMenuUI.appendPath(menuElementArray, jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        EclipseMenuUI.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }

    private static class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        public void menuSelected(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.isComponentPartOfCurrentMenu(jMenu)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            JPopupMenu jPopupMenu;
            if (!crossMenuMnemonic && (jPopupMenu = EclipseMenuUI.getActivePopupMenu()) != null && jPopupMenu != EclipseMenuUI.this.menuItem.getParent()) {
                return;
            }
            int n = EclipseMenuUI.this.menuItem.getMnemonic();
            if (n == 0) {
                return;
            }
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            if (this.lower((char)n) == this.lower(menuKeyEvent.getKeyChar())) {
                JPopupMenu jPopupMenu2 = ((JMenu)EclipseMenuUI.this.menuItem).getPopupMenu();
                ArrayList<MenuElement> arrayList = new ArrayList<MenuElement>(Arrays.asList(menuElementArray));
                arrayList.add(jPopupMenu2);
                MenuElement[] menuElementArray2 = jPopupMenu2.getSubElements();
                if (menuElementArray2.length > 0) {
                    arrayList.add(menuElementArray2[0]);
                }
                MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                MenuElement[] menuElementArray3 = new MenuElement[]{};
                menuElementArray3 = arrayList.toArray(menuElementArray3);
                menuSelectionManager.setSelectedPath(menuElementArray3);
                menuKeyEvent.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            char c2 = menuKeyEvent.getKeyChar();
            if (!Character.isLetterOrDigit(c2)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
            for (int i2 = menuElementArray2.length - 1; i2 >= 0; --i2) {
                if (menuElementArray2[i2] != EclipseMenuUI.this.menuItem) continue;
                JPopupMenu jPopupMenu = ((JMenu)EclipseMenuUI.this.menuItem).getPopupMenu();
                if (!jPopupMenu.isVisible()) {
                    return;
                }
                MenuElement[] menuElementArray3 = jPopupMenu.getSubElements();
                MenuElement menuElement = menuElementArray2[menuElementArray2.length - 1];
                int n = -1;
                int n2 = 0;
                int n3 = -1;
                int[] nArray = null;
                for (int i3 = 0; i3 < menuElementArray3.length; ++i3) {
                    int n4 = ((JMenuItem)menuElementArray3[i3]).getMnemonic();
                    if (this.lower((char)n4) == this.lower(c2)) {
                        if (n2 == 0) {
                            n3 = i3;
                            ++n2;
                        } else {
                            if (nArray == null) {
                                nArray = new int[menuElementArray3.length];
                                nArray[0] = n3;
                            }
                            nArray[n2++] = i3;
                        }
                    }
                    if (menuElement != menuElementArray3[i3]) continue;
                    n = n2 - 1;
                }
                if (n2 != 0) {
                    if (n2 == 1) {
                        JMenuItem jMenuItem = (JMenuItem)menuElementArray3[n3];
                        if (!(jMenuItem instanceof JMenu)) {
                            menuSelectionManager.clearSelectedPath();
                            jMenuItem.doClick();
                        }
                    } else {
                        MenuElement menuElement2 = null;
                        menuElement2 = menuElementArray3[nArray[(n + 1) % n2]];
                        MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 2];
                        System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                        menuElementArray4[menuElementArray.length] = jPopupMenu;
                        menuElementArray4[menuElementArray.length + 1] = menuElement2;
                        menuSelectionManager.setSelectedPath(menuElementArray4);
                    }
                }
                menuKeyEvent.consume();
                return;
            }
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private char lower(char c2) {
            return Character.toLowerCase(c2);
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)EclipseMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (jMenu.isTopLevelMenu()) {
                if (jMenu.isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    object = jMenu.getParent();
                    if (object != null && ((Component)object).getParent() instanceof MenuElement) {
                        MenuElement[] menuElementArray = new MenuElement[]{(MenuElement)((Object)((Component)object).getParent()), (MenuElement)object, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    } else if (object != null && object instanceof MenuElement) {
                        MenuElement[] menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
            if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    EclipseMenuUI.appendPath((MenuElement[])object, jMenu.getPopupMenu());
                } else {
                    EclipseMenuUI.setupPostTimer(jMenu);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)EclipseMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)EclipseMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        EclipseMenuUI.appendPath(EclipseMenuUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(EclipseMenuUI.this.getPath());
                        EclipseMenuUI.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
            EclipseMenuUI.this.setMouseOver(true);
            EclipseMenuUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            EclipseMenuUI.this.setMouseOver(false);
            EclipseMenuUI.this.menuItem.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)EclipseMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu jMenu, boolean bl) {
            this.menu = jMenu;
            this.force = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (!crossMenuMnemonic && (object = EclipseMenuUI.getActivePopupMenu()) != null && object != this.menu.getParent()) {
                return;
            }
            object = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] menuElementArray2 = menuElementArray.length > 0 ? new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu(), menuElementArray[0]} : new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu()};
                    ((MenuSelectionManager)object).setSelectedPath(menuElementArray2);
                }
            } else {
                MenuElement[] menuElementArray = ((MenuSelectionManager)object).getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                    EclipseMenuUI.appendPath(menuElementArray, this.menu.getPopupMenu());
                }
            }
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("mnemonic")) {
                EclipseMenuUI.this.updateMnemonicBinding();
            }
        }
    }
}

