/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxList
extends JList {
    protected CheckBoxListCellRenderer _listCellRenderer;
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;
    private CheckBoxListSelectionModel _checkBoxListSelectionModel;
    protected Handler _handler;

    public CheckBoxList() {
        this.init();
    }

    public CheckBoxList(Vector<?> vector) {
        super(vector);
        this.init();
    }

    public CheckBoxList(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public CheckBoxList(ListModel listModel) {
        super(listModel);
        this.init();
    }

    protected void init() {
        this._checkBoxListSelectionModel = this.createCheckBoxListSelectionModel(this.getModel());
        this.setSelectionMode(2);
        this._listCellRenderer = this.createCellRenderer();
        this._handler = this.createHandler();
        this._checkBoxListSelectionModel.addListSelectionListener(this._handler);
        JideSwingUtilities.insertMouseListener(this, this._handler, 0);
        this.addKeyListener(this._handler);
        this.addPropertyChangeListener("model", this._handler);
        ListModel listModel = this.getModel();
        if (listModel != null) {
            listModel.addListDataListener(this._handler);
        }
    }

    protected CheckBoxListSelectionModel createCheckBoxListSelectionModel(ListModel listModel) {
        return new CheckBoxListSelectionModel(listModel);
    }

    protected CheckBoxListCellRenderer createCellRenderer() {
        return new CheckBoxListCellRenderer();
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public ListCellRenderer getCellRenderer() {
        if (this._listCellRenderer != null) {
            this._listCellRenderer.setActualListRenderer(super.getCellRenderer());
            return this._listCellRenderer;
        }
        return super.getCellRenderer();
    }

    public ListCellRenderer getActualCellRenderer() {
        return super.getCellRenderer();
    }

    @Override
    public int getNextMatch(String string, int n, Position.Bias bias) {
        return -1;
    }

    public boolean isCheckBoxEnabled(int n) {
        return true;
    }

    public boolean isCheckBoxVisible(int n) {
        return true;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean bl) {
        if (bl != this._checkBoxEnabled) {
            boolean bl2 = this._checkBoxEnabled;
            this._checkBoxEnabled = bl;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, bl2, this._checkBoxEnabled);
            this.repaint();
        }
    }

    public boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean bl) {
        if (bl != this._clickInCheckBoxOnly) {
            boolean bl2 = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = bl;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, bl2, this._clickInCheckBoxOnly);
        }
    }

    public CheckBoxListSelectionModel getCheckBoxListSelectionModel() {
        return this._checkBoxListSelectionModel;
    }

    public void setCheckBoxListSelectionModel(CheckBoxListSelectionModel checkBoxListSelectionModel) {
        this._checkBoxListSelectionModel = checkBoxListSelectionModel;
        this._checkBoxListSelectionModel.setModel(this.getModel());
    }

    public int[] getCheckBoxListSelectedIndices() {
        CheckBoxListSelectionModel checkBoxListSelectionModel = this.getCheckBoxListSelectionModel();
        int n = checkBoxListSelectionModel.getMinSelectionIndex();
        int n2 = checkBoxListSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        for (int i2 = n; i2 <= n2; ++i2) {
            if (!checkBoxListSelectionModel.isSelectedIndex(i2)) continue;
            nArray[n3] = i2;
            ++n3;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public void setCheckBoxListSelectedIndex(int n) {
        if (n >= 0 && n < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().setSelectionInterval(n, n);
        }
    }

    public void addCheckBoxListSelectedIndex(int n) {
        if (n >= 0 && n < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().addSelectionInterval(n, n);
        }
    }

    public void removeCheckBoxListSelectedIndex(int n) {
        if (n >= 0 && n < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().removeSelectionInterval(n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckBoxListSelectedIndices(int[] nArray) {
        CheckBoxListSelectionModel checkBoxListSelectionModel = this.getCheckBoxListSelectionModel();
        try {
            checkBoxListSelectionModel.setValueIsAdjusting(true);
            checkBoxListSelectionModel.clearSelection();
            int n = this.getModel().getSize();
            for (int n2 : nArray) {
                if (n2 < 0 || n2 >= n) continue;
                checkBoxListSelectionModel.addSelectionInterval(n2, n2);
            }
        }
        finally {
            checkBoxListSelectionModel.setValueIsAdjusting(false);
        }
    }

    public void setSelectedObjects(Object[] objectArray) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object object : objectArray) {
            hashMap.put(object, "");
        }
        this.setSelectedObjects(hashMap);
    }

    public void setSelectedObjects(Vector<?> vector) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object obj : vector) {
            hashMap.put(obj, "");
        }
        this.setSelectedObjects(hashMap);
    }

    private void setSelectedObjects(Map<Object, String> map) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Object e2 = this.getModel().getElementAt(i2);
            if (map.get(e2) == null) continue;
            arrayList.add(i2);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            Integer n = (Integer)arrayList.get(i3);
            nArray[i3] = n;
        }
        this.setCheckBoxListSelectedIndices(nArray);
    }

    public Object[] getCheckBoxListSelectedValues() {
        CheckBoxListSelectionModel checkBoxListSelectionModel = this.getCheckBoxListSelectionModel();
        ListModel listModel = this.getModel();
        int n = checkBoxListSelectionModel.getMinSelectionIndex();
        int n2 = checkBoxListSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[1 + (n2 - n)];
        int n3 = 0;
        for (int i2 = n; i2 <= n2; ++i2) {
            if (!checkBoxListSelectionModel.isSelectedIndex(i2)) continue;
            objectArray[n3] = listModel.getElementAt(i2);
            ++n3;
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
        return objectArray2;
    }

    public int getCheckBoxListSelectedIndex() {
        return this.getCheckBoxListSelectionModel().getMinSelectionIndex();
    }

    public Object getCheckBoxListSelectedValue() {
        int n = this.getCheckBoxListSelectionModel().getMinSelectionIndex();
        return n == -1 ? null : this.getModel().getElementAt(n);
    }

    public void setCheckBoxListSelectedValue(Object object, boolean bl) {
        if (object == null) {
            this.setSelectedIndex(-1);
        } else {
            ListModel listModel = this.getModel();
            int n = listModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                if (!object.equals(listModel.getElementAt(i2))) continue;
                this.setCheckBoxListSelectedIndex(i2);
                if (bl) {
                    this.ensureIndexIsVisible(i2);
                }
                this.repaint();
                return;
            }
            this.setCheckBoxListSelectedIndex(-1);
        }
        this.repaint();
    }

    public void addCheckBoxListSelectedValue(Object object, boolean bl) {
        if (object != null) {
            ListModel listModel = this.getModel();
            int n = listModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                if (!object.equals(listModel.getElementAt(i2))) continue;
                this.addCheckBoxListSelectedIndex(i2);
                if (bl) {
                    this.ensureIndexIsVisible(i2);
                }
                this.repaint();
                return;
            }
        }
    }

    public void addCheckBoxListSelectedValues(Object[] objectArray) {
        if (objectArray != null) {
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            for (Object object : objectArray) {
                hashMap.put(object, "");
            }
            ListModel listModel = this.getModel();
            boolean bl = false;
            int n = listModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                if (hashMap.get(listModel.getElementAt(i2)) == null) continue;
                this.addCheckBoxListSelectedIndex(i2);
                bl = true;
            }
            if (bl) {
                this.repaint();
            }
            hashMap.clear();
        }
    }

    public void removeCheckBoxListSelectedValue(Object object, boolean bl) {
        if (object != null) {
            ListModel listModel = this.getModel();
            int n = listModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                if (!object.equals(listModel.getElementAt(i2))) continue;
                this.removeCheckBoxListSelectedIndex(i2);
                if (bl) {
                    this.ensureIndexIsVisible(i2);
                }
                this.repaint();
                return;
            }
        }
    }

    public void clearCheckBoxListSelection() {
        this.getCheckBoxListSelectionModel().clearSelection();
    }

    public void selectAll() {
        this.getCheckBoxListSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
    }

    public void selectNone() {
        this.getCheckBoxListSelectionModel().removeIndexInterval(0, this.getModel().getSize() - 1);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return JideSwingUtilities.adjustPreferredScrollableViewportSize(this, super.getPreferredScrollableViewportSize());
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    ListSelectionListener,
    PropertyChangeListener,
    ListDataListener {
        protected CheckBoxList _list;
        int hotspot;

        public Handler(CheckBoxList checkBoxList) {
            this.hotspot = new JCheckBox().getPreferredSize().width;
            this._list = checkBoxList;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getOldValue() instanceof ListModel) {
                ((ListModel)propertyChangeEvent.getOldValue()).removeListDataListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof ListModel) {
                this._list.getCheckBoxListSelectionModel().setModel((ListModel)propertyChangeEvent.getNewValue());
                ((ListModel)propertyChangeEvent.getNewValue()).addListDataListener(this);
            }
        }

        protected boolean clicksInCheckBox(MouseEvent mouseEvent) {
            int n = this._list.locationToIndex(mouseEvent.getPoint());
            Rectangle rectangle = this._list.getCellBounds(n, n);
            if (rectangle != null) {
                if (this._list.getComponentOrientation().isLeftToRight()) {
                    return mouseEvent.getX() < rectangle.x + this.hotspot;
                }
                return mouseEvent.getX() > rectangle.x + rectangle.width - this.hotspot;
            }
            return false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (!this._list.isClickInCheckBoxOnly() || this.clicksInCheckBox(mouseEvent)) {
                int n = this._list.locationToIndex(mouseEvent.getPoint());
                this.toggleSelection(n);
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (!this._list.isClickInCheckBoxOnly() || this.clicksInCheckBox(mouseEvent)) {
                mouseEvent.consume();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (keyEvent.getModifiers() == 0 && keyEvent.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void toggleSelections() {
            int[] nArray = this._list.getSelectedIndices();
            CheckBoxListSelectionModel checkBoxListSelectionModel = this._list.getCheckBoxListSelectionModel();
            checkBoxListSelectionModel.removeListSelectionListener(this);
            checkBoxListSelectionModel.setValueIsAdjusting(true);
            try {
                if (nArray.length > 0) {
                    boolean bl = checkBoxListSelectionModel.isSelectedIndex(nArray[0]);
                    for (int n : nArray) {
                        if (!this._list.isCheckBoxEnabled(n)) continue;
                        if (bl && checkBoxListSelectionModel.isSelectedIndex(n)) {
                            checkBoxListSelectionModel.removeSelectionInterval(n, n);
                            continue;
                        }
                        if (bl || checkBoxListSelectionModel.isSelectedIndex(n)) continue;
                        checkBoxListSelectionModel.addSelectionInterval(n, n);
                    }
                }
            }
            finally {
                checkBoxListSelectionModel.setValueIsAdjusting(false);
                checkBoxListSelectionModel.addListSelectionListener(this);
                this._list.repaint();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this._list.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void toggleSelection(int n) {
            if (!this._list.isEnabled() || !this._list.isCheckBoxEnabled(n)) {
                return;
            }
            CheckBoxListSelectionModel checkBoxListSelectionModel = this._list.getCheckBoxListSelectionModel();
            boolean bl = checkBoxListSelectionModel.isSelectedIndex(n);
            checkBoxListSelectionModel.removeListSelectionListener(this);
            try {
                if (bl) {
                    checkBoxListSelectionModel.removeSelectionInterval(n, n);
                } else {
                    checkBoxListSelectionModel.addSelectionInterval(n, n);
                }
            }
            finally {
                checkBoxListSelectionModel.addListSelectionListener(this);
                this._list.repaint();
            }
        }

        protected void toggleSelection() {
            int n = this._list.getSelectedIndex();
            this.toggleSelection(n);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            CheckBoxListSelectionModel checkBoxListSelectionModel = this._list.getCheckBoxListSelectionModel();
            if (checkBoxListSelectionModel != null) {
                checkBoxListSelectionModel.insertIndexInterval(n, n2 - n + 1, true);
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            CheckBoxListSelectionModel checkBoxListSelectionModel = this._list.getCheckBoxListSelectionModel();
            if (checkBoxListSelectionModel != null) {
                checkBoxListSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }
    }
}

