/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideScrollPaneConstants;
import com.jidesoft.swing.JideScrollPaneLayout;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;

public class JideScrollPane
extends JScrollPane
implements JideScrollPaneConstants {
    protected JViewport _rowFooter;
    protected JViewport _columnFooter;
    protected Component _hLeft;
    protected Component _hRight;
    protected Component _vTop;
    protected Component _vBottom;
    private boolean _horizontalScrollBarCoversWholeWidth;
    private boolean _verticalScrollBarCoversWholeHeight;
    public static final String PROPERTY_HORIZONTAL_SCROLL_BAR_COVERS_WHOLE_WIDTH = "horizontalScrollBarCoversWholeWidth";
    public static final String PROPERTY_VERTICAL_SCROLL_BAR_COVERS_WHOLE_HEIGHT = "verticalScrollBarCoversWholeHeight";
    private boolean _columnHeadersHeightUnified;
    private boolean _columnFootersHeightUnified;
    public static final String PROPERTY_COLUMN_HEADERS_HEIGHT_UNIFIED = "columnHeadersHeightUnified";
    public static final String PROPERTY_COLUMN_FOOTERS_HEIGHT_UNIFIED = "columnFootersHeightUnified";

    public JideScrollPane(Component component, int n, int n2) {
        this.setLayout(new JideScrollPaneLayout.UIResource());
        this.setVerticalScrollBarPolicy(n);
        this.setHorizontalScrollBarPolicy(n2);
        this.setViewport(this.createViewport());
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        if (null != component) {
            this.setViewportView(component);
        }
        this.setOpaque(true);
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
    }

    public JideScrollPane(Component component) {
        this(component, 20, 30);
    }

    public JideScrollPane(int n, int n2) {
        this(null, n, n2);
    }

    public JideScrollPane() {
        this(null, 20, 30);
    }

    public JViewport getRowFooter() {
        return this._rowFooter;
    }

    public void setRowFooter(JViewport jViewport) {
        JViewport jViewport2 = this.getRowFooter();
        this._rowFooter = jViewport;
        if (null != jViewport) {
            this.add((Component)jViewport, "ROW_FOOTER");
        } else if (null != jViewport2) {
            this.remove(jViewport2);
        }
        this.firePropertyChange("rowFooter", jViewport2, jViewport);
        this.revalidate();
        this.repaint();
        JideSwingUtilities.synchronizeView(jViewport, this.getViewport(), 1);
        JideSwingUtilities.synchronizeView(this.getViewport(), jViewport, 1);
    }

    public void setRowHeader(JViewport jViewport) {
        super.setRowHeader(jViewport);
        JideSwingUtilities.synchronizeView(jViewport, this.getViewport(), 1);
    }

    public void setRowFooterView(Component component) {
        if (null == this.getRowFooter()) {
            this.setRowFooter(this.createViewport());
        }
        this.getRowFooter().setView(component);
    }

    public JViewport getColumnFooter() {
        return this._columnFooter;
    }

    public void setColumnFooter(JViewport jViewport) {
        JViewport jViewport2 = this.getColumnFooter();
        this._columnFooter = jViewport;
        if (null != jViewport) {
            this.add((Component)jViewport, "COLUMN_FOOTER");
        } else if (null != jViewport2) {
            this.remove(jViewport2);
        }
        this.firePropertyChange("columnFooter", jViewport2, jViewport);
        this.revalidate();
        this.repaint();
        JideSwingUtilities.synchronizeView(this._columnFooter, this.getViewport(), 0);
        JideSwingUtilities.synchronizeView(this.getViewport(), this._columnFooter, 0);
    }

    public void setColumnHeader(JViewport jViewport) {
        super.setColumnHeader(jViewport);
        JideSwingUtilities.synchronizeView(this.columnHeader, this.getViewport(), 0);
    }

    public void setColumnFooterView(Component component) {
        if (null == this.getColumnFooter()) {
            this.setColumnFooter(this.createViewport());
        }
        this.getColumnFooter().setView(component);
    }

    public Component getScrollBarCorner(String string) {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (string.equals("HORIZONTAL_LEADING")) {
            string = bl ? "HORIZONTAL_LEFT" : "HORIZONTAL_RIGHT";
        } else if (string.equals("HORIZONTAL_TRAILING")) {
            String string2 = string = bl ? "HORIZONTAL_RIGHT" : "HORIZONTAL_LEFT";
        }
        if (string.equals("HORIZONTAL_LEFT")) {
            return this._hLeft;
        }
        if (string.equals("HORIZONTAL_RIGHT")) {
            return this._hRight;
        }
        if (string.equals("VERTICAL_BOTTOM")) {
            return this._vBottom;
        }
        if (string.equals("VERTICAL_TOP")) {
            return this._vTop;
        }
        return null;
    }

    public void setScrollBarCorner(String string, Component component) {
        Component component2;
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (string.equals("HORIZONTAL_LEADING")) {
            string = bl ? "HORIZONTAL_LEFT" : "HORIZONTAL_RIGHT";
        } else if (string.equals("HORIZONTAL_TRAILING")) {
            String string2 = string = bl ? "HORIZONTAL_RIGHT" : "HORIZONTAL_LEFT";
        }
        if (string.equals("HORIZONTAL_LEFT")) {
            component2 = this._hLeft;
            this._hLeft = component;
        } else if (string.equals("HORIZONTAL_RIGHT")) {
            component2 = this._hRight;
            this._hRight = component;
        } else if (string.equals("VERTICAL_TOP")) {
            component2 = this._vTop;
            this._vTop = component;
        } else if (string.equals("VERTICAL_BOTTOM")) {
            component2 = this._vBottom;
            this._vBottom = component;
        } else {
            throw new IllegalArgumentException("invalid scroll bar corner key");
        }
        if (null != component2) {
            this.remove(component2);
        }
        if (null != component) {
            this.add(component, string);
        }
        if (component != null) {
            component.setComponentOrientation(this.getComponentOrientation());
        }
        this.firePropertyChange(string, component2, component);
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
        super.updateUI();
        this.setLayout(new JideScrollPaneLayout.UIResource());
        LookAndFeel.installBorder(this, "JideScrollPane.border");
    }

    public boolean isVerticalScrollBarCoversWholeHeight() {
        return this._verticalScrollBarCoversWholeHeight;
    }

    public void setHorizontalScrollBarCoversWholeWidth(boolean bl) {
        boolean bl2 = this._horizontalScrollBarCoversWholeWidth;
        if (bl2 != bl) {
            this._horizontalScrollBarCoversWholeWidth = bl;
            this.firePropertyChange(PROPERTY_HORIZONTAL_SCROLL_BAR_COVERS_WHOLE_WIDTH, bl2, this._horizontalScrollBarCoversWholeWidth);
            this.invalidate();
            this.doLayout();
            if (this.getHorizontalScrollBar() != null) {
                this.getHorizontalScrollBar().doLayout();
            }
        }
    }

    public boolean isHorizontalScrollBarCoversWholeWidth() {
        return this._horizontalScrollBarCoversWholeWidth;
    }

    public void setVerticalScrollBarCoversWholeHeight(boolean bl) {
        boolean bl2 = this._verticalScrollBarCoversWholeHeight;
        if (bl2 != bl) {
            this._verticalScrollBarCoversWholeHeight = bl;
            this.firePropertyChange(PROPERTY_VERTICAL_SCROLL_BAR_COVERS_WHOLE_HEIGHT, bl2, this._verticalScrollBarCoversWholeHeight);
            this.invalidate();
            this.doLayout();
            if (this.getVerticalScrollBar() != null) {
                this.getVerticalScrollBar().doLayout();
            }
        }
    }

    public boolean isColumnHeadersHeightUnified() {
        return this._columnHeadersHeightUnified;
    }

    public void setColumnHeadersHeightUnified(boolean bl) {
        boolean bl2 = this._columnHeadersHeightUnified;
        if (bl2 != bl) {
            this._columnHeadersHeightUnified = bl;
            this.firePropertyChange(PROPERTY_COLUMN_HEADERS_HEIGHT_UNIFIED, bl2, this._horizontalScrollBarCoversWholeWidth);
            this.invalidate();
            this.doLayout();
        }
    }

    public boolean isColumnFootersHeightUnified() {
        return this._columnFootersHeightUnified;
    }

    public void setColumnFootersHeightUnified(boolean bl) {
        boolean bl2 = this._columnFootersHeightUnified;
        if (bl2 != bl) {
            this._columnFootersHeightUnified = bl;
            this.firePropertyChange(PROPERTY_COLUMN_FOOTERS_HEIGHT_UNIFIED, bl2, this._horizontalScrollBarCoversWholeWidth);
            this.invalidate();
            this.doLayout();
        }
    }
}

