/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class PartialLineBorder
extends LineBorder
implements PartialSide {
    private int _sides = 15;
    private int _roundedCornerSize = 5;

    public PartialLineBorder(Color color) {
        super(color);
    }

    public PartialLineBorder(Color color, int n) {
        super(color, n);
    }

    public PartialLineBorder(Color color, int n, boolean bl) {
        super(color, n, bl);
    }

    public PartialLineBorder(Color color, int n, boolean bl, int n2) {
        super(color, n, bl);
        this._roundedCornerSize = n2;
    }

    public PartialLineBorder(Color color, int n, int n2) {
        super(color, n);
        this._sides = n2;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int n) {
        this._sides = n;
    }

    public int getRoundedCornerSize() {
        return this._roundedCornerSize;
    }

    public void setRoundedCornerSize(int n) {
        this._roundedCornerSize = n;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor);
        for (int i2 = 0; i2 < this.thickness; ++i2) {
            if (this._sides == 15) {
                if (!this.roundedCorners) {
                    graphics.drawRect(n + i2, n2 + i2, n3 - i2 - i2 - 1, n4 - i2 - i2 - 1);
                    continue;
                }
                Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
                graphics.drawRoundRect(n + i2, n2 + i2, n3 - i2 - i2 - 1, n4 - i2 - i2 - 1, this._roundedCornerSize, this._roundedCornerSize);
                JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
                continue;
            }
            if ((this._sides & 1) != 0) {
                graphics.drawLine(n, n2 + i2, n + n3 - 1, n2 + i2);
            }
            if ((this._sides & 2) != 0) {
                graphics.drawLine(n, n2 + n4 - i2 - 1, n + n3 - 1, n2 + n4 - i2 - 1);
            }
            if ((this._sides & 8) != 0) {
                graphics.drawLine(n + i2, n2, n + i2, n2 + n4 - 1);
            }
            if ((this._sides & 4) == 0) continue;
            graphics.drawLine(n + n3 - i2 - 1, n2, n + n3 - i2 - 1, n2 + n4 - 1);
        }
        graphics.setColor(color);
    }

    public Insets getBorderInsets(Component component) {
        Insets insets = super.getBorderInsets(component);
        if ((this._sides & 1) == 0) {
            insets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            insets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            insets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            insets.right = 0;
        }
        return insets;
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = super.getBorderInsets(component, insets);
        if ((this._sides & 1) == 0) {
            insets2.top = 0;
        }
        if ((this._sides & 2) == 0) {
            insets2.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            insets2.left = 0;
        }
        if ((this._sides & 4) == 0) {
            insets2.right = 0;
        }
        return insets2;
    }
}

