/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.utils.SystemInfo;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.border.Border;

public class ResizableWindow
extends JWindow
implements ResizableSupport {
    private ResizablePanel _resizablePanel;

    public ResizableWindow() {
        this.initComponents();
    }

    public ResizableWindow(Frame frame) {
        super(frame);
        this.initComponents();
    }

    public ResizableWindow(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.initComponents();
    }

    public ResizableWindow(Window window) {
        super(window);
        this.initComponents();
    }

    public ResizableWindow(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.initComponents();
    }

    protected void initComponents() {
        this._resizablePanel = new ResizablePanel(){

            protected Resizable createResizable() {
                return new Resizable(this){

                    public void resizing(int n, int n2, int n3, int n4, int n5) {
                        Container container = ResizableWindow.this.getContentPane();
                        if (SystemInfo.isJdk15Above()) {
                            container.setPreferredSize(new Dimension(n4, n5));
                        } else if (container instanceof JComponent) {
                            ((JComponent)container).setPreferredSize(new Dimension(n4, n5));
                        }
                        ResizableWindow.this.setBounds(n2, n3, n4, n5);
                        ResizableWindow.this.resizing();
                    }

                    public void beginResizing(int n) {
                        super.beginResizing(n);
                        ResizableWindow.this.beginResizing();
                    }

                    public void endResizing(int n) {
                        super.endResizing(n);
                        ResizableWindow.this.endResizing();
                    }

                    public boolean isTopLevel() {
                        return true;
                    }
                };
            }
        };
        this.setContentPane(this._resizablePanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ResizableWindow.this._resizablePanel.setSize(ResizableWindow.this.getSize());
            }
        });
    }

    protected void beginResizing() {
    }

    protected void resizing() {
    }

    protected void endResizing() {
    }

    public void setBorder(Border border) {
        this._resizablePanel.setBorder(border);
    }

    public Border getBorder() {
        return this._resizablePanel.getBorder();
    }

    public Resizable getResizable() {
        return this._resizablePanel.getResizable();
    }
}

