/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;

class ScrollPaneOverview
extends JComponent {
    private static final int MAX_SIZE = 400;
    private Component _owner;
    private JScrollPane _scrollPane;
    private Component _viewComponent;
    private JPopupMenu _popupMenu;
    private BufferedImage _image;
    private Rectangle _startRectangle;
    private Rectangle _rectangle;
    private Point _startPoint;
    private double _scale;
    private Color _selectionBorder;

    public ScrollPaneOverview(JScrollPane jScrollPane, Component component) {
        this._scrollPane = jScrollPane;
        this._owner = component;
        this._image = null;
        this._startRectangle = null;
        this._rectangle = null;
        this._startPoint = null;
        this._scale = 0.0;
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(13));
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (ScrollPaneOverview.this._startPoint != null) {
                    Point point = mouseEvent.getPoint();
                    int n = (int)((double)(point.x - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.x) / ScrollPaneOverview.this._scale);
                    int n2 = (int)((double)(point.y - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.y) / ScrollPaneOverview.this._scale);
                    ScrollPaneOverview.this.scroll(n, n2);
                }
                ScrollPaneOverview.this._startPoint = null;
                ScrollPaneOverview.this._startRectangle = ScrollPaneOverview.this._rectangle;
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (ScrollPaneOverview.this._startPoint == null) {
                    ScrollPaneOverview.this._startPoint = new Point(((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.x + ((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.width / 2, ((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.y + ((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.height / 2);
                }
                Point point = mouseEvent.getPoint();
                ScrollPaneOverview.this.moveRectangle(point.x - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.x, point.y - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.y);
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this._popupMenu = new JPopupMenu();
        this._popupMenu.setLayout(new BorderLayout());
        this._popupMenu.add((Component)this, "Center");
    }

    public void setSelectionBorderColor(Color color) {
        this._selectionBorder = color;
    }

    public Color getSelectionBorder() {
        return this._selectionBorder;
    }

    protected void paintComponent(Graphics graphics) {
        if (this._image == null || this._rectangle == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        graphics.setColor(this._scrollPane.getViewport().getView().getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this._image, n, n2, null);
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        Area area = new Area(new Rectangle(n, n2, n3, n4));
        area.subtract(new Area(this._rectangle));
        graphics.setColor(new Color(255, 255, 255, 128));
        graphics2D.fill(area);
        Color color = graphics.getColor();
        graphics.setColor(this._selectionBorder);
        graphics.drawRect(this._rectangle.x, this._rectangle.y, this._rectangle.width, this._rectangle.height);
        graphics.setColor(color);
    }

    public Dimension getPreferredSize() {
        if (this._image == null || this._rectangle == null) {
            return new Dimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this._image.getWidth(null) + insets.left + insets.right, this._image.getHeight(null) + insets.top + insets.bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display() {
        this._viewComponent = this._scrollPane.getViewport().getView();
        if (this._viewComponent == null) {
            return;
        }
        int n = Math.max(400, Math.max(this._scrollPane.getWidth(), this._scrollPane.getHeight()) / 2);
        double d2 = this._viewComponent.getWidth();
        double d3 = this._viewComponent.getHeight();
        double d4 = (double)n / d2;
        double d5 = (double)n / d3;
        this._scale = Math.min(d4, d5);
        this._image = new BufferedImage((int)((double)this._viewComponent.getWidth() * this._scale), (int)((double)this._viewComponent.getHeight() * this._scale), 1);
        Graphics2D graphics2D = this._image.createGraphics();
        graphics2D.scale(this._scale, this._scale);
        boolean bl = this._viewComponent.isDoubleBuffered();
        try {
            if (this._viewComponent instanceof JComponent) {
                ((JComponent)this._viewComponent).setDoubleBuffered(false);
            }
            this._viewComponent.paint(graphics2D);
        }
        finally {
            if (this._viewComponent instanceof JComponent) {
                ((JComponent)this._viewComponent).setDoubleBuffered(bl);
            }
            graphics2D.dispose();
        }
        this._startRectangle = this._scrollPane.getViewport().getViewRect();
        Insets insets = this.getInsets();
        this._startRectangle.x = (int)(this._scale * (double)this._startRectangle.x + (double)insets.left);
        this._startRectangle.y = (int)(this._scale * (double)this._startRectangle.y + (double)insets.right);
        this._startRectangle.width = (int)((double)this._startRectangle.width * this._scale);
        this._startRectangle.height = (int)((double)this._startRectangle.height * this._scale);
        this._rectangle = this._startRectangle;
        Point point = new Point(this._rectangle.x + this._rectangle.width / 2, this._rectangle.y + this._rectangle.height / 2);
        this._popupMenu.show(this._owner, -point.x, -point.y);
    }

    private void moveRectangle(int n, int n2) {
        if (this._startRectangle == null) {
            return;
        }
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(this._startRectangle);
        rectangle.x += n;
        rectangle.y += n2;
        rectangle.x = Math.min(Math.max(rectangle.x, insets.left), this.getWidth() - insets.right - rectangle.width);
        rectangle.y = Math.min(Math.max(rectangle.y, insets.right), this.getHeight() - insets.bottom - rectangle.height);
        Rectangle rectangle2 = new Rectangle();
        Rectangle.union(this._rectangle, rectangle, rectangle2);
        rectangle2.grow(2, 2);
        this._rectangle = rectangle;
        this.paintImmediately(rectangle2);
    }

    private void scroll(int n, int n2) {
        JComponent jComponent = (JComponent)this._scrollPane.getViewport().getView();
        Rectangle rectangle = jComponent.getVisibleRect();
        rectangle.x += n;
        rectangle.y += n2;
        jComponent.scrollRectToVisible(rectangle);
        this._popupMenu.setVisible(false);
    }
}

