/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StyledLabelBuilder {
    private StringBuffer buffer = new StringBuffer();
    private List ranges = new ArrayList();
    private int start = 0;
    private Map styles = new HashMap();
    private static int[] colorShorthandTable = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    private static Map colorNamesMap = new TreeMap();

    public void clear() {
        this.buffer.delete(0, this.buffer.length());
        this.ranges.clear();
        this.start = 0;
    }

    public StyledLabelBuilder register(String string, Color color) {
        this.styles.put(string, new StyleRange(color));
        return this;
    }

    public StyledLabelBuilder register(String string, int n) {
        this.styles.put(string, new StyleRange(n));
        return this;
    }

    public StyledLabelBuilder register(String string, int n, Color color) {
        this.styles.put(string, new StyleRange(n, color));
        return this;
    }

    public StyledLabelBuilder register(String string, int n, Color color, int n2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, color, n2));
        return this;
    }

    public StyledLabelBuilder register(String string, int n, Color color, int n2, Color color2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, color, n2, color2));
        return this;
    }

    public StyledLabelBuilder register(String string, int n, Color color, int n2, Color color2, Stroke stroke) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, color, n2, color2, stroke));
        return this;
    }

    public StyledLabelBuilder register(String string, int n, Color color, int n2, Color color2, Stroke stroke, float f2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, color, n2, color2, stroke, f2));
        return this;
    }

    public StyledLabelBuilder register(String string, int n, int n2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, n2));
        return this;
    }

    public StyledLabelBuilder register(String string, int n, int n2, float f2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, n2, f2));
        return this;
    }

    public StyledLabelBuilder register(String string, String string2) {
        ParsedStyleResult parsedStyleResult = StyledLabelBuilder.parseStyleAnnotation(string2.toCharArray(), 0, this);
        this.styles.put(string, new StyleRange(parsedStyleResult.fontStyle, parsedStyleResult.fontColor, parsedStyleResult.backgroundColor, parsedStyleResult.additionalStyle, parsedStyleResult.lineColor));
        return this;
    }

    public StyledLabelBuilder add(String string) {
        this.buffer.append(string);
        this.start += string.length();
        return this;
    }

    public StyledLabelBuilder add(String string, Color color) {
        this.ranges.add(new StyleRange(this.start, string.length(), color));
        return this.add(string);
    }

    public StyledLabelBuilder add(String string, int n) {
        this.ranges.add(new StyleRange(this.start, string.length(), n));
        return this.add(string);
    }

    public StyledLabelBuilder add(String string, int n, Color color) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color));
        return this.add(string);
    }

    public StyledLabelBuilder add(String string, int n, Color color, int n2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, n2));
        return this.add(string);
    }

    public StyledLabelBuilder add(String string, int n, Color color, int n2, Color color2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, n2, color2));
        return this.add(string);
    }

    public StyledLabelBuilder add(String string, int n, Color color, Color color2, int n2, Color color3) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, color2, n2, color3));
        return this.add(string);
    }

    public StyledLabelBuilder add(String string, int n, Color color, Color color2, int n2, Color color3, Stroke stroke) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, color2, n2, color3, stroke));
        return this.add(string);
    }

    public StyledLabelBuilder add(String string, int n, Color color, int n2, Color color2, Stroke stroke, float f2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, n2, color2, stroke, f2));
        return this.add(string);
    }

    public StyledLabelBuilder add(String string, String string2) {
        StyleRange styleRange = (StyleRange)this.styles.get(string2);
        if (styleRange == null) {
            ParsedStyleResult parsedStyleResult = StyledLabelBuilder.parseStyleAnnotation(string2.toCharArray(), 0, this);
            return this.add(string, parsedStyleResult.fontStyle, parsedStyleResult.fontColor, parsedStyleResult.backgroundColor, parsedStyleResult.additionalStyle, parsedStyleResult.lineColor);
        }
        return this.add(string, styleRange.getFontStyle(), styleRange.getFontColor(), styleRange.getAdditionalStyle(), styleRange.getLineColor(), styleRange.getLineStroke(), styleRange.getFontShrinkRatio());
    }

    public StyledLabelBuilder add(String string, int n, int n2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, n2));
        return this.add(string);
    }

    public StyledLabelBuilder add(String string, int n, int n2, float f2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, n2, f2));
        return this.add(string);
    }

    public StyledLabel configure(StyledLabel styledLabel, String string) {
        StyledLabelBuilder.setStyledText(styledLabel, string, this);
        return styledLabel;
    }

    public StyledLabel configure(StyledLabel styledLabel) {
        styledLabel.setText(this.buffer.toString());
        int n = this.ranges.size();
        for (int i2 = 0; i2 < n; ++i2) {
            styledLabel.addStyleRange((StyleRange)this.ranges.get(i2));
        }
        return styledLabel;
    }

    public StyledLabel createLabel() {
        return this.configure(new StyledLabel());
    }

    public static StyledLabel createStyledLabel(String string) {
        StyledLabel styledLabel = new StyledLabel();
        StyledLabelBuilder.setStyledText(styledLabel, string);
        return styledLabel;
    }

    public static void setStyledText(StyledLabel styledLabel, String string) {
        StyledLabelBuilder.setStyledText(styledLabel, string.toCharArray());
    }

    private static void setStyledText(StyledLabel styledLabel, String string, StyledLabelBuilder styledLabelBuilder) {
        StyledLabelBuilder.setStyledText(styledLabel, string.toCharArray(), styledLabelBuilder);
    }

    public static void setStyledText(StyledLabel styledLabel, char[] cArray) {
        StyledLabelBuilder.setStyledText(styledLabel, cArray, null);
    }

    private static void setStyledText(StyledLabel styledLabel, char[] cArray, StyledLabelBuilder styledLabelBuilder) {
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        boolean bl = false;
        block4: for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (bl) {
                stringBuffer.append(cArray[i2]);
                bl = false;
                continue;
            }
            switch (cArray[i2]) {
                case '{': {
                    ParsedStyleResult parsedStyleResult = StyledLabelBuilder.parseStylePart(cArray, i2 + 1, styledLabelBuilder);
                    int n = stringBuffer.length();
                    stringBuffer.append(parsedStyleResult.text);
                    if (parsedStyleResult.text.length() > 0) {
                        styledLabel.addStyleRange(new StyleRange(n, parsedStyleResult.text.length(), parsedStyleResult.fontStyle, parsedStyleResult.fontColor, parsedStyleResult.backgroundColor, parsedStyleResult.additionalStyle, parsedStyleResult.lineColor));
                    }
                    i2 = parsedStyleResult.endOffset;
                    continue block4;
                }
                case '\\': {
                    bl = true;
                    continue block4;
                }
                default: {
                    stringBuffer.append(cArray[i2]);
                }
            }
        }
        styledLabel.setText(stringBuffer.toString());
    }

    private static ParsedStyleResult parseStylePart(char[] cArray, int n, StyledLabelBuilder styledLabelBuilder) {
        ParsedStyleResult parsedStyleResult = new ParsedStyleResult();
        int n2 = n;
        int n3 = StyledLabelBuilder.findNext(cArray, ':', n2);
        parsedStyleResult.text = StyledLabelBuilder.createTrimmedString(cArray, n2, n3 - 1);
        return StyledLabelBuilder.parseStyleAnnotation(cArray, n3 + 1, styledLabelBuilder, parsedStyleResult);
    }

    private static ParsedStyleResult parseStyleAnnotation(char[] cArray, int n, StyledLabelBuilder styledLabelBuilder) {
        ParsedStyleResult parsedStyleResult = new ParsedStyleResult();
        return StyledLabelBuilder.parseStyleAnnotation(cArray, n, styledLabelBuilder, parsedStyleResult);
    }

    private static ParsedStyleResult parseStyleAnnotation(char[] cArray, int n, StyledLabelBuilder styledLabelBuilder, ParsedStyleResult parsedStyleResult) {
        int n2 = n;
        char[] cArray2 = new char[]{',', '}'};
        boolean bl = false;
        while (n2 < cArray.length && !bl) {
            Object object;
            String string;
            int n3;
            n = StyledLabelBuilder.findNextOf(cArray, cArray2, n2);
            if (n == -1 || cArray[n] == '}') {
                bl = true;
            }
            if ((n3 = (string = StyledLabelBuilder.createTrimmedString(cArray, n2, n == -1 ? cArray.length - 1 : n - 1)).indexOf(58)) != -1) {
                object = string.substring(n3 + 1);
                if (((String)object).length() > 1) {
                    if (((String)object).charAt(0) == '(') {
                        n = StyledLabelBuilder.findNext(cArray, ')', n2 + n3 + 1);
                        string = StyledLabelBuilder.createTrimmedString(cArray, n2, n + 1);
                        object = string.substring(n3 + 1);
                        if (cArray[n + 1] == '}') {
                            bl = true;
                        }
                        ++n;
                    }
                    if (string.charAt(0) == 'f') {
                        parsedStyleResult.fontColor = StyledLabelBuilder.toColor((String)object);
                    } else if (string.charAt(0) == 'b') {
                        parsedStyleResult.backgroundColor = StyledLabelBuilder.toColor((String)object);
                    } else {
                        parsedStyleResult.lineColor = StyledLabelBuilder.toColor((String)object);
                    }
                }
            } else if (string.equals("plain") || string.equals("p")) {
                parsedStyleResult.fontStyle = 0;
            } else if (string.equals("bold") || string.equals("b")) {
                parsedStyleResult.fontStyle = 1;
            } else if (string.equals("italic") || string.equals("i")) {
                parsedStyleResult.fontStyle = 2;
            } else if (string.equals("bolditalic") || string.equals("bi")) {
                parsedStyleResult.fontStyle = 3;
            } else if (string.equals("strike") || string.equals("s")) {
                parsedStyleResult.additionalStyle |= 1;
            } else if (string.equals("doublestrike") || string.equals("ds")) {
                parsedStyleResult.additionalStyle |= 2;
            } else if (string.equals("waved") || string.equals("w")) {
                parsedStyleResult.additionalStyle |= 4;
            } else if (string.equals("underlined") || string.equals("u")) {
                parsedStyleResult.additionalStyle |= 8;
            } else if (string.equals("dotted") || string.equals("d")) {
                parsedStyleResult.additionalStyle |= 0x10;
            } else if (string.equals("superscript") || string.equals("sp")) {
                parsedStyleResult.additionalStyle |= 0x20;
            } else if (string.equals("subscipt") || string.equals("sb")) {
                parsedStyleResult.additionalStyle |= 0x40;
            } else if (styledLabelBuilder != null && styledLabelBuilder.styles.containsKey(string)) {
                object = (StyleRange)styledLabelBuilder.styles.get(string);
                parsedStyleResult.fontStyle = ((StyleRange)object).getFontStyle();
                parsedStyleResult.fontColor = ((StyleRange)object).getFontColor();
                parsedStyleResult.backgroundColor = ((StyleRange)object).getBackgroundColor();
                parsedStyleResult.additionalStyle = ((StyleRange)object).getAdditionalStyle();
                parsedStyleResult.lineColor = ((StyleRange)object).getLineColor();
            } else if (string.length() > 0) {
                System.err.println("Unknown style '" + string + "'");
            }
            n2 = n + 1;
        }
        parsedStyleResult.endOffset = n2 - 1;
        return parsedStyleResult;
    }

    private static Color toColor(String string) {
        switch (string.charAt(0)) {
            case '(': {
                int n = StyledLabelBuilder.nextColorInt(string, 1);
                int n2 = string.indexOf(44);
                int n3 = StyledLabelBuilder.nextColorInt(string, n2 + 1);
                n2 = string.indexOf(44, n2 + 1);
                int n4 = StyledLabelBuilder.nextColorInt(string, n2 + 1);
                return new Color(n, n3, n4);
            }
            case '#': {
                if (string.length() == 4) {
                    return new Color(StyledLabelBuilder.getShorthandValue(string.charAt(1)), StyledLabelBuilder.getShorthandValue(string.charAt(2)), StyledLabelBuilder.getShorthandValue(string.charAt(3)));
                }
                return new Color(Integer.parseInt(string.substring(1), 16));
            }
            case '0': {
                return new Color(Integer.parseInt(string.substring(2), 16));
            }
        }
        return (Color)colorNamesMap.get(string);
    }

    private static int nextColorInt(String string, int n) {
        char c2;
        int n2;
        while (n < string.length() && (48 > (n2 = (int)string.charAt(n)) || n2 > 57)) {
            ++n;
        }
        for (n2 = n; n2 < n + 3 && (c2 = string.charAt(n2)) >= '0' && '9' >= c2; ++n2) {
        }
        return Integer.parseInt(string.substring(n, n2));
    }

    private static int getShorthandValue(char c2) {
        if ('A' <= (c2 = Character.toUpperCase(c2)) && c2 <= 'F') {
            return colorShorthandTable[c2 - 65 + 10];
        }
        return colorShorthandTable[c2 - 48];
    }

    public static Map getColorNamesMap() {
        return colorNamesMap;
    }

    private static String createTrimmedString(char[] cArray, int n, int n2) {
        while ((cArray[n] == ' ' || cArray[n] == '\t') && n < cArray.length) {
            ++n;
        }
        while ((cArray[n2] == ' ' || cArray[n2] == '\t') && n < n2) {
            --n2;
        }
        if (n2 >= n) {
            StringBuffer stringBuffer = new StringBuffer(n2 - n);
            boolean bl = false;
            for (int i2 = n; i2 <= n2; ++i2) {
                if (cArray[i2] == '\\' && !bl) {
                    bl = true;
                    continue;
                }
                stringBuffer.append(cArray[i2]);
                if (!bl) continue;
                bl = false;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private static int findNextOf(char[] cArray, char[] cArray2, int n) {
        boolean bl = false;
        for (int i2 = n; i2 < cArray.length; ++i2) {
            if (bl) {
                bl = false;
                continue;
            }
            if (cArray[i2] == '\\') {
                bl = true;
                continue;
            }
            for (char c2 : cArray2) {
                if (cArray[i2] != c2) continue;
                return i2;
            }
        }
        return -1;
    }

    private static int findNext(char[] cArray, char c2, int n) {
        boolean bl = false;
        for (int i2 = n; i2 < cArray.length; ++i2) {
            if (bl) {
                bl = false;
                continue;
            }
            if (cArray[i2] == '\\') {
                bl = true;
                continue;
            }
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    static {
        colorNamesMap.put("white", new Color(0xFFFFFF));
        colorNamesMap.put("lightGray", new Color(0xC0C0C0));
        colorNamesMap.put("gray", new Color(0x808080));
        colorNamesMap.put("darkGray", new Color(0x404040));
        colorNamesMap.put("black", new Color(0));
        colorNamesMap.put("red", new Color(0xFF0000));
        colorNamesMap.put("pink", new Color(0xFFAFAF));
        colorNamesMap.put("orange", new Color(16762880));
        colorNamesMap.put("yellow", new Color(0xFFFF00));
        colorNamesMap.put("green", new Color(65280));
        colorNamesMap.put("magenta", new Color(0xFF00FF));
        colorNamesMap.put("cyan", new Color(65535));
        colorNamesMap.put("blue", new Color(255));
    }

    private static class ParsedStyleResult {
        String text;
        int endOffset;
        int fontStyle = 0;
        Color fontColor = null;
        Color lineColor = null;
        Color backgroundColor = null;
        int additionalStyle = 0;

        private ParsedStyleResult() {
        }
    }
}

