/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedArrayList<E>
extends ArrayList<E> {
    private Map<Object, Integer> _indexCache;
    private boolean _lazyCaching = false;

    public CachedArrayList() {
    }

    public CachedArrayList(Collection<? extends E> collection) {
        super(collection);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedArrayList(int n) {
        super(n);
    }

    @Override
    public int indexOf(Object object) {
        this.initializeCache();
        Integer n = this._indexCache.get(object);
        if (n != null) {
            return n;
        }
        if (this.isLazyCaching()) {
            int n2 = super.indexOf(object);
            if (n2 == -1) {
                this.uncacheIt(object);
            } else {
                this.cacheIt(object, n2);
            }
            return n2;
        }
        return -1;
    }

    protected synchronized void adjustCache(int n, int n2) {
        if (this._indexCache != null) {
            Map<Object, Integer> map = this.createCache();
            Set<Object> set = this._indexCache.keySet();
            for (Object object : set) {
                int n3 = this._indexCache.get(object);
                if (n3 >= n) {
                    map.put(object, n3 + n2);
                    continue;
                }
                map.put(object, n3);
            }
            this._indexCache = map;
        }
    }

    protected Map<Object, Integer> createCache() {
        return new IdentityHashMap<Object, Integer>();
    }

    public void cacheIt(Object object, int n) {
        if (this._indexCache != null && (this._indexCache.get(object) == null || n < this._indexCache.get(object))) {
            this._indexCache.put(object, n);
        }
    }

    public void uncacheIt(Object object) {
        if (this._indexCache != null) {
            this._indexCache.remove(object);
        }
    }

    @Override
    public boolean add(E e2) {
        boolean bl = super.add(e2);
        if (!this.isLazyCaching() && bl) {
            this.initializeCache();
            this.cacheIt(e2, this.size() - 1);
        }
        return bl;
    }

    @Override
    public void add(int n, E e2) {
        super.add(n, e2);
        if (!this.isLazyCaching()) {
            this.initializeCache();
            this.adjustCache(n, 1);
            this.cacheIt(e2, n);
        } else if (this._indexCache != null) {
            this.adjustCache(n, 1);
            this.cacheIt(e2, n);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public E remove(int n) {
        Object e2 = super.remove(n);
        if (e2 != null) {
            this.uncacheIt(e2);
            this.adjustCache(n, -1);
        }
        return e2;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        boolean bl = super.remove(object);
        if (bl) {
            this.uncacheIt(object);
            this.adjustCache(n, -1);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.uncacheAll();
        return super.removeAll(collection);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            this.cacheAll();
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = super.addAll(n, collection);
        this.initializeCache();
        this.adjustCache(n, collection.size());
        for (E e2 : collection) {
            this.cacheIt(e2, n++);
        }
        return bl;
    }

    @Override
    public E set(int n, E e2) {
        if (!this.isLazyCaching()) {
            this.initializeCache();
            E e3 = super.set(n, e2);
            this.uncacheIt(e3);
            this.cacheIt(e2, n);
            return e3;
        }
        return super.set(n, e2);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public void cacheAll() {
        this._indexCache = this.createCache();
        Integer n = 0;
        for (Object e2 : this) {
            if (this._indexCache.get(e2) == null) {
                this._indexCache.put(e2, n);
            }
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean bl) {
        this._lazyCaching = bl;
    }

    @Override
    protected void removeRange(int n, int n2) {
        if (n == n2) {
            this.remove(n);
        } else {
            super.removeRange(n, n2);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }
}

