/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvManager;
import ilog.views.IlvManagerFrame;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvResizableManagerFrame;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.IlvResourceUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class IlvDefaultManagerFrame
implements IlvResizableManagerFrame,
Serializable,
IlvPersistentObject {
    private static final float a = 5.0f;
    private static final boolean b = true;
    private static final boolean c = false;
    private static final float d = 1.0f;
    private static final float e = 2.0f;
    private static final Color f = Color.white;
    private static final Color g = Color.white;
    private static final Color h = Color.black;
    private static final Font i = new Font("Dialog", 0, 12);
    private static final double j = 0.0;
    private static final double k = Double.MAX_VALUE;
    private static final float l = IlvUtil.GetDeltaLine();
    public static final int LEFT = 1;
    public static final int CENTER = 16;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int WRAPPED = 128;
    private static final int m = 1;
    private float n = 5.0f;
    private float o = 5.0f;
    private float p = 5.0f;
    private float q = 5.0f;
    private boolean r = true;
    private Color s = h;
    private Paint t = g;
    private boolean u = false;
    private Font v = i;
    private Color w = f;
    private int x = 1;
    private double y = 0.0;
    private double z = Double.MAX_VALUE;
    private String aa = null;
    private transient float ab = -1.0f;
    private transient String ac = null;
    private transient double ad = 0.0;
    private transient float ae = -1.0f;
    private static IlvTransformer af = new IlvTransformer();

    public IlvDefaultManagerFrame() {
    }

    public IlvDefaultManagerFrame(IlvDefaultManagerFrame ilvDefaultManagerFrame) {
        this.n = ilvDefaultManagerFrame.n;
        this.o = ilvDefaultManagerFrame.o;
        this.p = ilvDefaultManagerFrame.p;
        this.q = ilvDefaultManagerFrame.q;
        this.r = ilvDefaultManagerFrame.r;
        this.s = ilvDefaultManagerFrame.s;
        this.t = ilvDefaultManagerFrame.t;
        this.u = ilvDefaultManagerFrame.u;
        this.v = ilvDefaultManagerFrame.v;
        this.w = ilvDefaultManagerFrame.w;
        this.x = ilvDefaultManagerFrame.x;
        this.aa = ilvDefaultManagerFrame.aa;
        this.y = ilvDefaultManagerFrame.y;
        this.z = ilvDefaultManagerFrame.z;
    }

    public IlvManagerFrame copy() {
        return new IlvDefaultManagerFrame(this);
    }

    public IlvDefaultManagerFrame(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        try {
            this.n = ilvInputStream.readFloat("topMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.p = ilvInputStream.readFloat("leftMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.o = ilvInputStream.readFloat("bottomMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.q = ilvInputStream.readFloat("rightMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.t = IlvUtility2D.readPaint(ilvInputStream);
        try {
            this.s = ilvInputStream.readColor("foreground");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.u = ilvInputStream.readBoolean("showingTitle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.w = ilvInputStream.readColor("titleColor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.v = ilvInputStream.readFont("font");
        }
        catch (IlvReadFileException ilvReadFileException) {
            // empty catch block
        }
        try {
            this.x = ilvInputStream.readInt("justification");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.r = ilvInputStream.readBoolean("opaque");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.aa = ilvInputStream.readString("title");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.y = ilvInputStream.readDouble("minTitle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.z = ilvInputStream.readDouble("maxTitle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        if (this.n != 5.0f) {
            ilvOutputStream.write("topMargin", this.n);
        }
        if (this.p != 5.0f) {
            ilvOutputStream.write("leftMargin", this.p);
        }
        if (this.o != 5.0f) {
            ilvOutputStream.write("bottomMargin", this.o);
        }
        if (this.q != 5.0f) {
            ilvOutputStream.write("rightMargin", this.q);
        }
        IlvUtility2D.writePaint(ilvOutputStream, this.t);
        if (!h.equals(this.s)) {
            ilvOutputStream.write("foreground", this.s);
        }
        if (this.u) {
            ilvOutputStream.write("showingTitle", this.u);
        }
        if (!f.equals(this.w)) {
            ilvOutputStream.write("titleColor", this.w);
        }
        if (!i.equals(this.v)) {
            ilvOutputStream.write("font", this.v);
        }
        if (this.x != 1) {
            ilvOutputStream.write("justification", this.x);
        }
        if (!this.r) {
            ilvOutputStream.write("opaque", this.r);
        }
        if (this.aa != null) {
            ilvOutputStream.write("title", this.aa);
        }
        if (this.y != 0.0) {
            ilvOutputStream.write("minTitle", this.y);
        }
        if (this.z != Double.MAX_VALUE) {
            ilvOutputStream.write("maxTitle", this.z);
        }
    }

    public float getTopMargin(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        float f2 = this.getTopMargin();
        if (ilvTransformer != null) {
            f2 = (float)((double)f2 * ilvTransformer.zoomFactor());
        }
        if ((this.getTitleJustification() & 8) == 0) {
            f2 += this.getTitleHeight(ilvManager, ilvTransformer);
        }
        return f2;
    }

    void a() {
        this.ab = -1.0f;
    }

    public boolean moveResize(IlvManager ilvManager, IlvRect ilvRect) {
        this.a();
        return false;
    }

    public void managerChanged(IlvManager ilvManager) {
        this.a();
    }

    protected double checkZoomFactor(IlvTransformer ilvTransformer) {
        double d2;
        double d3 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        if (d3 > (d2 = this.getMaxTitleZoomFactor())) {
            d3 = d2;
        } else {
            double d4 = this.getMinTitleZoomFactor();
            if (d3 < d4) {
                d3 = d4;
            }
        }
        return d3;
    }

    public float getTitleHeight(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        Cloneable cloneable;
        if (!this.isShowingTitle()) {
            return 0.0f;
        }
        double d2 = this.checkZoomFactor(ilvTransformer);
        String string = this.getTitle(ilvManager);
        if (string == null || string.length() == 0) {
            return 2.0f;
        }
        float f2 = 0.0f;
        if (!this.b()) {
            if (this.ab != -1.0f && string.equals(this.ac) && this.ad == d2) {
                return this.ab;
            }
        } else {
            IlvTransformer ilvTransformer2 = ilvManager.getTransformer();
            ilvTransformer2.compose(ilvTransformer);
            cloneable = ilvManager.computeBBox(ilvTransformer2, true);
            f2 = cloneable.width + this.getLeftMargin(ilvManager, ilvTransformer) + this.getRightMargin(ilvManager, ilvTransformer) - 1.0f;
            f2 = Math.max(2.0f, f2 - 4.0f - 2.0f);
            if (this.ab != -1.0f && string.equals(this.ac) && this.ad == d2 && this.ae == f2) {
                return this.ab;
            }
        }
        float f3 = 0.0f;
        cloneable = new AffineTransform(d2, 0.0, 0.0, d2, 0.0, 0.0);
        FontRenderContext fontRenderContext = new FontRenderContext((AffineTransform)cloneable, true, false);
        Font font = this.getFont().deriveFont((AffineTransform)cloneable);
        if (this.b()) {
            Paragraph paragraph = new Paragraph(string, font, fontRenderContext, f2);
            f3 = 2.0f;
            TextLayout textLayout = paragraph.a();
            while (textLayout != null) {
                f3 += textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
                textLayout = paragraph.a();
            }
        } else {
            TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
            f3 += textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
            f3 += 2.0f;
        }
        this.ab = f3;
        this.ac = string;
        this.ad = d2;
        this.ae = f2;
        return f3;
    }

    public float getTopMargin() {
        return this.n;
    }

    public void setTopMargin(float f2) {
        this.n = f2;
    }

    public float getBottomMargin(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        float f2 = this.getBottomMargin();
        if (ilvTransformer != null) {
            f2 = (float)((double)f2 * ilvTransformer.zoomFactor());
        }
        if ((this.getTitleJustification() & 8) == 8) {
            f2 += this.getTitleHeight(ilvManager, ilvTransformer);
        }
        return f2;
    }

    public float getBottomMargin() {
        return this.o;
    }

    public void setBottomMargin(float f2) {
        this.o = f2;
    }

    public float getRightMargin(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        if (ilvTransformer == null) {
            return this.getRightMargin();
        }
        return (float)((double)this.getRightMargin() * ilvTransformer.zoomFactor());
    }

    public float getRightMargin() {
        return this.q;
    }

    public void setRightMargin(float f2) {
        this.q = f2;
        this.a();
    }

    public float getLeftMargin(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        if (ilvTransformer == null) {
            return this.getLeftMargin();
        }
        return (float)((double)this.getLeftMargin() * ilvTransformer.zoomFactor());
    }

    public float getLeftMargin() {
        return this.p;
    }

    public void setLeftMargin(float f2) {
        this.p = f2;
        this.a();
    }

    public boolean isOpaque(IlvManager ilvManager) {
        return this.r;
    }

    public boolean isOpaque() {
        return this.r;
    }

    public void setOpaque(boolean bl) {
        this.r = bl;
    }

    public Color getTitleColor() {
        return this.w;
    }

    public void setTitleColor(Color color) {
        this.w = color;
    }

    public Font getFont() {
        return this.v;
    }

    public void setFont(Font font) {
        this.v = font;
        this.a();
    }

    public Paint getBackground() {
        return this.t;
    }

    public void setBackground(Paint paint) {
        this.t = paint;
    }

    public Color getForeground() {
        return this.s;
    }

    public void setForeground(Color color) {
        this.s = color;
    }

    public boolean isShowingTitle() {
        return this.u;
    }

    public void setShowingTitle(boolean bl) {
        this.u = bl;
    }

    public void setTitleJustification(int n2) {
        int n3 = n2 - (n2 & 0x8C);
        if (n3 != 16 && n3 != 1 && n3 != 2) {
            throw new IllegalArgumentException("bad value");
        }
        this.x = n2;
    }

    public int getTitleJustification() {
        return this.x;
    }

    boolean b() {
        return (this.getTitleJustification() & 0x80) == 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        IlvRect ilvRect2 = new IlvRect();
        IlvTransformer ilvTransformer2 = null;
        IlvTransformer ilvTransformer3 = af;
        synchronized (ilvTransformer3) {
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvRect2.setRect(ilvRect);
                ilvTransformer.inverse(ilvRect2);
                ilvTransformer2 = af;
                IlvTransformer.computeTransformer(ilvRect2, ilvRect, ilvTransformer2);
            } else {
                af.setValues(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
                ilvTransformer2 = af;
            }
            if (this.isShowingTitle()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                float f2 = this.getTitleHeight(ilvManager, ilvTransformer);
                if (this.isOpaque(ilvManager)) {
                    if ((this.getTitleJustification() & 8) == 8) {
                        ilvRect2.setRect(ilvRect.x + 1.0f, ilvRect.y + 1.0f, ilvRect.width - 1.0f, ilvRect.height - f2 - 1.0f);
                    } else {
                        ilvRect2.setRect(ilvRect.x + 1.0f, ilvRect.y + f2 + 1.0f, ilvRect.width - 1.0f, ilvRect.height - f2 - 1.0f);
                    }
                    this.drawBackground(ilvManager, ilvRect2, graphics2D, ilvTransformer2);
                }
                float f3 = ilvRect.y;
                f3 = (this.getTitleJustification() & 8) == 8 ? (f3 += ilvRect.height - f2) : (f3 += 1.0f);
                ilvRect2.setRect(ilvRect.x + 1.0f, f3, ilvRect.width - 1.0f, f2);
                this.drawTitleBackground(ilvManager, ilvRect2, graphics2D, ilvTransformer2);
                this.drawTitleText(ilvManager, ilvRect2, graphics2D, ilvTransformer2);
            } else if (this.isOpaque(ilvManager)) {
                ilvRect2.setRect(ilvRect.x + 1.0f, ilvRect.y + 1.0f, ilvRect.width - 1.0f, ilvRect.height - 1.0f);
                this.drawBackground(ilvManager, ilvRect2, graphics, ilvTransformer);
            }
            this.drawOutline(ilvManager, ilvRect, graphics, ilvTransformer);
        }
    }

    private float a(float f2, float f3, float f4) {
        float f5 = f2;
        switch (this.getTitleJustification() & 0x13) {
            case 1: {
                f5 += 2.0f;
                break;
            }
            case 2: {
                f5 += f3 - f4 - 2.0f;
                break;
            }
            case 16: {
                f5 += 2.0f + (f3 - f4) / 2.0f;
            }
        }
        return f5;
    }

    protected void drawTitleText(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        double d2 = this.checkZoomFactor(ilvTransformer);
        AffineTransform affineTransform = new AffineTransform(d2, 0.0, 0.0, d2, 0.0, 0.0);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.getTitleColor());
        Font font = this.getFont().deriveFont(affineTransform);
        String string = this.getTitle(ilvManager);
        if (string == null || string.length() == 0) {
            return;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, false);
        double d3 = font.getStringBounds(string, fontRenderContext).getWidth();
        if (!this.b() || d3 + 4.0 <= (double)(ilvRect.width - 2.0f)) {
            float f2 = this.a(ilvRect.x, ilvRect.width, (float)d3);
            graphics2D.setFont(font);
            float f3 = font.getLineMetrics(string, fontRenderContext).getAscent();
            graphics2D.drawString(string, f2, ilvRect.y + f3);
        } else {
            float f4 = Math.max(2.0f, ilvRect.width - 4.0f - 2.0f);
            Paragraph paragraph = new Paragraph(string, font, fontRenderContext, f4);
            float f5 = ilvRect.y + 1.0f;
            TextLayout textLayout = paragraph.a();
            while (textLayout != null) {
                float f6 = this.a(ilvRect.x, f4, textLayout.getAdvance());
                textLayout.draw(graphics2D, f6, f5 += textLayout.getAscent());
                f5 += textLayout.getLeading() + textLayout.getDescent();
                textLayout = paragraph.a();
            }
        }
    }

    protected void drawTitleBackground(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        int n2 = ilvRect.xFloor();
        int n3 = ilvRect.yFloor();
        int n4 = ilvRect.widthFloor();
        int n5 = ilvRect.heightFloor();
        graphics.setColor(this.getForeground());
        graphics.fillRect(n2, n3, n4, n5);
    }

    protected void drawBackground(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        int n2 = ilvRect.xFloor();
        int n3 = ilvRect.yFloor();
        int n4 = ilvRect.widthFloor();
        int n5 = ilvRect.heightFloor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = this.getBackground();
        if (paint instanceof Color) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(IlvUtility2D.AdaptPaint(ilvRect, paint));
        }
        graphics2D.fillRect(n2, n3, n4, n5);
    }

    protected void drawOutline(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        int n2 = ilvRect.xFloor();
        int n3 = ilvRect.yFloor();
        int n4 = ilvRect.widthFloor();
        int n5 = ilvRect.heightFloor();
        graphics.setColor(this.getForeground());
        graphics.drawRect(n2, n3, n4, n5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(IlvManager ilvManager, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = ilvManager.boundingBox(ilvTransformer);
        ilvRect.expand(l);
        if (!ilvRect.inside(ilvPoint2.x, ilvPoint2.y)) {
            return false;
        }
        ilvRect.expand(-2.0f * l);
        float f2 = this.isShowingTitle() ? this.getTitleHeight(ilvManager, ilvTransformer) : 0.0f;
        boolean bl = (this.getTitleJustification() & 8) == 0;
        boolean bl2 = (this.getTitleJustification() & 8) == 8;
        if (ilvPoint2.x < ilvRect.x) return true;
        if (ilvPoint2.x > ilvRect.x + ilvRect.width) return true;
        if (ilvPoint2.y < ilvRect.y + (bl ? f2 : 0.0f)) return true;
        float f3 = ilvPoint2.y;
        float f4 = ilvRect.y + ilvRect.height;
        float f5 = bl2 ? f2 : 0.0f;
        if (!(f3 > f4 - f5)) return false;
        return true;
    }

    protected String getTitle(IlvManager ilvManager) {
        if (this.aa != null) {
            return this.aa;
        }
        String string = ilvManager.getName();
        if (string != null) {
            return string;
        }
        return IlvResourceUtil.getString("IlvDefaultManagerFrame.untitled", IlvDefaultManagerFrame.class);
    }

    public void setTitle(String string) {
        this.aa = string;
    }

    public String getTitle() {
        return this.aa;
    }

    public double getMinTitleZoomFactor() {
        return this.y;
    }

    public void setMinTitleZoomFactor(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Zoom Factor can't be negative");
        }
        if (d2 > this.getMaxTitleZoomFactor()) {
            throw new IllegalArgumentException("Minimum have to be smaller than Maximum");
        }
        this.y = d2;
    }

    public double getMaxTitleZoomFactor() {
        return this.z;
    }

    public void setMaxTitleZoomFactor(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Zoom Factor can't be negative");
        }
        if (d2 < this.getMinTitleZoomFactor()) {
            throw new IllegalArgumentException("Maximum have to be greater than Minimum");
        }
        this.z = d2;
    }

    private static class Paragraph {
        transient float a;
        transient LineBreakMeasurer b;
        transient int c;

        Paragraph(String string, Font font, FontRenderContext fontRenderContext, float f2) {
            this.a = f2;
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, font);
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            int n2 = attributedCharacterIterator.getBeginIndex();
            this.c = attributedCharacterIterator.getEndIndex();
            this.b = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
            this.b.setPosition(n2);
        }

        TextLayout a() {
            if (this.b.getPosition() < this.c) {
                return this.b.nextLayout(this.a);
            }
            return null;
        }
    }
}

