/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvAList;
import ilog.views.IlvDrawSelection;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvNamedProperty;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectProperty;
import ilog.views.IlvPoint;
import ilog.views.IlvQuadtree;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.event.IlvListenerList;
import ilog.views.event.NamedPropertyEvent;
import ilog.views.event.NamedPropertyListener;
import ilog.views.graphic.IlvGraphicHandleBag;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.swing.IlvPopupMenuContext;
import ilog.views.swing.IlvPopupMenuManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JPopupMenu;

public abstract class IlvGraphic
implements Serializable,
Transferable,
IlvPersistentObject {
    private static final String a = "__ilvObjectInteractorProperty";
    IlvGraphicBag b;
    private IlvAList c;
    private boolean d = true;
    private boolean e = true;
    private boolean f = true;
    private boolean g = true;
    private IlvQuadtree h;
    private IlvObjectProperty i;
    private transient int j;
    private static final String k = "__IlvGraphicName";
    private static final String l = "__ActionListener";
    private static final String m = "__IlvNamedProps";
    private static final String n = "__IlvGraphicToolTipText";
    private static final String o = "__IlvGraphicPopupMenu";
    private static final DataFlavor[] p = new DataFlavor[]{DataFlavor.stringFlavor};

    public IlvGraphic() {
    }

    public IlvGraphic(IlvGraphic ilvGraphic) {
        HashMap hashMap = ilvGraphic.e(false);
        if (hashMap != null) {
            for (IlvNamedProperty ilvNamedProperty : hashMap.values()) {
                IlvNamedProperty ilvNamedProperty2 = ilvNamedProperty.copy();
                if (ilvNamedProperty2 == null) continue;
                this.setNamedProperty(ilvNamedProperty2);
            }
        }
        this.setToolTipText(ilvGraphic.getToolTipText());
        this.setProperty(o, ilvGraphic.getProperty(o));
        this.d = ilvGraphic.d;
        this.e = ilvGraphic.e;
        this.f = ilvGraphic.f;
        this.g = ilvGraphic.f;
    }

    public abstract IlvGraphic copy();

    public boolean zoomable() {
        return true;
    }

    public IlvGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        Object object;
        ilvInputStream.registerGraphic(this);
        try {
            String string = ilvInputStream.readString("name");
            this.setName(string);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            boolean bl = ilvInputStream.readBoolean("visible");
            this.setVisible(bl);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            object = ilvInputStream.readString("toolTip");
            this.setToolTipText((String)object);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            object = ilvInputStream.readString("popupMenuName");
            this.setPopupMenuName((String)object);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        object = IlvNamedProperty.a(ilvInputStream);
        if (object != null) {
            HashMap hashMap = this.e(true);
            hashMap.clear();
            hashMap.putAll(object);
        }
    }

    final void a(IlvQuadtree ilvQuadtree) {
        this.h = ilvQuadtree;
    }

    final IlvQuadtree h() {
        return this.h;
    }

    public abstract void draw(Graphics var1, IlvTransformer var2);

    public abstract IlvRect boundingBox(IlvTransformer var1);

    public final IlvRect boundingBox() {
        return this.boundingBox(null);
    }

    public IlvPoint getCenter(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
    }

    public abstract void applyTransform(IlvTransformer var1);

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return this.boundingBox(ilvTransformer).inside(ilvPoint2.x, ilvPoint2.y);
    }

    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        return this.boundingBox(ilvTransformer).intersects(ilvRect2);
    }

    public boolean inside(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        return ilvRect2.contains(this.boundingBox(ilvTransformer));
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return IlvClippingUtil.getClippedPoint(this.boundingBox(ilvTransformer), ilvPoint, ilvPoint2);
    }

    public void move(float f2, float f3) {
        IlvRect ilvRect = this.boundingBox(null);
        this.translate(f2 - ilvRect.x, f3 - ilvRect.y);
    }

    public void move(IlvPoint ilvPoint) {
        this.move(ilvPoint.x, ilvPoint.y);
    }

    public void moveResize(IlvRect ilvRect) {
        IlvRect ilvRect2 = this.boundingBox(null);
        if (!ilvRect2.equals(ilvRect)) {
            ilvRect2 = this.a(ilvRect2);
            ilvRect = this.a(ilvRect);
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvTransformer.computeTransformer(ilvRect2, ilvRect, ilvTransformer);
            if (!ilvTransformer.isBad()) {
                this.applyTransform(ilvTransformer);
            }
        }
    }

    private IlvRect a(IlvRect ilvRect) {
        if (ilvRect.width >= 1.0E-20f && ilvRect.height >= 1.0E-20f) {
            return ilvRect;
        }
        ilvRect = new IlvRect(ilvRect);
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }

    public void translate(float f2, float f3) {
        IlvTransformer ilvTransformer = new IlvTransformer(1.0, 0.0, 0.0, 1.0, f2, f3);
        this.applyTransform(ilvTransformer);
    }

    public void rotate(IlvPoint ilvPoint, double d2) {
        double d3;
        double d4 = Math.cos(d2 = IlvUtil.degreesToRadians(d2));
        IlvTransformer ilvTransformer = new IlvTransformer(d4, -(d3 = Math.sin(d2)), d3, d4, (double)ilvPoint.x * (1.0 - d4) + d3 * (double)ilvPoint.y, -((double)ilvPoint.x * d3) + (double)ilvPoint.y * (1.0 - d4));
        if (!ilvTransformer.isBad()) {
            this.applyTransform(ilvTransformer);
        }
    }

    public void scale(double d2, double d3) {
        IlvRect ilvRect = this.boundingBox(null);
        double d4 = (1.0 - d2) * (double)ilvRect.x;
        double d5 = (1.0 - d3) * (double)ilvRect.y;
        IlvTransformer ilvTransformer = new IlvTransformer(d2, 0.0, 0.0, d3, d4, d5);
        if (!ilvTransformer.isBad()) {
            this.applyTransform(ilvTransformer);
        }
    }

    public void resize(float f2, float f3) {
        IlvRect ilvRect = this.boundingBox(null);
        this.scale((double)f2 / (double)Math.max(1.0E-20f, ilvRect.width), (double)f3 / (double)Math.max(1.0E-20f, ilvRect.height));
    }

    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        this.b = ilvGraphicBag;
    }

    public final IlvGraphicBag getGraphicBag() {
        return this.b;
    }

    public final synchronized IlvGraphicBag getTopLevelGraphicBag() {
        IlvGraphicBag ilvGraphicBag;
        for (ilvGraphicBag = this.b; ilvGraphicBag != null && ilvGraphicBag.getGraphicBag() != null; ilvGraphicBag = ilvGraphicBag.getGraphicBag()) {
        }
        return ilvGraphicBag;
    }

    final void a(IlvObjectProperty ilvObjectProperty) {
        IlvObjectProperty ilvObjectProperty2 = this.i;
        this.i = ilvObjectProperty;
        if (ilvObjectProperty != null) {
            ilvObjectProperty.a(this, ilvObjectProperty2, ilvObjectProperty);
        } else if (ilvObjectProperty2 != null) {
            ilvObjectProperty2.a(this, ilvObjectProperty2, ilvObjectProperty);
        }
    }

    final IlvObjectProperty i() {
        return this.i;
    }

    public void setForeground(Color color) {
    }

    public void setBackground(Color color) {
    }

    public void setFillOn(boolean bl) {
    }

    public void setStrokeOn(boolean bl) {
    }

    public void reDraw() {
        if (this.b != null) {
            this.b.reDrawObj(this);
        }
    }

    public void setName(String string) {
        if (this.getGraphicBag() != null) {
            this.getGraphicBag().setObjectName(this, string);
        } else {
            this.setNameImpl(string);
        }
    }

    public void setNameImpl(String string) {
        this.setProperty(k, string);
    }

    public String getName() {
        return (String)this.getProperty(k);
    }

    public boolean removeProperty(String string) {
        return this.c != null ? this.c.a(string) : false;
    }

    public void setProperty(String string, Object object) {
        if (object != null) {
            if (!this.replaceProperty(string, object)) {
                if (this.c == null) {
                    this.c = new IlvAList();
                }
                this.c.a(string, object);
            }
        } else {
            this.removeProperty(string);
        }
    }

    public boolean replaceProperty(String string, Object object) {
        if (object == null) {
            return false;
        }
        return this.c != null ? this.c.b(string, object) : false;
    }

    public Object getProperty(String string) {
        return this.c != null ? this.c.b(string) : null;
    }

    public boolean hasProperty(String string, Object object) {
        return this.c != null ? this.c.b(string) == object : false;
    }

    public boolean isVisible() {
        return this.d;
    }

    public final void setVisible(boolean bl) {
        if (bl != this.d) {
            IlvManagerLayer ilvManagerLayer;
            this.d = bl;
            if (this.i != null && (ilvManagerLayer = this.i.g()) != null) {
                ilvManagerLayer.b(this);
            }
        }
    }

    public boolean isMovable() {
        return this.g;
    }

    public final void setMovable(boolean bl) {
        this.g = bl;
    }

    public final boolean isEditable() {
        return this.e;
    }

    public final void setEditable(boolean bl) {
        this.e = bl;
    }

    public boolean isSelectable() {
        return this.f;
    }

    public final void setSelectable(boolean bl) {
        this.f = bl;
    }

    public final void addActionListener(ActionListener actionListener) {
        IlvListenerList ilvListenerList = (IlvListenerList)this.getProperty(l);
        if (ilvListenerList == null) {
            ilvListenerList = new IlvListenerList();
            this.setProperty(l, ilvListenerList);
        }
        ilvListenerList.add(actionListener);
    }

    public final void removeActionListener(ActionListener actionListener) {
        IlvListenerList ilvListenerList = (IlvListenerList)this.getProperty(l);
        if (ilvListenerList == null) {
            return;
        }
        ilvListenerList.remove(actionListener);
        if (ilvListenerList.getListenerCount() == 0) {
            this.setProperty(l, null);
        }
    }

    public void processActionEvent(ActionEvent actionEvent) {
        IlvListenerList ilvListenerList = (IlvListenerList)this.getProperty(l);
        if (ilvListenerList == null) {
            return;
        }
        Object[] objectArray = ilvListenerList.getListenerList();
        for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
            ((ActionListener)objectArray[i2]).actionPerformed(actionEvent);
        }
    }

    public IlvSelection makeSelection() {
        return new IlvDrawSelection(this);
    }

    public String getDefaultInteractor() {
        return null;
    }

    public final IlvObjectInteractor getObjectInteractor() {
        return (IlvObjectInteractor)this.getProperty(a);
    }

    public final void setObjectInteractor(IlvObjectInteractor ilvObjectInteractor) {
        this.setProperty(a, ilvObjectInteractor);
        this.notifyObjectInteractorToManager(ilvObjectInteractor);
    }

    protected void notifyObjectInteractorToManager(IlvObjectInteractor ilvObjectInteractor) {
        if (ilvObjectInteractor == null) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        while (ilvGraphicBag instanceof IlvGraphicHandleBag) {
            IlvGraphicHandleBag ilvGraphicHandleBag = (IlvGraphicHandleBag)ilvGraphicBag;
            IlvObjectInteractor ilvObjectInteractor2 = ilvGraphicHandleBag.getObjectInteractor();
            if (!ilvGraphicHandleBag.isDelegateObjectInteractor(ilvObjectInteractor2)) {
                return;
            }
            ilvGraphicBag = ilvGraphicHandleBag.getGraphicBag();
        }
        if (ilvGraphicBag instanceof IlvManager) {
            ((IlvManager)ilvGraphicBag).f();
        }
    }

    public final IlvObjectInteractor getAndAssociateObjectInteractor() {
        IlvObjectInteractor ilvObjectInteractor = this.getObjectInteractor();
        if (ilvObjectInteractor != null) {
            return ilvObjectInteractor;
        }
        ilvObjectInteractor = IlvObjectInteractor.Get(this.getDefaultInteractor());
        if (ilvObjectInteractor != null) {
            this.setObjectInteractor(ilvObjectInteractor);
        }
        return ilvObjectInteractor;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        String string;
        String string2;
        if (ilvOutputStream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        String string3 = this.getName();
        if (string3 != null) {
            ilvOutputStream.write("name", string3);
        }
        if (!this.d) {
            ilvOutputStream.write("visible", false);
        }
        if ((string2 = this.getToolTipText()) != null) {
            ilvOutputStream.write("toolTip", string2);
        }
        if ((string = this.getPopupMenuName()) != null) {
            ilvOutputStream.write("popupMenuName", string);
        }
        IlvNamedProperty.a(ilvOutputStream, this.e(false));
    }

    public boolean isPersistent() {
        return true;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return p;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DataFlavor.stringFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            String string = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IlvOutputStream ilvOutputStream = new IlvOutputStream(byteArrayOutputStream);
            try {
                ilvOutputStream.write("transfer", (IlvPersistentObject)this);
                ilvOutputStream.flush();
                string = ((Object)byteArrayOutputStream).toString();
            }
            finally {
                ((OutputStream)byteArrayOutputStream).close();
            }
            return string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public static IlvGraphic GetGraphicObject(Transferable transferable) throws IOException {
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            String string = null;
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            IlvInputStream ilvInputStream = new IlvInputStream(byteArrayInputStream);
            IlvGraphic ilvGraphic = null;
            try {
                ilvGraphic = (IlvGraphic)ilvInputStream.readPersistentObject("transfer");
            }
            catch (IlvReadFileException ilvReadFileException) {
                IOException iOException = new IOException(ilvReadFileException.getMessage());
                iOException.initCause(ilvReadFileException);
                throw iOException;
            }
            finally {
                ((InputStream)byteArrayInputStream).close();
            }
            return ilvGraphic;
        }
        return null;
    }

    public String toString() {
        String string = this.getName();
        return super.toString() + (string != null ? " Name: " + string : "");
    }

    public void setToolTipText(String string) {
        this.setProperty(n, string);
    }

    public String getToolTipText() {
        return (String)this.getProperty(n);
    }

    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getToolTipText();
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.setProperty(o, jPopupMenu);
    }

    public JPopupMenu getPopupMenu() {
        Object object = this.getProperty(o);
        if (object instanceof JPopupMenu) {
            return (JPopupMenu)object;
        }
        return null;
    }

    public void setPopupMenuName(String string) {
        this.setProperty(o, string);
    }

    public String getPopupMenuName() {
        Object object = this.getProperty(o);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public JPopupMenu getPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (jPopupMenu == null) {
            jPopupMenu = IlvPopupMenuManager.getRegisteredMenu(this.getPopupMenuName());
        }
        if (jPopupMenu != null) {
            IlvPopupMenuManager.setPopupMenuContext(jPopupMenu, new IlvPopupMenuContext(ilvPoint, null, this, ilvTransformer, ilvManagerView));
        }
        return jPopupMenu;
    }

    NamedProperties d(boolean bl) {
        NamedProperties namedProperties = (NamedProperties)this.getProperty(m);
        if (bl && namedProperties == null) {
            namedProperties = new NamedProperties();
            this.setProperty(m, namedProperties);
        }
        return namedProperties;
    }

    final HashMap e(boolean bl) {
        NamedProperties namedProperties = this.d(bl);
        if (namedProperties == null) {
            return null;
        }
        if (bl && namedProperties.a == null) {
            namedProperties.a = new HashMap(4);
        }
        return namedProperties.a;
    }

    private IlvListenerList a(boolean bl) {
        NamedProperties namedProperties = this.d(bl);
        if (namedProperties == null) {
            return null;
        }
        if (bl && namedProperties.b == null) {
            namedProperties.b = new IlvListenerList();
        }
        return namedProperties.b;
    }

    public void addNamedPropertyListener(NamedPropertyListener namedPropertyListener) {
        IlvListenerList ilvListenerList = this.a(true);
        ilvListenerList.add(namedPropertyListener);
    }

    public void removeNamedPropertyListener(NamedPropertyListener namedPropertyListener) {
        IlvListenerList ilvListenerList = this.a(false);
        if (ilvListenerList != null) {
            ilvListenerList.remove(namedPropertyListener);
            if (ilvListenerList.getListenerCount() == 0) {
                NamedProperties namedProperties = this.d(false);
                namedProperties.b = null;
            }
        }
    }

    private void a(IlvNamedProperty ilvNamedProperty, IlvNamedProperty ilvNamedProperty2) {
        if (ilvNamedProperty == null && ilvNamedProperty2 == null) {
            return;
        }
        IlvListenerList ilvListenerList = this.a(false);
        if (ilvListenerList != null) {
            NamedPropertyEvent namedPropertyEvent = new NamedPropertyEvent(this, ilvNamedProperty, ilvNamedProperty2);
            Object[] objectArray = ilvListenerList.getListenerList();
            int n2 = objectArray.length;
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                ((NamedPropertyListener)objectArray[i2]).propertyChanged(namedPropertyEvent);
            }
        }
    }

    public IlvNamedProperty setNamedProperty(IlvNamedProperty ilvNamedProperty) {
        HashMap hashMap = this.e(true);
        IlvNamedProperty ilvNamedProperty2 = (IlvNamedProperty)hashMap.get(ilvNamedProperty.getName());
        hashMap.put(ilvNamedProperty.getName(), ilvNamedProperty);
        this.a(ilvNamedProperty2, ilvNamedProperty);
        return ilvNamedProperty2;
    }

    public IlvNamedProperty getNamedProperty(String string) {
        HashMap hashMap = this.e(false);
        return hashMap != null ? (IlvNamedProperty)hashMap.get(string) : null;
    }

    public void removeNamedProperty(String string) {
        HashMap hashMap = this.e(false);
        if (hashMap != null) {
            IlvNamedProperty ilvNamedProperty = (IlvNamedProperty)hashMap.remove(string);
            this.a(ilvNamedProperty, null);
        }
    }

    public final boolean isInApplyToObject() {
        return this.j > 0;
    }

    public final boolean setInApplyToObject(boolean bl) {
        boolean bl2;
        boolean bl3 = bl ? ++this.j == 1 : (bl2 = --this.j == 0);
        if (this.j < 0) {
            this.j = 0;
        }
        return bl2;
    }

    static final class NamedProperties {
        HashMap a;
        IlvListenerList b;

        NamedProperties() {
        }
    }
}

