/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.beans.editor;

import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.beans.IlvPropertyEditorManager;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class IlvShapePropertyEditor
extends PropertyEditorSupport {
    private static HashMap a = new HashMap(IlvPropertyEditorManager.getPropertyEditorCacheSize() * 4 / 3);

    public void setAsText(String string) throws IllegalArgumentException {
        Object v = a.get(string);
        if (v != null) {
            this.setValue(new GeneralPath((Shape)v));
        } else {
            if (a.size() > IlvPropertyEditorManager.getPropertyEditorCacheSize()) {
                a.clear();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            IlvInputStream ilvInputStream = new IlvInputStream(byteArrayInputStream);
            try {
                Shape shape = ilvInputStream.readShape("path", "rule");
                a.put(string, shape);
                this.setValue(shape);
            }
            catch (IlvReadFileException ilvReadFileException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot read shape from string");
                illegalArgumentException.initCause(ilvReadFileException);
                throw illegalArgumentException;
            }
        }
    }

    public static void clear() {
        a.clear();
    }

    public String getAsText() {
        Shape shape = (Shape)this.getValue();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IlvOutputStream ilvOutputStream = new IlvOutputStream(byteArrayOutputStream, false);
        try {
            ilvOutputStream.write("path", "rule", shape);
            ilvOutputStream.flush();
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toString().replace('\n', ' ');
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }
}

