/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDrawable;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvScale;
import ilog.views.chart.print.IlvChartPrintableDocument;
import ilog.views.util.print.IlvPage;
import ilog.views.util.print.IlvUnit;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public abstract class IlvChartPrintContext {
    private IlvPage a;
    private IlvChartPrintableDocument b;
    private IlvUnit.Rectangle c;
    private AffineTransform d;
    private AffineTransform e;
    private AffineTransform f;
    private AffineTransform g;
    Rectangle h;

    public IlvChartPrintContext(IlvUnit.Rectangle rectangle, IlvChartPrintableDocument ilvChartPrintableDocument, IlvPage ilvPage) throws IllegalArgumentException {
        this.c = new IlvUnit.Rectangle(rectangle.getXAs(IlvUnit.POINTS), rectangle.getYAs(IlvUnit.POINTS), rectangle.getWidthAs(IlvUnit.POINTS), rectangle.getHeightAs(IlvUnit.POINTS), IlvUnit.POINTS);
        this.b = ilvChartPrintableDocument;
        this.a = ilvPage;
        this.f();
    }

    public final IlvChartPrintableDocument getDocument() {
        return this.b;
    }

    public final IlvPage getPage() {
        return this.a;
    }

    public final IlvChart getChart() {
        return this.b.getChart();
    }

    public final IlvUnit.Rectangle getPrintArea() {
        return this.c;
    }

    public abstract IlvDataInterval getRange(int var1);

    final AffineTransform a() {
        return this.d;
    }

    final AffineTransform b() {
        return this.e;
    }

    public Rectangle getDrawRect() {
        Rectangle rectangle = this.getChart().getChartArea().getBounds();
        if (!this.b.isPrintingChart()) {
            rectangle.setLocation(0, 0);
        }
        return this.f.createTransformedShape(rectangle).getBounds();
    }

    private void f() {
        boolean bl = this.b.isPrintingChart();
        IlvChart ilvChart = this.getChart();
        int n2 = this.b.getResizeMode();
        float f2 = this.b.getResolutionScaleFactor();
        Rectangle rectangle = new Rectangle(0, 0, bl ? ilvChart.getWidth() : ilvChart.getChartArea().getWidth(), bl ? ilvChart.getHeight() : ilvChart.getChartArea().getHeight());
        float f3 = (float)this.c.getWidth();
        float f4 = (float)this.c.getHeight();
        double d2 = (double)f3 / (double)rectangle.width;
        double d3 = (double)f4 / (double)rectangle.height;
        if (n2 == 1) {
            d3 = d2 = Math.min(d2, d3);
        }
        float f5 = (float)this.c.getX();
        float f6 = (float)this.c.getY();
        if (n2 == 1) {
            int n3 = this.b.getScalingAlignment();
            switch (n3) {
                case 1: {
                    break;
                }
                case 2: {
                    f5 = (float)((double)f5 + Math.abs((double)f3 - d2 * (double)rectangle.width) / 2.0);
                    break;
                }
                case 3: {
                    f5 = (float)((double)f5 + Math.abs((double)f3 - d2 * (double)rectangle.width));
                    break;
                }
                case 4: {
                    f6 = (float)((double)f6 + Math.abs((double)f4 - d3 * (double)rectangle.height) / 2.0);
                    break;
                }
                case 6: {
                    f6 = (float)((double)f6 + Math.abs((double)f4 - d3 * (double)rectangle.height) / 2.0);
                    f5 = (float)((double)f5 + Math.abs((double)f3 - d2 * (double)rectangle.width));
                    break;
                }
                case 7: {
                    f6 = (float)((double)f6 + Math.abs((double)f4 - d3 * (double)rectangle.height));
                    break;
                }
                case 8: {
                    f6 = (float)((double)f6 + Math.abs((double)f4 - d3 * (double)rectangle.height));
                    f5 = (float)((double)f5 + Math.abs((double)f3 - d2 * (double)rectangle.width) / 2.0);
                    break;
                }
                case 9: {
                    f6 = (float)((double)f6 + Math.abs((double)f4 - d3 * (double)rectangle.height));
                    f5 = (float)((double)f5 + Math.abs((double)f3 - d2 * (double)rectangle.width));
                    break;
                }
                default: {
                    f6 = (float)((double)f6 + Math.abs((double)f4 - d3 * (double)rectangle.height) / 2.0);
                    f5 = (float)((double)f5 + Math.abs((double)f3 - d2 * (double)rectangle.width) / 2.0);
                }
            }
        }
        double d4 = (double)f5 - d2 * (double)rectangle.x;
        double d5 = (double)f6 - d3 * (double)rectangle.y;
        this.d = new AffineTransform(d2, 0.0, 0.0, d3, d4, d5);
        d4 = f5 - 1.0f / f2 * f5;
        d5 = f6 - 1.0f / f2 * f6;
        if (bl && f2 != 1.0f) {
            Point2D point2D = this.d.transform(ilvChart.getChartArea().getLocation(), null);
            d4 += (double)(1.0f / f2) * point2D.getX();
            d5 += (double)(1.0f / f2) * point2D.getY();
        }
        this.e = new AffineTransform((double)(1.0f / f2), 0.0, 0.0, (double)(1.0f / f2), d4, d5);
        try {
            this.f = new AffineTransform(this.e.createInverse());
            this.f.concatenate(this.d);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException("Cannot compute transform (highRes transform noninvertible).");
        }
    }

    final void a(Graphics2D graphics2D) {
        this.g = graphics2D.getTransform();
        graphics2D.transform(this.d);
        AffineTransform affineTransform = graphics2D.getTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), Math.floor(affineTransform.getTranslateX()), Math.floor(affineTransform.getTranslateY()));
        graphics2D.setTransform(affineTransform);
    }

    final void b(Graphics2D graphics2D) {
        if (this.g != null) {
            graphics2D.setTransform(this.g);
        }
        this.g = null;
    }

    public Color getBackground() {
        return this.getDocument().getBackground();
    }

    public boolean isTitleVisible(IlvScale ilvScale) {
        int n2;
        if (this.b.getRepeatTitle() || ilvScale.getAxis().isYAxis()) {
            return true;
        }
        return ilvScale.e() != null && ((n2 = ilvScale.e().getPlacement()) != 0 && n2 != 100 || n2 == 0 && this.c() || n2 == 100 && this.d());
    }

    public boolean isVisible(IlvChartDrawable ilvChartDrawable) {
        if (ilvChartDrawable instanceof IlvScale) {
            IlvScale ilvScale = (IlvScale)ilvChartDrawable;
            if (this.b.getRepeatYScales() || ilvScale.getAxis().isXAxis()) {
                return true;
            }
            return ilvScale.getCrossing() == IlvAxis.MIN_VALUE && this.c() || ilvScale.getCrossing() == IlvAxis.MAX_VALUE && this.d();
        }
        return true;
    }

    final boolean c() {
        return this.a.getPageIndex() == 0;
    }

    final boolean d() {
        return this.a.getPageIndex() == this.a.getDocument().getNumberOfPages() - 1;
    }

    void e() {
        this.h = null;
    }
}

