/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChart3DSupport;
import ilog.views.chart.IlvChart3DView;
import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvColor;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.data.IlvDataSetProperty;
import ilog.views.chart.data.IlvDataSource;
import ilog.views.chart.data.IlvDefaultDataSource;
import ilog.views.chart.data.lod.IlvLODDataSet;
import ilog.views.chart.data.lod.IlvLODHandler;
import ilog.views.chart.data.xml.IlvXMLDataSource;
import ilog.views.chart.event.DataSourceEvent;
import ilog.views.chart.event.DataSourceListener;
import ilog.views.chart.event.DataSourceListener2;
import ilog.views.chart.event.TreemapFocusEvent;
import ilog.views.chart.graphic.IlvDataAnnotation;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvAreaChartRenderer;
import ilog.views.chart.renderer.IlvBarChartRenderer;
import ilog.views.chart.renderer.IlvBubbleChartRenderer;
import ilog.views.chart.renderer.IlvComboChartRenderer;
import ilog.views.chart.renderer.IlvHiLoChartRenderer;
import ilog.views.chart.renderer.IlvPieChartRenderer;
import ilog.views.chart.renderer.IlvPolylineChartRenderer;
import ilog.views.chart.renderer.IlvScatterChartRenderer;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.renderer.IlvStairChartRenderer;
import ilog.views.chart.renderer.IlvTreemapChartRenderer;
import ilog.views.chart.renderer.internal.IlvDataSetRendererProperty;
import ilog.views.chart.renderer.internal.IlvVirtualDataSet;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.styling.IlvDataPointStyle;
import ilog.views.chart.styling.IlvDataSetStyle;
import ilog.views.chart.styling.IlvStylingSupport;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvFlags;
import ilog.views.util.IlvColorUtil;
import ilog.views.util.collections.IlvCollections;
import ilog.views.util.collections.internal.IlvIntToObjectHashMap;
import ilog.views.util.collections.internal.IlvIntToObjectMap;
import ilog.views.util.css.IlvApplicableDeclarationCollection;
import ilog.views.util.styling.IlvStylingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class IlvChartRenderer
implements IlvChart3DSupport,
Serializable {
    public static final int BAR = 0;
    public static final int STACKED_BAR = 1;
    public static final int STACKED100_BAR = 17;
    public static final int STACKED_DIVERGING_BAR = 24;
    public static final int SUPERIMPOSED_BAR = 2;
    public static final int AREA = 3;
    public static final int STACKED_AREA = 4;
    public static final int STACKED100_AREA = 19;
    public static final int POLYLINE = 5;
    public static final int STACKED_POLYLINE = 11;
    public static final int STACKED100_POLYLINE = 18;
    public static final int SCATTER = 6;
    public static final int STAIR = 7;
    public static final int STACKED_STAIR = 14;
    public static final int STACKED100_STAIR = 20;
    public static final int SUMMED_STAIR = 15;
    public static final int BUBBLE = 8;
    public static final int HILO = 9;
    public static final int HILO_ARROW = 21;
    public static final int HILO_STICK = 22;
    public static final int CANDLE = 12;
    public static final int HLOC = 13;
    public static final int PIE = 10;
    public static final int TREEMAP = 23;
    public static final int COMBO = 16;
    public static final int DATA_LABEL = 1;
    public static final int Y_VALUE_LABEL = 2;
    public static final int XY_VALUES_LABEL = 3;
    public static final int X_VALUE_LABEL = 4;
    public static final int PERCENT_LABEL = 5;
    public static final int CENTERED_LABEL_LAYOUT = 1;
    public static final int OUTSIDE_LABEL_LAYOUT = 2;
    public static final int DEFAULT_LABEL_LAYOUT = 1;
    public static final int DEFAULT_LABELING = 2;
    private static final int a = 1;
    private static final int b = 2;
    private static final int c = 1;
    private static final ArrayList d = new ArrayList(0);
    private static HashMap e = new HashMap();
    private IlvChart f;
    private IlvChart.AxisElement g;
    private String h;
    private IlvChartRenderer i;
    private IlvFlags j = new IlvFlags(1);
    private double k;
    private IlvDataSource l;
    private DataSourceListener m;
    private IlvDataAnnotation n;
    private IlvDataRenderingHint o;
    private Integer p;
    private Integer q;
    private Boolean r;
    private transient int s;

    protected static void register(String string, Class clazz) {
        e.put(string, clazz);
    }

    public static IlvChartRenderer create(String string) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        Class<?> clazz = (Class<?>)e.get(string);
        if (clazz == null) {
            clazz = Class.forName(string);
        }
        if (clazz != null) {
            return (IlvChartRenderer)clazz.newInstance();
        }
        throw new ClassNotFoundException("Unknown class: " + string);
    }

    protected IlvChartRenderer() {
        this.setDataSource(new IlvDefaultDataSource());
    }

    public final IlvChart getChart() {
        if (this.f == null) {
            return this.i == null ? null : this.i.getChart();
        }
        return this.f;
    }

    void a(IlvChart ilvChart, IlvChart.AxisElement axisElement) {
        Object object;
        if (this.f == ilvChart) {
            return;
        }
        IlvChart ilvChart2 = this.f;
        this.f = ilvChart;
        if (ilvChart2 != null) {
            for (int i2 = this.s; i2 > 0; --i2) {
                ilvChart2.endRendererChanges();
            }
            object = IlvStylingSupport.get(ilvChart2);
            if (object != null && ((IlvStylingSupport)object).isLogging(this)) {
                ((IlvStylingSupport)object).setLogging(this, false);
            }
        }
        if (ilvChart != null) {
            this.g = axisElement;
            object = IlvStylingSupport.get(ilvChart);
            if (object != null && !((IlvStylingSupport)object).isLogging(this)) {
                ((IlvStylingSupport)object).setLogging(this, true);
            }
            for (int i3 = this.s; i3 > 0; --i3) {
                ilvChart.startRendererChanges();
            }
            ilvChart.a(this, 1);
        } else {
            this.g = null;
            ilvChart2.a(this, 2);
        }
        this.f();
        this.chartConnected(ilvChart2, ilvChart);
        object = this.getChildIterator();
        while (object.hasNext()) {
            ((IlvChartRenderer)object.next()).a(ilvChart, axisElement);
        }
        this.c();
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
        if (ilvChart2 != null) {
            this.a(this.getDataSource().getDataSets(), true, ilvChart);
        } else {
            this.a(this.getDataSource().getDataSets(), false, ilvChart);
        }
    }

    public final Rectangle getPlotRect() {
        if (this.i != null) {
            return this.i.getPlotRect();
        }
        return this.f.getChartArea().getPlotRect();
    }

    public Rectangle getClipRect() {
        return this.getPlotRect();
    }

    public boolean isVisible() {
        return this.j.getFlag(1);
    }

    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        this.j.setFlag(1, bl);
        this.f();
    }

    public final IlvCoordinateSystem getCoordinateSystem() {
        IlvChart.AxisElement axisElement = this.a();
        return axisElement == null ? null : axisElement.g();
    }

    public final int getYAxisIdx() {
        IlvChart.AxisElement axisElement = this.a();
        return axisElement == null ? -1 : axisElement.b();
    }

    final IlvChart.AxisElement a() {
        if (this.g == null) {
            return this.i == null ? null : this.i.a();
        }
        return this.g;
    }

    void a(IlvChart.AxisElement axisElement) {
        this.g = axisElement;
        Iterator iterator = this.getChildIterator();
        while (iterator.hasNext()) {
            ((IlvChartRenderer)iterator.next()).a(axisElement);
        }
        this.f();
    }

    public void toData(IlvDoublePoints ilvDoublePoints) {
        IlvChart ilvChart = this.getChart();
        if (ilvChart != null) {
            ilvChart.getProjector().toData(ilvDoublePoints, this.getPlotRect(), this.getCoordinateSystem());
        }
    }

    public void toDisplay(IlvDoublePoints ilvDoublePoints) {
        IlvChart ilvChart = this.getChart();
        if (ilvChart != null) {
            double d2 = this.getXShift();
            if (d2 != 0.0) {
                for (int i2 = 0; i2 < ilvDoublePoints.b; ++i2) {
                    ilvDoublePoints.setX(i2, ilvDoublePoints.getX(i2) + d2);
                }
            }
            ilvChart.getProjector().toDisplay(ilvDoublePoints, this.getPlotRect(), this.getCoordinateSystem());
        }
    }

    public String getName() {
        return this.h;
    }

    public void setName(String string) {
        if (string != null ? !string.equals(this.h) : string != this.h) {
            this.h = string;
            this.triggerChange(6);
        }
    }

    public void setXShift(double d2) {
        if (d2 != this.k) {
            this.k = d2;
            this.triggerChange(5);
        }
    }

    public double getXShift() {
        return this.i == null ? this.k : this.k + this.i.getXShift();
    }

    public boolean isViewable() {
        return this.j.getFlag(2) && (!this.getChart().is3D() || this.has3DSupport());
    }

    public abstract IlvDataInterval getXRange(IlvDataInterval var1);

    public abstract IlvDataInterval getYRange(IlvDataInterval var1);

    public abstract IlvDataInterval getYRange(IlvDataInterval var1, IlvDataInterval var2);

    int b() {
        return Integer.MAX_VALUE;
    }

    public int getMinDataSetCount() {
        return 1;
    }

    public final IlvDataSource getDataSource() {
        return this.l;
    }

    public int getDataSetIndex(IlvDataSet ilvDataSet) {
        return this.l == null ? -1 : this.l.getDataSetIndex(ilvDataSet);
    }

    public void setDataSource(IlvDataSource ilvDataSource) {
        if (ilvDataSource == null) {
            throw new IllegalArgumentException();
        }
        IlvDataSource ilvDataSource2 = this.getDataSource();
        if (ilvDataSource2 == ilvDataSource) {
            return;
        }
        if (ilvDataSource2 != null) {
            this.b(ilvDataSource2);
        }
        this.l = ilvDataSource;
        this.a(ilvDataSource);
        this.triggerChange(7);
        this.f();
    }

    private void a(IlvDataSource ilvDataSource) {
        ilvDataSource.addDataSourceListener(this.d());
        if (ilvDataSource.getDataSetCount() > 0) {
            this.dataSetsAdded(0, ilvDataSource.getDataSetCount() - 1, new IlvDataSet[0]);
            if (this.getChart() != null) {
                this.a(ilvDataSource.getDataSets(), true, null);
            }
        }
        this.c();
    }

    private void c() {
        String[] stringArray;
        if (this.l instanceof IlvXMLDataSource && (stringArray = ((IlvXMLDataSource)this.l).getStyleSheets()) != null && this.getChart() != null && !this.getChart().l().isStyling()) {
            try {
                this.getChart().setStyleSheets(stringArray);
            }
            catch (IlvStylingException ilvStylingException) {
                ilvStylingException.printStackTrace();
            }
        }
    }

    private void b(IlvDataSource ilvDataSource) {
        IlvDataSet[] ilvDataSetArray = ilvDataSource.getDataSets();
        ilvDataSource.removeDataSourceListener(this.d());
        if (ilvDataSetArray.length > 0) {
            this.dataSetsRemoved(0, ilvDataSetArray.length - 1, ilvDataSetArray);
            if (this.getChart() != null) {
                this.a(ilvDataSource.getDataSets(), false, null);
            }
        }
    }

    public final boolean isDisplayingDataSet(IlvDataSet ilvDataSet) {
        return this.l != null && this.l.containsDataSet(ilvDataSet);
    }

    public final IlvDataSet getVirtualDataSet(IlvDataSet ilvDataSet) {
        IlvVirtualDataSet ilvVirtualDataSet = IlvDataSetRendererProperty.getVirtualDataSet(this, ilvDataSet);
        if (ilvVirtualDataSet != null) {
            return ilvVirtualDataSet;
        }
        return ilvDataSet;
    }

    public abstract void setDisplayPoint(IlvDataSet var1, int var2, double var3, double var5);

    public void setDataPoint(IlvDataSet ilvDataSet, int n2, double d2, double d3) {
        if (this.isDisplayingDataSet(ilvDataSet)) {
            IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint(ilvDataSet, n2);
            ilvDataSetPoint.setData(d2, d3);
        }
    }

    public void addImageMapAreas(IlvIMapDefinition ilvIMapDefinition, List list) {
        int n2 = this.getChildCount();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            IlvChartRenderer ilvChartRenderer = this.getChild(i2);
            if (!ilvChartRenderer.isViewable() || !ilvIMapDefinition.mustGenerate(ilvChartRenderer)) continue;
            ilvChartRenderer.addImageMapAreas(ilvIMapDefinition, list);
        }
    }

    private synchronized DataSourceListener d() {
        if (this.m == null) {
            this.m = new DataSourceLST();
        }
        return this.m;
    }

    protected void dataSetsRemoved(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
    }

    protected void dataSetsAdded(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
    }

    protected void dataSetsChangesBatchStarting() {
        this.startRendererChanges();
    }

    protected void dataSetsChangesBatchEnding() {
        this.endRendererChanges();
    }

    public abstract IlvStyle[] getStyles();

    public abstract void setStyles(IlvStyle[] var1);

    public IlvStyle getStyle(int n2) {
        IlvStyle[] ilvStyleArray = this.getStyles();
        return ilvStyleArray != null && n2 < ilvStyleArray.length ? ilvStyleArray[n2] : null;
    }

    public void setStyle(int n2, IlvStyle ilvStyle) {
        IlvStyle[] ilvStyleArray = this.getStyles();
        if (ilvStyleArray != null && n2 < ilvStyleArray.length) {
            ilvStyleArray[n2] = ilvStyle;
            this.setStyles(ilvStyleArray);
        }
    }

    public abstract IlvStyle getStyle(IlvDataSet var1, int var2);

    public Color[] getDefaultColors() {
        if (this.i != null) {
            return this.i.getDefaultColors();
        }
        if (this.f != null) {
            return this.f.getDefaultColors();
        }
        return null;
    }

    protected Color findAppropriateColor(Collection collection) {
        Color color;
        ArrayList<Color> arrayList;
        Color[] colorArray = this.getDefaultColors();
        if (colorArray == null) {
            arrayList = IlvColor.getDefaultColors();
        } else {
            arrayList = new ArrayList<Color>(Arrays.asList(colorArray));
            List list = IlvColor.getDefaultColors();
            for (int i2 = arrayList.size(); i2 < list.size(); ++i2) {
                arrayList.add((Color)list.get(i2));
            }
        }
        int n2 = this.e();
        if (n2 < arrayList.size() && !collection.contains(arrayList.get(n2))) {
            color = (Color)arrayList.get(n2);
        } else {
            HashSet<Color> hashSet = new HashSet<Color>(arrayList);
            hashSet.removeAll(collection);
            if (hashSet.size() == 0) {
                color = IlvColorUtil.getRandomColor();
            } else {
                color = null;
                int n3 = arrayList.size();
                for (int i3 = 0; i3 < n3 && !hashSet.contains(color = (Color)arrayList.get(i3)); ++i3) {
                }
            }
        }
        return color;
    }

    private int e() {
        Object e2;
        int n2 = 0;
        Iterator iterator = this.getChart().getAllRendererIterator();
        while (iterator.hasNext() && (e2 = iterator.next()) != this) {
            if (!(e2 instanceof IlvSingleChartRenderer)) continue;
            ++n2;
        }
        return n2;
    }

    public abstract void draw(Graphics var1);

    public abstract void drawAnnotations(Graphics var1);

    public abstract void draw(Graphics var1, IlvDataSet var2, int var3, int var4);

    public Rectangle2D getBounds(IlvDataSet ilvDataSet, int n2, int n3, Rectangle2D rectangle2D) {
        return this.getBounds(ilvDataSet, n2, n3, rectangle2D, true);
    }

    public abstract Rectangle2D getBounds(IlvDataSet var1, int var2, int var3, Rectangle2D var4, boolean var5);

    public boolean has3DSupport() {
        return false;
    }

    protected void set3D(boolean bl) {
    }

    public double[] getDepths() {
        IlvChart ilvChart = this.getChart();
        if (ilvChart == null || !this.has3DSupport()) {
            return null;
        }
        IlvChart3DView ilvChart3DView = ilvChart.get3DView();
        double[] dArray = null;
        Iterator iterator = null;
        if (this.getParent() != null) {
            dArray = this.getParent().getDepths();
            if (dArray == null) {
                return null;
            }
            iterator = this.getParent().getChildIterator();
        } else {
            iterator = ilvChart.getRendererIterator();
            dArray = new double[]{ilvChart3DView.getFrontDepth(), ilvChart3DView.getBackDepth()};
        }
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)iterator.next();
            if (ilvChartRenderer == this) {
                n3 = n2;
            }
            if (!ilvChartRenderer.isViewable()) continue;
            ++n2;
        }
        double d2 = (dArray[0] - dArray[1]) / (double)n2;
        dArray[0] = ilvChart.getType() == 3 ? dArray[0] - d2 * (double)n3 : dArray[0] - d2 * (double)(n2 - n3 - 1);
        dArray[1] = dArray[0] - d2;
        if (this.getParent() != null || this.getChildCount() == 0) {
            double d3 = d2 * (double)ilvChart.get3DView().getDepthGap() / 200.0;
            dArray[0] = dArray[0] - d3;
            dArray[1] = dArray[1] + d3;
        }
        return dArray;
    }

    public int getChildCount() {
        return 0;
    }

    public Iterator getChildIterator() {
        return IlvCollections.emptyIterator();
    }

    public List getChildren() {
        return d;
    }

    public IlvChartRenderer getChild(int n2) {
        return null;
    }

    public IlvChartRenderer getParent() {
        return this.i;
    }

    public void setParent(IlvChartRenderer ilvChartRenderer) {
        if (ilvChartRenderer != null) {
            if (this.i != null) {
                throw new IllegalArgumentException("Renderer already connected to a parent");
            }
            if (this.getChart() != null) {
                throw new IllegalArgumentException("Renderer already connected to a chart");
            }
            this.i = ilvChartRenderer;
            this.a(ilvChartRenderer.getChart(), ilvChartRenderer.a());
        } else {
            this.i = null;
            this.a(null, null);
        }
    }

    public abstract IlvDisplayPoint getNearestPoint(IlvChartDataPicker var1);

    public abstract IlvDisplayPoint getDisplayItem(IlvChartDataPicker var1);

    public abstract IlvDisplayPoint getDisplayPoint(IlvDataSet var1, int var2);

    public abstract void drawLegendSymbol(IlvLegendItem var1, Graphics var2, int var3, int var4, int var5, int var6);

    public abstract IlvLegendItem[] createLegendItems();

    public String getLegendText(IlvLegendItem ilvLegendItem) {
        return this.getName();
    }

    public String getDefaultLegendTitle() {
        return null;
    }

    public IlvStyle getLegendStyle() {
        return this.getStyle(0);
    }

    public Insets getPreferredMargins() {
        Insets insets = new Insets(0, 0, 0, 0);
        Iterator iterator = this.getChildIterator();
        while (iterator.hasNext()) {
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)iterator.next();
            if (!ilvChartRenderer.isViewable()) continue;
            insets = IlvGraphicUtil.mergeInsets(insets, ilvChartRenderer.getPreferredMargins());
        }
        return insets;
    }

    public static List getDisplayItems(Iterator iterator, IlvChartDataPicker ilvChartDataPicker) {
        ArrayList<IlvDisplayPoint> arrayList = null;
        while (iterator.hasNext()) {
            IlvDisplayPoint ilvDisplayPoint;
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)iterator.next();
            if (!ilvChartRenderer.isViewable() || !ilvChartDataPicker.accept(ilvChartRenderer) || (ilvDisplayPoint = ilvChartRenderer.getDisplayItem(ilvChartDataPicker)) == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IlvDisplayPoint>();
            }
            arrayList.add(ilvDisplayPoint);
        }
        if (arrayList == null) {
            return Collections.EMPTY_LIST;
        }
        return arrayList;
    }

    public static IlvDisplayPoint getDisplayItem(Iterator iterator, IlvChartDataPicker ilvChartDataPicker) {
        IlvChartRenderer ilvChartRenderer;
        IlvDisplayPoint ilvDisplayPoint = null;
        while (!(!iterator.hasNext() || (ilvChartRenderer = (IlvChartRenderer)iterator.next()).isViewable() && ilvChartDataPicker.accept(ilvChartRenderer) && (ilvDisplayPoint = ilvChartRenderer.getDisplayItem(ilvChartDataPicker)) != null)) {
        }
        return ilvDisplayPoint;
    }

    public static IlvDisplayPoint getNearestPoint(Iterator iterator, IlvChartDataPicker ilvChartDataPicker) {
        IlvDisplayPoint ilvDisplayPoint = null;
        double d2 = Double.MAX_VALUE;
        while (iterator.hasNext()) {
            double d3;
            double d4;
            double d5;
            IlvDisplayPoint ilvDisplayPoint2;
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)iterator.next();
            if (!ilvChartRenderer.isViewable() || !ilvChartDataPicker.accept(ilvChartRenderer) || (ilvDisplayPoint2 = ilvChartRenderer.getNearestPoint(ilvChartDataPicker)) == null || !((d5 = (d4 = ilvDisplayPoint2.getXCoord() - (double)ilvChartDataPicker.getPickX()) * d4 + (d3 = ilvDisplayPoint2.getYCoord() - (double)ilvChartDataPicker.getPickY()) * d3) < d2)) continue;
            d2 = d5;
            ilvDisplayPoint = ilvDisplayPoint2;
        }
        return ilvDisplayPoint;
    }

    protected void triggerChange(int n2) {
        if (this.f != null) {
            this.f.a(this, n2);
        }
    }

    protected void startRendererChanges() {
        if (this.f != null) {
            this.f.startRendererChanges();
        }
    }

    protected void endRendererChanges() {
        if (this.f != null) {
            this.f.endRendererChanges();
        }
    }

    protected void fireTreemapFocusEvent(TreemapFocusEvent treemapFocusEvent) {
        if (this.f != null) {
            this.f.a(treemapFocusEvent);
        }
    }

    public boolean isVisibleInLegend() {
        return this.r == null ? (this.getParent() == null ? true : this.getParent().isVisibleInLegend()) : this.r;
    }

    public void setVisibleInLegend(boolean bl) {
        if (bl == this.isVisibleInLegend()) {
            return;
        }
        this.r = bl ? Boolean.TRUE : Boolean.FALSE;
        this.triggerChange(6);
    }

    public int getDataLabeling() {
        return this.p == null ? (this.getParent() == null ? 2 : this.getParent().getDataLabeling()) : this.p;
    }

    public int getDataLabelling() {
        return this.getDataLabeling();
    }

    public void setDataLabeling(int n2) {
        if (this.p == null || n2 != this.p) {
            this.p = new Integer(n2);
            if (this.getChart() != null) {
                this.getChart().getChartArea().revalidateLayout();
            }
        }
    }

    public void setDataLabelling(int n2) {
        this.setDataLabeling(n2);
    }

    public int getDataLabelLayout() {
        return this.q == null ? (this.getParent() == null ? 1 : this.getParent().getDataLabelLayout()) : this.q;
    }

    public void setDataLabelLayout(int n2) {
        if (this.q == null || n2 != this.q) {
            this.q = new Integer(n2);
            if (this.getChart() != null) {
                this.getChart().getChartArea().revalidateLayout();
            }
        }
    }

    public final IlvDataAnnotation getAnnotation() {
        return this.n;
    }

    public void setAnnotation(IlvDataAnnotation ilvDataAnnotation) {
        if (ilvDataAnnotation != this.n) {
            this.n = ilvDataAnnotation;
            if (this.getChart() != null) {
                this.getChart().getChartArea().repaint();
            }
        }
    }

    public abstract IlvDataAnnotation getAnnotation(IlvDataSet var1, int var2);

    public abstract void setAnnotation(IlvDataSet var1, int var2, IlvDataAnnotation var3);

    public abstract void setAnnotation(IlvDataSet var1, IlvDataAnnotation var2);

    public final IlvDataRenderingHint getRenderingHint() {
        return this.o;
    }

    public void setRenderingHint(IlvDataRenderingHint ilvDataRenderingHint) {
        if (ilvDataRenderingHint != this.o) {
            this.o = ilvDataRenderingHint;
            if (this.getChart() != null) {
                this.getChart().getChartArea().repaint();
            }
        }
    }

    public abstract IlvDataRenderingHint getRenderingHint(IlvDataSet var1, int var2);

    public abstract void setRenderingHint(IlvDataSet var1, int var2, IlvDataRenderingHint var3);

    public abstract void setRenderingHint(IlvDataSet var1, IlvDataRenderingHint var2);

    public String computeDataLabel(IlvDataSetPoint ilvDataSetPoint) {
        switch (this.getDataLabeling()) {
            case 1: {
                return ilvDataSetPoint.getDataSet().getDataLabel(ilvDataSetPoint.getIndex());
            }
            case 2: {
                return this.b(ilvDataSetPoint);
            }
            case 4: {
                return this.a(ilvDataSetPoint);
            }
            case 3: {
                StringBuffer stringBuffer = new StringBuffer("(");
                stringBuffer.append(this.a(ilvDataSetPoint));
                stringBuffer.append(",");
                stringBuffer.append(this.b(ilvDataSetPoint));
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
        }
        return null;
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        return new Point(IlvGraphicUtil.toInt(ilvDisplayPoint.getXCoord()), IlvGraphicUtil.toInt(ilvDisplayPoint.getYCoord()));
    }

    public void applyStyles(boolean bl) throws Exception {
        Iterator iterator = this.getChildIterator();
        while (iterator.hasNext()) {
            ((IlvChartRenderer)iterator.next()).applyStyles(bl);
        }
    }

    protected static IlvDataSetStyle applyStyles(IlvDataSet ilvDataSet, IlvChartRenderer ilvChartRenderer, IlvStylingSupport ilvStylingSupport) {
        IlvDataSetStyle ilvDataSetStyle = ilvStylingSupport.createDataSetStyle(ilvDataSet);
        IlvChartRenderer.a(ilvDataSetStyle, ilvChartRenderer, ilvStylingSupport);
        ilvStylingSupport.setDataSetStyle(ilvDataSet, ilvDataSetStyle);
        return ilvDataSetStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvDataSetStyle ilvDataSetStyle, IlvChartRenderer ilvChartRenderer, IlvStylingSupport ilvStylingSupport) {
        IlvDataSetStyle ilvDataSetStyle2 = ilvDataSetStyle;
        synchronized (ilvDataSetStyle2) {
            Object object;
            Object object2;
            IlvDataSet ilvDataSet = ilvDataSetStyle.getDataSet();
            IlvDataSetStyle.DataSetPointCSSModel dataSetPointCSSModel = ilvDataSetStyle.getCSSModel();
            Object object3 = ilvStylingSupport.getChart().getPseudoClasses(ilvDataSet);
            Object object4 = IlvDataSetProperty.getPseudoClasses(ilvDataSet);
            Object object5 = object4 == null ? object3 : (object2 = object3 == null ? object4 : IlvChartRenderer.a((String[])object3, (String[])object4));
            if (ilvChartRenderer != null) {
                object = new Object[]{ilvDataSetStyle, ilvChartRenderer};
                ilvStylingSupport.customizeBeans(dataSetPointCSSModel, ilvDataSet, ilvDataSet, (Object[])object, (String[])object2);
            } else {
                ilvStylingSupport.createBeanAndApplyDeclarations(dataSetPointCSSModel, ilvDataSet, ilvDataSet, ilvDataSetStyle, true, (String[])object2);
            }
            if (ilvChartRenderer != null) {
                ilvChartRenderer.setDataLabelLayout(ilvDataSetStyle.getLabelLayout());
                ilvChartRenderer.setDataLabeling(ilvDataSetStyle.getLabeling());
            }
            if ((object3 = ilvDataSet.getData()) != null) {
                object4 = new IlvDataSetPoint(ilvDataSet, 0);
                object2 = ilvDataSetStyle.getPointStyles();
                object = ilvStylingSupport.getChart().a(ilvDataSet);
                dataSetPointCSSModel.setDataPoint((IlvDataSetPoint)object4);
                object2.clear();
                int n2 = ((IlvDoublePoints)object3).size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3;
                    ((IlvDataSetPoint)object4).index = n3 = ((IlvDataPoints)object3).getIndex(i2);
                    ilvStylingSupport.clear();
                    String[] stringArray = object != null ? (String[])((IlvIntToObjectHashMap)object).get(n3) : null;
                    IlvApplicableDeclarationCollection ilvApplicableDeclarationCollection = ilvStylingSupport.getDeclarations(dataSetPointCSSModel, ilvDataSet, object4, stringArray);
                    ilvApplicableDeclarationCollection.reset();
                    if (!ilvApplicableDeclarationCollection.next()) continue;
                    IlvDataPointStyle ilvDataPointStyle = new IlvDataPointStyle(ilvDataSet);
                    ilvStylingSupport.createBeanAndApplyDeclarations(dataSetPointCSSModel, ilvDataSet, object4, ilvDataPointStyle, true, stringArray);
                    object2.put(n3, ilvDataPointStyle);
                }
                dataSetPointCSSModel.setDataPoint(null);
                ((IlvDataPoints)object3).dispose();
            }
        }
    }

    protected static void applyStyles(IlvDataSet ilvDataSet, boolean bl, int n2, int n3, IlvStylingSupport ilvStylingSupport) {
        IlvDataSetStyle ilvDataSetStyle = ilvStylingSupport.getDataSetStyle(ilvDataSet);
        if (ilvDataSetStyle != null) {
            IlvChartRenderer.a(bl, n2, n3, ilvDataSetStyle, ilvStylingSupport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(boolean bl, int n2, int n3, IlvDataSetStyle ilvDataSetStyle, IlvStylingSupport ilvStylingSupport) {
        IlvDataSetStyle ilvDataSetStyle2 = ilvDataSetStyle;
        synchronized (ilvDataSetStyle2) {
            IlvDataPoints ilvDataPoints;
            IlvDataSet ilvDataSet = ilvDataSetStyle.getDataSet();
            IlvIntToObjectMap<IlvDataPointStyle> ilvIntToObjectMap = ilvDataSetStyle.getPointStyles();
            if (bl || n2 == 0 && n3 == ilvDataSet.getDataCount() - 1) {
                ilvIntToObjectMap.clear();
            }
            if ((ilvDataPoints = ilvDataSet.getDataBetween(n2, n3)) != null) {
                IlvDataSetStyle.DataSetPointCSSModel dataSetPointCSSModel = ilvDataSetStyle.getCSSModel();
                IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint(ilvDataSet, n2);
                IlvIntToObjectHashMap<String[]> ilvIntToObjectHashMap = ilvStylingSupport.getChart().a(ilvDataSet);
                dataSetPointCSSModel.setDataPoint(ilvDataSetPoint);
                int n4 = ilvDataPoints.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n5;
                    ilvDataSetPoint.index = n5 = ilvDataPoints.getIndex(i2);
                    ilvStylingSupport.clear();
                    String[] stringArray = ilvIntToObjectHashMap != null ? ilvIntToObjectHashMap.get(n5) : null;
                    IlvApplicableDeclarationCollection ilvApplicableDeclarationCollection = ilvStylingSupport.getDeclarations(dataSetPointCSSModel, ilvDataSet, ilvDataSetPoint, stringArray);
                    ilvApplicableDeclarationCollection.reset();
                    if (ilvApplicableDeclarationCollection.next()) {
                        IlvDataPointStyle ilvDataPointStyle = new IlvDataPointStyle(ilvDataSet);
                        ilvStylingSupport.createBeanAndApplyDeclarations(dataSetPointCSSModel, ilvDataSet, ilvDataSetPoint, ilvDataPointStyle, true, stringArray);
                        ilvIntToObjectMap.put(n5, ilvDataPointStyle);
                        continue;
                    }
                    ilvIntToObjectMap.remove(n5);
                }
                dataSetPointCSSModel.setDataPoint(null);
                ilvDataPoints.dispose();
            }
        }
    }

    private static String[] a(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private void f() {
        boolean bl = this.j.getFlag(2);
        boolean bl2 = this.isVisible() && this.getDataSource().getDataSetCount() >= this.getMinDataSetCount() && this.a() != null;
        this.j.setFlag(2, bl2);
        if (bl != bl2) {
            this.triggerChange(3);
        }
    }

    private final String a(IlvDataSetPoint ilvDataSetPoint) {
        return this.getChart().formatXValue(ilvDataSetPoint.getXData());
    }

    private final String b(IlvDataSetPoint ilvDataSetPoint) {
        return this.getChart().formatYValue(this.getYAxisIdx(), ilvDataSetPoint.getYData());
    }

    static void a(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown chart renderer type: " + n2);
            }
        }
    }

    public static IlvChartRenderer createRenderer(int n2) {
        IlvChartRenderer ilvChartRenderer;
        switch (n2) {
            case 0: {
                ilvChartRenderer = new IlvBarChartRenderer();
                break;
            }
            case 1: {
                ilvChartRenderer = new IlvBarChartRenderer(3);
                break;
            }
            case 17: {
                ilvChartRenderer = new IlvBarChartRenderer(3);
                ilvChartRenderer.setStacked100Percent(true);
                break;
            }
            case 24: {
                ilvChartRenderer = new IlvBarChartRenderer(3);
                ilvChartRenderer.setDiverging(true);
                break;
            }
            case 2: {
                ilvChartRenderer = new IlvBarChartRenderer(1);
                break;
            }
            case 3: {
                ilvChartRenderer = new IlvAreaChartRenderer();
                break;
            }
            case 4: {
                ilvChartRenderer = new IlvAreaChartRenderer(2);
                break;
            }
            case 19: {
                ilvChartRenderer = new IlvAreaChartRenderer(2);
                ((IlvAreaChartRenderer)ilvChartRenderer).setStacked100Percent(true);
                break;
            }
            case 5: {
                ilvChartRenderer = new IlvPolylineChartRenderer();
                break;
            }
            case 11: {
                ilvChartRenderer = new IlvPolylineChartRenderer(2);
                break;
            }
            case 18: {
                ilvChartRenderer = new IlvPolylineChartRenderer(2);
                ((IlvPolylineChartRenderer)ilvChartRenderer).setStacked100Percent(true);
                break;
            }
            case 6: {
                ilvChartRenderer = new IlvScatterChartRenderer();
                break;
            }
            case 7: {
                ilvChartRenderer = new IlvStairChartRenderer();
                break;
            }
            case 14: {
                ilvChartRenderer = new IlvStairChartRenderer(2);
                break;
            }
            case 20: {
                ilvChartRenderer = new IlvStairChartRenderer(2);
                ((IlvStairChartRenderer)ilvChartRenderer).setStacked100Percent(true);
                break;
            }
            case 15: {
                ilvChartRenderer = new IlvStairChartRenderer(3);
                break;
            }
            case 8: {
                ilvChartRenderer = new IlvBubbleChartRenderer();
                break;
            }
            case 9: {
                ilvChartRenderer = new IlvHiLoChartRenderer();
                break;
            }
            case 21: {
                ilvChartRenderer = new IlvHiLoChartRenderer(1, 2, 80.0);
                break;
            }
            case 22: {
                ilvChartRenderer = new IlvHiLoChartRenderer(1, 0, 80.0);
                break;
            }
            case 12: {
                ilvChartRenderer = new IlvHiLoChartRenderer(2, 1, 80.0);
                break;
            }
            case 13: {
                ilvChartRenderer = new IlvHiLoChartRenderer(3, 1, 80.0);
                break;
            }
            case 10: {
                ilvChartRenderer = new IlvPieChartRenderer();
                break;
            }
            case 23: {
                ilvChartRenderer = new IlvTreemapChartRenderer();
                break;
            }
            case 16: {
                ilvChartRenderer = new IlvComboChartRenderer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown chart type: " + n2);
            }
        }
        return ilvChartRenderer;
    }

    void a(IlvChartRenderer ilvChartRenderer) {
        this.setRenderingHint(ilvChartRenderer.getRenderingHint());
        this.setAnnotation(ilvChartRenderer.getAnnotation());
        this.setDataLabelLayout(ilvChartRenderer.getDataLabelLayout());
        this.setDataLabeling(ilvChartRenderer.getDataLabeling());
    }

    private void a(IlvDataSet[] ilvDataSetArray, boolean bl, IlvChart ilvChart) {
        IlvStylingSupport ilvStylingSupport;
        IlvChart ilvChart2;
        IlvChart ilvChart3 = ilvChart2 = this.getChart() == null ? ilvChart : this.getChart();
        if (!bl) {
            int n2 = ilvDataSetArray.length;
            while (--n2 >= 0) {
                IlvDataSetStyle.set(ilvChart2, ilvDataSetArray[n2], null);
            }
        } else if (this.getChart().isDynamicStyling() && (ilvStylingSupport = IlvStylingSupport.get(this.getChart())) != null && ilvStylingSupport.hasStyles() && !ilvStylingSupport.isStyling()) {
            try {
                this.applyStyles(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n3 = ilvDataSetArray.length;
        while (--n3 >= 0) {
            IlvDataSet ilvDataSet = ilvDataSetArray[n3];
            if (!(ilvDataSet instanceof IlvLODDataSet)) continue;
            if (bl && this.isViewable()) {
                IlvLODHandler.connect(ilvChart2, (IlvLODDataSet)ilvDataSet);
                continue;
            }
            IlvLODHandler.disconnect(ilvChart2, (IlvLODDataSet)ilvDataSet);
        }
    }

    public void dispose() {
        if (this.f != null) {
            throw new IllegalStateException("dispose: renderer still connected to a chart. You need to remove it from the chart before being able to dispose it.");
        }
        if (this.i != null) {
            throw new IllegalArgumentException("dispose: renderer is a child renderer, belonging to " + this.i);
        }
        if (this.j != null) {
            if (this.l != null) {
                this.b(this.l);
            }
            Iterator iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                ((IlvChartRenderer)iterator.next()).dispose();
            }
            this.g = null;
            this.h = null;
            this.j = null;
            this.l = null;
            this.m = null;
            this.n = null;
            this.o = null;
        }
    }

    class DataSourceLST
    implements DataSourceListener2,
    Serializable {
        DataSourceLST() {
        }

        public void dataSourceChanged(DataSourceEvent dataSourceEvent) {
            int n2 = dataSourceEvent.getFirstIdx();
            int n3 = dataSourceEvent.getLastIdx();
            if (dataSourceEvent.getType() == 0) {
                IlvChartRenderer.this.dataSetsAdded(n2, n3, dataSourceEvent.getOldDataSets());
                if (IlvChartRenderer.this.getChart() != null) {
                    IlvDataSet[] ilvDataSetArray = new IlvDataSet[n3 - n2 + 1];
                    int n4 = n2;
                    int n5 = 0;
                    while (n4 <= n3) {
                        ilvDataSetArray[n5] = IlvChartRenderer.this.getDataSource().getDataSet(n4);
                        ++n4;
                        ++n5;
                    }
                    IlvChartRenderer.this.a(ilvDataSetArray, true, null);
                }
            } else if (dataSourceEvent.getType() == 1) {
                IlvChartRenderer.this.dataSetsRemoved(n2, n3, dataSourceEvent.getOldDataSets());
                if (IlvChartRenderer.this.getChart() != null) {
                    IlvDataSet[] ilvDataSetArray = new IlvDataSet[n3 - n2 + 1];
                    int n6 = n2;
                    int n7 = 0;
                    while (n6 <= n3) {
                        ilvDataSetArray[n7] = dataSourceEvent.getOldDataSets()[n6];
                        ++n6;
                        ++n7;
                    }
                    IlvChartRenderer.this.a(ilvDataSetArray, false, null);
                }
            }
            IlvChartRenderer.this.f();
            IlvChartRenderer.this.triggerChange(7);
        }

        public void startDataSourceChanges() {
            IlvChartRenderer.this.dataSetsChangesBatchStarting();
        }

        public void endDataSourceChanges() {
            IlvChartRenderer.this.dataSetsChangesBatchEnding();
        }
    }
}

