/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataRangePolicy;
import ilog.views.chart.IlvScale;
import java.io.Serializable;

public class IlvDefaultDataRangePolicy
implements IlvDataRangePolicy,
Serializable {
    public IlvDataInterval computeDataRange(IlvChart ilvChart, IlvAxis ilvAxis, IlvDataInterval ilvDataInterval) {
        if (ilvDataInterval == null) {
            ilvDataInterval = new IlvDataInterval();
        } else {
            ilvDataInterval.empty();
        }
        int n2 = ilvChart.getRendererCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChartRenderer ilvChartRenderer = ilvChart.getRenderer(i2);
            if (!ilvChartRenderer.isViewable()) continue;
            if (ilvAxis.isXAxis()) {
                ilvDataInterval.add(ilvChartRenderer.getXRange(null));
                continue;
            }
            if (ilvChartRenderer.getCoordinateSystem().getYAxis() != ilvAxis) continue;
            ilvDataInterval.add(ilvChartRenderer.getYRange(null));
        }
        ilvChart.a(ilvAxis, ilvDataInterval);
        if (!ilvAxis.isAutoDataMin()) {
            ilvDataInterval.setMin(ilvAxis.getDataMin());
        }
        if (!ilvAxis.isAutoDataMax()) {
            ilvDataInterval.setMax(ilvAxis.getDataMax());
        }
        if (this.shouldAdjust(ilvChart, ilvAxis)) {
            this.adjustRange(ilvChart, ilvAxis, ilvDataInterval);
        }
        return ilvDataInterval;
    }

    protected boolean shouldAdjust(IlvChart ilvChart, IlvAxis ilvAxis) {
        return ilvAxis.isYAxis();
    }

    protected void adjustRange(IlvChart ilvChart, IlvAxis ilvAxis, IlvDataInterval ilvDataInterval) {
        Object object;
        if (ilvDataInterval.getLength() == 0.0 && ilvAxis.isYAxis()) {
            object = ilvChart.getDataSource();
            if (object == null) {
                return;
            }
            boolean bl = false;
            int n2 = object.getDataSetCount();
            while (--n2 >= 0) {
                if (object.getDataSet(n2).getDataCount() <= 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            ilvDataInterval.add(ilvChart.c(ilvAxis).getXCrossingValue());
            if (ilvDataInterval.getLength() == 0.0) {
                ilvDataInterval.add(0.0);
            }
            if (ilvDataInterval.getLength() == 0.0) {
                ilvDataInterval.expand(1.0);
            }
        }
        if (!IlvDefaultDataRangePolicy.a(ilvDataInterval)) {
            return;
        }
        object = ilvChart.getScale(ilvAxis);
        if (object == null) {
            return;
        }
        ((IlvScale)object).getStepsDefinition().a(null, ilvDataInterval);
    }

    private static boolean a(IlvDataInterval ilvDataInterval) {
        return !ilvDataInterval.isEmpty() && ilvDataInterval.getMin() != Double.NEGATIVE_INFINITY && ilvDataInterval.getMax() != Double.POSITIVE_INFINITY && ilvDataInterval.getMax() < 8.988465674311579E307 && ilvDataInterval.getMin() > -8.988465674311579E307;
    }
}

