/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvDataInterval;

public class IlvLogarithmicAxisTransformer
extends IlvAxisTransformer {
    private double a;
    private double b;
    private boolean c = true;

    public IlvLogarithmicAxisTransformer() {
        this(10.0);
    }

    public IlvLogarithmicAxisTransformer(double d2) {
        this.setLogBase(d2);
    }

    public final double getLogBase() {
        return this.a;
    }

    public void setLogBase(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Logarithmic base must be strictly positive");
        }
        if (d2 != this.a) {
            this.a = d2;
            this.b = Math.log(d2);
            this.transformerChanged();
        }
    }

    public boolean isRoundingToPowers() {
        return this.c;
    }

    public void setRoundingToPowers(boolean bl) {
        this.c = bl;
    }

    public double apply(double d2) throws IlvAxisTransformerException {
        if (d2 <= 0.0) {
            return 0.0;
        }
        return Math.log(d2) / this.b;
    }

    public double inverse(double d2) throws IlvAxisTransformerException {
        return Math.exp(d2 * this.b);
    }

    public boolean validateInterval(IlvDataInterval ilvDataInterval) {
        boolean bl = false;
        if (this.getLogBase() > 1.0) {
            double d2;
            double d3 = ilvDataInterval.min;
            double d4 = 1.0E-6;
            if (this.c) {
                if (d3 <= 0.0) {
                    d2 = 0.0;
                } else {
                    if (d3 + d4 > Double.MAX_VALUE) {
                        d4 = 0.0;
                    }
                    d2 = Math.floor(Math.log(d3) / this.b + d4);
                }
                ilvDataInterval.min = Math.pow(this.getLogBase(), d2);
            } else if (d3 <= 0.0) {
                ilvDataInterval.min = 0.0;
            }
            if (d3 != ilvDataInterval.min) {
                bl = true;
            }
            d3 = ilvDataInterval.max;
            d4 = 1.0E-6;
            if (this.c) {
                if (d3 <= 0.0) {
                    d2 = 0.0;
                } else {
                    if (d3 + d4 > Double.MAX_VALUE) {
                        d4 = 0.0;
                    }
                    d2 = Math.floor(Math.log(d3) / this.b + d4);
                    if (Math.pow(this.getLogBase(), d2) != d3) {
                        d2 += 1.0;
                    }
                }
                ilvDataInterval.max = Math.pow(this.getLogBase(), d2);
            } else if (d3 <= 0.0) {
                ilvDataInterval.max = 0.0;
            }
            if (d3 != ilvDataInterval.max) {
                bl = true;
            }
        }
        return bl;
    }
}

