/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvCategoryStepsDefinition;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDrawable;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDefaultStepsDefinition;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLabelRenderer;
import ilog.views.chart.IlvLogarithmicAxisTransformer;
import ilog.views.chart.IlvLogarithmicStepsDefinition;
import ilog.views.chart.IlvScaleAnnotation;
import ilog.views.chart.IlvScaleConfiguration;
import ilog.views.chart.IlvStepsDefinition;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.IlvTimeStepsDefinition;
import ilog.views.chart.IlvTimeUnit;
import ilog.views.chart.IlvValueFormat;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import ilog.views.chart.internal.IlvPolarProjector;
import ilog.views.chart.internal.IlvTextRenderer;
import ilog.views.chart.util.IlvDoubleArray;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvFlags;
import ilog.views.chart.util.internal.IlvMathUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class IlvScale
implements IlvChartDrawable,
Serializable {
    static final boolean a = true;
    static final boolean b = true;
    public static final int TICK_INSIDE = 1;
    public static final int TICK_OUTSIDE = 2;
    public static final int TICK_CROSS = 3;
    public static final int CONSTANT_SKIP = 1;
    public static final int ADAPTIVE_SKIP = 2;
    public static final int LOWER_SIDE = -1;
    public static final int UPPER_SIDE = 1;
    static final int c = 1;
    static final int d = 2;
    static final int e = 3;
    private static final int f = 1;
    private static final int g = 2;
    private static final int h = 4;
    private static final int i = 8;
    private static final int j = 16;
    private static final int k = 32;
    private static final int l = 1024;
    private static final int m = 2048;
    private static final int n = 8192;
    private static final int o = 16384;
    private static final int p = 32768;
    private static final int q = 63;
    IlvFlags r = new IlvFlags(63);
    private int s = Integer.MAX_VALUE;
    private int t = 6;
    private int u = 3;
    private int v = 3;
    private int w = 3;
    private int x = 0;
    private int y = 2;
    private int z = 1;
    private double aa = 0.0;
    private boolean ab;
    private IlvChart.AxisElement ac;
    private AxisListener ad;
    private IlvAxis.Crossing ae;
    private int af;
    transient Rectangle ag;
    transient Rectangle ah;
    Steps ai;
    IlvStepsDefinition aj;
    transient boolean ak;
    private IlvStyle al;
    private Color am;
    private Title an;
    private List ao;
    private IlvValueFormat ap;
    private Font aq;
    private IlvScale ar;
    private IlvScale as;
    private boolean at;
    private IlvScaleConfiguration au = IlvScaleConfiguration.a(1);

    public IlvScale() {
        this(0.0, 0.0);
    }

    public IlvScale(double d2, double d3) {
        this.au.a(this);
        this.setStepUnit(d2 == 0.0 ? null : new Double(d2), d3 == 0.0 ? null : new Double(d3));
        this.an();
    }

    public IlvScale(IlvTimeUnit ilvTimeUnit) {
        this.au.a(this);
        this.setTimeUnit(ilvTimeUnit);
        this.an();
    }

    final IlvScaleConfiguration a() {
        return this.au;
    }

    void a(IlvScaleConfiguration ilvScaleConfiguration) {
        if (ilvScaleConfiguration != this.au) {
            if (this.au != null) {
                this.au.a((IlvScale)null);
            }
            this.au = ilvScaleConfiguration;
            if (ilvScaleConfiguration != null) {
                ilvScaleConfiguration.a(this);
            }
            this.m().h();
        }
    }

    public final Stroke getAxisStroke() {
        return this.b().getStroke();
    }

    public void setAxisStroke(Stroke stroke) {
        this.al = this.b().setStroke(stroke);
    }

    final IlvStyle b() {
        if (this.al == null) {
            this.al = IlvStyle.createStroked(this.getForeground());
        } else if (!this.r.getFlag(32768)) {
            this.al.a(this.getForeground());
        }
        return this.al;
    }

    final boolean c() {
        return this.r.getFlag(8192);
    }

    void a(boolean bl) {
        this.r.setFlag(8192, bl);
    }

    final boolean d() {
        return this.getChart().isAntiAliasingText();
    }

    void b(boolean bl) {
        this.r.setFlag(16384, bl);
    }

    public final Font getLabelFont() {
        if (this.aq == null) {
            if (this.getChart() != null) {
                return this.getChart().getChartArea().getFont();
            }
            return UIManager.getFont("Label.font");
        }
        return this.getChart() != null && this.getChart().getFontManager() != null ? this.getChart().getFontManager().getDeriveFont(this.aq) : this.aq;
    }

    public void setLabelFont(Font font) {
        if (font != this.aq) {
            this.aq = font;
            this.ae();
        }
    }

    FontMetrics a(Font font) {
        if (this.getChart() != null) {
            return this.getChart().getChartArea().getFontMetrics(font);
        }
        return new JLabel().getFontMetrics(font);
    }

    public final Color getLabelColor() {
        return this.am == null ? this.getForeground() : this.am;
    }

    public void setLabelColor(Color color) {
        this.am = color;
    }

    public Color getForeground() {
        if (this.al == null || !this.r.getFlag(32768)) {
            return this.af();
        }
        return this.al.getStrokeColor();
    }

    public void setForeground(Color color) {
        if (color == null || color instanceof ColorUIResource) {
            this.r.setFlag(32768, false);
            color = this.af();
        } else {
            this.r.setFlag(32768, true);
        }
        this.al = this.b().setStrokePaint(color);
    }

    private Color af() {
        return this.getChart() != null ? this.getChart().getChartArea().getForeground() : UIManager.getColor("Label.foreground");
    }

    public final int getDrawOrder() {
        return this.s;
    }

    public void setDrawOrder(int n2) {
        if (this.s == n2) {
            return;
        }
        int n3 = this.s;
        this.s = n2;
        if (this.getChart() != null) {
            this.getChart().a(this, n3, n2);
            this.getChart().getChartArea().repaint2D(this.getBounds(null));
        }
    }

    public final int getMajorTickSize() {
        return this.t;
    }

    public void setMajorTickSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
        if (n2 != this.t) {
            this.t = n2;
            this.ae();
        }
    }

    public final int getMinorTickSize() {
        return this.u;
    }

    public void setMinorTickSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
        if (n2 != this.u) {
            this.u = n2;
            this.ae();
        }
    }

    public final int getTickLayout() {
        return this.y;
    }

    public void setTickLayout(int n2) {
        if (this.y == n2) {
            return;
        }
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("Invalid constant");
        }
        this.y = n2;
        this.ae();
    }

    public final int getLabelOffset() {
        return this.v;
    }

    public void setLabelOffset(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
        if (n2 != this.v) {
            this.v = n2;
            this.ae();
        }
    }

    public final int getTitleOffset() {
        return this.w;
    }

    public void setTitleOffset(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
        if (n2 != this.w) {
            this.w = n2;
            this.ae();
        }
    }

    public final boolean isAutoWrapping() {
        return this.ab;
    }

    public void setAutoWrapping(boolean bl) {
        if (this.ab == bl) {
            return;
        }
        this.ab = bl;
        this.m().b(bl);
        this.ae();
    }

    public final int getLabelAlignment() {
        return this.x;
    }

    public void setLabelAlignment(int n2) {
        if (n2 != 2 && n2 != 0 && n2 != 4) {
            throw new IllegalArgumentException("Invalid Alignment");
        }
        if (this.x == n2) {
            return;
        }
        this.x = n2;
        this.m().b(n2);
        if (this.getChart() != null) {
            this.getChart().getChartArea().repaint();
        }
    }

    private synchronized Title ag() {
        if (this.an == null) {
            this.an = new Title(null, 0.0);
        }
        return this.an;
    }

    public double getTitleRotation() {
        return this.ag().getLabelRenderer().getRotation();
    }

    public void setTitleRotation(double d2) {
        this.ag().getLabelRenderer().setRotation(d2);
    }

    public Font getTitleFont() {
        return this.ag().getLabelRenderer().getFont();
    }

    public void setTitleFont(Font font) {
        this.ag().getLabelRenderer().setFont(font);
    }

    public final String getTitle() {
        return this.ag().getText();
    }

    public void setTitle(String string) {
        if (string != null ? !string.equals(this.getTitle()) : string != this.getTitle()) {
            this.ag().setText(string);
            this.ae();
        }
    }

    public void setTitle(String string, double d2) {
        if ((string == null ? string != this.getTitle() : !string.equals(this.getTitle())) || d2 != this.ag().getLabelRenderer().getRotation()) {
            this.ag().setText(string);
            this.ag().getLabelRenderer().setRotation(d2);
            this.ae();
        }
    }

    public IlvLabelRenderer getTitleRenderer() {
        return this.ag().getLabelRenderer();
    }

    public int getTitlePlacement() {
        return this.ag().getPlacement();
    }

    public void setTitlePlacement(int n2) {
        this.ag().setPlacement(n2);
    }

    final Title e() {
        return this.an;
    }

    boolean f() {
        IlvAxis ilvAxis = this.getDualAxis();
        if (ilvAxis == null) {
            return false;
        }
        IlvDataInterval ilvDataInterval = ilvAxis.getVisibleRange();
        return this.isVisible() && this.getAxis() != null && (!this.aj() || ilvDataInterval.isInside(this.getCrossingValue()));
    }

    public double getLabelRotation() {
        return this.aa;
    }

    public void setLabelRotation(double d2) {
        if (d2 != this.aa) {
            this.aa = d2;
            this.m().a(d2);
            this.ae();
        }
    }

    public final boolean isSkippingLabel() {
        return this.r.getFlag(2);
    }

    public void setSkippingLabel(boolean bl) {
        if (bl == this.isSkippingLabel()) {
            return;
        }
        this.r.setFlag(2, bl);
        this.ae();
    }

    public final int getSkipLabelMode() {
        return this.z;
    }

    public void setSkipLabelMode(int n2) {
        if (n2 == this.z) {
            return;
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid constant");
        }
        this.z = n2;
        this.ae();
    }

    final boolean g() {
        return this.isCategory() && ((IlvCategoryStepsDefinition)this.getStepsDefinition()).isStepBetweenCategory();
    }

    final boolean h() {
        return this.isCategory() && ((IlvCategoryStepsDefinition)this.getStepsDefinition()).isLabelBetweenCategory();
    }

    private void d(boolean bl) {
        this.r.setFlag(2048, bl);
    }

    public boolean has3DSupport() {
        return true;
    }

    public final boolean isVisible() {
        return this.r.getFlag(1);
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            this.r.setFlag(1, bl);
            this.ae();
        }
    }

    public final boolean isAxisVisible() {
        return this.r.getFlag(16);
    }

    public void setAxisVisible(boolean bl) {
        if (bl != this.isAxisVisible()) {
            this.r.setFlag(16, bl);
            this.ae();
        }
    }

    public final boolean isMajorTickVisible() {
        return this.r.getFlag(4);
    }

    public void setMajorTickVisible(boolean bl) {
        if (bl != this.isMajorTickVisible()) {
            this.r.setFlag(4, bl);
            this.ae();
        }
    }

    public final boolean isMinorTickVisible() {
        return this.r.getFlag(8);
    }

    public void setMinorTickVisible(boolean bl) {
        if (bl != this.isMinorTickVisible()) {
            this.r.setFlag(8, bl);
            this.ae();
        }
    }

    public final boolean isLabelVisible() {
        return this.r.getFlag(32);
    }

    public void setLabelVisible(boolean bl) {
        if (bl != this.isLabelVisible()) {
            this.r.setFlag(32, bl);
            this.ae();
        }
    }

    public final boolean isAutoCrossing() {
        return this.ae == null;
    }

    public void setAutoCrossing(boolean bl) {
        if (bl) {
            this.a((IlvAxis.Crossing)null);
        } else {
            this.a(this.getCrossing());
        }
    }

    private IlvAxis.Crossing ah() {
        return this.au.a();
    }

    public final IlvAxis.Crossing getCrossing() {
        return this.ae == null ? this.ah() : this.ae;
    }

    public void setCrossing(IlvAxis.Crossing crossing) {
        this.a(crossing);
    }

    private void a(IlvAxis.Crossing crossing) {
        this.ae = crossing;
        this.m().p();
        this.ae();
    }

    public final double getCrossingValue() {
        if (this.getChart().is3D()) {
            return this.getChart().get3DView().d().getCrossingValue(this.getAxis());
        }
        return this.getCrossing().getValue(this.getDualAxis());
    }

    public void setCrossingValue(double d2) {
        this.setCrossing(new IlvAxis.AnchoredCrossing(d2));
    }

    public final boolean isAutoSide() {
        return this.af == 0;
    }

    public void setAutoSide(boolean bl) {
        if (bl != this.isAutoSide()) {
            if (bl) {
                int n2 = this.getSide();
                this.af = 0;
                if (this.getSide() != n2) {
                    this.au.b();
                    this.ae();
                }
            } else {
                this.af = this.getDefaultSide();
            }
        }
    }

    public int getDefaultSide() {
        return this.getCrossing() == IlvAxis.MAX_VALUE ? 1 : -1;
    }

    public int getSide() {
        return this.isAutoSide() ? this.getDefaultSide() : this.af;
    }

    public void setSide(int n2) {
        switch (n2) {
            case -1: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid side: " + n2);
            }
        }
        int n3 = this.getSide();
        this.af = n2;
        if (n2 != n3) {
            this.au.b();
            this.ae();
        }
    }

    void a(IlvScale ilvScale) {
        if (ilvScale == this.as) {
            return;
        }
        if (this.as != null) {
            this.as.b((IlvScale)null);
        }
        this.as = ilvScale;
        this.as.b(this);
        this.at = false;
        this.ae();
    }

    final IlvScale i() {
        if (this.as != null) {
            return this.as;
        }
        IlvChart ilvChart = this.getChart();
        if (ilvChart == null || ilvChart.getType() != 1 || this.getAxis().isXAxis() || this.aj()) {
            return null;
        }
        int n2 = ilvChart.getYAxisCount();
        IlvAxis.Crossing crossing = this.getCrossing();
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvScale ilvScale = ilvChart.getYScale(i2);
            if (ilvScale == null) continue;
            if (ilvScale == this) {
                bl = true;
                continue;
            }
            if (!bl || ilvScale.getCrossing() != crossing) continue;
            return ilvScale;
        }
        return null;
    }

    final void b(IlvScale ilvScale) {
        this.ar = ilvScale;
        this.m().p();
        this.ae();
    }

    final IlvScale j() {
        if (this.ar != null) {
            return this.ar;
        }
        IlvChart ilvChart = this.getChart();
        if (ilvChart == null || ilvChart.getType() != 1 || this.getAxis().isXAxis() || this.aj()) {
            return null;
        }
        IlvAxis.Crossing crossing = this.getCrossing();
        boolean bl = false;
        int n2 = ilvChart.getYAxisCount();
        while (--n2 >= 0) {
            IlvScale ilvScale = ilvChart.getYScale(n2);
            if (ilvScale == null) continue;
            if (ilvScale == this) {
                bl = true;
                continue;
            }
            if (!bl || ilvScale.getCrossing() != crossing) continue;
            return ilvScale;
        }
        return null;
    }

    final boolean k() {
        return this.at;
    }

    final boolean l() {
        return this.i() != null && this.k() && (this.getChart() == null || this.getChart().getType() == 1);
    }

    void c(IlvScale ilvScale) {
        this.a(ilvScale);
        boolean bl = this.at = ilvScale != null;
        if (this.at) {
            ilvScale.a(this.r());
        }
    }

    public final IlvStepsDefinition getStepsDefinition() {
        return this.aj;
    }

    public void setStepsDefinition(IlvStepsDefinition ilvStepsDefinition) {
        if (ilvStepsDefinition == null) {
            throw new IllegalArgumentException("Steps definition cannot be null");
        }
        if (ilvStepsDefinition.getScale() != null && ilvStepsDefinition.getScale() != this) {
            throw new IllegalArgumentException("Steps definition owned by another scale");
        }
        if (ilvStepsDefinition == this.aj) {
            return;
        }
        boolean bl = this.isCategory();
        if (this.aj != null) {
            this.aj.a(null);
        }
        this.d(ilvStepsDefinition instanceof IlvCategoryStepsDefinition);
        this.aj = ilvStepsDefinition;
        this.aj.a(this);
        if (this.getAxis() != null && ilvStepsDefinition instanceof IlvLogarithmicStepsDefinition && (this.getAxis().getTransformer() == null || !(this.getAxis().getTransformer() instanceof IlvLogarithmicAxisTransformer))) {
            this.getAxis().setTransformer(new IlvLogarithmicAxisTransformer());
        }
        if (this.m() != null) {
            this.m().h();
        }
        if (bl != this.isCategory() && this.getChart() != null) {
            this.getChart().updateDataRange();
        }
        this.ae();
    }

    public void setStepUnit(double d2, double d3) {
        IlvDefaultStepsDefinition ilvDefaultStepsDefinition;
        boolean bl = false;
        if (this.getStepsDefinition() instanceof IlvDefaultStepsDefinition) {
            ilvDefaultStepsDefinition = (IlvDefaultStepsDefinition)this.getStepsDefinition();
        } else {
            ilvDefaultStepsDefinition = new IlvDefaultStepsDefinition();
            bl = true;
        }
        if (d2 != 0.0) {
            ilvDefaultStepsDefinition.setStepUnit(d2);
        } else {
            ilvDefaultStepsDefinition.setAutoStepUnit(true);
        }
        if (d3 != 0.0) {
            ilvDefaultStepsDefinition.setSubStepUnit(d3);
        } else {
            ilvDefaultStepsDefinition.setAutoSubStepUnit(true);
        }
        if (bl) {
            this.setStepsDefinition(ilvDefaultStepsDefinition);
        }
    }

    public void setStepUnit(Double d2, Double d3) {
        IlvDefaultStepsDefinition ilvDefaultStepsDefinition;
        boolean bl = false;
        if (this.getStepsDefinition() instanceof IlvDefaultStepsDefinition) {
            ilvDefaultStepsDefinition = (IlvDefaultStepsDefinition)this.getStepsDefinition();
        } else {
            ilvDefaultStepsDefinition = new IlvDefaultStepsDefinition();
            bl = true;
        }
        if (d2 != null) {
            ilvDefaultStepsDefinition.setStepUnit(d2);
        } else {
            ilvDefaultStepsDefinition.setAutoStepUnit(true);
        }
        if (d3 != null) {
            ilvDefaultStepsDefinition.setSubStepUnit(d3);
        } else {
            ilvDefaultStepsDefinition.setAutoSubStepUnit(true);
        }
        if (bl) {
            this.setStepsDefinition(ilvDefaultStepsDefinition);
        }
    }

    public void setTimeUnit(IlvTimeUnit ilvTimeUnit) {
        IlvTimeStepsDefinition ilvTimeStepsDefinition;
        boolean bl = false;
        if (this.getStepsDefinition() instanceof IlvTimeStepsDefinition) {
            ilvTimeStepsDefinition = (IlvTimeStepsDefinition)this.getStepsDefinition();
        } else {
            ilvTimeStepsDefinition = new IlvTimeStepsDefinition();
            bl = true;
        }
        if (ilvTimeUnit != null) {
            ilvTimeStepsDefinition.setUnit(ilvTimeUnit);
        } else {
            ilvTimeStepsDefinition.setAutoUnit(true);
        }
        if (bl) {
            this.setStepsDefinition(ilvTimeStepsDefinition);
        }
    }

    public final boolean isCategory() {
        return this.r.getFlag(2048);
    }

    public final void setCategory(boolean bl) {
        if (bl != this.r.getFlag(2048)) {
            if (bl) {
                this.setCategory(null, true);
            } else {
                this.setStepUnit(null, null);
            }
        }
    }

    public void setCategory(IlvDataSet ilvDataSet, boolean bl) {
        this.setStepsDefinition(new IlvCategoryStepsDefinition(bl, ilvDataSet));
    }

    public void setLogarithmic(double d2) {
        if (this.getAxis() == null) {
            throw new UnsupportedOperationException("Scale should be added to a chart");
        }
        this.getAxis().setTransformer(new IlvLogarithmicAxisTransformer(d2));
        this.setStepsDefinition(new IlvLogarithmicStepsDefinition());
    }

    final Steps m() {
        return this.ai;
    }

    void a(Steps steps) {
        this.ai = steps;
    }

    final boolean n() {
        return this.getChart() != null && this.getChart().is3D();
    }

    final IlvChartProjector o() {
        return this.ac == null ? null : this.ac.f().getProjector();
    }

    final IlvChartProjector p() {
        return this.ac == null ? null : this.ac.f().getProjector2D();
    }

    public final IlvAxis getAxis() {
        return this.ac == null ? null : this.ac.c();
    }

    public final IlvAxis getDualAxis() {
        return this.ac == null ? null : this.ac.h();
    }

    public final IlvCoordinateSystem getCoordinateSystem() {
        return this.ac == null ? null : this.ac.g();
    }

    public final IlvChart getChart() {
        return this.ac == null ? null : this.ac.f();
    }

    final Rectangle q() {
        return this.ag;
    }

    final IlvChart.AxisElement r() {
        return this.ac;
    }

    void a(IlvChart.AxisElement axisElement) {
        if (axisElement != this.ac) {
            if (this.ac != null) {
                this.ac.c().removeAxisListener(this.al());
            }
            this.ac = axisElement;
            if (this.ac != null) {
                this.ac.c().addAxisListener(this.al());
                if (this.getChart().isAutoScaleTitleRotation()) {
                    this.a(true, false);
                }
            }
        }
        if (this.getStepsDefinition() instanceof IlvTimeStepsDefinition) {
            ((IlvTimeStepsDefinition)this.getStepsDefinition()).a();
        }
        if (this.l()) {
            this.i().a(axisElement);
        }
    }

    void a(boolean bl, boolean bl2) {
        if (bl) {
            double d2;
            double d3 = d2 = this.getAxis().isXAxis() ? 0.0 : -90.0;
            if (this.getChart() != null && this.getChart().isProjectorReversed()) {
                d2 = d2 == 0.0 ? -90.0 : 0.0;
            }
            this.ag().getLabelRenderer().setRotation(d2);
        }
        if (bl2) {
            this.ae();
        }
    }

    void a(Rectangle rectangle, boolean bl) {
        if (!this.ag.equals(rectangle)) {
            this.ag.setBounds(rectangle);
            if (bl) {
                this.ai.p();
            } else {
                this.ai.h();
            }
            this.au.b();
            this.ai();
        }
        if (this.l()) {
            this.i().a(rectangle, bl);
        }
    }

    final double a(double d2) {
        return this.au.a(d2);
    }

    void a(double d2, double d3, int n2, double d4, int[] nArray) {
        double d5 = IlvMathUtil.cosDeg(d4);
        double d6 = IlvMathUtil.sinDeg(d4);
        if (this.getTickLayout() == 2) {
            nArray[0] = IlvGraphicUtil.toInt(d2);
            nArray[1] = IlvGraphicUtil.toInt(d3);
            nArray[2] = IlvGraphicUtil.toInt(d2 + (double)n2 * d5);
            nArray[3] = IlvGraphicUtil.toInt(d3 - (double)n2 * d6);
        } else if (this.getTickLayout() == 1) {
            nArray[0] = IlvGraphicUtil.toInt(d2);
            nArray[1] = IlvGraphicUtil.toInt(d3);
            nArray[2] = IlvGraphicUtil.toInt(d2 - (double)n2 * d5);
            nArray[3] = IlvGraphicUtil.toInt(d3 + (double)n2 * d6);
        } else {
            double d7 = (double)n2 * d5;
            double d8 = (double)(-n2) * d6;
            nArray[0] = IlvGraphicUtil.toInt(d2 + d7);
            nArray[1] = IlvGraphicUtil.toInt(d3 + d8);
            nArray[2] = IlvGraphicUtil.toInt(d2 - d7);
            nArray[3] = IlvGraphicUtil.toInt(d3 - d8);
        }
    }

    final Rectangle2D a(int n2) {
        return this.ai.a(n2).getBounds(true);
    }

    final String b(int n2) {
        return this.ai.s()[n2];
    }

    final IlvDoublePoints s() {
        return this.ai.l();
    }

    final IlvDoublePoints t() {
        return this.ai.m();
    }

    final IlvDoublePoints u() {
        return this.ai.n();
    }

    public final IlvDoubleArray getStepValues() {
        this.ai.aa();
        return this.ai.d();
    }

    public final IlvDoubleArray getSubStepValues() {
        this.ai.aa();
        return this.ai.e();
    }

    public final void recalc() {
        this.getChart().updateScales();
    }

    final void v() {
        this.au.b();
        this.m().y();
        if (this.y()) {
            this.e().f();
        }
    }

    final boolean w() {
        return this.au.c() && this.m().z() && (!this.y() || this.e().g());
    }

    final boolean x() {
        if (!this.getChart().bh) {
            this.getChart().updateScales();
            return true;
        }
        this.au.e();
        if (this.m().aa()) {
            if (this.y()) {
                this.e().h();
            }
            return true;
        }
        return false;
    }

    public synchronized void draw(Graphics graphics) {
        if (!this.f()) {
            return;
        }
        this.au.draw(graphics);
    }

    final boolean y() {
        return this.an != null && this.an.getText() != null;
    }

    private final void a(IlvDoublePoint ilvDoublePoint) {
        this.au.computeTitleLocation(ilvDoublePoint);
    }

    Rectangle2D a(IlvDoublePoint ilvDoublePoint, int n2, int n3, int n4, double d2, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(ilvDoublePoint.x - (double)n2 / 2.0, ilvDoublePoint.y - (double)n3 / 2.0, n2, n3);
        } else {
            rectangle2D.setRect(ilvDoublePoint.x - (double)n2 / 2.0, ilvDoublePoint.y - (double)n3 / 2.0, n2, n3);
        }
        if (d2 != 0.0) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(IlvMathUtil.toRadians(d2), ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor());
            rectangle2D = IlvGraphicUtil.transform(rectangle2D, affineTransform);
        }
        return rectangle2D;
    }

    int a(IlvDoublePoints ilvDoublePoints, int n2) {
        this.m().c();
        int n3 = ilvDoublePoints.size();
        if (n3 == 0 || !this.isSkippingLabel() || this.getSkipLabelMode() != 1) {
            return 1;
        }
        double[] dArray = this.m().f().data();
        Rectangle2D rectangle2D = this.a(0);
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
        ilvDoublePoint = this.computeLabelLocation(ilvDoublePoint, this.a(dArray[0]), n2, d2, d3);
        Rectangle2D rectangle2D2 = IlvScale.a(ilvDoublePoint, d2, d3, null);
        IlvGraphicUtil.grow(rectangle2D2, 1.0, 1.0);
        Rectangle2D rectangle2D3 = null;
        Rectangle2D rectangle2D4 = null;
        int n4 = 1;
        int n5 = 1;
        for (int i2 = 1; i2 < n3; i2 += n4) {
            rectangle2D = this.a(i2);
            d2 = rectangle2D.getWidth();
            d3 = rectangle2D.getHeight();
            ilvDoublePoint.setLocation(ilvDoublePoints.getX(i2), ilvDoublePoints.getY(i2));
            ilvDoublePoint = this.computeLabelLocation(ilvDoublePoint, this.a(dArray[i2]), n2, d2, d3);
            rectangle2D3 = IlvScale.a(ilvDoublePoint, d2, d3, rectangle2D3);
            IlvGraphicUtil.grow(rectangle2D3, 1.0, 1.0);
            if (rectangle2D2.intersects(rectangle2D3)) {
                ++n5;
                continue;
            }
            rectangle2D4 = rectangle2D2;
            rectangle2D2 = rectangle2D3;
            rectangle2D3 = rectangle2D4;
            if (n5 > n4) {
                n4 = n5;
            }
            n5 = 1;
        }
        return n4;
    }

    int c(boolean bl) {
        return this.au.a(bl);
    }

    int z() {
        int n2 = this.getLabelOffset();
        if (this.g() == this.h() && this.isMajorTickVisible() && (this.getTickLayout() == 2 || this.getTickLayout() == 3)) {
            n2 += this.getMajorTickSize();
        }
        return n2;
    }

    void a(double d2, IlvDoublePoint ilvDoublePoint) {
        IlvDoublePoints ilvDoublePoints = this.getAxis().isXAxis() ? new IlvDoublePoints(d2, this.getCrossingValue()) : new IlvDoublePoints(this.getCrossingValue(), d2);
        this.a(ilvDoublePoints);
        ilvDoublePoint.x = ilvDoublePoints.getX(0);
        ilvDoublePoint.y = ilvDoublePoints.getY(0);
        ilvDoublePoints.dispose();
    }

    IlvDoublePoints a(double[] dArray, int n2) {
        if (n2 != 0) {
            IlvDoublePoints ilvDoublePoints = this.b(dArray, n2);
            this.a(ilvDoublePoints);
            return ilvDoublePoints;
        }
        return new IlvDoublePoints(0);
    }

    public double toValue(int n2, int n3) {
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(n2, n3);
        this.o().toData(ilvDoublePoints, this.q(), this.getCoordinateSystem());
        double d2 = this.getAxis().isXAxis() ? ilvDoublePoints.getX(0) : ilvDoublePoints.getY(0);
        ilvDoublePoints.dispose();
        return d2;
    }

    public Point toPoint(double d2) {
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint();
        this.a(d2, ilvDoublePoint);
        return new Point(ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Rectangle2D computeBounds(Rectangle2D rectangle2D) {
        this.ai.c();
        this.ai.k();
        if (this.y()) {
            this.an.c();
        }
        this.au.d();
        rectangle2D = this.a(rectangle2D);
        if (this.isLabelVisible()) {
            rectangle2D = this.b(rectangle2D);
        }
        if (!(!this.isMajorTickVisible() && !this.isMinorTickVisible() || this.isLabelVisible() && this.getTickLayout() != 3 && this.getTickLayout() != 1)) {
            rectangle2D = this.a(rectangle2D, this.isMajorTickVisible());
        }
        if (this.y()) {
            Rectangle2D rectangle2D2 = this.an.a((Rectangle2D)null);
            rectangle2D.add(rectangle2D2);
        }
        try {
            this.ak = true;
            this.updateAnnotations();
        }
        finally {
            this.ak = false;
        }
        return rectangle2D;
    }

    Rectangle2D a(Rectangle2D rectangle2D) {
        return this.au.getAxisBounds(rectangle2D);
    }

    Rectangle2D b(Rectangle2D rectangle2D) {
        this.m().c();
        int n2 = this.z();
        IlvDoublePoints ilvDoublePoints = this.u();
        double[] dArray = this.m().f().data();
        int n3 = ilvDoublePoints.size();
        Rectangle2D rectangle2D2 = null;
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint();
        for (int i2 = 0; i2 < n3; ++i2) {
            Rectangle2D rectangle2D3 = this.a(i2);
            double d2 = rectangle2D3.getWidth();
            double d3 = rectangle2D3.getHeight();
            ilvDoublePoint.setLocation(ilvDoublePoints.getX(i2), ilvDoublePoints.getY(i2));
            ilvDoublePoint = this.computeLabelLocation(ilvDoublePoint, this.a(dArray[i2]), n2, d2, d3);
            rectangle2D2 = IlvScale.a(ilvDoublePoint, d2, d3, rectangle2D2);
            rectangle2D = IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
        }
        return rectangle2D;
    }

    Rectangle2D a(Rectangle2D rectangle2D, boolean bl) {
        this.ai.c();
        this.ai.k();
        IlvDoublePoints ilvDoublePoints = bl ? this.ai.l() : this.ai.m();
        int n2 = ilvDoublePoints.size();
        if (n2 == 0) {
            return rectangle2D;
        }
        double[] dArray = bl ? this.ai.d().data() : this.ai.e().data();
        int n3 = this.c(bl);
        int[] nArray = new int[4];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(ilvDoublePoints.getX(i2), ilvDoublePoints.getY(i2), n3, this.a(dArray[i2]), nArray);
            if (this.getTickLayout() == 3) {
                IlvGraphicUtil.addToRect(rectangle2D, (double)nArray[0], (double)nArray[1]);
            }
            IlvGraphicUtil.addToRect(rectangle2D, (double)nArray[2], (double)nArray[3]);
        }
        return rectangle2D;
    }

    private final Rectangle2D e(Rectangle2D rectangle2D) {
        rectangle2D = this.computeBounds(rectangle2D);
        this.ah.setRect(rectangle2D);
        this.r.setFlag(1024, true);
        return rectangle2D;
    }

    final void aa() {
        if (!this.r.getFlag(1024)) {
            throw new ConcurrentModificationException("missing updateBounds() - probably a multithread problem");
        }
    }

    final Rectangle2D c(Rectangle2D rectangle2D) {
        this.aa();
        if (rectangle2D == null) {
            rectangle2D = new Rectangle(this.ah);
        } else {
            rectangle2D.setRect(this.ah);
        }
        return rectangle2D;
    }

    private void ai() {
        this.r.setFlag(1024, false);
    }

    final void ab() {
        if (!this.r.getFlag(1024)) {
            this.e(null);
        }
    }

    public synchronized Rectangle2D getBounds(Rectangle2D rectangle2D) {
        this.recalc();
        return this.getBoundsUsingCache(rectangle2D);
    }

    public Rectangle2D getBoundsUsingCache(Rectangle2D rectangle2D) {
        rectangle2D = this.r.getFlag(1024) ? this.c(rectangle2D) : this.e(rectangle2D);
        rectangle2D = this.d(rectangle2D);
        this.au.a(rectangle2D);
        return rectangle2D;
    }

    final void a(IlvDoublePoints ilvDoublePoints) {
        this.o().toDisplay(ilvDoublePoints, this.q(), this.getCoordinateSystem());
    }

    private IlvDoublePoints b(double[] dArray, int n2) {
        boolean bl = this.getAxis().isXAxis();
        double[] dArray2 = new double[n2];
        if (bl) {
            double d2 = this.getCrossingValue();
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray2[i2] = d2;
            }
            return new IlvDoublePoints(n2, dArray, dArray2);
        }
        double d3 = this.getCrossingValue();
        for (int i3 = 0; i3 < n2; ++i3) {
            dArray2[i3] = d3;
        }
        return new IlvDoublePoints(n2, dArray2, dArray);
    }

    final int ac() {
        return this.au.getScaleLength();
    }

    final int a(int n2, int n3, int n4) {
        return this.au.a(n2, n3, n4);
    }

    public IlvScaleAnnotation[] getAnnotations() {
        if (this.ao == null) {
            return null;
        }
        IlvScaleAnnotation[] ilvScaleAnnotationArray = new IlvScaleAnnotation[this.ao.size()];
        return this.ao.toArray(ilvScaleAnnotationArray);
    }

    public void setAnnotations(IlvScaleAnnotation[] ilvScaleAnnotationArray) {
        if (ilvScaleAnnotationArray == null && this.ao != null) {
            int n2 = this.ao.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b((IlvScaleAnnotation)this.ao.get(0));
            }
            this.ae();
        } else if (ilvScaleAnnotationArray != null) {
            int n3 = ilvScaleAnnotationArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                this.a(ilvScaleAnnotationArray[i3]);
            }
            this.ae();
        }
    }

    List ad() {
        return this.ao;
    }

    public void addAnnotation(IlvScaleAnnotation ilvScaleAnnotation) {
        this.a(ilvScaleAnnotation);
        this.ae();
    }

    private void a(IlvScaleAnnotation ilvScaleAnnotation) {
        if (ilvScaleAnnotation == null) {
            throw new IllegalArgumentException();
        }
        if (ilvScaleAnnotation.getScale() != null) {
            throw new IllegalArgumentException("Annotation already attached to a scale");
        }
        if (this.ao == null) {
            this.ao = new ArrayList();
        }
        this.ao.add(ilvScaleAnnotation);
        ilvScaleAnnotation.a(this);
    }

    public void removeAnnotation(IlvScaleAnnotation ilvScaleAnnotation) {
        this.b(ilvScaleAnnotation);
        this.ae();
    }

    private void b(IlvScaleAnnotation ilvScaleAnnotation) {
        if (ilvScaleAnnotation.getScale() != this) {
            throw new IllegalArgumentException("Annotation not displayed by this scale");
        }
        ilvScaleAnnotation.a((IlvScale)null);
        this.ao.remove(ilvScaleAnnotation);
        if (this.ao.size() == 0) {
            this.ao = null;
        }
    }

    public void updateAnnotations() {
    }

    Rectangle2D d(Rectangle2D rectangle2D) {
        if (this.ao == null) {
            return rectangle2D;
        }
        Rectangle2D rectangle2D2 = null;
        IlvDataInterval ilvDataInterval = this.getAxis().getVisibleRange();
        for (IlvScaleAnnotation ilvScaleAnnotation : this.ao) {
            if (!ilvDataInterval.isInside(ilvScaleAnnotation.getValue())) continue;
            rectangle2D2 = ilvScaleAnnotation.getBounds(rectangle2D2);
            IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
        }
        return rectangle2D;
    }

    void a(IlvDoubleArray ilvDoubleArray, IlvDoubleArray ilvDoubleArray2) {
        block21: {
            ilvDoubleArray.reset();
            ilvDoubleArray2.reset();
            IlvStepsDefinition ilvStepsDefinition = this.getStepsDefinition();
            if (ilvStepsDefinition == null) {
                return;
            }
            ilvStepsDefinition.update();
            IlvAxisTransformer ilvAxisTransformer = this.getAxis().getTransformer();
            boolean bl = ilvAxisTransformer != null && ilvStepsDefinition.d();
            IlvDataInterval ilvDataInterval = bl ? this.getAxis().getTVisibleRange() : this.getAxis().getVisibleRange();
            try {
                double d2 = ilvDataInterval.getMin();
                if (!ilvStepsDefinition.hasNext(d2)) {
                    return;
                }
                double d3 = ilvDataInterval.getMax();
                if (ilvStepsDefinition.hasSubStep()) {
                    int n2 = 1;
                    double d4 = ilvStepsDefinition.b(d2);
                    if ((d2 = ilvStepsDefinition.a(d2)) == d4) {
                        d4 = ilvStepsDefinition.incrementSubStep(d4);
                        ++n2;
                    }
                    while (d4 < d2 && !IlvMathUtil.equals(d4, d2, (double)n2 * 1.0E-15)) {
                        if (bl) {
                            ilvDoubleArray2.add(ilvAxisTransformer.inverse(d4));
                        } else {
                            ilvDoubleArray2.add(d4);
                        }
                        d4 = ilvStepsDefinition.incrementSubStep(d4);
                        ++n2;
                    }
                    while (d2 <= d3) {
                        if (bl) {
                            ilvDoubleArray.add(ilvAxisTransformer.inverse(d2));
                        } else {
                            ilvDoubleArray.add(d2);
                        }
                        d4 = ilvStepsDefinition.b(d2);
                        if (d2 == d4) {
                            d4 = ilvStepsDefinition.incrementSubStep(d4);
                            ++n2;
                        }
                        if (ilvStepsDefinition.hasNext(d2)) {
                            d2 = ilvStepsDefinition.incrementStep(d2);
                            while (d4 < d2 && d4 <= d3 && !IlvMathUtil.equals(d4, d2, (double)n2 * 1.0E-15)) {
                                if (bl) {
                                    ilvDoubleArray2.add(ilvAxisTransformer.inverse(d4));
                                } else {
                                    ilvDoubleArray2.add(d4);
                                }
                                d4 = ilvStepsDefinition.incrementSubStep(d4);
                                ++n2;
                            }
                            continue;
                        }
                        break block21;
                    }
                    break block21;
                }
                d2 = ilvStepsDefinition.a(d2);
                while (d2 <= d3) {
                    if (bl) {
                        ilvDoubleArray.add(ilvAxisTransformer.inverse(d2));
                    } else {
                        ilvDoubleArray.add(d2);
                    }
                    if (ilvStepsDefinition.hasNext(d2)) {
                        d2 = ilvStepsDefinition.incrementStep(d2);
                        continue;
                    }
                    break;
                }
            }
            catch (IlvAxisTransformerException ilvAxisTransformerException) {
                ilvAxisTransformerException.printStackTrace();
                ilvDoubleArray.reset();
                ilvDoubleArray2.reset();
            }
        }
    }

    public Rectangle2D getLabelBounds(int n2, Rectangle2D rectangle2D) {
        if (n2 >= this.getLabelCount()) {
            throw new IndexOutOfBoundsException("Invalid step label index");
        }
        this.m().aa();
        IlvDoublePoints ilvDoublePoints = this.u();
        Rectangle2D rectangle2D2 = this.a(n2);
        double d2 = rectangle2D2.getWidth();
        double d3 = rectangle2D2.getHeight();
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDoublePoints.getX(n2), ilvDoublePoints.getY(n2));
        double d4 = this.m().f().get(n2);
        ilvDoublePoint = this.computeLabelLocation(ilvDoublePoint, this.a(d4), this.z(), d2, d3);
        return IlvScale.a(ilvDoublePoint, d2, d3, rectangle2D);
    }

    public int getLabelCount() {
        return this.u().size();
    }

    public double getLabelValue(int n2) {
        if (n2 >= this.getLabelCount()) {
            throw new IndexOutOfBoundsException("Invalid step label index");
        }
        return this.m().f().get(n2);
    }

    public String computeLabel(double d2) {
        if (this.getLabelFormat() != null) {
            return this.getLabelFormat().formatValue(d2);
        }
        return this.getStepsDefinition() == null ? "" : this.getStepsDefinition().computeLabel(d2);
    }

    public final IlvValueFormat getLabelFormat() {
        return this.ap;
    }

    public void setLabelFormat(IlvValueFormat ilvValueFormat) {
        if (ilvValueFormat != this.ap) {
            this.ap = ilvValueFormat;
            this.m().u();
            this.ae();
        }
    }

    private final boolean aj() {
        IlvAxis.Crossing crossing = this.getCrossing();
        return crossing != IlvAxis.MIN_VALUE && crossing != IlvAxis.MAX_VALUE;
    }

    private void ak() {
        if (this.getAxis().isXAxis()) {
            int n2 = this.getChart().getYAxisCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                IlvScale ilvScale = this.getChart().getYScale(i2);
                if (ilvScale == null || !ilvScale.aj()) continue;
                ilvScale.m().p();
            }
        } else {
            IlvScale ilvScale = this.getChart().getXScale();
            if (ilvScale != null && ilvScale.aj()) {
                ilvScale.m().p();
            }
        }
    }

    private synchronized AxisListener al() {
        if (this.ad == null) {
            this.ad = this.am();
        }
        return this.ad;
    }

    private AxisListener am() {
        return new AxisLST();
    }

    protected IlvDoublePoint computeLabelLocation(IlvDoublePoint ilvDoublePoint, double d2, int n2, double d3, double d4) {
        return IlvGraphicUtil.computeTextLocation(ilvDoublePoint, d2, n2, d3, d4);
    }

    static final Rectangle2D a(IlvDoublePoint ilvDoublePoint, double d2, double d3, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(ilvDoublePoint.x - d2 / 2.0, ilvDoublePoint.y - d3 / 2.0, d2, d3);
        } else {
            rectangle2D.setRect(ilvDoublePoint.x - d2 / 2.0, ilvDoublePoint.y - d3 / 2.0, d2, d3);
        }
        return rectangle2D;
    }

    void ae() {
        IlvChart.Area area;
        this.ai();
        IlvChart.Area area2 = area = this.getChart() != null ? this.getChart().getChartArea() : null;
        if (area != null) {
            area.d();
            if (!this.ak) {
                area.revalidateLayout();
            }
        }
    }

    private void an() {
        this.ag = new Rectangle(0, 0, -1, -1);
        this.ah = new Rectangle();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.an();
    }

    public void drawHighlight(Graphics graphics) {
        this.au.drawSelection(graphics);
    }

    public boolean hit(Point2D point2D) {
        return this.au.contains(point2D);
    }

    public static int getAxisIndex(IlvScale ilvScale) {
        if (ilvScale.ac == null) {
            throw new IllegalArgumentException("scale not connected to a chart.");
        }
        return ilvScale.ac.b();
    }

    class AxisLST
    implements AxisListener,
    Serializable {
        AxisLST() {
        }

        public void axisRangeChanged(AxisRangeEvent axisRangeEvent) {
            if (axisRangeEvent.isVisibleRangeEvent() && axisRangeEvent.isChangedEvent()) {
                IlvScale.this.ak();
                IlvScale.this.m().h();
                if (!axisRangeEvent.isAdjusting()) {
                    IlvScale.this.ae();
                }
            }
        }

        public void axisChanged(AxisChangeEvent axisChangeEvent) {
            if (axisChangeEvent.getType() != 1) {
                if (axisChangeEvent.getType() == 2) {
                    IlvScale.this.m().h();
                }
                IlvScale.this.ak();
            }
            if (!axisChangeEvent.isAdjusting()) {
                IlvScale.this.ae();
            }
        }
    }

    class CircularSteps
    extends Steps {
        CircularSteps() {
        }

        void a() {
            double d2;
            super.a();
            int n2 = this._values.size();
            if (n2 > 1 && (d2 = this._values.get(n2 - 1)) == IlvScale.this.getAxis().getVisibleMax()) {
                this._values.remove(n2 - 1, 1);
            }
        }
    }

    class RadialSteps
    extends Steps {
        RadialSteps() {
        }

        protected String[] computeLabels() {
            if (((IlvPolarProjector)IlvScale.this.p()).isSymmetric()) {
                IlvDoubleArray ilvDoubleArray = IlvScale.this.g() == IlvScale.this.h() ? this._values : this._subValues;
                int n2 = ilvDoubleArray.size();
                String[] stringArray = this._labels.length == n2 ? this._labels : new String[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    double d2 = ilvDoubleArray.get(i2);
                    if (d2 < 0.0) {
                        d2 = -d2;
                    }
                    stringArray[i2] = IlvScale.this.computeLabel(d2);
                }
                return stringArray;
            }
            return super.computeLabels();
        }
    }

    class Steps
    implements Serializable {
        protected transient IlvDoubleArray _values;
        protected transient IlvDoubleArray _subValues;
        private transient boolean a;
        protected transient IlvDoublePoints _points;
        protected transient IlvDoublePoints _subPoints;
        private transient boolean b;
        protected transient String[] _labels;
        private transient boolean c;
        private transient IlvTextRenderer[] d;
        private transient double e;
        private transient double f;
        private transient boolean g;
        private transient Font h;

        Steps() {
            this.ab();
        }

        void a() {
            IlvScale.this.a(this._values, this._subValues);
        }

        final void b() {
            this.a();
            this.a = true;
        }

        final void c() {
            if (!this.a || !IlvScale.this.getChart().bh) {
                throw new ConcurrentModificationException("missing updateAll() for values - probably a multithread problem");
            }
        }

        final IlvDoubleArray d() {
            this.c();
            return this._values;
        }

        final IlvDoubleArray e() {
            this.c();
            return this._subValues;
        }

        final IlvDoubleArray f() {
            this.c();
            return IlvScale.this.g() == IlvScale.this.h() ? this.d() : this.e();
        }

        final boolean g() {
            return this.a && IlvScale.this.getChart().bh;
        }

        void h() {
            this.a = false;
        }

        void i() {
            this._points = IlvScale.this.a((double[])this._values.data().clone(), this._values.size());
            this._subPoints = IlvScale.this.a((double[])this._subValues.data().clone(), this._subValues.size());
        }

        final void j() {
            this.i();
            this.b = true;
        }

        final void k() {
            if (!(this.a && this.b && IlvScale.this.getChart().bh)) {
                throw new ConcurrentModificationException("missing updateAll() for points - probably a multithread problem");
            }
        }

        final IlvDoublePoints l() {
            this.k();
            return this._points;
        }

        final IlvDoublePoints m() {
            this.k();
            return this._subPoints;
        }

        final IlvDoublePoints n() {
            this.k();
            return IlvScale.this.g() == IlvScale.this.h() ? this._points : this._subPoints;
        }

        final boolean o() {
            return this.b && !IlvScale.this.n() && IlvScale.this.getChart().bh;
        }

        void p() {
            this.b = false;
        }

        protected String[] computeLabels() {
            IlvDoubleArray ilvDoubleArray = IlvScale.this.g() == IlvScale.this.h() ? this._values : this._subValues;
            int n2 = ilvDoubleArray.size();
            String[] stringArray = this._labels.length == n2 ? this._labels : new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = IlvScale.this.computeLabel(ilvDoubleArray.get(i2));
            }
            return stringArray;
        }

        final void q() {
            this._labels = this.computeLabels();
            this.c = true;
        }

        final void r() {
            if (!(this.a && this.c && IlvScale.this.getChart().bh)) {
                throw new ConcurrentModificationException("missing updateAll() for labels - probably a multithread problem");
            }
        }

        final String[] s() {
            this.r();
            return this._labels;
        }

        final boolean t() {
            return this.c && IlvScale.this.getChart().bh;
        }

        void u() {
            this.c = false;
        }

        void v() {
            int n2;
            this.r();
            String[] stringArray = this.s();
            int n3 = stringArray.length;
            int n4 = Math.min(this.d.length, n3);
            IlvTextRenderer[] ilvTextRendererArray = n3 == n4 ? this.d : new IlvTextRenderer[n3];
            for (n2 = 0; n2 < n4; ++n2) {
                ilvTextRendererArray[n2] = this.a(stringArray[n2], this.d[n2]);
            }
            while (n2 < n3) {
                ilvTextRendererArray[n2] = this.a(stringArray[n2], null);
                ++n2;
            }
            this.d = ilvTextRendererArray;
            this.a(true);
        }

        IlvTextRenderer a(String string, IlvTextRenderer ilvTextRenderer) {
            if (ilvTextRenderer == null) {
                ilvTextRenderer = new IlvTextRenderer(string);
            } else {
                ilvTextRenderer.setText(string);
            }
            ilvTextRenderer.setAutoWrapping(IlvScale.this.isAutoWrapping());
            ilvTextRenderer.setRotation(IlvScale.this.getLabelRotation());
            ilvTextRenderer.setAlignment(IlvScale.this.getLabelAlignment());
            return ilvTextRenderer;
        }

        boolean a(boolean bl) {
            int n2;
            boolean bl2;
            boolean bl3 = false;
            Font font = IlvScale.this.getLabelFont();
            boolean bl4 = IlvScale.this.d();
            boolean bl5 = bl || this.g != bl4;
            boolean bl6 = bl2 = bl || this.h == null || !this.h.equals(font);
            if (bl2 || bl5) {
                this.g = bl4;
                this.h = font;
                double d2 = 0.0;
                double d3 = 0.0;
                int n3 = this.d.length;
                while (--n3 >= 0) {
                    Rectangle2D rectangle2D;
                    IlvTextRenderer ilvTextRenderer = this.d[n3];
                    if (bl5) {
                        ilvTextRenderer.setAntiAliased(bl4);
                    }
                    if (bl2) {
                        ilvTextRenderer.setFont(font);
                    }
                    if ((rectangle2D = ilvTextRenderer.getBounds(true)).getWidth() > d2) {
                        d2 = rectangle2D.getWidth();
                    }
                    if (!(rectangle2D.getHeight() > d3)) continue;
                    d3 = rectangle2D.getHeight();
                }
                this.e = d2;
                this.f = d3;
                bl3 = true;
            }
            if (IlvScale.this.isAutoWrapping() && (n2 = this.d.length) > 0) {
                if (n2 > 1) {
                    --n2;
                }
                float f2 = IlvScale.this.ac() / n2;
                bl3 = (f2 = Math.max(6.0f, f2 - 4.0f)) != this.d[0].getWrappingWidth();
                this.a(f2);
            }
            return bl3;
        }

        final IlvTextRenderer a(int n2) {
            return this.d[n2];
        }

        final double w() {
            return this.e;
        }

        final double x() {
            return this.f;
        }

        void y() {
            this.h();
        }

        boolean z() {
            return this.g() && this.o() && this.t();
        }

        boolean aa() {
            if (!IlvScale.this.getChart().bh) {
                IlvScale.this.getChart().updateScales();
                return true;
            }
            boolean bl = false;
            if (!this.g()) {
                this.b();
                this.j();
                this.q();
                this.v();
                bl = true;
            } else {
                if (!this.o()) {
                    this.j();
                    bl = true;
                }
                if (!this.t()) {
                    this.q();
                    this.v();
                    bl = true;
                } else {
                    boolean bl2 = bl = this.a(false) || bl;
                }
            }
            if (bl) {
                IlvScale.this.ai();
            }
            return bl;
        }

        void a(double d2) {
            int n2 = this.d.length;
            while (--n2 >= 0) {
                this.d[n2].setRotation(d2);
            }
        }

        void b(int n2) {
            int n3 = this.d.length;
            while (--n3 >= 0) {
                this.d[n3].setAlignment(n2);
            }
        }

        void b(boolean bl) {
            int n2 = this.d.length;
            while (--n2 >= 0) {
                this.d[n2].setAutoWrapping(bl);
            }
        }

        void a(float f2) {
            int n2 = this.d.length;
            while (--n2 >= 0) {
                this.d[n2].setWrappingWidth(f2);
            }
            IlvScale.this.ai();
        }

        private void ab() {
            this._values = new IlvDoubleArray(0);
            this._subValues = new IlvDoubleArray(0);
            this.d = new IlvTextRenderer[0];
            this._labels = new String[0];
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.ab();
        }
    }

    final class Title
    implements Serializable {
        transient IlvDoublePoint a;
        private transient boolean b;
        int c = 50;
        String d;
        IlvLabelRenderer e;

        public Title(String string, double d2) {
            this.d = string;
            this.e = new IlvLabelRenderer(){

                public void stateChanged() {
                    IlvScale.this.ae();
                }
            };
            this.e.setRotation(d2);
            this.i();
        }

        public void setText(String string) {
            if (string != null ? !string.equals(this.d) : string != this.d) {
                this.d = string;
                this.stateChanged();
            }
        }

        public String getText() {
            return this.d;
        }

        public IlvLabelRenderer getLabelRenderer() {
            return this.e;
        }

        public void setPlacement(int n2) {
            if (n2 > 100) {
                n2 = 100;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n2 != this.c) {
                this.c = n2;
                this.stateChanged();
            }
        }

        public int getPlacement() {
            return this.c;
        }

        public Dimension2D getSize2D(boolean bl) {
            return this.e.getSize2D(IlvScale.this.getChart().getChartArea(), this.d, true, bl);
        }

        void a() {
            if (this.d != null) {
                IlvScale.this.a(this.a);
            }
        }

        final void b() {
            this.a();
            this.b = true;
        }

        final void c() {
            if (!this.b || !IlvScale.this.getChart().bh) {
                throw new ConcurrentModificationException("missing updateAll() in title - probably a multithread problem");
            }
        }

        final IlvDoublePoint d() {
            this.c();
            return this.a;
        }

        final void e() {
            this.b = false;
        }

        void f() {
            this.e();
        }

        boolean g() {
            return this.b && IlvScale.this.getChart().bh;
        }

        void h() {
            this.b();
        }

        void a(Graphics graphics) {
            IlvDoublePoint ilvDoublePoint = this.d();
            this.e.paintLabel(IlvScale.this.getChart().getChartArea(), graphics, this.d, ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor());
        }

        Rectangle2D a(Rectangle2D rectangle2D) {
            this.c();
            IlvDoublePoint ilvDoublePoint = this.d();
            return this.e.getBounds(IlvScale.this.getChart().getChartArea(), ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor(), this.d, rectangle2D);
        }

        protected void stateChanged() {
            IlvScale.this.ae();
        }

        private void i() {
            this.a = new IlvDoublePoint();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.i();
        }
    }
}

