/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAffineAxisTransformer;
import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvMultipleTimeUnit;
import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvStepsDefinition;
import ilog.views.chart.IlvTimeUnit;
import ilog.views.chart.util.internal.IlvFlags;
import java.awt.FontMetrics;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

public class IlvTimeStepsDefinition
extends IlvStepsDefinition {
    private static final IlvTimeUnit[] a = new IlvTimeUnit[]{IlvTimeUnit.MILLISECOND, IlvTimeUnit.SECOND, IlvTimeUnit.MINUTE, IlvTimeUnit.HOUR, IlvTimeUnit.DAY, IlvTimeUnit.WEEK, IlvTimeUnit.MONTH, IlvTimeUnit.QUARTER, IlvTimeUnit.YEAR, IlvTimeUnit.DECADE, IlvTimeUnit.CENTURY};
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    private static final int e = 8;
    private static final int f = 1;
    private IlvFlags g = new IlvFlags(1);
    private IlvTimeUnit h = IlvTimeUnit.DAY;
    private IlvTimeUnit i = null;
    private int j = 0;
    private Calendar k = null;
    private Calendar l = null;
    protected IlvTimeUnit[] autoUnits = a;
    private DateFormat m;

    public IlvTimeStepsDefinition() {
        this.b();
        this.j();
    }

    final void a() {
        this.b();
        this.j();
    }

    public void update() {
        this.l();
        this.n();
    }

    final Calendar a(Date date) {
        this.l.setTime(date);
        return this.l;
    }

    final Calendar c(double d2) {
        return this.a(new Date((long)d2));
    }

    void b() {
        this.k = this.getScale() != null && this.getScale().getChart() != null ? Calendar.getInstance(this.getScale().getChart().getLocale()) : Calendar.getInstance();
        this.l = (Calendar)this.k.clone();
    }

    public IlvTimeUnit[] getAutoUnits() {
        IlvTimeUnit[] ilvTimeUnitArray = new IlvTimeUnit[this.autoUnits.length];
        System.arraycopy(this.autoUnits, 0, ilvTimeUnitArray, 0, this.autoUnits.length);
        return ilvTimeUnitArray;
    }

    public void setAutoUnits(IlvTimeUnit[] ilvTimeUnitArray) {
        if (ilvTimeUnitArray == null) {
            this.autoUnits = a;
        } else {
            this.autoUnits = new IlvTimeUnit[ilvTimeUnitArray.length];
            System.arraycopy(ilvTimeUnitArray, 0, this.autoUnits, 0, ilvTimeUnitArray.length);
            Arrays.sort(this.autoUnits, TimeUnitComparator.a());
        }
    }

    public final boolean isAutoUnit() {
        return this.g.getFlag(1);
    }

    public void setAutoUnit(boolean bl) {
        if (this.isAutoUnit() != bl) {
            this.g.setFlag(1, bl);
            if (this.getScale() != null) {
                this.getScale().m().h();
                this.getScale().ae();
            }
        }
    }

    final boolean c() {
        return this.g.getFlag(2);
    }

    void a(boolean bl) {
        this.g.setFlag(2, bl);
    }

    public final IlvTimeUnit getUnit() {
        return this.h;
    }

    public void setUnit(IlvTimeUnit ilvTimeUnit) {
        if (this.h == ilvTimeUnit && !this.isAutoUnit()) {
            return;
        }
        this.setAutoUnit(false);
        this.a(ilvTimeUnit);
        if (this.getScale() != null) {
            this.getScale().m().h();
            this.getScale().ae();
        }
    }

    private void a(IlvTimeUnit ilvTimeUnit) {
        if (this.h == ilvTimeUnit) {
            return;
        }
        this.h = ilvTimeUnit;
        this.j();
    }

    private void l() {
        if (this.getScale() == null) {
            this.a(IlvTimeUnit.DAY);
            return;
        }
        if (this.isAutoUnit()) {
            this.m();
        } else if (this.c()) {
            this.e();
        }
    }

    private void m() {
        this.a(this.computeTimeUnit());
    }

    protected IlvTimeUnit computeTimeUnit() {
        FontMetrics fontMetrics = this.getScale().a(this.getScale().getLabelFont());
        double d2 = this.f().getVisibleMax() - this.f().getVisibleMin();
        double d3 = Double.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        int n3 = this.autoUnits.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            IlvTimeUnit ilvTimeUnit = this.autoUnits[i2];
            double d4 = ilvTimeUnit.getMillis();
            double d5 = d2 / d4;
            if (d5 < 0.1 || d5 > 200.0) continue;
            simpleDateFormat.applyPattern(ilvTimeUnit.getFormatString());
            String string = this.a(simpleDateFormat, ilvTimeUnit, this.f().getVisibleMax());
            int n4 = this.getScale().a(fontMetrics.stringWidth(string), fontMetrics.getHeight(), 6);
            double d6 = Math.abs(d5 - (double)n4) / (double)n4;
            if (!(d6 < d3)) continue;
            n2 = i2;
            d3 = d6;
        }
        if (n2 < n3) {
            return this.autoUnits[n2];
        }
        return IlvTimeUnit.YEAR;
    }

    void e() {
        IlvScale ilvScale = this.getScale().j();
        if (ilvScale != null) {
            IlvTimeStepsDefinition ilvTimeStepsDefinition = (IlvTimeStepsDefinition)ilvScale.getStepsDefinition();
            this.setUnit(this.b(ilvTimeStepsDefinition.getUnit()));
        }
    }

    private IlvTimeUnit b(IlvTimeUnit ilvTimeUnit) {
        for (int i2 = 0; i2 < this.autoUnits.length; ++i2) {
            if (ilvTimeUnit != this.autoUnits[i2]) continue;
            return this.autoUnits[Math.min(i2 + 1, this.autoUnits.length - 1)];
        }
        return IlvTimeUnit.YEAR;
    }

    DateFormat i() {
        return this.m;
    }

    void j() {
        this.m = this.getScale() != null && this.getScale().getChart() != null ? new SimpleDateFormat(this.h.getFormatString(), this.getScale().getChart().getLocale()) : new SimpleDateFormat(this.h.getFormatString());
    }

    public double previousStep(double d2) {
        return this.h.previousUnitTime(this.c(d2)).getTimeInMillis();
    }

    public double incrementStep(double d2) {
        return this.h.incrementTime(this.c(d2)).getTimeInMillis();
    }

    public String computeLabel(double d2) {
        return this.a(this.i(), this.h, d2);
    }

    private final String a(DateFormat dateFormat, IlvTimeUnit ilvTimeUnit, double d2) {
        return ilvTimeUnit.format(dateFormat, this.c(d2));
    }

    public final boolean isAutoSubStepUnit() {
        return this.g.getFlag(4);
    }

    public void setAutoSubStepUnit(boolean bl) {
        if (this.isAutoSubStepUnit() != bl) {
            this.b(bl);
            if (this.getScale() != null) {
                this.getScale().m().h();
                this.getScale().ae();
            }
        }
    }

    private void b(boolean bl) {
        this.g.setFlag(4, bl);
        this.g.setFlag(8, false);
    }

    public boolean hasSubStep() {
        return this.i != null;
    }

    public final IlvTimeUnit getSubStepUnit() {
        IlvScale ilvScale = this.getScale();
        if (this.isAutoSubStepUnit() && ilvScale != null && !ilvScale.m().g()) {
            ilvScale.m().aa();
        }
        return this.i;
    }

    public void setSubStepUnit(IlvTimeUnit ilvTimeUnit) {
        if (ilvTimeUnit == this.i && !this.g.getFlag(8) && !this.isAutoSubStepUnit()) {
            return;
        }
        this.c(ilvTimeUnit);
        this.b(false);
        if (this.getScale() != null) {
            this.getScale().m().h();
            this.getScale().ae();
        }
    }

    private void c(IlvTimeUnit ilvTimeUnit) {
        this.i = ilvTimeUnit;
    }

    public int getSubStepCount() {
        return this.g.getFlag(8) ? this.j : (this.i != null ? (int)(this.h.getMillis() / this.i.getMillis() + 0.5) - 1 : 0);
    }

    public void setSubStepCount(int n2) {
        if (n2 == this.j && this.g.getFlag(8) && !this.isAutoSubStepUnit()) {
            return;
        }
        this.j = n2;
        this.b(false);
        this.g.setFlag(8, true);
        if (this.getScale() != null) {
            this.getScale().m().h();
            this.getScale().ae();
        }
    }

    private void n() {
        if (this.getScale() == null) {
            this.c(null);
            return;
        }
        if (this.isAutoSubStepUnit()) {
            this.i = this.o();
        } else if (this.g.getFlag(8)) {
            this.i = this.a(this.j + 1);
        }
    }

    private IlvTimeUnit o() {
        int n2;
        double d2 = this.k().getLength() / this.h.getMillis();
        int n3 = this.getScale().ac();
        int n4 = n2 = d2 > 0.0 ? (int)((double)(n3 / 4) / d2) : n3 / 4;
        if (n2 >= 2) {
            int[] nArray = this.d(this.h);
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                if (nArray[i2] > n2) continue;
                return this.a(nArray[i2]);
            }
        }
        return null;
    }

    private int[] d(IlvTimeUnit ilvTimeUnit) {
        if (ilvTimeUnit == IlvTimeUnit.MILLISECOND) {
            return new int[0];
        }
        if (ilvTimeUnit == IlvTimeUnit.SECOND) {
            return new int[]{2, 4, 10};
        }
        if (ilvTimeUnit == IlvTimeUnit.MINUTE || ilvTimeUnit == IlvTimeUnit.HOUR) {
            return new int[]{2, 4, 6, 10, 20, 30, 60};
        }
        if (ilvTimeUnit == IlvTimeUnit.DAY) {
            return new int[]{2, 4, 6, 8, 12, 24};
        }
        if (ilvTimeUnit == IlvTimeUnit.WEEK) {
            return new int[]{7};
        }
        if (ilvTimeUnit == IlvTimeUnit.MONTH) {
            return new int[]{2, 4};
        }
        if (ilvTimeUnit == IlvTimeUnit.QUARTER) {
            return new int[]{3};
        }
        if (ilvTimeUnit == IlvTimeUnit.YEAR) {
            return new int[]{2, 4, 12};
        }
        if (ilvTimeUnit == IlvTimeUnit.DECADE) {
            return new int[]{2, 10};
        }
        if (ilvTimeUnit == IlvTimeUnit.CENTURY) {
            return new int[]{2, 4, 10};
        }
        if (ilvTimeUnit instanceof IlvMultipleTimeUnit) {
            int n2 = ((IlvMultipleTimeUnit)ilvTimeUnit).a();
            switch (n2) {
                case 4: {
                    return new int[]{2, 4};
                }
                case 6: {
                    return new int[]{2, 3};
                }
                case 8: {
                    return new int[]{2, 4, 8};
                }
                case 10: {
                    return new int[]{2, 5, 10};
                }
                case 12: {
                    return new int[]{2, 3, 4, 6, 12};
                }
                case 15: {
                    return new int[]{3, 5, 15};
                }
                case 20: {
                    return new int[]{2, 4, 5, 10, 20};
                }
                case 24: {
                    return new int[]{2, 3, 4, 6, 8, 12, 24};
                }
                case 30: {
                    return new int[]{2, 3, 5, 6, 10, 15, 30};
                }
            }
            return new int[]{n2};
        }
        return new int[0];
    }

    private IlvTimeUnit a(int n2) {
        int n3;
        for (n3 = this.autoUnits.length - 1; n3 >= 0 && this.autoUnits[n3] != this.h; --n3) {
        }
        while (n3 >= 0) {
            long l2 = (long)(this.h.getMillis() / this.autoUnits[n3].getMillis());
            if (l2 % (long)n2 == 0L && l2 / (long)n2 <= Integer.MAX_VALUE) {
                return new IlvMultipleTimeUnit(this.autoUnits[n3], (int)(l2 / (long)n2), null, this.h);
            }
            --n3;
        }
        for (n3 = 0; n3 < this.autoUnits.length; ++n3) {
            double d2 = this.h.getMillis() / this.autoUnits[n3].getMillis() / (double)n2;
            if (!(d2 <= 2.147483647E9)) continue;
            return new IlvMultipleTimeUnit(this.autoUnits[n3], (int)(d2 + 0.5), null, this.h);
        }
        for (n3 = 0; n3 < a.length; ++n3) {
            double d3 = this.h.getMillis() / a[n3].getMillis() / (double)n2;
            if (!(d3 <= 2.147483647E9)) continue;
            return new IlvMultipleTimeUnit(a[n3], (int)(d3 + 0.5), null, this.h);
        }
        return null;
    }

    boolean d() {
        IlvAxisTransformer ilvAxisTransformer = this.g();
        return ilvAxisTransformer != null && ilvAxisTransformer instanceof IlvAffineAxisTransformer;
    }

    final IlvDataInterval k() {
        return this.d() ? this.f().getTVisibleRange() : this.f().getVisibleRange();
    }

    public double previousSubStep(double d2) {
        return this.i.previousUnitTime(this.c(d2)).getTimeInMillis();
    }

    public double incrementSubStep(double d2) {
        return d2 + this.i.getMillis();
    }

    private static class TimeUnitComparator
    implements Comparator {
        static TimeUnitComparator a = null;

        private TimeUnitComparator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static TimeUnitComparator a() {
            if (a != null) return a;
            Class<TimeUnitComparator> clazz = TimeUnitComparator.class;
            synchronized (TimeUnitComparator.class) {
                if (a != null) return a;
                a = new TimeUnitComparator();
                // ** MonitorExit[var0] (shouldn't be in output)
                return a;
            }
        }

        public int compare(Object object, Object object2) {
            double d2;
            double d3 = ((IlvTimeUnit)object).getMillis();
            return d3 < (d2 = ((IlvTimeUnit)object2).getMillis()) ? -1 : 1;
        }
    }
}

