/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.data.lod;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.data.lod.DataTileEvent;
import ilog.views.chart.data.lod.DataTileListener;
import ilog.views.chart.data.lod.IlvDataTile;
import ilog.views.chart.data.lod.IlvLODDataSet;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import ilog.views.chart.graphic.IlvDataIndicator;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IlvLODHandler {
    private static final String a = "__IlvLODHandler";
    private ArrayList<IlvLODDataSet> b = new ArrayList();
    private Map<IlvDataTile, IlvDataIndicator> c = new HashMap<IlvDataTile, IlvDataIndicator>();
    private DataTileListener d;
    private AxisListener e;
    private IlvChart f;

    IlvLODHandler(IlvChart ilvChart) {
        this.f = ilvChart;
    }

    synchronized void a(final DataTileEvent dataTileEvent) {
        if (IlvSwingUtil.isDispatchThread()) {
            this.b(dataTileEvent);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    IlvLODHandler.this.b(dataTileEvent);
                }
            });
        }
    }

    private synchronized void b(DataTileEvent dataTileEvent) {
        IlvDataTile ilvDataTile = dataTileEvent.getTile();
        ilvDataTile.getController().b(ilvDataTile);
        IlvLODDataSet ilvLODDataSet = ilvDataTile.getController().getDataSet();
        if (ilvLODDataSet.isShowingLoading()) {
            switch (dataTileEvent.getType()) {
                case 0: {
                    IlvDataIndicator ilvDataIndicator = new IlvDataIndicator(-1, ilvDataTile.getRange(), ilvLODDataSet.getLoadingText());
                    ilvDataIndicator.setStyle(ilvLODDataSet.getLoadingStyle());
                    this.c.put(ilvDataTile, ilvDataIndicator);
                    this.f.addDecoration(ilvDataIndicator);
                    break;
                }
                case 1: 
                case 4: {
                    IlvDataIndicator ilvDataIndicator = this.c.remove(ilvDataTile);
                    if (ilvDataIndicator != null) {
                        this.f.removeDecoration(ilvDataIndicator);
                        break;
                    }
                    this.a(ilvDataTile);
                    break;
                }
            }
        } else if (dataTileEvent.getType() == 4) {
            if (this.c.size() != 0) {
                Iterator<IlvDataIndicator> iterator = this.c.values().iterator();
                while (iterator.hasNext()) {
                    this.f.removeDecoration(iterator.next());
                }
                this.c.clear();
            }
            this.a(ilvDataTile);
        }
    }

    private void a(IlvDataTile ilvDataTile) {
        IlvDataWindow ilvDataWindow = new IlvDataWindow(ilvDataTile.getRange(), this.f.getYAxis(0).getVisibleRange());
        this.f.getChartArea().repaint(ilvDataWindow, 0);
    }

    private void a(IlvLODDataSet ilvLODDataSet) {
        this.b.add(ilvLODDataSet);
        ilvLODDataSet.getController().addDataTileListener(this.a());
        ilvLODDataSet.axisRangeChanged(this.f.getXAxis());
    }

    private boolean b(IlvLODDataSet ilvLODDataSet) {
        if (this.b.remove(ilvLODDataSet)) {
            ilvLODDataSet.getController().unlockTiles(this.f.getXAxis());
            ilvLODDataSet.getController().removeDataTileListener(this.a());
            if (this.b.size() == 0) {
                return true;
            }
        }
        return false;
    }

    private DataTileListener a() {
        if (this.d == null) {
            this.d = new DataTileListener(){

                public synchronized void dataTileChanged(DataTileEvent dataTileEvent) {
                    if (dataTileEvent.getType() == 0 || dataTileEvent.getType() == 4 || dataTileEvent.getType() == 1) {
                        IlvLODHandler.this.a(dataTileEvent);
                    }
                }
            };
        }
        return this.d;
    }

    private AxisListener b() {
        if (this.e == null) {
            this.e = new AxisListener(){

                public void axisRangeChanged(AxisRangeEvent axisRangeEvent) {
                    if (axisRangeEvent.isAboutToChangeEvent() || !axisRangeEvent.isVisibleRangeEvent()) {
                        return;
                    }
                    int n2 = IlvLODHandler.this.b.size();
                    IlvAxis ilvAxis = axisRangeEvent.getAxis();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        boolean bl = false;
                        IlvLODDataSet ilvLODDataSet = (IlvLODDataSet)IlvLODHandler.this.b.get(i2);
                        Iterator iterator = IlvLODHandler.this.f.getRendererIterator();
                        while (iterator.hasNext()) {
                            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)iterator.next();
                            if (!ilvChartRenderer.isViewable() || !ilvChartRenderer.isDisplayingDataSet(ilvLODDataSet)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                        ilvLODDataSet.axisRangeChanged(ilvAxis);
                    }
                }

                public void axisChanged(AxisChangeEvent axisChangeEvent) {
                }
            };
        }
        return this.e;
    }

    public static void connect(IlvChart ilvChart, IlvLODDataSet ilvLODDataSet) {
        IlvLODHandler ilvLODHandler = IlvLODHandler.a(ilvChart);
        if (ilvLODHandler == null) {
            ilvLODHandler = new IlvLODHandler(ilvChart);
            ilvChart.getXAxis().addAxisListener(ilvLODHandler.b());
            ilvChart.putClientProperty(a, ilvLODHandler);
        }
        ilvLODHandler.a(ilvLODDataSet);
    }

    public static void disconnect(IlvChart ilvChart, IlvLODDataSet ilvLODDataSet) {
        IlvLODHandler ilvLODHandler = IlvLODHandler.a(ilvChart);
        if (ilvLODHandler == null) {
            return;
        }
        if (ilvLODHandler.b(ilvLODDataSet)) {
            ilvChart.putClientProperty(a, null);
        }
    }

    static IlvLODHandler a(IlvChart ilvChart) {
        IlvLODHandler ilvLODHandler = (IlvLODHandler)ilvChart.getClientProperty(a);
        return ilvLODHandler;
    }
}

