/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.data.xml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

final class IlvValueConvert {
    IlvValueConvert() {
    }

    static final class IlvDateParser
    implements IlvValueParser {
        private SimpleDateFormat a;

        public IlvDateParser(String string, Locale locale) {
            this.a = new SimpleDateFormat(string, locale);
        }

        public double toValue(String string) throws Exception {
            try {
                return this.a.parse(string).getTime();
            }
            catch (ParseException parseException) {
                ParseException parseException2 = new ParseException("not a valid date in date format \"" + this.a.toPattern() + "\" syntax: \"" + string + "\": " + parseException.getMessage(), parseException.getErrorOffset());
                parseException2.initCause(parseException);
                throw parseException2;
            }
        }

        public String toString(double d2) {
            return this.a.format(new Date((long)d2));
        }
    }

    static final class IlvDateParserFactory
    implements IlvValueParserFactory {
        private String a;
        private transient Locale b;
        private transient IlvDateParser c;

        public IlvDateParserFactory(String string) {
            this.a = string;
        }

        public IlvValueParser getValueParser(Locale locale) {
            if (this.b == null || !this.b.equals(locale)) {
                this.c = new IlvDateParser(this.a, locale);
            }
            return this.c;
        }
    }

    static final class IlvNumberParser
    implements IlvValueParser {
        IlvNumberParser() {
        }

        public double toValue(String string) throws Exception {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                NumberFormatException numberFormatException2 = new NumberFormatException("not a valid number syntax: \"" + string + "\": " + numberFormatException.getMessage());
                numberFormatException2.initCause(numberFormatException);
                throw numberFormatException2;
            }
        }

        public String toString(double d2) {
            return Double.toString(d2);
        }
    }

    static final class IlvNumberParserFactory
    implements IlvValueParserFactory {
        private IlvNumberParser a = new IlvNumberParser();

        public IlvValueParser getValueParser(Locale locale) {
            return this.a;
        }
    }

    static interface IlvValueParser {
        public String toString(double var1);

        public double toValue(String var1) throws Exception;
    }

    static interface IlvValueParserFactory {
        public IlvValueParser getValueParser(Locale var1);
    }
}

