/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.datax;

import ilog.views.chart.datax.IlvDataColumnInfo;
import ilog.views.chart.datax.IlvModelWithColumns;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IlvColumnUtilities {
    public static int getColumnIndex(IlvModelWithColumns ilvModelWithColumns, IlvDataColumnInfo ilvDataColumnInfo) {
        int n2 = ilvModelWithColumns.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (ilvModelWithColumns.getColumn(i2) != ilvDataColumnInfo) continue;
            return i2;
        }
        return -1;
    }

    public static int getColumnIndexByName(IlvModelWithColumns ilvModelWithColumns, String string) {
        int n2 = ilvModelWithColumns.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equals(ilvModelWithColumns.getColumn(i2).getName())) continue;
            return i2;
        }
        return -1;
    }

    public static IlvDataColumnInfo getColumnByName(IlvModelWithColumns ilvModelWithColumns, String string) {
        int n2 = ilvModelWithColumns.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equals(ilvModelWithColumns.getColumn(i2).getName())) continue;
            return ilvModelWithColumns.getColumn(i2);
        }
        return null;
    }

    public static boolean haveSameColumns(IlvModelWithColumns ilvModelWithColumns, IlvModelWithColumns ilvModelWithColumns2) {
        int n2;
        int n3 = ilvModelWithColumns.getColumnCount();
        if (n3 != (n2 = ilvModelWithColumns2.getColumnCount())) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (ilvModelWithColumns.getColumn(i2) == ilvModelWithColumns2.getColumn(i2)) continue;
            return false;
        }
        return true;
    }

    public static IlvDataColumnInfo[] getColumnsArray(IlvModelWithColumns ilvModelWithColumns) {
        int n2 = ilvModelWithColumns.getColumnCount();
        IlvDataColumnInfo[] ilvDataColumnInfoArray = new IlvDataColumnInfo[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ilvDataColumnInfoArray[i2] = ilvModelWithColumns.getColumn(i2);
        }
        return ilvDataColumnInfoArray;
    }

    public static List getColumnsList(IlvModelWithColumns ilvModelWithColumns) {
        int n2 = ilvModelWithColumns.getColumnCount();
        ArrayList<IlvDataColumnInfo> arrayList = new ArrayList<IlvDataColumnInfo>();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(ilvModelWithColumns.getColumn(i2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static String constructColumnName(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 < 26) {
            return new String(new char[]{(char)(65 + n2)});
        }
        return IlvColumnUtilities.constructColumnName(n2 / 26) + new String(new char[]{(char)(65 + (n2 -= 26) % 26)});
    }

    private IlvColumnUtilities() {
    }
}

