/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.graphic;

import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvLabelRenderer;
import ilog.views.chart.graphic.IlvDataAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class IlvDataLabelAnnotation
implements IlvDataAnnotation,
Serializable {
    IlvLabelRenderer a;
    private String b;

    public IlvDataLabelAnnotation() {
        this.a = new IlvLabelRenderer(Color.white, Color.black);
    }

    public IlvDataLabelAnnotation(IlvLabelRenderer ilvLabelRenderer) {
        this.a = ilvLabelRenderer;
    }

    public String getText() {
        return this.b;
    }

    public void setText(String string) {
        this.b = string;
    }

    public final IlvLabelRenderer getLabelRenderer() {
        return this.a;
    }

    public void setLabelRenderer(IlvLabelRenderer ilvLabelRenderer) {
        this.a = ilvLabelRenderer;
    }

    public void draw(Graphics graphics, IlvDisplayPoint ilvDisplayPoint) {
        String string = this.computeText(ilvDisplayPoint);
        if (string == null) {
            return;
        }
        Point point = this.computeLabelLocation(string, ilvDisplayPoint);
        this.getLabelRenderer().paintLabel(ilvDisplayPoint.getRenderer().getChart().getChartArea(), graphics, string, point.x, point.y);
    }

    public Rectangle2D getBounds(IlvDisplayPoint ilvDisplayPoint, Rectangle2D rectangle2D) {
        String string = this.computeText(ilvDisplayPoint);
        if (string == null) {
            if (rectangle2D == null) {
                rectangle2D = new Rectangle2D.Double();
            } else {
                rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
            }
        } else {
            Point point = this.computeLabelLocation(string, ilvDisplayPoint);
            Dimension2D dimension2D = this.getLabelRenderer().getSize2D(ilvDisplayPoint.getRenderer().getChart().getChartArea(), string, true, true);
            if (rectangle2D == null) {
                rectangle2D = new Rectangle2D.Double((double)point.x - dimension2D.getWidth() / 2.0, (double)point.y - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            } else {
                rectangle2D.setRect((double)point.x - dimension2D.getWidth() / 2.0, (double)point.y - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            }
        }
        return rectangle2D;
    }

    protected String computeText(IlvDisplayPoint ilvDisplayPoint) {
        return this.b != null ? this.b : ilvDisplayPoint.getRenderer().computeDataLabel(ilvDisplayPoint);
    }

    protected Point computeLabelLocation(String string, IlvDisplayPoint ilvDisplayPoint) {
        Dimension dimension = this.getLabelRenderer().getSize(ilvDisplayPoint.getRenderer().getChart().getChartArea(), string, true, true);
        return ilvDisplayPoint.getRenderer().computeDataLabelLocation(ilvDisplayPoint, dimension);
    }
}

