/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.datax.tree.list.IlvTreeListModel;
import ilog.views.chart.renderer.IlvContinuousColorDistribution;
import ilog.views.chart.renderer.IlvMinMaxAvgNormalizedValueColorScheme;
import ilog.views.chart.renderer.IlvMinMaxNormalizedValueColorScheme;
import ilog.views.chart.renderer.IlvNormalizedValueColorScheme;
import ilog.views.chart.renderer.IlvSimpleValueColorScheme;
import ilog.views.chart.renderer.IlvValueNormalizer;
import java.awt.Color;
import java.io.Serializable;

public abstract class IlvColorScheme
implements Serializable {
    protected IlvColorScheme() {
    }

    public static IlvContinuousColorDistribution createContinuousColorDistribution(final IlvContinuousColorDistribution ilvContinuousColorDistribution, final IlvValueNormalizer ilvValueNormalizer) {
        return new IlvContinuousColorDistribution(){

            public double normalize(double d2) {
                return ilvValueNormalizer.normalize(d2);
            }

            public double normalizeInverse(double d2) {
                return ilvValueNormalizer.normalizeInverse(d2);
            }

            public Color getFillColor(double d2) {
                return ilvContinuousColorDistribution.getFillColor(d2);
            }
        };
    }

    public static IlvContinuousColorDistribution createContinuousColorDistribution(final IlvSimpleValueColorScheme ilvSimpleValueColorScheme, final IlvValueNormalizer ilvValueNormalizer) {
        return new IlvContinuousColorDistribution(){

            public double normalize(double d2) {
                return ilvValueNormalizer.normalize(d2);
            }

            public double normalizeInverse(double d2) {
                return ilvValueNormalizer.normalizeInverse(d2);
            }

            public Color getFillColor(double d2) {
                return ilvSimpleValueColorScheme.getFillColor(d2);
            }
        };
    }

    public static IlvColorScheme createAdjustedColorScheme(IlvSimpleValueColorScheme ilvSimpleValueColorScheme) {
        return new AvgAdjustedColorScheme(ilvSimpleValueColorScheme);
    }

    public static IlvColorScheme createAdjustedColorScheme(IlvSimpleValueColorScheme ilvSimpleValueColorScheme, double d2) {
        return new ParamAdjustedColorScheme(ilvSimpleValueColorScheme, d2);
    }

    private static class AvgAdjustedColorScheme
    extends IlvMinMaxAvgNormalizedValueColorScheme {
        private IlvSimpleValueColorScheme a;

        AvgAdjustedColorScheme(IlvSimpleValueColorScheme ilvSimpleValueColorScheme) {
            this.a = ilvSimpleValueColorScheme;
        }

        public IlvContinuousColorDistribution createContinuousDistribution(IlvTreeListModel ilvTreeListModel, IlvNormalizedValueColorScheme.Evaluator evaluator, IlvValueNormalizer ilvValueNormalizer, double d2, double d3, double d4) {
            IlvValueNormalizer ilvValueNormalizer2 = IlvMinMaxNormalizedValueColorScheme.createAdjustedNormalizer(ilvValueNormalizer, d2, d3, d4);
            return IlvColorScheme.createContinuousColorDistribution(this.a, ilvValueNormalizer2);
        }
    }

    private static class ParamAdjustedColorScheme
    extends IlvMinMaxNormalizedValueColorScheme {
        private IlvSimpleValueColorScheme a;
        private double b;

        ParamAdjustedColorScheme(IlvSimpleValueColorScheme ilvSimpleValueColorScheme, double d2) {
            this.a = ilvSimpleValueColorScheme;
            this.b = d2;
        }

        public IlvContinuousColorDistribution createContinuousDistribution(IlvTreeListModel ilvTreeListModel, IlvNormalizedValueColorScheme.Evaluator evaluator, IlvValueNormalizer ilvValueNormalizer, double d2, double d3) {
            double d4;
            double d5 = d4 = ilvValueNormalizer != null ? ilvValueNormalizer.normalize(this.b) : this.b;
            if (d4 < d2) {
                d2 = d4;
            } else if (d4 > d3) {
                d3 = d4;
            }
            IlvValueNormalizer ilvValueNormalizer2 = IlvMinMaxNormalizedValueColorScheme.createAdjustedNormalizer(ilvValueNormalizer, d2, d3, d4);
            return IlvColorScheme.createContinuousColorDistribution(this.a, ilvValueNormalizer2);
        }
    }
}

