/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvColor;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvRendererLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.data.IlvDataSetProperty;
import ilog.views.chart.data.IlvDataSource;
import ilog.views.chart.event.DataSetContentsEvent;
import ilog.views.chart.event.DataSetListener;
import ilog.views.chart.event.DataSetPropertyEvent;
import ilog.views.chart.graphic.IlvDataAnnotation;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.internal.IlvDataSetRendererProperty;
import ilog.views.chart.renderer.internal.IlvDefaultedRenderingModifierArray;
import ilog.views.chart.renderer.internal.IlvVirtualDataSet;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.styling.IlvDataPointStyle;
import ilog.views.chart.styling.IlvDataSetStyle;
import ilog.views.chart.styling.IlvStylingSupport;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvIntInterval;
import ilog.views.chart.util.internal.IlvIntIntervalSet;
import ilog.views.chart.util.internal.IlvMathUtil;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.util.collections.internal.IlvIntToObjectHashMap;
import ilog.views.util.collections.internal.IlvIntToObjectMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IlvSingleChartRenderer
extends IlvChartRenderer {
    private IlvStyle a;
    private Map<IlvDataSet, IlvDefaultedRenderingModifierArray> b;
    private MyChartListener c;
    private transient IlvIntToObjectMap<IlvChart3DObject> d;
    private transient Stroke e;
    private transient boolean f;
    MyDataSetListener g;

    protected IlvSingleChartRenderer() {
        this(null);
    }

    protected IlvSingleChartRenderer(IlvStyle ilvStyle) {
        this.setStyle(ilvStyle);
        this.c = new MyChartListener();
    }

    public boolean isFilled() {
        return true;
    }

    boolean f() {
        return true;
    }

    public void setStyle(IlvStyle ilvStyle) {
        this.a(ilvStyle);
    }

    private void a(IlvStyle ilvStyle) {
        if (ilvStyle == null && this.getChart() != null) {
            ilvStyle = this.makeDefaultStyle();
            this.f = true;
            this.a = ilvStyle;
            this.triggerChange(4);
        } else {
            this.f = false;
            if (ilvStyle != this.a) {
                this.a = ilvStyle;
                this.triggerChange(4);
            }
        }
    }

    public IlvStyle getStyle() {
        return this.a;
    }

    @Override
    public void setStyles(IlvStyle[] ilvStyleArray) {
        this.setStyle(ilvStyleArray != null ? ilvStyleArray[0] : null);
    }

    @Override
    public IlvStyle[] getStyles() {
        IlvStyle[] ilvStyleArray;
        if (this.a == null) {
            ilvStyleArray = new IlvStyle[]{};
        } else {
            IlvStyle[] ilvStyleArray2 = new IlvStyle[1];
            ilvStyleArray = ilvStyleArray2;
            ilvStyleArray2[0] = this.a;
        }
        return ilvStyleArray;
    }

    @Override
    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
        super.chartConnected(ilvChart, ilvChart2);
        if (ilvChart != null) {
            ilvChart.removePropertyChangeListener(this.c);
        }
        if (ilvChart2 != null) {
            ilvChart2.addPropertyChangeListener(this.c);
            if (this.a == null) {
                this.a((IlvStyle)null);
            }
        }
    }

    static boolean a(IlvChartRenderer ilvChartRenderer, IlvDataSet ilvDataSet, IlvVirtualDataSet ilvVirtualDataSet) {
        if (ilvChartRenderer instanceof IlvSingleChartRenderer) {
            return ((IlvSingleChartRenderer)ilvChartRenderer).a(ilvDataSet, ilvVirtualDataSet);
        }
        return false;
    }

    IlvDataSet d(int n2) {
        return this.a(this.getDataSource().getDataSet(n2));
    }

    IlvDataSet a(IlvDataSet ilvDataSet) {
        if (!this.isDisplayingDataSet(ilvDataSet)) {
            return null;
        }
        IlvVirtualDataSet ilvVirtualDataSet = IlvDataSetRendererProperty.getVirtualDataSet(this, ilvDataSet);
        return ilvVirtualDataSet == null ? ilvDataSet : ilvVirtualDataSet;
    }

    IlvDataSet g() {
        return this.a(this.h());
    }

    final IlvDataSet h() {
        return this.getDataSource().getDataSet(0);
    }

    int c() {
        return 0;
    }

    int d() {
        return this.c();
    }

    Points a(IlvDataPoints ilvDataPoints) {
        return new Points(ilvDataPoints, true);
    }

    void a(Points points) {
        points.b();
    }

    @Override
    public void toDisplay(IlvDoublePoints ilvDoublePoints) {
        IlvChart ilvChart = this.getChart();
        if (this.k()) {
            double[] dArray;
            double d2 = this.getXShift();
            if (d2 != 0.0) {
                for (int i2 = 0; i2 < ilvDoublePoints.size(); ++i2) {
                    ilvDoublePoints.setX(i2, ilvDoublePoints.getX(i2) + d2);
                }
            }
            double d3 = (dArray = this.getDepths()) == null ? ilvChart.get3DView().getFrontDepth() : (dArray[0] + dArray[1]) / 2.0;
            ilvChart.get3DView().toDisplay(ilvDoublePoints, this.getYAxisIdx(), d3);
        } else {
            super.toDisplay(ilvDoublePoints);
        }
    }

    void a(IlvDoublePoints ilvDoublePoints) {
        IlvChart ilvChart = this.getChart();
        if (ilvChart != null) {
            double d2 = this.getXShift();
            if (d2 != 0.0) {
                for (int i2 = 0; i2 < ilvDoublePoints.size(); ++i2) {
                    ilvDoublePoints.setX(i2, ilvDoublePoints.getX(i2) + d2);
                }
            }
            ilvChart.getProjector2D().toDisplay(ilvDoublePoints, this.getPlotRect(), this.getCoordinateSystem());
        }
    }

    final IlvAxis i() {
        return this.getCoordinateSystem().getYAxis();
    }

    final IlvAxis j() {
        return this.getCoordinateSystem().getXAxis();
    }

    @Override
    protected void set3D(boolean bl) {
        super.set3D(bl);
        if (!bl && this.d != null) {
            this.d.clear();
        }
    }

    public String getZAnnotationText() {
        return null;
    }

    final boolean k() {
        return this.getChart() != null && this.getChart().is3D() && this.has3DSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IlvIntToObjectMap<IlvChart3DObject> l() {
        if (this.d == null) {
            IlvSingleChartRenderer ilvSingleChartRenderer = this;
            synchronized (ilvSingleChartRenderer) {
                if (this.d == null) {
                    this.d = new IlvIntToObjectHashMap<IlvChart3DObject>();
                }
            }
        }
        return this.d;
    }

    void a(IlvIntToObjectMap<IlvChart3DObject> ilvIntToObjectMap) {
        this.d = ilvIntToObjectMap;
    }

    final IlvChart3DObject e(int n2) {
        return this.d != null ? this.d.get(n2) : null;
    }

    Rectangle2D b(Points points) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D rectangle2D = null;
        int n2 = points.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChart3DObject ilvChart3DObject = this.e(points.getDataIndex(i2));
            if (ilvChart3DObject == null) continue;
            rectangle2D = ilvChart3DObject.getBounds2D(rectangle2D);
            IlvGraphicUtil.addToRect(double_, rectangle2D);
        }
        return double_;
    }

    void a(Graphics graphics, Points points) {
        this.a(points, true);
    }

    void a(Points points, boolean bl) {
    }

    IlvDataPoints a(IlvDataSet ilvDataSet, int n2, int n3, int n4) {
        if (n4 > 0) {
            if ((n2 -= n4) < 0) {
                n2 = 0;
            }
            if ((n3 += n4) > ilvDataSet.getDataCount() - 1) {
                n3 = ilvDataSet.getDataCount() - 1;
            }
        }
        return ilvDataSet.getDataBetween(n2, n3);
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.k()) {
            this.a(graphics, this.a((Rectangle)null), true);
        } else {
            Shape shape = graphics.getClip();
            Rectangle rectangle = this.getClipRect();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Rectangle rectangle2 = this.getChart() != null && !this.getChart().isOptimizedRepaint() ? null : graphics.getClipBounds();
            this.a(graphics, this.a(rectangle2), false);
            graphics.setClip(shape);
        }
    }

    @Override
    public void draw(Graphics graphics, IlvDataSet ilvDataSet, int n2, int n3) {
        this.a(graphics, this.a(ilvDataSet, n2, n3, this.c()), this.getChart().is3D());
    }

    void a(Graphics graphics, IlvDataPoints ilvDataPoints, boolean bl) {
        if (ilvDataPoints == null) {
            return;
        }
        Points points = this.a(ilvDataPoints);
        if (points.size() > 0) {
            if (bl) {
                this.a(graphics, points);
            } else {
                this.b(graphics, points);
            }
        }
        this.a(points);
    }

    IlvDataPoints a(Rectangle rectangle) {
        IlvDataWindow ilvDataWindow;
        if (rectangle != null) {
            ilvDataWindow = this.c(this.b(rectangle));
            if (ilvDataWindow.isEmpty()) {
                return null;
            }
        } else {
            ilvDataWindow = this.getCoordinateSystem().getVisibleWindow();
        }
        return this.g().getDataInside(ilvDataWindow, this.c(), this.f());
    }

    Rectangle b(Rectangle rectangle) {
        IlvStyle ilvStyle = this.getStyle();
        if (ilvStyle.quickBounds()) {
            ilvStyle.expand(rectangle);
        } else {
            rectangle.setBounds(this.getPlotRect());
        }
        return rectangle;
    }

    IlvDataWindow a(IlvDataWindow ilvDataWindow) {
        return ilvDataWindow;
    }

    IlvDataWindow c(Rectangle rectangle) {
        Rectangle rectangle2 = this.getPlotRect();
        IlvDataWindow ilvDataWindow = this.getChart().getProjector().toDataWindow(rectangle, rectangle2, this.getCoordinateSystem());
        this.a(ilvDataWindow);
        if (this.getXShift() != 0.0) {
            ilvDataWindow.xRange.translate(-this.getXShift());
        }
        ilvDataWindow.xRange.intersection(this.j().getVisibleRange());
        ilvDataWindow.yRange.intersection(this.i().getVisibleRange());
        return ilvDataWindow;
    }

    @Override
    public Rectangle2D getBounds(IlvDataSet object, int n2, int n3, Rectangle2D rectangle2D, boolean bl) {
        IlvDataPoints ilvDataPoints;
        Object object2;
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double();
        } else {
            rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
        }
        if (this.getChart() == null) {
            return rectangle2D;
        }
        boolean bl2 = this.getChart().is3D();
        if (bl2 && !this.has3DSupport()) {
            return rectangle2D;
        }
        if (!(object instanceof IlvVirtualDataSet)) {
            if (!this.isDisplayingDataSet((IlvDataSet)object)) {
                return null;
            }
            object2 = IlvDataSetRendererProperty.getVirtualDataSet(this, (IlvDataSet)object);
            if (object2 != null) {
                if (((IlvVirtualDataSet)object2).mapsMonotonically()) {
                    IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint((IlvDataSet)object, n2);
                    IlvDataSetPoint ilvDataSetPoint2 = new IlvDataSetPoint((IlvDataSet)object, n3);
                    ((IlvVirtualDataSet)object2).map(ilvDataSetPoint);
                    ((IlvVirtualDataSet)object2).map(ilvDataSetPoint2);
                    assert (ilvDataSetPoint.getDataSet() == object2);
                    assert (ilvDataSetPoint2.getDataSet() == object2);
                    object = object2;
                    ilvDataPoints = this.a((IlvDataSet)object2, ilvDataSetPoint.getIndex(), ilvDataSetPoint2.getIndex(), this.d());
                } else {
                    IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint();
                    IlvDataPoints ilvDataPoints2 = this.a((IlvDataSet)object, n2, n3, this.d());
                    if (ilvDataPoints2 != null) {
                        int n4 = ilvDataPoints2.size();
                        ilvDataPoints = new IlvDataPoints((IlvDataSet)object2, n4);
                        for (int i2 = 0; i2 < n4; ++i2) {
                            ilvDataSetPoint.dataSet = object;
                            ilvDataSetPoint.index = ilvDataPoints2.getIndex(i2);
                            ((IlvVirtualDataSet)object2).map(ilvDataSetPoint);
                            assert (ilvDataSetPoint.getDataSet() == object2);
                            ilvDataPoints.add(((IlvVirtualDataSet)object2).getXData(ilvDataSetPoint.index), ((IlvVirtualDataSet)object2).getYData(ilvDataSetPoint.index), ilvDataSetPoint.index);
                        }
                    } else {
                        ilvDataPoints = null;
                    }
                }
            } else {
                ilvDataPoints = this.a((IlvDataSet)object, n2, n3, this.d());
            }
        } else {
            ilvDataPoints = this.a((IlvDataSet)object, n2, n3, this.d());
        }
        if (ilvDataPoints != null) {
            object2 = this.a(ilvDataPoints);
            if (((Points)object2).size() > 0) {
                rectangle2D = bl2 ? this.b((Points)object2) : this.c((Points)object2);
                if (bl && this.r()) {
                    this.a((Points)object2, rectangle2D);
                }
            }
            this.a((Points)object2);
        }
        return rectangle2D;
    }

    @Override
    public IlvDisplayPoint getNearestPoint(IlvChartDataPicker ilvChartDataPicker) {
        IlvDataPoints ilvDataPoints;
        if (this.getChart() == null || this.getChart().is3D()) {
            return null;
        }
        int n2 = ilvChartDataPicker.getPickX();
        int n3 = ilvChartDataPicker.getPickY();
        int n4 = ilvChartDataPicker.getPickDistance();
        Rectangle rectangle = null;
        if (n4 >= 0 && n4 < 2000) {
            rectangle = new Rectangle((int)Math.floor(n2 - n4), (int)Math.floor(n3 - n4), 2 * n4, 2 * n4);
        }
        if ((ilvDataPoints = this.a(rectangle)) == null) {
            return null;
        }
        Points points = this.a(ilvDataPoints);
        int n5 = points.size();
        IlvDataSetPoint ilvDataSetPoint = null;
        if (n5 > 0) {
            double d2;
            int n6 = -1;
            IlvDataSet ilvDataSet = points.getDataSet();
            Double d3 = ilvDataSet.getUndefValue();
            double d4 = d2 = d3 != null ? d3 : 0.0;
            if (ilvChartDataPicker.useDataSpace()) {
                IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(n2, n3);
                this.toData(ilvDoublePoints);
                double[] dArray = points.getXData();
                double[] dArray2 = points.getYData();
                double d5 = Double.MAX_VALUE;
                for (int i2 = 0; i2 < n5; ++i2) {
                    double d6;
                    double d7 = dArray2[i2];
                    if (d3 != null && d7 == d2 || Double.isNaN(d7) || !((d6 = ilvChartDataPicker.computeDistance(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0), dArray[i2], d7)) <= d5)) continue;
                    n6 = i2;
                    if (d6 == 0.0) break;
                    d5 = d6;
                }
                if (n6 != -1) {
                    ilvDoublePoints.set(0, dArray[n6], dArray2[n6]);
                    this.toDisplay(ilvDoublePoints);
                    ilvDataSetPoint = new IlvDisplayPoint(this, ilvDataSet, points.getDataIndex(n6), ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
                }
                ilvDoublePoints.dispose();
            } else {
                double[] dArray = points.getXCoords();
                double[] dArray3 = points.getYCoords();
                double[] dArray4 = points.getYData();
                double d8 = n4;
                for (int i3 = 0; i3 < n5; ++i3) {
                    double d9;
                    double d10 = dArray4[i3];
                    if (d3 != null && d10 == d2 || Double.isNaN(d10) || !((d9 = ilvChartDataPicker.computeDistance(n2, n3, dArray[i3], dArray3[i3])) <= d8)) continue;
                    n6 = i3;
                    if (d9 == 0.0) break;
                    d8 = d9;
                }
                if (n6 != -1) {
                    ilvDataSetPoint = new IlvDisplayPoint(this, ilvDataSet, points.getDataIndex(n6), dArray[n6], dArray3[n6]);
                }
            }
            if (ilvDataSetPoint != null && ilvDataSet instanceof IlvVirtualDataSet) {
                ((IlvVirtualDataSet)ilvDataSet).unmap(ilvDataSetPoint);
                if (ilvDataSetPoint.getIndex() == -1) {
                    ilvDataSetPoint = null;
                }
            }
        }
        this.a(points);
        return ilvDataSetPoint;
    }

    @Override
    public IlvDisplayPoint getDisplayItem(IlvChartDataPicker ilvChartDataPicker) {
        int n2 = ilvChartDataPicker.getPickX();
        int n3 = ilvChartDataPicker.getPickY();
        Rectangle rectangle = new Rectangle((int)Math.floor(n2 - 1), (int)Math.floor(n3 - 1), 2, 2);
        IlvDataPoints ilvDataPoints = this.a(rectangle);
        if (ilvDataPoints == null) {
            return null;
        }
        Points points = this.a(ilvDataPoints);
        IlvDisplayPoint ilvDisplayPoint = this.a(ilvChartDataPicker, points);
        points.b();
        if (ilvDisplayPoint != null && ilvDisplayPoint.getDataSet() instanceof IlvVirtualDataSet) {
            ((IlvVirtualDataSet)ilvDisplayPoint.getDataSet()).unmap(ilvDisplayPoint);
            if (ilvDisplayPoint.getIndex() == -1) {
                ilvDisplayPoint = null;
            }
        }
        return ilvDisplayPoint;
    }

    IlvDisplayPoint a(IlvChartDataPicker ilvChartDataPicker, Points points) {
        int n2 = points.size();
        if (n2 == 0) {
            return null;
        }
        ContainsItemAction containsItemAction = this.a(ilvChartDataPicker);
        containsItemAction.startProcessItems();
        this.a(points, containsItemAction);
        containsItemAction.endProcessItems();
        return containsItemAction.getDisplayItem();
    }

    @Override
    public IlvDisplayPoint getDisplayPoint(IlvDataSet ilvDataSet, int n2) {
        IlvDataSet ilvDataSet2 = this.a(ilvDataSet);
        if (ilvDataSet2 == null) {
            return null;
        }
        IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint(ilvDataSet, n2);
        if (ilvDataSet2 instanceof IlvVirtualDataSet) {
            ((IlvVirtualDataSet)ilvDataSet2).map(ilvDataSetPoint);
        }
        IlvDataPoints ilvDataPoints = ilvDataSetPoint.getData();
        this.toDisplay(ilvDataPoints);
        double d2 = ilvDataPoints.getX(0);
        double d3 = ilvDataPoints.getY(0);
        ilvDataPoints.dispose();
        return new IlvDisplayPoint(this, ilvDataSet, n2, d2, d3);
    }

    @Override
    public void setDisplayPoint(IlvDataSet ilvDataSet, int n2, double d2, double d3) {
        if (!this.isDisplayingDataSet(ilvDataSet)) {
            return;
        }
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(d2, d3);
        this.toData(ilvDoublePoints);
        double d4 = ilvDoublePoints.getX(0);
        double d5 = ilvDoublePoints.getY(0);
        ilvDoublePoints.dispose();
        this.setDataPoint(ilvDataSet, n2, d4, d5);
    }

    @Override
    public void setDataPoint(IlvDataSet ilvDataSet, int n2, double d2, double d3) {
        if (this.isDisplayingDataSet(ilvDataSet)) {
            IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint(ilvDataSet, n2);
            IlvVirtualDataSet ilvVirtualDataSet = IlvDataSetRendererProperty.getVirtualDataSet(this, ilvDataSet);
            if (ilvVirtualDataSet != null) {
                ilvVirtualDataSet.map(ilvDataSetPoint);
            }
            ilvDataSetPoint.setData(d2, d3);
        }
    }

    Rectangle m() {
        IlvChart.Area area = this.getChart().getChartArea();
        if (this.getChart().isPaintingImage() && this.getChart().getPaintContext().getBounds() != null) {
            return (Rectangle)this.getChart().getPaintContext().getBounds().get(area);
        }
        return area.getBounds();
    }

    @Override
    public void addImageMapAreas(IlvIMapDefinition ilvIMapDefinition, List list) {
        IlvDataPoints ilvDataPoints = this.a((Rectangle)null);
        if (ilvDataPoints == null) {
            return;
        }
        Points points = this.a(ilvDataPoints);
        if (points.size() > 0) {
            ImageMapItemAction imageMapItemAction = this.a(ilvIMapDefinition, list);
            imageMapItemAction.startProcessItems();
            this.a(points, imageMapItemAction);
            imageMapItemAction.endProcessItems();
        }
        this.a(points);
    }

    abstract void a(Points var1, ItemAction var2);

    Rectangle2D c(Points points) {
        BoundsItemAction boundsItemAction = this.o();
        boundsItemAction.startProcessItems();
        this.a(points, boundsItemAction);
        boundsItemAction.endProcessItems();
        return boundsItemAction.getBounds();
    }

    void b(Graphics graphics, Points points) {
        DrawItemAction drawItemAction = this.n();
        drawItemAction.setGraphics(graphics);
        drawItemAction.startProcessItems();
        this.a(points, drawItemAction);
        drawItemAction.endProcessItems();
    }

    DrawItemAction n() {
        return new DefaultDrawItemAction();
    }

    BoundsItemAction o() {
        return new DefaultBoundsItemAction();
    }

    ContainsItemAction a(IlvChartDataPicker ilvChartDataPicker) {
        return new DefaultContainsItemAction(ilvChartDataPicker);
    }

    ImageMapItemAction a(IlvIMapDefinition ilvIMapDefinition, List list) {
        return new ImageMapItemAction(ilvIMapDefinition, list);
    }

    void a(IlvDataSet ilvDataSet, IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray) {
        if (ilvDefaultedRenderingModifierArray == null) {
            if (this.b != null) {
                this.b.remove(ilvDataSet);
            }
        } else {
            if (this.b == null) {
                this.b = new HashMap<IlvDataSet, IlvDefaultedRenderingModifierArray>();
            }
            this.b.put(ilvDataSet, ilvDefaultedRenderingModifierArray);
        }
    }

    IlvDefaultedRenderingModifierArray a(IlvDataSet ilvDataSet, boolean bl) {
        IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray;
        IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray2 = ilvDefaultedRenderingModifierArray = this.b != null ? this.b.get(ilvDataSet) : null;
        if (ilvDefaultedRenderingModifierArray == null && bl) {
            ilvDefaultedRenderingModifierArray = new IlvDefaultedRenderingModifierArray();
            this.a(ilvDataSet, ilvDefaultedRenderingModifierArray);
        }
        return ilvDefaultedRenderingModifierArray;
    }

    public void dataSetContentsChanged(DataSetContentsEvent dataSetContentsEvent) {
        switch (dataSetContentsEvent.getType()) {
            case -2: {
                this.g.a = dataSetContentsEvent;
                break;
            }
            case -1: {
                this.g.a();
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (this.g.a == null) {
                    this.a(dataSetContentsEvent);
                    break;
                }
                this.g.a(dataSetContentsEvent);
            }
        }
        if (this.isViewable()) {
            this.getChart().dataSetContentsChanged(dataSetContentsEvent, this);
        }
    }

    void a(DataSetContentsEvent dataSetContentsEvent) {
        Object object;
        Object object2;
        IlvChart ilvChart = this.getChart();
        if (ilvChart != null && ilvChart.isDynamicStyling() && (object2 = IlvStylingSupport.get(ilvChart)) != null && ((IlvStylingSupport)object2).hasStyles()) {
            object = dataSetContentsEvent.getDataSet();
            boolean bl = dataSetContentsEvent.getType() == 6;
            int n2 = dataSetContentsEvent.getFirstIdx();
            int n3 = dataSetContentsEvent.getLastIdx();
            if (object instanceof IlvVirtualDataSet) {
                if (dataSetContentsEvent.getType() == 6) {
                    object = this.h();
                    n2 = 0;
                    n3 = (object != null ? object.getDataCount() : 0) - 1;
                } else {
                    IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint((IlvDataSet)object, n2);
                    IlvDataSetPoint ilvDataSetPoint2 = new IlvDataSetPoint((IlvDataSet)object, n3);
                    ((IlvVirtualDataSet)object).unmap(ilvDataSetPoint);
                    ((IlvVirtualDataSet)object).unmap(ilvDataSetPoint2);
                    n2 = ilvDataSetPoint.index;
                    n3 = ilvDataSetPoint2.index;
                    object = ilvDataSetPoint.dataSet;
                    if (n2 == -1 || n3 == -1) {
                        n2 = 0;
                        n3 = object.getDataCount() - 1;
                    }
                }
            }
            if (object != null) {
                IlvChartRenderer.applyStyles((IlvDataSet)object, bl, n2, n3, (IlvStylingSupport)object2);
            }
        }
        if (this.isViewable() && this.k()) {
            switch (dataSetContentsEvent.getType()) {
                case 2: 
                case 3: 
                case 4: {
                    object2 = dataSetContentsEvent.getDataSet();
                    object = this.a(this.a((IlvDataSet)object2, dataSetContentsEvent.getFirstIdx(), dataSetContentsEvent.getLastIdx(), this.c()));
                    this.a((Points)object, false);
                    ((Points)object).b();
                    break;
                }
            }
        }
    }

    public void dataSetPropertyChanged(DataSetPropertyEvent dataSetPropertyEvent) {
        IlvStylingSupport ilvStylingSupport;
        IlvChart ilvChart;
        if (dataSetPropertyEvent.getPropertyName().equals("name")) {
            this.triggerChange(6);
        }
        if ((ilvChart = this.getChart()) != null && (ilvStylingSupport = IlvStylingSupport.get(ilvChart)) != null && ilvStylingSupport.hasStyles()) {
            IlvDataSet ilvDataSet = dataSetPropertyEvent.getDataSet();
            if (ilvDataSet instanceof IlvVirtualDataSet) {
                ilvDataSet = this.h();
            }
            try {
                IlvDataSetStyle ilvDataSetStyle = IlvChartRenderer.applyStyles(ilvDataSet, this, ilvStylingSupport);
                if (ilvDataSetStyle != null) {
                    this.applyDataSetStyle(ilvDataSetStyle);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    DataSetListener b(IlvDataSet ilvDataSet) {
        IlvDataSetRendererProperty ilvDataSetRendererProperty = IlvDataSetRendererProperty.getDataSetRendererProperty(this, ilvDataSet, true);
        if (ilvDataSetRendererProperty.listener != null) {
            throw new IllegalStateException(this + " is already connected to " + ilvDataSet);
        }
        ilvDataSetRendererProperty.listener = new MyDataSetListener();
        return ilvDataSetRendererProperty.listener;
    }

    DataSetListener c(IlvDataSet ilvDataSet) {
        IlvDataSetRendererProperty ilvDataSetRendererProperty = IlvDataSetRendererProperty.getDataSetRendererProperty(this, ilvDataSet, false);
        if (ilvDataSetRendererProperty == null || ilvDataSetRendererProperty.listener == null) {
            throw new IllegalStateException(this + " is not currently connected to " + ilvDataSet);
        }
        return ilvDataSetRendererProperty.listener;
    }

    @Override
    protected void dataSetsRemoved(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        boolean bl = false;
        for (int i2 = n2; i2 <= n3; ++i2) {
            IlvDataSet ilvDataSet = ilvDataSetArray[i2];
            this.a(ilvDataSet, (IlvDefaultedRenderingModifierArray)null);
            bl |= this.a(ilvDataSet, (IlvVirtualDataSet)null);
            ilvDataSet.removeDataSetListener(this.c(ilvDataSet));
            IlvDataSetRendererProperty.clearDataSetRendererProperty(this, ilvDataSet);
        }
        if (bl && this.getChart() != null) {
            this.getChart().updateDataRange();
        }
        super.dataSetsRemoved(n2, n3, ilvDataSetArray);
    }

    @Override
    protected void dataSetsAdded(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            IlvDataSet ilvDataSet = this.getDataSource().getDataSet(i2);
            ilvDataSet.addDataSetListener(this.b(ilvDataSet));
        }
        super.dataSetsAdded(n2, n3, ilvDataSetArray);
    }

    final boolean a(IlvDataSet ilvDataSet, IlvVirtualDataSet ilvVirtualDataSet) {
        return this.a(ilvDataSet, ilvVirtualDataSet, true);
    }

    boolean a(IlvDataSet ilvDataSet, IlvVirtualDataSet ilvVirtualDataSet, boolean bl) {
        IlvDataSetRendererProperty ilvDataSetRendererProperty = IlvDataSetRendererProperty.getDataSetRendererProperty(this, ilvDataSet, false);
        if (ilvDataSetRendererProperty == null || ilvDataSetRendererProperty.listener == null) {
            throw new IllegalStateException(this + " is not currently connected to " + ilvDataSet);
        }
        IlvVirtualDataSet ilvVirtualDataSet2 = ilvDataSetRendererProperty.virtualDataSet;
        if (ilvVirtualDataSet != ilvVirtualDataSet2) {
            MyDataSetListener myDataSetListener = (MyDataSetListener)ilvDataSetRendererProperty.listener;
            if (ilvVirtualDataSet2 != null) {
                if (bl) {
                    myDataSetListener.a();
                    ilvVirtualDataSet2.removeDataSetListener(myDataSetListener);
                }
                ilvVirtualDataSet2.dispose();
            }
            if (ilvVirtualDataSet2 != null && ilvVirtualDataSet == null) {
                ilvDataSet.addDataSetListener(myDataSetListener);
            }
            ilvDataSetRendererProperty.virtualDataSet = ilvVirtualDataSet;
            if (ilvVirtualDataSet2 == null && ilvVirtualDataSet != null) {
                myDataSetListener.a();
                ilvDataSet.removeDataSetListener(myDataSetListener);
            }
            if (ilvVirtualDataSet != null && bl) {
                ilvVirtualDataSet.addDataSetListener(myDataSetListener);
            }
            return true;
        }
        return false;
    }

    @Override
    public IlvDataInterval getXRange(IlvDataInterval ilvDataInterval) {
        IlvDataSet ilvDataSet = this.g();
        if (ilvDataSet == null) {
            if (ilvDataInterval == null) {
                ilvDataInterval = new IlvDataInterval();
            } else {
                ilvDataInterval.empty();
            }
            return ilvDataInterval;
        }
        IlvDataInterval ilvDataInterval2 = ilvDataSet.getXRange(ilvDataInterval);
        double d2 = this.getXShift();
        if (d2 != 0.0) {
            ilvDataInterval2.translate(d2);
        }
        return ilvDataInterval2;
    }

    @Override
    public IlvDataInterval getYRange(IlvDataInterval ilvDataInterval) {
        IlvDataSet ilvDataSet = this.g();
        if (ilvDataSet == null) {
            if (ilvDataInterval == null) {
                ilvDataInterval = new IlvDataInterval();
            } else {
                ilvDataInterval.empty();
            }
            return ilvDataInterval;
        }
        return ilvDataSet.getYRange(ilvDataInterval);
    }

    @Override
    public IlvDataInterval getYRange(IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
        if (ilvDataInterval2 == null) {
            ilvDataInterval2 = new IlvDataInterval();
        } else {
            ilvDataInterval2.empty();
        }
        IlvDataSet ilvDataSet = this.g();
        if (ilvDataSet == null) {
            return ilvDataInterval2;
        }
        IlvDataWindow ilvDataWindow = new IlvDataWindow(ilvDataInterval, this.i().getVisibleRange());
        IlvDataPoints ilvDataPoints = ilvDataSet.getDataInside(ilvDataWindow, 0, true);
        if (ilvDataPoints == null) {
            return ilvDataInterval2;
        }
        int n2 = ilvDataPoints.size();
        Double d2 = ilvDataSet.getUndefValue();
        double d3 = d2 != null ? d2 : 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = ilvDataPoints.getY(i2);
            if (d2 != null && d4 == d3 || Double.isNaN(d4)) continue;
            ilvDataInterval2.add(d4);
        }
        ilvDataPoints.dispose();
        return ilvDataInterval2;
    }

    @Override
    public Insets getPreferredMargins() {
        return new Insets(0, 0, 0, 0);
    }

    protected IlvStyle makeDefaultStyle() {
        return this.a(this.e(), null, this.e);
    }

    private Color e() {
        Color color = this.getChart() == null ? (Color)IlvColor.getDefaultColors().get(0) : this.findAppropriateColor(this.t());
        return color;
    }

    IlvStyle a(Paint paint, Paint paint2, Stroke stroke) {
        if (stroke == null) {
            stroke = IlvStyle.DEFAULT_STROKE;
        }
        if (paint2 == null) {
            paint2 = Color.black;
        }
        if (this.isFilled()) {
            return new IlvStyle(stroke, paint2, paint);
        }
        return new IlvStyle(stroke, paint);
    }

    private Set t() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getChart().getRendererIterator();
        while (iterator.hasNext()) {
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)iterator.next();
            this.a(hashSet, ilvChartRenderer.getStyles());
        }
        return hashSet;
    }

    private void a(Set set, IlvStyle[] ilvStyleArray) {
        if (ilvStyleArray == null) {
            return;
        }
        for (int i2 = 0; i2 < ilvStyleArray.length; ++i2) {
            Color color = ilvStyleArray[i2].getFillColor();
            if (color != null) {
                set.add(color);
            }
            if ((color = ilvStyleArray[i2].getStrokeColor()) == null) continue;
            set.add(color);
        }
    }

    @Override
    public void drawLegendSymbol(IlvLegendItem ilvLegendItem, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n4, n5);
        this.getLegendStyle().renderRect(graphics, n2 + (n4 - n6) / 2, n3 + (n5 - n6) / 2, n6, n6);
    }

    @Override
    public IlvLegendItem[] createLegendItems() {
        if (this.isViewable() && this.isVisibleInLegend()) {
            return new IlvLegendItem[]{new IlvRendererLegendItem(this)};
        }
        return null;
    }

    @Override
    public String getLegendText(IlvLegendItem ilvLegendItem) {
        return this.getDefaultLegendText();
    }

    public String getDefaultLegendText() {
        if (this.getName() != null) {
            return this.getName();
        }
        IlvDataSet ilvDataSet = this.g();
        if (ilvDataSet != null) {
            return ilvDataSet.getName() != null ? ilvDataSet.getName() : "";
        }
        return "";
    }

    final double p() {
        IlvDataSet ilvDataSet = this.g();
        if (ilvDataSet == null) {
            return 0.0;
        }
        Double d2 = IlvDataSetProperty.getCategory(ilvDataSet);
        if (d2 != null) {
            return d2;
        }
        int n2 = ilvDataSet.getDataCount();
        if (n2 == 0) {
            return 1.0;
        }
        IlvDataPoints ilvDataPoints = ilvDataSet.getDataBetween(0, n2 - 1);
        if (ilvDataPoints == null) {
            return 1.0;
        }
        n2 = ilvDataPoints.size();
        if (n2 == 0) {
            ilvDataPoints.dispose();
            return 1.0;
        }
        double[] dArray = ilvDataPoints.getXValues();
        boolean bl = true;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!(dArray[i2 - 1] > dArray[i2])) continue;
            bl = false;
            break;
        }
        if (!bl) {
            Arrays.sort(dArray);
        }
        if (n2 > 1) {
            double d3 = Double.MAX_VALUE;
            for (int i3 = 1; i3 < n2; ++i3) {
                double d4 = dArray[i3] - dArray[i3 - 1];
                if (!(d4 > 0.0)) continue;
                d3 = Math.min(d3, d4);
            }
            if (d3 < Double.MAX_VALUE) {
                ilvDataPoints.dispose();
                return d3;
            }
        }
        double d5 = dArray[0];
        ilvDataPoints.dispose();
        return d5 == 0.0 ? 1.0 : (Math.abs(d5) <= 1.0 ? Math.abs(d5) : 0.5 * Math.abs(d5));
    }

    @Override
    public void drawAnnotations(Graphics graphics) {
        if (this.r()) {
            IlvDataPoints ilvDataPoints = this.a((Rectangle)null);
            if (ilvDataPoints == null) {
                return;
            }
            Points points = this.a(ilvDataPoints);
            if (points.size() > 0) {
                this.c(graphics, points);
            }
            this.a(points);
        }
    }

    void c(Graphics graphics, Points points) {
        IlvDataSet ilvDataSet = points.getDataSet();
        int n2 = points.size();
        double[] dArray = points.getXCoords();
        double[] dArray2 = points.getYCoords();
        int[] nArray = points.getIndices();
        IlvDisplayPoint ilvDisplayPoint = new IlvDisplayPoint(this, ilvDataSet);
        Rectangle2D rectangle2D = null;
        IlvDataWindow ilvDataWindow = this.getCoordinateSystem().getVisibleWindow();
        Rectangle rectangle = graphics.getClipBounds();
        Double d2 = ilvDataSet.getUndefValue();
        double d3 = d2 != null ? d2 : 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = points.getYData(i2);
            if (d2 != null && d4 == d3 || Double.isNaN(d4) || !ilvDataWindow.contains(points.getXData(i2), d4)) continue;
            ilvDisplayPoint.dataSet = ilvDataSet;
            ilvDisplayPoint.set(nArray[i2], dArray[i2], dArray2[i2]);
            IlvDataAnnotation ilvDataAnnotation = this.a(ilvDisplayPoint);
            if (ilvDataAnnotation == null) continue;
            rectangle2D = ilvDataAnnotation.getBounds(ilvDisplayPoint, rectangle2D);
            if (rectangle != null && !rectangle.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight())) continue;
            ilvDataAnnotation.draw(graphics, ilvDisplayPoint);
        }
    }

    void a(Points points, Rectangle2D rectangle2D) {
        IlvDataSet ilvDataSet = points.getDataSet();
        int n2 = points.size();
        double[] dArray = points.getXCoords();
        double[] dArray2 = points.getYCoords();
        int[] nArray = points.getIndices();
        IlvDisplayPoint ilvDisplayPoint = new IlvDisplayPoint(this, ilvDataSet);
        Rectangle2D rectangle2D2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            ilvDisplayPoint.dataSet = ilvDataSet;
            ilvDisplayPoint.set(nArray[i2], dArray[i2], dArray2[i2]);
            IlvDataAnnotation ilvDataAnnotation = this.a(ilvDisplayPoint);
            if (ilvDataAnnotation == null) continue;
            rectangle2D2 = ilvDataAnnotation.getBounds(ilvDisplayPoint, rectangle2D2);
            rectangle2D = IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
        }
    }

    Rectangle2D a(IlvDataSet ilvDataSet, int n2) {
        IlvDataAnnotation ilvDataAnnotation;
        IlvDisplayPoint ilvDisplayPoint = this.getDisplayPoint(ilvDataSet, n2);
        if (ilvDisplayPoint != null && (ilvDataAnnotation = this.a(ilvDisplayPoint)) != null) {
            return ilvDataAnnotation.getBounds(ilvDisplayPoint, null);
        }
        return null;
    }

    @Override
    public void setAnnotation(IlvDataSet ilvDataSet, int n2, IlvDataAnnotation ilvDataAnnotation) {
        IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray = this.a(ilvDataSet, ilvDataAnnotation != null);
        if (ilvDefaultedRenderingModifierArray == null) {
            return;
        }
        Rectangle2D rectangle2D = null;
        boolean bl = false;
        if (this.getChart() != null) {
            IlvDataInterval ilvDataInterval = this.j().getVisibleRange();
            bl = ilvDataInterval.isInside(ilvDataSet.getXData(n2));
        }
        if (bl) {
            rectangle2D = this.a(ilvDataSet, n2);
        }
        ilvDefaultedRenderingModifierArray.setAnnotation(n2, ilvDataAnnotation);
        if (bl) {
            if (ilvDataAnnotation != null || this.u() != null) {
                if (rectangle2D == null) {
                    rectangle2D = this.a(ilvDataSet, n2);
                } else {
                    IlvGraphicUtil.addToRect(rectangle2D, this.a(ilvDataSet, n2));
                }
            }
            if (rectangle2D != null && !rectangle2D.isEmpty()) {
                this.getChart().getChartArea().repaint2D(rectangle2D);
            }
        }
    }

    @Override
    public void setAnnotation(IlvDataSet ilvDataSet, IlvDataAnnotation ilvDataAnnotation) {
        IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray = this.a(ilvDataSet, ilvDataAnnotation != null);
        if (ilvDefaultedRenderingModifierArray == null) {
            return;
        }
        ilvDefaultedRenderingModifierArray.setAnnotation(ilvDataAnnotation);
        if (this.getChart() != null) {
            this.getChart().getChartArea().repaint();
        }
    }

    @Override
    public IlvDataAnnotation getAnnotation(IlvDataSet ilvDataSet, int n2) {
        return this.a(new IlvDataSetPoint(ilvDataSet, n2));
    }

    @Override
    public void setRenderingHint(IlvDataSet ilvDataSet, int n2, IlvDataRenderingHint ilvDataRenderingHint) {
        boolean bl;
        IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray = this.a(ilvDataSet, ilvDataRenderingHint != null);
        if (ilvDefaultedRenderingModifierArray == null) {
            return;
        }
        Rectangle2D rectangle2D = null;
        boolean bl2 = bl = this.getChart() != null;
        if (bl) {
            rectangle2D = this.getBounds(ilvDataSet, n2, n2, rectangle2D);
        }
        ilvDefaultedRenderingModifierArray.setRenderingHint(n2, ilvDataRenderingHint);
        if (bl) {
            Rectangle2D rectangle2D2 = this.getBounds(ilvDataSet, n2, n2, null);
            IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
            this.getChart().getChartArea().repaint2D(rectangle2D);
        }
    }

    @Override
    public void setRenderingHint(IlvDataSet ilvDataSet, IlvDataRenderingHint ilvDataRenderingHint) {
        IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray = this.a(ilvDataSet, ilvDataRenderingHint != null);
        if (ilvDefaultedRenderingModifierArray == null) {
            return;
        }
        ilvDefaultedRenderingModifierArray.setRenderingHint(ilvDataRenderingHint);
        if (this.getChart() != null) {
            this.getChart().getChartArea().repaint();
        }
    }

    @Override
    public IlvDataRenderingHint getRenderingHint(IlvDataSet ilvDataSet, int n2) {
        return this.b(new IlvDataSetPoint(ilvDataSet, n2));
    }

    @Override
    public IlvStyle getStyle(IlvDataSet ilvDataSet, int n2) {
        IlvDisplayPoint ilvDisplayPoint;
        IlvDataRenderingHint ilvDataRenderingHint;
        if (!this.isDisplayingDataSet(ilvDataSet)) {
            return null;
        }
        IlvStyle ilvStyle = this.b(ilvDataSet, n2);
        if (this.s() && (ilvDataRenderingHint = this.b(ilvDisplayPoint = new IlvDisplayPoint(this, ilvDataSet, n2, 0.0, 0.0))) != null) {
            return ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
        }
        return ilvStyle;
    }

    public IlvStyle getDisplayStyle(int n2) {
        return this.getStyle(this.h(), n2);
    }

    void q() {
        if (this.f) {
            this.a = null;
            this.a((IlvStyle)null);
        }
    }

    IlvStyle b(IlvDataSet ilvDataSet, int n2) {
        return this.getStyle();
    }

    IlvDataAnnotation a(IlvDataSetPoint ilvDataSetPoint) {
        IlvDataAnnotation ilvDataAnnotation;
        IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray;
        if (ilvDataSetPoint.getDataSet() instanceof IlvVirtualDataSet) {
            ((IlvVirtualDataSet)ilvDataSetPoint.getDataSet()).unmap(ilvDataSetPoint);
        }
        if ((ilvDefaultedRenderingModifierArray = this.a(ilvDataSetPoint.getDataSet(), false)) != null && (ilvDataAnnotation = ilvDefaultedRenderingModifierArray.getAnnotation(ilvDataSetPoint.getIndex())) != null) {
            return ilvDataAnnotation;
        }
        ilvDataAnnotation = this.u();
        if (ilvDataAnnotation != null) {
            return ilvDataAnnotation;
        }
        IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSetPoint.getDataSet());
        if (ilvDataSetStyle != null) {
            IlvDataPointStyle ilvDataPointStyle = ilvDataSetStyle.getPointStyle(ilvDataSetPoint.getIndex());
            if (ilvDataPointStyle != null && (ilvDataAnnotation = ilvDataPointStyle.getAnnotation()) != null) {
                return ilvDataAnnotation;
            }
            ilvDataAnnotation = ilvDataSetStyle.getAnnotation();
            if (ilvDataAnnotation != null) {
                return ilvDataAnnotation;
            }
        }
        return null;
    }

    private IlvDataAnnotation u() {
        IlvDataAnnotation ilvDataAnnotation = this.getAnnotation();
        return ilvDataAnnotation != null || this.getParent() == null ? ilvDataAnnotation : this.getParent().getAnnotation();
    }

    boolean r() {
        if (this.u() != null) {
            return true;
        }
        IlvDataSource ilvDataSource = this.getDataSource();
        int n2 = ilvDataSource.getDataSetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvDataSet ilvDataSet = ilvDataSource.getDataSet(i2);
            IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray = this.a(ilvDataSet, false);
            if (ilvDefaultedRenderingModifierArray != null && ilvDefaultedRenderingModifierArray.holdsAnnotation()) {
                return true;
            }
            IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSet);
            if (ilvDataSetStyle == null || !ilvDataSetStyle.holdsAnnotation()) continue;
            return true;
        }
        return false;
    }

    IlvDataRenderingHint b(IlvDataSetPoint ilvDataSetPoint) {
        IlvDataRenderingHint ilvDataRenderingHint;
        IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray;
        if (ilvDataSetPoint.getDataSet() instanceof IlvVirtualDataSet) {
            ((IlvVirtualDataSet)ilvDataSetPoint.getDataSet()).unmap(ilvDataSetPoint);
        }
        if ((ilvDefaultedRenderingModifierArray = this.a(ilvDataSetPoint.getDataSet(), false)) != null && (ilvDataRenderingHint = ilvDefaultedRenderingModifierArray.getRenderingHint(ilvDataSetPoint.getIndex())) != null) {
            return ilvDataRenderingHint;
        }
        ilvDataRenderingHint = this.v();
        if (ilvDataRenderingHint != null) {
            return ilvDataRenderingHint;
        }
        IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSetPoint.getDataSet());
        if (ilvDataSetStyle != null && (ilvDataRenderingHint = ilvDataSetStyle.getPointStyle(ilvDataSetPoint.getIndex())) != null) {
            return ilvDataRenderingHint;
        }
        return null;
    }

    private IlvDataRenderingHint v() {
        IlvDataRenderingHint ilvDataRenderingHint = this.getRenderingHint();
        return ilvDataRenderingHint != null || this.getParent() == null ? ilvDataRenderingHint : this.getParent().getRenderingHint();
    }

    boolean s() {
        if (this.v() != null) {
            return true;
        }
        IlvDataSource ilvDataSource = this.getDataSource();
        int n2 = ilvDataSource.getDataSetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvIntToObjectMap<IlvDataPointStyle> ilvIntToObjectMap;
            IlvDataSet ilvDataSet = ilvDataSource.getDataSet(i2);
            IlvDefaultedRenderingModifierArray ilvDefaultedRenderingModifierArray = this.a(ilvDataSet, false);
            if (ilvDefaultedRenderingModifierArray != null && ilvDefaultedRenderingModifierArray.holdsRenderingHint()) {
                return true;
            }
            IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSet);
            if (ilvDataSetStyle == null || (ilvIntToObjectMap = ilvDataSetStyle.getPointStyles()) == null || ilvIntToObjectMap.isEmpty()) continue;
            return true;
        }
        return false;
    }

    Point a(IlvDoublePoint ilvDoublePoint, Dimension dimension, double d2, boolean bl) {
        IlvChartProjector ilvChartProjector = this.getChart().getProjector();
        Rectangle rectangle = this.getPlotRect();
        IlvDoublePoint ilvDoublePoint2 = new IlvDoublePoint(ilvDoublePoint.x, ilvDoublePoint.y);
        ilvChartProjector.shiftAlongAxis(rectangle, bl ? this.i() : this.j(), ilvDoublePoint2, d2);
        double d3 = IlvGraphicUtil.pointAngleDeg(ilvDoublePoint.x, ilvDoublePoint.y, ilvDoublePoint2.x, ilvDoublePoint2.y);
        double d4 = IlvMathUtil.cosDeg(d3);
        double d5 = IlvMathUtil.sinDeg(d3);
        d3 = Math.min(d4 == 0.0 ? 100000.0 : Math.abs((double)dimension.width / (2.0 * d4)), d5 == 0.0 ? 100000.0 : Math.abs((double)dimension.height / (2.0 * d5)));
        ilvDoublePoint2.x += d3 * d4;
        ilvDoublePoint2.y -= d3 * d5;
        return new Point(ilvDoublePoint2.xFloor(), ilvDoublePoint2.yFloor());
    }

    @Override
    public void applyStyles(boolean bl) throws Exception {
        IlvStylingSupport ilvStylingSupport = IlvStylingSupport.get(this.getChart());
        if (ilvStylingSupport == null) {
            return;
        }
        IlvDataSet ilvDataSet = this.h();
        if (ilvDataSet == null) {
            return;
        }
        IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSet);
        if (ilvDataSetStyle != null && !bl) {
            return;
        }
        ilvDataSetStyle = IlvChartRenderer.applyStyles(ilvDataSet, this, ilvStylingSupport);
        if (ilvDataSetStyle != null) {
            this.applyDataSetStyle(ilvDataSetStyle);
        }
    }

    public void applyDataSetStyle(IlvDataSetStyle ilvDataSetStyle) {
        this.e = ilvDataSetStyle.getUsedStroke();
        if (ilvDataSetStyle.getColor1() == null) {
            boolean bl = this.f;
            this.a = null;
            this.setStyle(this.a(this.e(), ilvDataSetStyle.getColor2(), ilvDataSetStyle.getUsedStroke()));
            this.f = bl;
        } else {
            IlvStyle ilvStyle = ilvDataSetStyle.getStyle(this, this.getStyle());
            this.setStyle(ilvStyle);
        }
    }

    abstract class BoundsItemAction
    implements ItemAction {
        BoundsItemAction() {
        }

        public void startProcessItems() {
        }

        public void endProcessItems() {
        }

        public void processItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            this.itemBounds(points, n2, item, ilvStyle);
        }

        protected abstract void itemBounds(Points var1, int var2, Item var3, IlvStyle var4);

        public abstract Rectangle2D getBounds();
    }

    abstract class ContainsItemAction
    implements ItemAction {
        private IlvChartDataPicker a;

        public void startProcessItems() {
        }

        public void endProcessItems() {
        }

        public ContainsItemAction(IlvChartDataPicker ilvChartDataPicker) {
            this.a = ilvChartDataPicker;
        }

        public abstract void processItem(Points var1, int var2, Item var3, IlvStyle var4);

        public final int getX() {
            return this.a.getPickX();
        }

        public final int getY() {
            return this.a.getPickY();
        }

        public final IlvChartDataPicker getDataPicker() {
            return this.a;
        }

        public abstract IlvDisplayPoint getDisplayItem();
    }

    class DefaultBoundsItemAction
    extends BoundsItemAction {
        Rectangle2D a = new Rectangle2D.Double();
        Rectangle2D b = null;

        DefaultBoundsItemAction() {
        }

        protected void itemBounds(Points points, int n2, Item item, IlvStyle ilvStyle) {
            this.b = item.getBounds(ilvStyle, this.b);
            this.a = IlvGraphicUtil.addToRect(this.a, this.b);
        }

        public Rectangle2D getBounds() {
            return this.a;
        }
    }

    class DefaultContainsItemAction
    extends ContainsItemAction {
        IlvDisplayPoint a;

        public DefaultContainsItemAction(IlvChartDataPicker ilvChartDataPicker) {
            super(ilvChartDataPicker);
        }

        public void processItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            if (item.contains(ilvStyle, this.getX(), this.getY())) {
                this.a = new IlvDisplayPoint(IlvSingleChartRenderer.this, points.getDataSet(), points.getDataIndex(n2), points.getXCoord(n2), points.getYCoord(n2));
            }
        }

        public IlvDisplayPoint getDisplayItem() {
            return this.a;
        }
    }

    class DefaultDrawItemAction
    extends DrawItemAction {
        DefaultDrawItemAction() {
        }

        protected void drawItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            item.draw(this.getGraphics(), ilvStyle);
        }
    }

    class DefaultItem
    extends IlvDoublePoints
    implements Item {
        public DefaultItem() {
        }

        public DefaultItem(int n2) {
            super(n2);
        }

        public void draw(Graphics graphics, IlvStyle ilvStyle) {
            if (IlvSingleChartRenderer.this.isFilled()) {
                ilvStyle.renderPoints(graphics, this.getXValues(), this.getYValues(), this.size());
            } else {
                ilvStyle.drawPolyline(graphics, this.getXValues(), this.getYValues(), this.size());
            }
        }

        public Rectangle2D getBounds(IlvStyle ilvStyle, Rectangle2D rectangle2D) {
            return ilvStyle.getBounds(this.getXValues(), this.getYValues(), this.size(), rectangle2D);
        }

        public boolean contains(IlvStyle ilvStyle, double d2, double d3) {
            return IlvSingleChartRenderer.this.isFilled() ? ilvStyle.pointsContains(this.getXValues(), this.getYValues(), this.size(), d2, d3) : ilvStyle.polylineContains(this.getXValues(), this.getYValues(), this.size(), d2, d3);
        }

        public IlvIMapArea getMapArea(IlvIMapDefinition ilvIMapDefinition, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            double[] dArray;
            double[] dArray2;
            int n2 = this.size();
            if (ilvIMapDefinition.isChartOrigin()) {
                Rectangle rectangle = IlvSingleChartRenderer.this.m();
                if (rectangle.x != 0 || rectangle.y != 0) {
                    dArray2 = this.getXValuesClone();
                    dArray = this.getYValuesClone();
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = n3;
                        dArray2[n4] = dArray2[n4] + (double)rectangle.x;
                        int n5 = n3++;
                        dArray[n5] = dArray[n5] + (double)rectangle.y;
                    }
                } else {
                    dArray2 = this.getXValues();
                    dArray = this.getYValues();
                }
            } else {
                dArray2 = this.getXValues();
                dArray = this.getYValues();
            }
            return new IlvIMapArea(dArray2, dArray, n2, ilvIMapAttributes);
        }
    }

    abstract class DrawItemAction
    implements ItemAction {
        Graphics a;

        DrawItemAction() {
        }

        public void startProcessItems() {
        }

        public void endProcessItems() {
        }

        public final Graphics getGraphics() {
            return this.a;
        }

        public void setGraphics(Graphics graphics) {
            this.a = graphics;
        }

        public void processItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            this.drawItem(points, n2, item, ilvStyle);
        }

        protected abstract void drawItem(Points var1, int var2, Item var3, IlvStyle var4);
    }

    class ImageMapItemAction
    implements ItemAction {
        static final double a = 2.0;
        IlvIMapDefinition b;
        List c;

        ImageMapItemAction(IlvIMapDefinition ilvIMapDefinition, List list) {
            this.b = ilvIMapDefinition;
            this.c = list;
        }

        public void startProcessItems() {
        }

        public void endProcessItems() {
        }

        public void processItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            IlvIMapArea ilvIMapArea;
            IlvDataSetPoint ilvDataSetPoint = points.a(n2);
            IlvIMapAttributes ilvIMapAttributes = this.b.getAttributes(ilvDataSetPoint);
            IlvIMapArea ilvIMapArea2 = ilvIMapArea = ilvIMapAttributes == null ? null : this.a(item, ilvStyle, ilvIMapAttributes);
            if (ilvIMapArea != null) {
                this.c.add(ilvIMapArea);
            }
        }

        IlvIMapArea a(Item item, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            return item.getMapArea(this.b, ilvStyle, ilvIMapAttributes);
        }
    }

    static interface Item {
        public void draw(Graphics var1, IlvStyle var2);

        public Rectangle2D getBounds(IlvStyle var1, Rectangle2D var2);

        public boolean contains(IlvStyle var1, double var2, double var4);

        public IlvIMapArea getMapArea(IlvIMapDefinition var1, IlvStyle var2, IlvIMapAttributes var3);
    }

    static interface ItemAction {
        public void startProcessItems();

        public void endProcessItems();

        public void processItem(Points var1, int var2, Item var3, IlvStyle var4);
    }

    abstract class ItemIterator {
        int a;
        int b = -1;
        Points c;
        boolean d;
        Double e;
        double f;

        public ItemIterator(Points points) {
            this.c = points;
            this.d = IlvSingleChartRenderer.this.s();
            this.e = points.getDataSet().getUndefValue();
            this.f = this.e != null ? this.e : 0.0;
        }

        public boolean hasNext() {
            return this.a();
        }

        public void next() {
            if (this.b >= this.c.size()) {
                throw new NoSuchElementException();
            }
            this.a = this.b;
        }

        public abstract Item getItem();

        public IlvStyle getStyle() {
            IlvDisplayPoint ilvDisplayPoint;
            IlvDataRenderingHint ilvDataRenderingHint;
            IlvStyle ilvStyle = IlvSingleChartRenderer.this.getStyle();
            if (this.d && (ilvDataRenderingHint = IlvSingleChartRenderer.this.b(ilvDisplayPoint = this.c.getDisplayPoint(this.getCurrentIdx()))) != null) {
                return ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
            }
            return ilvStyle;
        }

        public int getCurrentIdx() {
            return this.a;
        }

        public Points getPoints() {
            return this.c;
        }

        private boolean a() {
            double d2;
            do {
                if (++this.b >= this.c.size()) {
                    return false;
                }
                d2 = this.c.getYData(this.b);
            } while (this.e != null && d2 == this.f || Double.isNaN(d2));
            return true;
        }
    }

    private class MyChartListener
    implements PropertyChangeListener,
    Serializable {
        private MyChartListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == IlvSingleChartRenderer.this.getChart() && "defaultColors".equals(propertyChangeEvent.getPropertyName())) {
                IlvSingleChartRenderer.this.q();
            }
        }
    }

    private class MyDataSetListener
    implements DataSetListener,
    Serializable {
        DataSetContentsEvent a;
        boolean b;
        IlvIntIntervalSet c;

        private MyDataSetListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataSetContentsChanged(DataSetContentsEvent dataSetContentsEvent) {
            try {
                IlvSingleChartRenderer.this.g = this;
                IlvSingleChartRenderer.this.dataSetContentsChanged(dataSetContentsEvent);
            }
            finally {
                IlvSingleChartRenderer.this.g = null;
            }
        }

        void a(DataSetContentsEvent dataSetContentsEvent) {
            switch (dataSetContentsEvent.getType()) {
                case 6: {
                    this.b = true;
                    break;
                }
                default: {
                    if (this.c == null) {
                        this.c = new IlvIntIntervalSet();
                    }
                    this.c.add(dataSetContentsEvent.getFirstIdx(), dataSetContentsEvent.getLastIdx());
                }
            }
        }

        void a() {
            if (this.a != null) {
                IlvDataSet ilvDataSet = this.a.getDataSet();
                boolean bl = this.b;
                IlvIntIntervalSet ilvIntIntervalSet = this.c;
                this.a = null;
                this.b = false;
                this.c = null;
                if (bl) {
                    IlvSingleChartRenderer.this.a(new DataSetContentsEvent(ilvDataSet));
                } else if (ilvIntIntervalSet != null) {
                    Iterator<IlvIntInterval> iterator = ilvIntIntervalSet.intervalIterator();
                    while (iterator.hasNext()) {
                        IlvIntInterval ilvIntInterval = iterator.next();
                        IlvSingleChartRenderer.this.a(new DataSetContentsEvent(ilvDataSet, 3, ilvIntInterval.getFirst(), ilvIntInterval.getLast()));
                    }
                }
            }
        }

        public void dataSetPropertyChanged(DataSetPropertyEvent dataSetPropertyEvent) {
            IlvSingleChartRenderer.this.dataSetPropertyChanged(dataSetPropertyEvent);
        }
    }

    final class Points {
        private IlvDataPoints a;
        private boolean b = false;
        private IlvDataSet c;
        private IlvDoublePoints d;
        private boolean e;

        public Points(IlvDataPoints ilvDataPoints, boolean bl) {
            this.a = ilvDataPoints;
            this.c = ilvDataPoints.getDataSet();
            this.e = bl;
        }

        public final IlvChart getChart() {
            return IlvSingleChartRenderer.this.getChart();
        }

        public final IlvDataSet getDataSet() {
            return this.c;
        }

        final IlvDataSetPoint a(int n2) {
            IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint(this.getDataSet(), this.getDataIndex(n2));
            if (this.getDataSet() instanceof IlvVirtualDataSet) {
                ((IlvVirtualDataSet)this.getDataSet()).unmap(ilvDataSetPoint);
            }
            return ilvDataSetPoint;
        }

        final void a() {
            if (this.a != null) {
                if (this.e) {
                    this.d = new IlvDoublePoints();
                    this.d.add(this.a);
                    IlvSingleChartRenderer.this.toDisplay(this.d);
                } else {
                    IlvSingleChartRenderer.this.toDisplay(this.a);
                    this.d = this.a;
                }
            }
            this.b = true;
        }

        public final void addData(double d2, double d3, int n2) {
            this.a.add(d2, d3, n2);
        }

        public final void addData(double[] dArray, double[] dArray2, int[] nArray, int n2) {
            this.a.add(dArray, dArray2, nArray, n2);
        }

        public final void addData(int n2, double[] dArray, double[] dArray2, int[] nArray, int n3) {
            this.a.add(n2, dArray, dArray2, nArray, n3);
        }

        public final void addData(int n2, double d2, double d3, int n3) {
            this.a.add(n2, new double[]{d2}, new double[]{d3}, new int[]{n3}, 1);
        }

        void b() {
            if (this.a != null) {
                this.a.dispose();
            }
            if (this.d != null && this.d != this.a) {
                this.d.dispose();
            }
        }

        IlvDataPoints c() {
            return this.isProjected() && !this.e ? null : this.a;
        }

        IlvDoublePoints d() {
            return this.d;
        }

        public final boolean isProjected() {
            return this.d != null;
        }

        public final int[] getIndices() {
            return this.a.getIndices();
        }

        public int size() {
            return this.a == null ? 0 : this.a.size();
        }

        public final int getDataIndex(int n2) {
            return this.a.getIndices()[n2];
        }

        public final double[] getXCoords() {
            if (!this.isProjected()) {
                this.a();
            }
            return this.d.getXValues();
        }

        public final double[] getYCoords() {
            if (!this.isProjected()) {
                this.a();
            }
            return this.d.getYValues();
        }

        public final double getXCoord(int n2) {
            return this.getXCoords()[n2];
        }

        public final double getYCoord(int n2) {
            return this.getYCoords()[n2];
        }

        public final IlvDisplayPoint getDisplayPoint(int n2) {
            return this.getDisplayPoint(n2, false, true);
        }

        public final IlvDisplayPoint getDisplayPoint(int n2, boolean bl, boolean bl2) {
            double d2 = bl2 ? this.getXCoord(n2) : 0.0;
            double d3 = bl2 ? this.getYCoord(n2) : 0.0;
            IlvDisplayPoint ilvDisplayPoint = new IlvDisplayPoint(IlvSingleChartRenderer.this, this.c, this.getDataIndex(n2), d2, d3);
            if (bl && this.c instanceof IlvVirtualDataSet) {
                ((IlvVirtualDataSet)this.c).unmap(ilvDisplayPoint);
            }
            return ilvDisplayPoint;
        }

        public final double[] getXData() {
            if (this.isProjected()) {
                if (this.e) {
                    return this.a.getXValues();
                }
                int[] nArray = this.getIndices();
                int n2 = this.size();
                double[] dArray = new double[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    dArray[i2] = this.c.getXData(nArray[i2]);
                }
                return dArray;
            }
            return this.a.getXValues();
        }

        public final double[] getYData() {
            if (this.b) {
                if (this.e) {
                    return this.a.getYValues();
                }
                int[] nArray = this.getIndices();
                int n2 = this.size();
                double[] dArray = new double[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    dArray[i2] = this.c.getYData(nArray[i2]);
                }
                return dArray;
            }
            return this.a.getYValues();
        }

        public final double getXData(int n2) {
            return this.isProjected() && !this.e ? this.c.getXData(this.getDataIndex(n2)) : this.a.getX(n2);
        }

        public final double getYData(int n2) {
            return this.isProjected() && !this.e ? this.c.getYData(this.getDataIndex(n2)) : this.a.getY(n2);
        }

        public String toString() {
            if (this.a != null) {
                return this.a.toString();
            }
            return null;
        }
    }
}

