/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer.internal;

import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.event.DataSetContentsEvent;
import ilog.views.chart.event.DataSetPropertyEvent;
import ilog.views.chart.renderer.internal.IlvVirtualDataSet;

public class IlvHiLoDataSet
extends IlvVirtualDataSet {
    IlvHiLoDataSet() {
        this.setMaxDataSetCount(2);
    }

    public IlvHiLoDataSet(IlvDataSet ilvDataSet, IlvDataSet ilvDataSet2) {
        this();
        this.addDataSet(ilvDataSet);
        this.addDataSet(ilvDataSet2);
    }

    public String getName() {
        if (this.getDataSetCount() == 2) {
            return this.getDataSet(0).getName() + " - " + this.getDataSet(1).getName();
        }
        return "";
    }

    public Double getUndefValue() {
        return null;
    }

    public double getYData(int n2) {
        int n3 = this.getDataSetCount();
        if (n3 < 2) {
            return 0.0;
        }
        IlvDataSet ilvDataSet = this.getDataSet(n2 % n3);
        double d2 = ilvDataSet.getYData(n2 / n3);
        Double d3 = ilvDataSet.getUndefValue();
        if (d3 != null && d2 == d3) {
            return Double.NaN;
        }
        return d2;
    }

    public double getXData(int n2) {
        int n3 = this.getDataSetCount();
        if (n3 < 2) {
            return 0.0;
        }
        return this.getDataSet(n2 % n3).getXData(n2 / n3);
    }

    public boolean isXValuesSorted() {
        return this.getDataSet(0) != null ? this.getDataSet(0).isXValuesSorted() : false;
    }

    public boolean isEditable() {
        return true;
    }

    public void map(IlvDataSetPoint ilvDataSetPoint) {
        int n2 = this.getDataSetIndex(ilvDataSetPoint.dataSet);
        if (n2 == -1) {
            throw new IllegalArgumentException("Unknown data set");
        }
        ilvDataSetPoint.index = ilvDataSetPoint.index * this.getDataSetCount() + n2;
        ilvDataSetPoint.dataSet = this;
    }

    public boolean mapsMonotonically() {
        return true;
    }

    public void unmap(IlvDataSetPoint ilvDataSetPoint) {
        int n2 = this.getDataSetCount();
        ilvDataSetPoint.dataSet = this.getDataSet(ilvDataSetPoint.index % n2);
        ilvDataSetPoint.index /= n2;
    }

    public void unmap(IlvDataSetPoint ilvDataSetPoint, IlvDoublePoint ilvDoublePoint) {
        this.unmap(ilvDataSetPoint);
    }

    public void dataSetContentsChanged(DataSetContentsEvent dataSetContentsEvent) {
        super.dataSetContentsChanged(dataSetContentsEvent);
        int n2 = this.getDataSetCount();
        DataSetContentsEvent dataSetContentsEvent2 = new DataSetContentsEvent(this, dataSetContentsEvent.getType(), dataSetContentsEvent.getFirstIdx() * n2, dataSetContentsEvent.getLastIdx() * n2);
        this.fireDataSetContentsEvent(dataSetContentsEvent2);
    }

    protected void dataSetPropertyChanged(DataSetPropertyEvent dataSetPropertyEvent) {
        this.fireDataSetPropertyEvent(dataSetPropertyEvent);
    }

    protected int computeDataCount() {
        int n2 = this.getDataSetCount();
        return n2 > 1 ? super.computeDataCount() * n2 : 0;
    }
}

