/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer.internal;

import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.renderer.internal.IlvAbstractIndexStackedDataSet;
import ilog.views.chart.util.IlvDoubleArray;

public class IlvIndexStacked100DataSet
extends IlvAbstractIndexStackedDataSet {
    private int a;

    public IlvIndexStacked100DataSet(int n2, IlvDataSet[] ilvDataSetArray, IlvIndexStacked100DataSet ilvIndexStacked100DataSet) {
        super(ilvIndexStacked100DataSet);
        this.a = n2;
        this.setDataSets(ilvDataSetArray);
    }

    protected IlvDataSet getRefDataSet() {
        return this.getDataSet(this.a);
    }

    public void setData(int n2, double d2, double d3) {
        if (d3 >= 100.0) {
            int n3 = this.getDataSetCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (i2 == this.a) continue;
                this.getDataSet(i2).setData(n2, d2, 0.0);
            }
        } else {
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            super.setData(n2, d2, d3);
        }
    }

    public void unmap(IlvDataSetPoint ilvDataSetPoint, IlvDoublePoint ilvDoublePoint) {
        this.unmap(ilvDataSetPoint);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = ilvDoublePoint.y;
        int n2 = this.getDataSetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Double d5;
            double d6;
            IlvDataSet ilvDataSet;
            if (i2 < this.a) {
                ilvDataSet = this.getDataSet(i2);
                d6 = ilvDataSet.getYData(ilvDataSetPoint.index);
                d5 = ilvDataSet.getUndefValue();
                if (d5 != null && d6 == d5 || Double.isNaN(d6)) continue;
                d2 += d6;
                continue;
            }
            if (i2 <= this.a) continue;
            ilvDataSet = this.getDataSet(i2);
            d6 = ilvDataSet.getYData(ilvDataSetPoint.index);
            d5 = ilvDataSet.getUndefValue();
            if (d5 != null && d6 == d5 || Double.isNaN(d6)) continue;
            d3 += d6;
        }
        ilvDoublePoint.y = Math.max(0.0, (d4 * (d2 + d3) - 100.0 * d2) / (100.0 - d4));
    }

    protected IlvDoubleArray computeStackedData(IlvDoubleArray ilvDoubleArray, int n2, int n3) {
        int n4;
        int n5 = this.getDataSetCount();
        int n6 = ilvDoubleArray.size();
        if (this.a == n5 - 1) {
            IlvDataSet ilvDataSet = this.getRefDataSet();
            Double d2 = ilvDataSet.getUndefValue();
            double d3 = d2 != null ? d2 : 0.0;
            for (int i2 = n2; i2 <= n3; ++i2) {
                double d4 = ilvDataSet.getYData(i2);
                double d5 = d2 != null && d4 == d3 || Double.isNaN(d4) ? Double.NaN : 100.0;
                if (i2 >= n6) {
                    ilvDoubleArray.add(d5);
                    continue;
                }
                ilvDoubleArray.set(i2, d5);
            }
            return ilvDoubleArray;
        }
        Double[] doubleArray = new Double[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            doubleArray[n4] = this.getDataSet(n4).getUndefValue();
        }
        for (n4 = n2; n4 <= n3; ++n4) {
            double d6 = 0.0;
            double d7 = 0.0;
            for (int i3 = 0; i3 < n5; ++i3) {
                double d8 = this.getDataSet(i3).getYData(n4);
                Double d9 = doubleArray[i3];
                if (d9 != null && d8 == d9 || Double.isNaN(d8)) {
                    if (i3 != n5 - 1) continue;
                    d6 = Double.NaN;
                    break;
                }
                d6 += d8;
                if (i3 > this.a) continue;
                d7 += d8;
            }
            double d10 = Double.isNaN(d6) ? Double.NaN : (d6 == 0.0 ? 0.0 : 100.0 * d7 / d6);
            if (n4 >= n6) {
                ilvDoubleArray.add(d10);
                continue;
            }
            ilvDoubleArray.set(n4, d10);
        }
        return ilvDoubleArray;
    }

    protected void computeLimits(IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
        this.getDataSet(this.a).getXRange(ilvDataInterval);
        ilvDataInterval2.set(0.0, 100.0);
    }
}

