/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.util.internal.IlvMathUtil;
import ilog.views.chart.view3d.Ilv3DVector;
import ilog.views.chart.view3d.IlvQuaternion;

public final class Ilv3DMatrix {
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Ilv3DMatrix() {
        this.setIdentity();
    }

    public Ilv3DMatrix(Ilv3DMatrix ilv3DMatrix) {
        this.set(ilv3DMatrix.m00, ilv3DMatrix.m01, ilv3DMatrix.m02, ilv3DMatrix.m03, ilv3DMatrix.m10, ilv3DMatrix.m11, ilv3DMatrix.m12, ilv3DMatrix.m13, ilv3DMatrix.m20, ilv3DMatrix.m21, ilv3DMatrix.m22, ilv3DMatrix.m23, ilv3DMatrix.m30, ilv3DMatrix.m31, ilv3DMatrix.m32, ilv3DMatrix.m33);
    }

    public Ilv3DMatrix(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        this.set(d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17);
    }

    public Ilv3DMatrix set(Ilv3DMatrix ilv3DMatrix) {
        return this.set(ilv3DMatrix.m00, ilv3DMatrix.m01, ilv3DMatrix.m02, ilv3DMatrix.m03, ilv3DMatrix.m10, ilv3DMatrix.m11, ilv3DMatrix.m12, ilv3DMatrix.m13, ilv3DMatrix.m20, ilv3DMatrix.m21, ilv3DMatrix.m22, ilv3DMatrix.m23, ilv3DMatrix.m30, ilv3DMatrix.m31, ilv3DMatrix.m32, ilv3DMatrix.m33);
    }

    public Ilv3DMatrix set(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m03 = d5;
        this.m10 = d6;
        this.m11 = d7;
        this.m12 = d8;
        this.m13 = d9;
        this.m20 = d10;
        this.m21 = d11;
        this.m22 = d12;
        this.m23 = d13;
        this.m30 = d14;
        this.m31 = d15;
        this.m32 = d16;
        this.m33 = d17;
        return this;
    }

    public Ilv3DMatrix copy() {
        return new Ilv3DMatrix(this);
    }

    public void set(IlvQuaternion ilvQuaternion) {
        double d2 = ilvQuaternion.x * ilvQuaternion.x;
        double d3 = ilvQuaternion.x * ilvQuaternion.y;
        double d4 = ilvQuaternion.x * ilvQuaternion.z;
        double d5 = ilvQuaternion.x * ilvQuaternion.w;
        double d6 = ilvQuaternion.y * ilvQuaternion.y;
        double d7 = ilvQuaternion.y * ilvQuaternion.z;
        double d8 = ilvQuaternion.y * ilvQuaternion.w;
        double d9 = ilvQuaternion.z * ilvQuaternion.z;
        double d10 = ilvQuaternion.z * ilvQuaternion.w;
        this.m00 = 1.0 - 2.0 * (d6 + d9);
        this.m01 = 2.0 * (d3 - d10);
        this.m02 = 2.0 * (d4 + d8);
        this.m10 = 2.0 * (d3 + d10);
        this.m11 = 1.0 - 2.0 * (d2 + d9);
        this.m12 = 2.0 * (d7 - d5);
        this.m20 = 2.0 * (d4 - d8);
        this.m21 = 2.0 * (d7 + d5);
        this.m22 = 1.0 - 2.0 * (d2 + d6);
        this.m33 = 1.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        this.m23 = 0.0;
        this.m13 = 0.0;
        this.m03 = 0.0;
    }

    public void rotX(double d2) {
        this.setIdentity();
        d2 = Math.toRadians(d2);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        this.m11 = d3;
        this.m12 = -d4;
        this.m21 = d4;
        this.m22 = d3;
    }

    public void rotY(double d2) {
        this.setIdentity();
        d2 = Math.toRadians(d2);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        this.m01 = d3;
        this.m02 = -d4;
        this.m11 = d4;
        this.m12 = d3;
    }

    public void rotZ(double d2) {
        this.setIdentity();
        d2 = Math.toRadians(d2);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        this.m00 = d3;
        this.m01 = -d4;
        this.m10 = d4;
        this.m11 = d3;
    }

    public Ilv3DMatrix setIdentity() {
        return this.set(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Ilv3DMatrix identity() {
        return new Ilv3DMatrix(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public void translate(double d2, double d3, double d4) {
        this.m03 += d2;
        this.m13 += d3;
        this.m23 += d4;
    }

    public Ilv3DMatrix scale(double d2) {
        return this.scale(d2, d2, d2);
    }

    public Ilv3DMatrix scale(double d2, double d3, double d4) {
        this.m00 *= d2;
        this.m01 *= d2;
        this.m02 *= d2;
        this.m03 *= d2;
        this.m10 *= d3;
        this.m11 *= d3;
        this.m12 *= d3;
        this.m13 *= d3;
        this.m20 *= d4;
        this.m21 *= d4;
        this.m22 *= d4;
        this.m23 *= d4;
        return this;
    }

    public Ilv3DMatrix mult(double d2, Ilv3DMatrix ilv3DMatrix) {
        if (ilv3DMatrix == null) {
            ilv3DMatrix = new Ilv3DMatrix();
        }
        return ilv3DMatrix.set(this.m00 * d2, this.m01 * d2, this.m02 * d2, this.m03 * d2, this.m10 * d2, this.m11 * d2, this.m12 * d2, this.m13 * d2, this.m20 * d2, this.m21 * d2, this.m22 * d2, this.m23 * d2, this.m30 * d2, this.m31 * d2, this.m32 * d2, this.m33 * d2);
    }

    public Ilv3DMatrix mult(Ilv3DMatrix ilv3DMatrix, Ilv3DMatrix ilv3DMatrix2) {
        if (ilv3DMatrix2 == null) {
            ilv3DMatrix2 = new Ilv3DMatrix();
        }
        return ilv3DMatrix2.set(this.m00 * ilv3DMatrix.m00 + this.m01 * ilv3DMatrix.m10 + this.m02 * ilv3DMatrix.m20 + this.m03 * ilv3DMatrix.m30, this.m00 * ilv3DMatrix.m01 + this.m01 * ilv3DMatrix.m11 + this.m02 * ilv3DMatrix.m21 + this.m03 * ilv3DMatrix.m31, this.m00 * ilv3DMatrix.m02 + this.m01 * ilv3DMatrix.m12 + this.m02 * ilv3DMatrix.m22 + this.m03 * ilv3DMatrix.m32, this.m00 * ilv3DMatrix.m03 + this.m01 * ilv3DMatrix.m13 + this.m02 * ilv3DMatrix.m23 + this.m03 * ilv3DMatrix.m33, this.m10 * ilv3DMatrix.m00 + this.m11 * ilv3DMatrix.m10 + this.m12 * ilv3DMatrix.m20 + this.m13 * ilv3DMatrix.m30, this.m10 * ilv3DMatrix.m01 + this.m11 * ilv3DMatrix.m11 + this.m12 * ilv3DMatrix.m21 + this.m13 * ilv3DMatrix.m31, this.m10 * ilv3DMatrix.m02 + this.m11 * ilv3DMatrix.m12 + this.m12 * ilv3DMatrix.m22 + this.m13 * ilv3DMatrix.m32, this.m10 * ilv3DMatrix.m03 + this.m11 * ilv3DMatrix.m13 + this.m12 * ilv3DMatrix.m23 + this.m13 * ilv3DMatrix.m33, this.m20 * ilv3DMatrix.m00 + this.m21 * ilv3DMatrix.m10 + this.m22 * ilv3DMatrix.m20 + this.m23 * ilv3DMatrix.m30, this.m20 * ilv3DMatrix.m01 + this.m21 * ilv3DMatrix.m11 + this.m22 * ilv3DMatrix.m21 + this.m23 * ilv3DMatrix.m31, this.m20 * ilv3DMatrix.m02 + this.m21 * ilv3DMatrix.m12 + this.m22 * ilv3DMatrix.m22 + this.m23 * ilv3DMatrix.m32, this.m20 * ilv3DMatrix.m03 + this.m21 * ilv3DMatrix.m13 + this.m22 * ilv3DMatrix.m23 + this.m23 * ilv3DMatrix.m33, this.m30 * ilv3DMatrix.m00 + this.m31 * ilv3DMatrix.m10 + this.m32 * ilv3DMatrix.m20 + this.m33 * ilv3DMatrix.m30, this.m30 * ilv3DMatrix.m01 + this.m31 * ilv3DMatrix.m11 + this.m32 * ilv3DMatrix.m21 + this.m33 * ilv3DMatrix.m31, this.m30 * ilv3DMatrix.m02 + this.m31 * ilv3DMatrix.m12 + this.m32 * ilv3DMatrix.m22 + this.m33 * ilv3DMatrix.m32, this.m30 * ilv3DMatrix.m03 + this.m31 * ilv3DMatrix.m13 + this.m32 * ilv3DMatrix.m23 + this.m33 * ilv3DMatrix.m33);
    }

    public double determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * (this.m22 * this.m33 - this.m23 * this.m32) - (this.m00 * this.m12 - this.m02 * this.m10) * (this.m21 * this.m33 - this.m23 * this.m31) + (this.m00 * this.m13 - this.m03 * this.m10) * (this.m21 * this.m32 - this.m22 * this.m31) + (this.m01 * this.m12 - this.m02 * this.m11) * (this.m20 * this.m33 - this.m23 * this.m30) - (this.m01 * this.m13 - this.m03 * this.m11) * (this.m20 * this.m32 - this.m22 * this.m30) + (this.m02 * this.m13 - this.m03 * this.m12) * (this.m20 * this.m31 - this.m21 * this.m30);
    }

    public Ilv3DMatrix invert(Ilv3DMatrix ilv3DMatrix) {
        double d2;
        if (ilv3DMatrix == null) {
            ilv3DMatrix = new Ilv3DMatrix();
        }
        if (IlvMathUtil.isNear0(d2 = this.determinant())) {
            return null;
        }
        ilv3DMatrix.set(this.m11 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m12 * (this.m23 * this.m31 - this.m21 * this.m33) + this.m13 * (this.m21 * this.m32 - this.m22 * this.m31), this.m21 * (this.m02 * this.m33 - this.m03 * this.m32) + this.m22 * (this.m03 * this.m31 - this.m01 * this.m33) + this.m23 * (this.m01 * this.m32 - this.m02 * this.m31), this.m31 * (this.m02 * this.m13 - this.m03 * this.m12) + this.m32 * (this.m03 * this.m11 - this.m01 * this.m13) + this.m33 * (this.m01 * this.m12 - this.m02 * this.m11), this.m01 * (this.m13 * this.m22 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m13 * this.m21) + this.m03 * (this.m12 * this.m21 - this.m11 * this.m22), this.m12 * (this.m20 * this.m33 - this.m23 * this.m30) + this.m13 * (this.m22 * this.m30 - this.m20 * this.m32) + this.m10 * (this.m23 * this.m32 - this.m22 * this.m33), this.m22 * (this.m00 * this.m33 - this.m03 * this.m30) + this.m23 * (this.m02 * this.m30 - this.m00 * this.m32) + this.m20 * (this.m03 * this.m32 - this.m02 * this.m33), this.m32 * (this.m00 * this.m13 - this.m03 * this.m10) + this.m33 * (this.m02 * this.m10 - this.m00 * this.m12) + this.m30 * (this.m03 * this.m12 - this.m02 * this.m13), this.m02 * (this.m13 * this.m20 - this.m10 * this.m23) + this.m03 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m00 * (this.m12 * this.m23 - this.m13 * this.m22), this.m13 * (this.m20 * this.m31 - this.m21 * this.m30) + this.m10 * (this.m21 * this.m33 - this.m23 * this.m31) + this.m11 * (this.m23 * this.m30 - this.m20 * this.m33), this.m23 * (this.m00 * this.m31 - this.m01 * this.m30) + this.m20 * (this.m01 * this.m33 - this.m03 * this.m31) + this.m21 * (this.m03 * this.m30 - this.m00 * this.m33), this.m33 * (this.m00 * this.m11 - this.m01 * this.m10) + this.m30 * (this.m01 * this.m13 - this.m03 * this.m11) + this.m31 * (this.m03 * this.m10 - this.m00 * this.m13), this.m03 * (this.m11 * this.m20 - this.m10 * this.m21) + this.m00 * (this.m13 * this.m21 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m13 * this.m20), this.m10 * (this.m22 * this.m31 - this.m21 * this.m32) + this.m11 * (this.m20 * this.m32 - this.m22 * this.m30) + this.m12 * (this.m21 * this.m30 - this.m20 * this.m31), this.m20 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m21 * (this.m00 * this.m32 - this.m02 * this.m30) + this.m22 * (this.m01 * this.m30 - this.m00 * this.m31), this.m30 * (this.m02 * this.m11 - this.m01 * this.m12) + this.m31 * (this.m00 * this.m12 - this.m02 * this.m10) + this.m32 * (this.m01 * this.m10 - this.m00 * this.m11), this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20));
        return ilv3DMatrix.mult(1.0 / d2, ilv3DMatrix);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Ilv3DMatrix) {
            Ilv3DMatrix ilv3DMatrix = (Ilv3DMatrix)object;
            return ilv3DMatrix.m00 == this.m00 && ilv3DMatrix.m01 == this.m01 && ilv3DMatrix.m02 == this.m02 && ilv3DMatrix.m03 == this.m03 && ilv3DMatrix.m10 == this.m10 && ilv3DMatrix.m11 == this.m11 && ilv3DMatrix.m12 == this.m12 && ilv3DMatrix.m13 == this.m13 && ilv3DMatrix.m20 == this.m20 && ilv3DMatrix.m21 == this.m21 && ilv3DMatrix.m22 == this.m22 && ilv3DMatrix.m23 == this.m23 && ilv3DMatrix.m30 == this.m30 && ilv3DMatrix.m31 == this.m31 && ilv3DMatrix.m32 == this.m32 && ilv3DMatrix.m33 == this.m33;
        }
        return false;
    }

    public void transform(Ilv3DVector ilv3DVector) {
        double d2 = ilv3DVector.x;
        double d3 = ilv3DVector.y;
        double d4 = ilv3DVector.z;
        ilv3DVector.x = d2 * this.m00 + d3 * this.m01 + d4 * this.m02 + this.m03;
        ilv3DVector.y = d2 * this.m10 + d3 * this.m11 + d4 * this.m12 + this.m13;
        ilv3DVector.z = d2 * this.m20 + d3 * this.m21 + d4 * this.m22 + this.m23;
    }

    public Ilv3DVector transform(Ilv3DVector ilv3DVector, Ilv3DVector ilv3DVector2) {
        double d2 = ilv3DVector.x;
        double d3 = ilv3DVector.y;
        double d4 = ilv3DVector.z;
        if (ilv3DVector2 == null) {
            ilv3DVector2 = new Ilv3DVector();
        }
        ilv3DVector2.x = d2 * this.m00 + d3 * this.m01 + d4 * this.m02 + this.m03;
        ilv3DVector2.y = d2 * this.m10 + d3 * this.m11 + d4 * this.m12 + this.m13;
        ilv3DVector2.z = d2 * this.m20 + d3 * this.m21 + d4 * this.m22 + this.m23;
        return ilv3DVector2;
    }

    public void transform(Ilv3DVector[] ilv3DVectorArray, Ilv3DVector[] ilv3DVectorArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Ilv3DVector ilv3DVector = ilv3DVectorArray[i2];
            double d2 = ilv3DVector.x;
            double d3 = ilv3DVector.y;
            double d4 = ilv3DVector.z;
            ilv3DVector = ilv3DVectorArray2[i2];
            ilv3DVector.x = d2 * this.m00 + d3 * this.m01 + d4 * this.m02 + this.m03;
            ilv3DVector.y = d2 * this.m10 + d3 * this.m11 + d4 * this.m12 + this.m13;
            ilv3DVector.z = d2 * this.m20 + d3 * this.m21 + d4 * this.m22 + this.m23;
        }
    }

    public String toString() {
        return "[" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + "\n " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + "\n " + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + "\n " + this.m30 + ", " + this.m31 + ", " + this.m32 + ", " + this.m33 + "]";
    }
}

