/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.view3d.Ilv3DBounds;
import ilog.views.chart.view3d.Ilv3DObject;
import ilog.views.chart.view3d.Ilv3DTransform;
import ilog.views.chart.view3d.Ilv3DVector;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ilv3DScene {
    private static final int a = 2;
    static final int b = -1;
    public static final int WIREFRAME = 0;
    public static final int SOLID = 1;
    public static final int SHADING = 2;
    protected boolean transfoValid = false;
    protected boolean tObjectsValid = false;
    protected boolean sortValid = false;
    private Rectangle2D c = new Rectangle2D.Double();
    private double d = 0.0;
    private double e = 0.0;
    private Ilv3DVector f = new Ilv3DVector(0.0, 0.0, 1.0);
    private float g = 0.1f;
    private int h = 2;
    private Ilv3DTransform i;
    protected ArrayList<Ilv3DObject> objects = new ArrayList();

    public Ilv3DScene() {
        this.i = new Ilv3DTransform(this);
    }

    public void addObject(Ilv3DObject ilv3DObject) {
        this.addObject(ilv3DObject, false);
    }

    public void addObject(Ilv3DObject ilv3DObject, boolean bl) {
        if (ilv3DObject == null) {
            throw new IllegalArgumentException("Null Object");
        }
        this.objects.add(ilv3DObject);
        if (bl) {
            ilv3DObject.applyTransform(this.getValidatedTransform(), 1);
        }
        this.contentsChanged();
    }

    public void clearObjects() {
        this.objects.clear();
        this.contentsChanged();
    }

    public void removeObjects(Collection<Ilv3DObject> collection) {
        if (this.objects.removeAll(collection)) {
            this.contentsChanged();
        }
    }

    public void removeObject(Ilv3DObject ilv3DObject) {
        if (this.objects.remove(ilv3DObject)) {
            this.contentsChanged();
        }
    }

    protected void contentsChanged() {
        this.sortValid = false;
    }

    public Ilv3DVector getLightVector() {
        return this.f;
    }

    private void a(double d2, double d3) {
        d2 = Math.toRadians(d2);
        d3 = Math.toRadians(d3);
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d3);
        double d7 = Math.cos(d3);
        double d8 = d6 * d5;
        double d9 = d4;
        double d10 = d7 * d5;
        this.f.set(d8, -d9, d10);
    }

    public void setLightLatitude(double d2) {
        if (d2 != this.d) {
            this.d = d2;
            this.a(d2, this.getLightLongitude());
        }
    }

    public final double getLightLatitude() {
        return this.d;
    }

    public void setLightLongitude(double d2) {
        if (d2 != this.e) {
            this.e = d2;
            this.a(this.getLightLatitude(), d2);
        }
    }

    public final double getLightLongitude() {
        return this.e;
    }

    public void setAmbientLight(float f2) {
        this.g = f2;
    }

    public final float getAmbientLight() {
        return this.g;
    }

    public void setRenderingMode(int n2) {
        this.h = n2;
    }

    public final int getRenderingMode() {
        return this.h;
    }

    public Ilv3DObject contains(double d2, double d3) {
        int n2 = this.objects.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            Ilv3DObject ilv3DObject = this.objects.get(i2);
            if (!ilv3DObject.contains(d2, d3)) continue;
            return ilv3DObject;
        }
        return null;
    }

    protected Comparator<Ilv3DObject> getObjectComparator() {
        return new DefaultComparator();
    }

    protected void updateScene() {
        Ilv3DTransform ilv3DTransform = this.getValidatedTransform();
        if (!this.tObjectsValid) {
            int n2 = this.objects.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.objects.get(i2).applyTransform(ilv3DTransform, 1);
            }
            this.tObjectsValid = true;
        }
        if (!this.sortValid) {
            this.sortObjects();
        }
    }

    protected void drawContent(Graphics graphics) {
        boolean bl;
        int n2 = this.objects.size();
        if (n2 == 0) {
            return;
        }
        Rectangle2D rectangle2D = null;
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl2 = bl = rectangle != null;
        if (bl) {
            boolean bl3 = bl = (double)(2 * rectangle.width * rectangle.height) < this.c.getWidth() * this.c.getHeight();
        }
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Ilv3DObject ilv3DObject = this.objects.get(i2);
                rectangle2D = ilv3DObject.getBounds(true, null).getXYBounds(rectangle2D);
                if (!rectangle.intersects(rectangle2D)) continue;
                ilv3DObject.draw(graphics);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                Ilv3DObject ilv3DObject = this.objects.get(i3);
                ilv3DObject.draw(graphics);
            }
        }
    }

    public synchronized void draw(Graphics graphics) {
        this.updateScene();
        this.drawContent(graphics);
    }

    protected void sortObjects() {
        Collections.sort(this.objects, this.getObjectComparator());
        this.sortValid = true;
    }

    public void setScreenPort(double d2, double d3, double d4, double d5) {
        if (this.c.getX() == d2 && this.c.getY() == d3 && this.c.getWidth() == d4 && this.c.getHeight() == d5) {
            return;
        }
        this.c.setRect(d2, d3, d4, d5);
        this.invalidateTransform();
    }

    public Rectangle2D getScreenPort() {
        return this.c;
    }

    public final double getScreenCenterX() {
        return this.c.getX() + this.c.getWidth() / 2.0;
    }

    public final double getScreenCenterY() {
        return this.c.getY() + this.c.getHeight() / 2.0;
    }

    public void setPerspective(int n2) {
        if (n2 != this.i.getPerspective()) {
            this.i.setPerspective(n2);
            this.invalidateTransform();
        }
    }

    public final int getPerspective() {
        return this.i.getPerspective();
    }

    public void setProjectionType(int n2) {
        if (n2 != this.i.getProjectionType()) {
            this.i.setProjectionType(n2);
            this.invalidateTransform();
        }
    }

    public final int getProjectionType() {
        return this.i.getProjectionType();
    }

    public void invalidateTransform() {
        this.transfoValid = false;
        this.tObjectsValid = false;
        this.sortValid = false;
    }

    protected void updateTransform() {
        this.adjustViewTransform();
        this.adjustScreenTransform();
    }

    protected void adjustViewTransform() {
    }

    protected void adjustScreenTransform() {
    }

    public final Ilv3DTransform getTransform() {
        return this.i;
    }

    public final Ilv3DTransform getValidatedTransform() {
        if (!this.transfoValid) {
            this.updateTransform();
            this.transfoValid = true;
        }
        return this.i;
    }

    protected Ilv3DBounds computeBounds(boolean bl, Ilv3DBounds ilv3DBounds) {
        ilv3DBounds.empty();
        Ilv3DBounds ilv3DBounds2 = null;
        int n2 = this.objects.size();
        while (--n2 >= 0) {
            Ilv3DObject ilv3DObject = this.objects.get(n2);
            if (bl) {
                ilv3DObject.applyTransform(this.getTransform(), 0);
            }
            ilv3DBounds2 = ilv3DObject.getBounds(bl, ilv3DBounds2);
            ilv3DBounds.add(ilv3DBounds2);
        }
        return ilv3DBounds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultComparator
    implements Comparator<Ilv3DObject> {
        private DefaultComparator() {
        }

        @Override
        public int compare(Ilv3DObject ilv3DObject, Ilv3DObject ilv3DObject2) {
            Ilv3DVector ilv3DVector = ilv3DObject.getCenter(true);
            Ilv3DVector ilv3DVector2 = ilv3DObject2.getCenter(true);
            double d2 = ilv3DVector.z - ilv3DVector2.z;
            return d2 > 0.0 ? 1 : (d2 < 0.0 ? -1 : 0);
        }
    }
}

