/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.util.internal.IlvMathUtil;
import ilog.views.chart.view3d.Ilv3DMatrix;
import ilog.views.chart.view3d.Ilv3DScene;
import ilog.views.chart.view3d.Ilv3DVector;
import ilog.views.chart.view3d.IlvQuaternion;

public final class Ilv3DTransform {
    public static final int ORTHOGRAPHIC = 0;
    public static final int OBLIQUE = 1;
    public static final int VIEW = 0;
    public static final int SCREEN = 1;
    private transient boolean a;
    private transient boolean b;
    private double c;
    private double d;
    private double e;
    private Ilv3DMatrix f = new Ilv3DMatrix();
    private Ilv3DMatrix g = new Ilv3DMatrix();
    private Ilv3DMatrix h = new Ilv3DMatrix();
    private Ilv3DMatrix i = new Ilv3DMatrix();
    private Ilv3DMatrix j = new Ilv3DMatrix();
    private Ilv3DMatrix k = new Ilv3DMatrix();
    private Ilv3DMatrix l = new Ilv3DMatrix();
    private int m = 0;
    private int n = 0;
    private double o = 0.0;
    private Ilv3DScene p;

    public Ilv3DTransform(Ilv3DScene ilv3DScene) {
        this.p = ilv3DScene;
    }

    public void setRotation(double d2, double d3, double d4) {
        if (d2 != this.c || d3 != this.d || d4 != this.e) {
            this.c = d2;
            this.d = d3;
            this.e = d4;
            this.a();
        }
    }

    private void a() {
        double d2 = this.c;
        double d3 = this.d;
        double d4 = this.e;
        if (this.isOblique()) {
            d2 = IlvMathUtil.clamp(d2, -45.0, 45.0);
            d3 = IlvMathUtil.clamp(d3, -45.0, 45.0);
        }
        IlvQuaternion ilvQuaternion = new IlvQuaternion(Ilv3DVector.a, -d2, false);
        ilvQuaternion.mult(new IlvQuaternion(Ilv3DVector.b, -d3, false));
        ilvQuaternion.mult(new IlvQuaternion(Ilv3DVector.c, -d4, false));
        this.f.set(ilvQuaternion);
        this.b = false;
        this.a = false;
    }

    public void setXRotation(double d2) {
        this.setRotation(d2, this.d, this.e);
    }

    public double getXRotation() {
        return this.c;
    }

    public void setYRotation(double d2) {
        this.setRotation(this.c, d2, this.e);
    }

    public double getYRotation() {
        return this.d;
    }

    public void setZRotation(double d2) {
        this.setRotation(this.c, this.d, d2);
    }

    public double getZRotation() {
        return this.e;
    }

    public void setScale(double d2, double d3, double d4) {
        this.g.setIdentity();
        this.g.scale(d2, d3, d4);
        this.b = false;
        this.a = false;
    }

    public void setTranslation(double d2, double d3, double d4) {
        this.h.setIdentity();
        this.h.translate(d2, d3, d4);
        this.b = false;
        this.a = false;
    }

    public boolean isModified() {
        return !this.b;
    }

    public Ilv3DMatrix getRotation() {
        return this.f;
    }

    public Ilv3DMatrix getScale() {
        return this.g;
    }

    public Ilv3DMatrix getTranslation() {
        return this.h;
    }

    public Ilv3DMatrix getMatrix() {
        if (!this.b) {
            this.b();
        }
        return this.k;
    }

    public Ilv3DMatrix getInvertMatrix() {
        if (!this.b) {
            this.b();
        }
        return this.l;
    }

    private void b() {
        this.k = this.getScreenMatrix().mult(this.getViewMatrix(), this.k);
        this.l = this.k.invert(this.l);
        this.b = true;
    }

    public Ilv3DMatrix getViewMatrix() {
        if (!this.a) {
            this.a = true;
            if (this.isOblique()) {
                this.i.setIdentity();
                double d2 = Math.toRadians(this.c);
                double d3 = Math.toRadians(this.d);
                this.i.m02 = -Math.sin(d3) / 2.0;
                this.i.m12 = Math.sin(d2) / 2.0;
            } else {
                this.i.set(this.f);
            }
            this.i.mult(this.g, this.i);
            this.i.mult(this.h, this.i);
        }
        return this.i;
    }

    protected Ilv3DMatrix getScreenMatrix() {
        return this.j;
    }

    public void setScreenMatrix(Ilv3DMatrix ilv3DMatrix) {
        this.j = ilv3DMatrix;
        this.b = false;
    }

    public Ilv3DScene getScene() {
        return this.p;
    }

    public void setPerspective(int n2) {
        this.n = n2;
    }

    public int getPerspective() {
        return this.n;
    }

    public void setScreenDist(double d2) {
        this.o = d2;
    }

    public double getScreenDist() {
        return this.o;
    }

    public void setProjectionType(int n2) {
        if (n2 != this.m) {
            this.m = n2;
            this.a();
        }
    }

    public final int getProjectionType() {
        return this.m;
    }

    public final boolean isOblique() {
        return this.m == 1;
    }

    public boolean isUsingPerspective() {
        return !this.isOblique() && this.getPerspective() > 0;
    }

    public void transform(int n2, Ilv3DVector ilv3DVector) {
        Ilv3DMatrix ilv3DMatrix = this.a(n2);
        ilv3DMatrix.transform(ilv3DVector);
        if (n2 == 1 && this.isUsingPerspective()) {
            this.a(ilv3DVector);
        }
    }

    public Ilv3DVector transform(int n2, Ilv3DVector ilv3DVector, Ilv3DVector ilv3DVector2) {
        Ilv3DMatrix ilv3DMatrix = this.a(n2);
        ilv3DVector2 = ilv3DMatrix.transform(ilv3DVector, ilv3DVector2);
        if (n2 == 1 && this.isUsingPerspective()) {
            this.a(ilv3DVector2);
        }
        return ilv3DVector2;
    }

    public void transform(int n2, Ilv3DVector[] ilv3DVectorArray, Ilv3DVector[] ilv3DVectorArray2, int n3) {
        Ilv3DMatrix ilv3DMatrix = this.a(n2);
        ilv3DMatrix.transform(ilv3DVectorArray, ilv3DVectorArray2, n3);
        if (n2 == 1 && this.isUsingPerspective()) {
            this.a(ilv3DVectorArray2, n3);
        }
    }

    private void a(Ilv3DVector ilv3DVector) {
        double d2 = this.getScreenDist() / ilv3DVector.z;
        ilv3DVector.x = this.getScene().getScreenCenterX() + ilv3DVector.x * d2;
        ilv3DVector.y = this.getScene().getScreenCenterY() + ilv3DVector.y * d2;
    }

    private void a(Ilv3DVector[] ilv3DVectorArray, int n2) {
        double d2 = this.getScene().getScreenCenterX();
        double d3 = this.getScene().getScreenCenterY();
        for (int i2 = 0; i2 < n2; ++i2) {
            Ilv3DVector ilv3DVector = ilv3DVectorArray[i2];
            double d4 = this.getScreenDist() / ilv3DVector.z;
            ilv3DVector.x = d2 + ilv3DVector.x * d4;
            ilv3DVector.y = d3 + ilv3DVector.y * d4;
        }
    }

    private Ilv3DMatrix a(int n2) {
        return n2 == 0 ? this.getViewMatrix() : this.getMatrix();
    }
}

