/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.view3d.Ilv3DBounds;
import ilog.views.chart.view3d.Ilv3DObject;
import ilog.views.chart.view3d.Ilv3DScene;
import ilog.views.chart.view3d.Ilv3DTransform;
import ilog.views.chart.view3d.Ilv3DUtil;
import ilog.views.chart.view3d.Ilv3DVector;

public abstract class IlvAbstract3DObject
extends Ilv3DObject {
    protected Ilv3DVector[] vtx;
    protected Ilv3DVector[] vtxT;
    protected Ilv3DVector center = new Ilv3DVector();
    protected Ilv3DVector centerT = new Ilv3DVector();

    public IlvAbstract3DObject(Ilv3DScene ilv3DScene) {
        super(ilv3DScene);
    }

    protected void setVertices(Ilv3DVector[] ilv3DVectorArray, Ilv3DVector ilv3DVector) {
        this.vtx = ilv3DVectorArray;
        if (ilv3DVectorArray == null) {
            this.vtxT = null;
        } else {
            int n2 = ilv3DVectorArray.length;
            this.vtxT = new Ilv3DVector[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.vtxT[i2] = new Ilv3DVector(ilv3DVectorArray[i2]);
            }
            if (ilv3DVector == null) {
                this.computeCenter();
            } else {
                this.center = ilv3DVector;
            }
            this.centerT = this.center.copy();
        }
    }

    public final Ilv3DVector[] getVertices() {
        return this.vtx;
    }

    public final Ilv3DVector[] getVerticesT() {
        return this.vtxT;
    }

    public Ilv3DVector getCenter(boolean bl) {
        return bl ? this.centerT : this.center;
    }

    public void applyTransform(Ilv3DTransform ilv3DTransform, int n2) {
        ilv3DTransform.transform(n2, this.vtx, this.vtxT, this.vtx.length);
        this.centerT = ilv3DTransform.transform(n2, this.center, this.centerT);
    }

    public Ilv3DBounds getBounds(boolean bl, Ilv3DBounds ilv3DBounds) {
        Ilv3DVector[] ilv3DVectorArray;
        Ilv3DVector[] ilv3DVectorArray2 = ilv3DVectorArray = bl ? this.vtxT : this.vtx;
        if (ilv3DBounds == null) {
            return Ilv3DBounds.getBounds(ilv3DVectorArray);
        }
        return ilv3DBounds.compute(ilv3DVectorArray);
    }

    protected void computeCenter() {
        this.center = Ilv3DUtil.computeCenter(this.vtx, this.center);
    }

    String b() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" {");
        for (int i2 = 0; i2 < this.vtx.length; ++i2) {
            stringBuffer.append("\n  ");
            stringBuffer.append(this.vtx[i2]);
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + this.b();
    }
}

