/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.util.IlvDoubleArray;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvMathUtil;
import ilog.views.chart.view3d.Ilv3DBounds;
import ilog.views.chart.view3d.Ilv3DTransform;
import ilog.views.chart.view3d.Ilv3DVector;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.chart.view3d.IlvPolyhedron;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Arc2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;

public class IlvChart3DSlice
extends IlvChart3DObject {
    boolean a;
    boolean b;
    double c;
    double d;
    private int e;
    private int f;
    private int g;
    private int h;
    private Ilv3DVector i;
    private Ilv3DVector j;
    private Ilv3DVector k;
    private Ilv3DVector l;
    IlvChart3DSlice m;

    IlvChart3DSlice(IlvChart3DScene ilvChart3DScene, IlvSingleChartRenderer ilvSingleChartRenderer, int n2) {
        super(ilvChart3DScene, ilvSingleChartRenderer, n2);
    }

    public IlvChart3DSlice(IlvChart3DScene ilvChart3DScene, Point2D point2D, double d2, double d3, double d4, double d5, double[] dArray, IlvSingleChartRenderer ilvSingleChartRenderer, int n2) {
        this(ilvChart3DScene, ilvSingleChartRenderer, n2);
        if (d5 > d4 + 180.0) {
            this.m = new IlvChart3DSlice(ilvChart3DScene, ilvSingleChartRenderer, n2);
            this.m.a(point2D, d2, d3, d4 + 180.0, d5, dArray, false, true);
            d5 = d4 + 180.0;
        }
        this.a(point2D, d2, d3, d4, d5, dArray, true, this.m == null);
    }

    public final IlvChart3DSlice getNextSlice() {
        return this.m;
    }

    private void a(Point2D point2D, double d2, double d3, double d4, double d5, double[] dArray, boolean bl, boolean bl2) {
        double d6 = d5 - d4;
        this.a = bl;
        this.b = bl2;
        this.c = d4;
        this.d = d5;
        double d7 = Math.toRadians((d4 + d5) / 2.0);
        double d8 = (d2 + d3) / 2.0;
        this.i = new Ilv3DVector(point2D.getX() + d8 * Math.cos(d7), point2D.getY() - d8 * Math.sin(d7), dArray[0]);
        this.j = this.i.copy();
        this.k = new Ilv3DVector(point2D.getX() + d3 * Math.cos(d7), point2D.getY() - d3 * Math.sin(d7), dArray[0]);
        this.l = this.k.copy();
        double d9 = d3 / 400.0;
        int n2 = 8;
        IlvDoubleArray ilvDoubleArray = new IlvDoubleArray(16);
        IlvDoubleArray ilvDoubleArray2 = new IlvDoubleArray(16);
        if (d2 == 0.0) {
            Arc2D.Double double_ = new Arc2D.Double();
            double_.setArcByCenter(point2D.getX(), point2D.getY(), d3, d4, d6, 0);
            FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(double_.getPathIterator(null), d9, n2);
            IlvChart3DSlice.a(flatteningPathIterator, ilvDoubleArray, ilvDoubleArray2);
            ilvDoubleArray.add(point2D.getX());
            ilvDoubleArray2.add(point2D.getY());
            this.a(ilvDoubleArray.data(), ilvDoubleArray2.data(), ilvDoubleArray.size() - 1, 0, dArray);
        } else {
            Arc2D.Double double_ = new Arc2D.Double();
            double_.setArcByCenter(point2D.getX(), point2D.getY(), d2, d4 + d6, -d6, 0);
            FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(double_.getPathIterator(null), d9, n2);
            IlvChart3DSlice.a(flatteningPathIterator, ilvDoubleArray, ilvDoubleArray2);
            int n3 = ilvDoubleArray.size();
            double_.setArcByCenter(point2D.getX(), point2D.getY(), d3, d4, d6, 0);
            d9 = d2 / 600.0;
            flatteningPathIterator = new FlatteningPathIterator(double_.getPathIterator(null), d9, n2);
            IlvChart3DSlice.a(flatteningPathIterator, ilvDoubleArray, ilvDoubleArray2);
            int n4 = ilvDoubleArray.size() - n3;
            this.a(ilvDoubleArray.data(), ilvDoubleArray2.data(), n4, n3, dArray);
        }
    }

    protected void computeFacesNormal() {
        Ilv3DVector ilv3DVector;
        IlvPolyhedron.Face face;
        int n2;
        int n3 = this.faces.length;
        for (n2 = 0; n2 <= this.f; ++n2) {
            face = this.getFace(n2);
            ilv3DVector = this.a(face, null);
            face.a(ilv3DVector);
        }
        while (n2 <= this.h) {
            face = this.getFace(n2);
            ilv3DVector = this.a(face, null);
            face.a(ilv3DVector);
            ++n2;
        }
        while (n2 < n3) {
            face = this.getFace(n2);
            ilv3DVector = super.computeFaceNormal(face);
            face.a(ilv3DVector);
            ++n2;
        }
    }

    private void a(double[] dArray, double[] dArray2, int n2, int n3, double[] dArray3) {
        Object object;
        int n4 = n2 + (n3 == 0 ? 1 : n3);
        ArrayList<IlvPolyhedron.Face> arrayList = new ArrayList<IlvPolyhedron.Face>(n4);
        Ilv3DVector[] ilv3DVectorArray = new Ilv3DVector[2 * n4];
        double d2 = dArray3[0];
        double d3 = dArray3[1];
        int n5 = 0;
        int n6 = n4;
        while (n5 < n4) {
            ilv3DVectorArray[n5] = new Ilv3DVector(dArray[n5], dArray2[n5], d2);
            ilv3DVectorArray[n6] = new Ilv3DVector(dArray[n5], dArray2[n5], d3);
            ++n5;
            ++n6;
        }
        Ilv3DVector ilv3DVector = this.i.copy();
        ilv3DVector.z = (d2 + d3) / 2.0;
        this.setVertices(ilv3DVectorArray, ilv3DVector);
        this.e = 0;
        this.f = n3 - 2;
        this.g = n3 > 0 ? n3 - 1 : 0;
        this.h = this.g + n2 - 2;
        int n7 = n3 - 1;
        n6 = n5 + n4;
        for (n5 = 0; n5 < n7; ++n5) {
            object = new IlvPolyhedron.Face(this, new int[]{n5, n5 + 1, n6 + 1, n6++});
            ((IlvPolyhedron.Face)object).f = 0;
            arrayList.add((IlvPolyhedron.Face)object);
        }
        n6 = n5 + n4;
        n7 = n3 + n2 - 1;
        for (n5 = n3; n5 < n7; ++n5) {
            object = new IlvPolyhedron.Face(this, new int[]{n5, n5 + 1, n6 + 1, n6++});
            ((IlvPolyhedron.Face)object).f = 0;
            arrayList.add((IlvPolyhedron.Face)object);
        }
        if (n3 > 0) {
            n5 = n3 - 1;
            n6 = n5 + n4;
            if (this.a) {
                arrayList.add(new IlvPolyhedron.Face(this, new int[]{n5, n5 + 1, n6 + 1, n6}));
            }
            if (this.b) {
                arrayList.add(new IlvPolyhedron.Face(this, new int[]{n4 - 1, 0, n4, 2 * n4 - 1}));
            }
        } else {
            n5 = n2 - 1;
            n6 = n5 + n4;
            if (this.b) {
                arrayList.add(new IlvPolyhedron.Face(this, new int[]{n5, n5 + 1, n6 + 1, n6}));
            }
            if (this.a) {
                arrayList.add(new IlvPolyhedron.Face(this, new int[]{n4 - 1, 0, n4, 2 * n4 - 1}));
            }
        }
        object = n3 > 0 ? new int[n4 + 1] : new int[n4];
        for (n5 = 0; n5 < n4; ++n5) {
            object[n5] = n5;
        }
        if (n3 > 0) {
            object[n5] = false;
        }
        IlvPolyhedron.Face face = new IlvPolyhedron.Face(this, (int[])object);
        face.f = 0;
        arrayList.add(face);
        this.setFaces(arrayList);
    }

    public void applyTransform(Ilv3DTransform ilv3DTransform, int n2) {
        super.applyTransform(ilv3DTransform, n2);
        this.j = ilv3DTransform.transform(n2, this.i, this.j);
        this.l = ilv3DTransform.transform(n2, this.k, this.l);
    }

    public void draw(Graphics graphics, int n2) {
        IlvPolyhedron.Face face;
        int n3;
        IlvStyle ilvStyle = this.getStyle();
        if (!ilvStyle.isStrokeOn() || n2 == 1 || this.getRenderingMode() == 0) {
            super.draw(graphics, n2);
            return;
        }
        if (this.f >= 0) {
            this.a(graphics, this.e, this.f, ilvStyle);
        }
        this.a(graphics, this.g, this.h, ilvStyle);
        int n4 = this.faces.length;
        for (n3 = this.h + 1; n3 < n4 - 1; ++n3) {
            face = this.faces[n3];
            if (!this.isFaceVisible(face)) continue;
            face.a(graphics);
        }
        face = this.faces[n3];
        if (this.isFaceVisible(face)) {
            face.a(graphics);
            if (this.a && this.b) {
                face.a(graphics, 1);
            } else if (this.f < 0) {
                face.b(graphics, 0, this.h + 1, ilvStyle);
                if (this.a) {
                    face.a(graphics, this.h + 2, 0, ilvStyle);
                } else if (this.b) {
                    face.a(graphics, this.h + 1, this.h + 2, ilvStyle);
                }
            } else {
                int n5 = this.f - this.e + 2;
                int n6 = this.h - this.g + 2;
                face.b(graphics, 0, n5 - 1, ilvStyle);
                if (this.a) {
                    face.a(graphics, n5 - 1, n5, ilvStyle);
                }
                face.b(graphics, n5, n5 + n6 - 1, ilvStyle);
                if (this.b) {
                    face.a(graphics, n5 + n6 - 1, 0, ilvStyle);
                }
            }
        }
    }

    private void a(Graphics graphics, int n2, int n3, IlvStyle ilvStyle) {
        int n4;
        int n5 = -1;
        int n6 = -1;
        for (int i2 = n2; i2 <= n3; ++i2) {
            IlvPolyhedron.Face face = this.faces[i2];
            if (!this.isFaceVisible(face)) continue;
            face.a(graphics);
        }
        IlvPolyhedron.Face face = null;
        for (n4 = n2; n4 <= n3; ++n4) {
            face = this.faces[n4];
            if (this.isFaceVisible(face)) {
                face.a(graphics, 3, 2, ilvStyle);
                if (n5 != -1) continue;
                n5 = n4;
                continue;
            }
            if (n5 == -1 || n6 != -1) continue;
            n6 = n4 - 1;
        }
        int n7 = n4 = n3 == this.f ? 1 : 0;
        if (n4 != 0) {
            if (this.f != -1 && this.a && this.isFaceVisible(this.faces[this.f])) {
                this.faces[this.f].a(graphics, 1, 2, ilvStyle);
            }
            if (this.e != -1 && this.b && this.isFaceVisible(this.faces[this.e])) {
                this.faces[this.e].a(graphics, 0, 3, ilvStyle);
            }
        } else {
            if (n5 != -1 && (this.a || n5 != n2)) {
                this.faces[n5].a(graphics, 0, 3, ilvStyle);
            }
            if (n6 != -1) {
                this.faces[n6].a(graphics, 1, 2, ilvStyle);
            } else if (this.b && this.isFaceVisible(face)) {
                face.a(graphics, 1, 2, ilvStyle);
            }
        }
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        if (this.getRenderer().getDataLabelLayout() == 2) {
            double d2 = IlvGraphicUtil.pointAngleDeg(this.j.x, this.j.y, this.l.x, this.l.y);
            IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(this.l.x, this.l.y);
            ilvDoublePoint = IlvGraphicUtil.computeTextLocation(ilvDoublePoint, d2, 6, dimension.width, dimension.height);
            return new Point(ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor());
        }
        return new Point(IlvGraphicUtil.toInt(this.j.x), IlvGraphicUtil.toInt(this.j.y));
    }

    public Ilv3DBounds getBounds(boolean bl, Ilv3DBounds ilv3DBounds) {
        ilv3DBounds = super.getBounds(bl, ilv3DBounds);
        if (this.m != null) {
            ilv3DBounds.add(this.m.getBounds(bl, null));
        }
        return ilv3DBounds;
    }

    private static void a(PathIterator pathIterator, IlvDoubleArray ilvDoubleArray, IlvDoubleArray ilvDoubleArray2) {
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            if (n2 == 0 || n2 == 1) {
                ilvDoubleArray.add(dArray[0]);
                ilvDoubleArray2.add(dArray[1]);
            } else if (n2 == 4) {
                ilvDoubleArray.add(ilvDoubleArray.get(0));
                ilvDoubleArray2.add(ilvDoubleArray2.get(0));
            }
            pathIterator.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ZComparator
    implements Comparator<IlvChart3DSlice> {
        private static ZComparator a = new ZComparator();

        ZComparator() {
        }

        public static final Comparator<IlvChart3DSlice> getInstance() {
            return a;
        }

        @Override
        public int compare(IlvChart3DSlice ilvChart3DSlice, IlvChart3DSlice ilvChart3DSlice2) {
            if (ilvChart3DSlice.getRenderer() != ilvChart3DSlice2.getRenderer()) {
                double d2 = ilvChart3DSlice.getCenter((boolean)false).z - ilvChart3DSlice2.getCenter((boolean)false).z;
                if (d2 > 0.0) {
                    return 1;
                }
                if (d2 < 0.0) {
                    return -1;
                }
                return 0;
            }
            Ilv3DTransform ilv3DTransform = ilvChart3DSlice.getScene().getTransform();
            int n2 = this.a(ilvChart3DSlice, ilvChart3DSlice2, ilv3DTransform);
            return ilv3DTransform.getXRotation() > 0.0 ? -n2 : n2;
        }

        private int a(IlvChart3DSlice ilvChart3DSlice, IlvChart3DSlice ilvChart3DSlice2, Ilv3DTransform ilv3DTransform) {
            double d2;
            double d3 = ilv3DTransform.getZRotation();
            double d4 = ZComparator.a(ilvChart3DSlice.c + d3, 90.0);
            double d5 = ZComparator.a(ilvChart3DSlice.d + d3, 90.0);
            double d6 = ZComparator.a(ilvChart3DSlice2.c + d3, 90.0);
            double d7 = ZComparator.a(ilvChart3DSlice2.d + d3, 90.0);
            if (d4 <= 0.0 && d5 >= 0.0) {
                if (d4 == 0.0 && d4 == d7 || d5 == 0.0 && d6 == d5) {
                    return 0;
                }
                return -1;
            }
            if (d6 <= 0.0 && d7 >= 0.0) {
                if (d6 == 0.0 && d6 == d5 || d7 == 0.0 && d4 == d7) {
                    return 0;
                }
                return 1;
            }
            if (d4 >= 0.0 && d5 <= 0.0) {
                return 1;
            }
            if (d6 >= 0.0 && d7 <= 0.0) {
                return -1;
            }
            double d8 = Math.max(Math.abs(d4), Math.abs(d5));
            double d9 = d8 - (d2 = Math.max(Math.abs(d6), Math.abs(d7)));
            if (d9 > 0.0) {
                return 1;
            }
            if (d9 < 0.0) {
                return -1;
            }
            return 0;
        }

        static double a(double d2, double d3) {
            d2 = IlvMathUtil.mod360(d2);
            double d4 = IlvMathUtil.mod360(d3 + 180.0);
            if (d2 >= d3 && d2 <= d4) {
                d2 -= d3;
            } else if (d2 < d3) {
                d2 -= d3;
            } else if (d2 > d4) {
                d2 = -180.0 + (d2 - d4);
            }
            return d2;
        }
    }
}

