/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.IlvStyle;
import ilog.views.chart.util.internal.IlvArrayPool;
import ilog.views.chart.view3d.Ilv3DMatrix;
import ilog.views.chart.view3d.Ilv3DScene;
import ilog.views.chart.view3d.Ilv3DTransform;
import ilog.views.chart.view3d.Ilv3DUtil;
import ilog.views.chart.view3d.Ilv3DVector;
import ilog.views.chart.view3d.IlvAbstract3DObject;
import ilog.views.util.java2d.IlvPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IlvPolyhedron
extends IlvAbstract3DObject {
    static final IlvStyle a = new IlvStyle(Color.black, (Paint)Color.blue);
    static final int b = -1;
    public static final int FILL = 0;
    public static final int STROKE = 1;
    public static final int STROKE_FILL = 2;
    protected Face[] faces;
    protected int renderingMode = -1;

    public IlvPolyhedron(Ilv3DScene ilv3DScene) {
        super(ilv3DScene);
    }

    public final int getRenderingMode() {
        return this.renderingMode == -1 ? this.getScene().getRenderingMode() : this.renderingMode;
    }

    public final int getFaceCount() {
        return this.faces.length;
    }

    public final Face getFace(int n2) {
        return this.faces[n2];
    }

    protected final void setFaces(Collection<Face> collection) {
        this.setFaces(collection.toArray(new Face[collection.size()]));
    }

    protected void setFaces(Face[] faceArray) {
        this.faces = faceArray;
        this.computeFacesNormal();
    }

    public IlvStyle getStyle() {
        return a;
    }

    public void setStyle(IlvStyle ilvStyle) {
        Face[] faceArray = this.faces;
        int n2 = faceArray.length;
        while (--n2 >= 0) {
            faceArray[n2].setStyle(ilvStyle);
        }
    }

    protected void computeFacesNormal() {
        Face[] faceArray = this.faces;
        int n2 = faceArray.length;
        while (--n2 >= 0) {
            Face face = faceArray[n2];
            face.a(this.computeFaceNormal(face));
        }
    }

    protected Ilv3DVector computeFaceNormal(Face face) {
        return this.a(face, this.getCenter(false));
    }

    final Ilv3DVector a(Face face, Ilv3DVector ilv3DVector) {
        Ilv3DVector ilv3DVector2 = Ilv3DUtil.computeNormal(this.getVertices(), face.getIndices(), face.getNormal(false));
        if (ilv3DVector != null) {
            Ilv3DVector ilv3DVector3 = face.getCenter(false);
            ilv3DVector3.sub(ilv3DVector);
            if (ilv3DVector3.dot(ilv3DVector2) < 0.0) {
                ilv3DVector2.scale(-1.0);
            }
        }
        return ilv3DVector2;
    }

    final Ilv3DVector a(Face face) {
        Ilv3DVector ilv3DVector = Ilv3DUtil.computeNormal(this.getVerticesT(), face.getIndices(), null);
        Ilv3DVector ilv3DVector2 = this.getCenter(true);
        if (ilv3DVector2 != null) {
            Ilv3DVector ilv3DVector3 = face.getCenter(true);
            ilv3DVector3.sub(ilv3DVector2);
            if (ilv3DVector3.dot(ilv3DVector) < 0.0) {
                ilv3DVector.scale(-1.0);
            }
        }
        return ilv3DVector;
    }

    public boolean isFaceVisible(Face face) {
        if (face.e) {
            if (this.isCulling() && this.getRenderingMode() != 0) {
                return face.getNormal((boolean)true).z > 0.0;
            }
            return true;
        }
        return false;
    }

    protected void updateGeometry() {
        this.computeCenter();
        this.computeFacesNormal();
    }

    @Override
    public boolean contains(double d2, double d3) {
        Face[] faceArray = this.faces;
        int n2 = faceArray.length;
        while (--n2 >= 0) {
            Face face = faceArray[n2];
            if (!this.isFaceVisible(face) || !face.contains(d2, d3)) continue;
            return true;
        }
        return false;
    }

    public boolean isCulling() {
        return true;
    }

    @Override
    public final void draw(Graphics graphics) {
        this.draw(graphics, -1);
    }

    public void draw(Graphics graphics, int n2) {
        for (Face face : this.faces) {
            if (!this.isFaceVisible(face)) continue;
            face.a(graphics, n2 == -1 ? face.f : n2);
        }
    }

    @Override
    public void applyTransform(Ilv3DTransform ilv3DTransform, int n2) {
        super.applyTransform(ilv3DTransform, n2);
        if (n2 == 1) {
            Ilv3DMatrix ilv3DMatrix = ilv3DTransform.getRotation();
            for (Face face : this.faces) {
                face.a(ilv3DMatrix);
            }
        }
    }

    @Override
    String b() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" {");
        for (n2 = 0; n2 < this.vtx.length; ++n2) {
            stringBuffer.append("\n  ");
            stringBuffer.append("[");
            stringBuffer.append(n2);
            stringBuffer.append("] = ");
            stringBuffer.append(this.vtx[n2]);
        }
        stringBuffer.append("\n} faces={");
        for (n2 = 0; n2 < this.faces.length; ++n2) {
            stringBuffer.append("\n  ");
            Face face = this.faces[n2];
            stringBuffer.append("[");
            for (int i2 = 0; i2 < face.getIndices().length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(" - ");
                }
                stringBuffer.append(face.getIndices()[i2]);
            }
            stringBuffer.append("]");
            stringBuffer.append(this.isFaceVisible(face) ? " vis" : " inv");
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    public final class Face {
        private Ilv3DVector a = new Ilv3DVector();
        private Ilv3DVector b = new Ilv3DVector();
        private IlvStyle c;
        private int[] d;
        boolean e = true;
        int f = 2;

        public Face(int[] nArray) {
            this(nArray, null);
        }

        public Face(int[] nArray, IlvStyle ilvStyle) {
            this.d = nArray;
            this.c = ilvStyle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(double d2, double d3) {
            IlvStyle ilvStyle;
            IlvStyle ilvStyle2 = ilvStyle = this.c == null ? IlvPolyhedron.this.getStyle() : this.c;
            if (ilvStyle == null) {
                return false;
            }
            boolean bl = false;
            Object object = IlvArrayPool.getDoubleCoordsLock();
            synchronized (object) {
                double[][] dArray = this.a();
                int n2 = this.d.length + 1;
                bl = IlvPolyhedron.this.getRenderingMode() == 0 ? ilvStyle.polylineContains(dArray[0], dArray[1], n2, d2, d3) : ilvStyle.pointsContains(dArray[0], dArray[1], n2, d2, d3);
            }
            return bl;
        }

        public Ilv3DVector getVertex(int n2) {
            return IlvPolyhedron.this.getVerticesT()[this.d[n2]];
        }

        public int[] getIndices() {
            return this.d;
        }

        public final IlvPolyhedron getPolyhedron() {
            return IlvPolyhedron.this;
        }

        public void setStyle(IlvStyle ilvStyle) {
            this.c = ilvStyle;
        }

        public IlvStyle getStyle() {
            return this.c;
        }

        public boolean isVisible() {
            return IlvPolyhedron.this.isFaceVisible(this);
        }

        void a(Graphics graphics) {
            this.a(graphics, this.f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void a(Graphics graphics, int n2) {
            IlvStyle ilvStyle = this.b();
            if (ilvStyle == null) {
                return;
            }
            Object object = IlvArrayPool.getDoubleCoordsLock();
            synchronized (object) {
                double[][] dArray = this.a();
                double[] dArray2 = dArray[0];
                double[] dArray3 = dArray[1];
                int n3 = this.d.length + 1;
                if (IlvPolyhedron.this.getRenderingMode() == 0) {
                    ilvStyle.drawPolyline(graphics, dArray2, dArray3, n3);
                } else {
                    if (ilvStyle.isFillOn() && (n2 == 2 || n2 == 0)) {
                        ilvStyle.fillPolygon(graphics, dArray2, dArray3, n3);
                    }
                    if (ilvStyle.isStrokeOn() && (n2 == 2 || n2 == 1)) {
                        ilvStyle.drawPolyline(graphics, dArray2, dArray3, n3);
                    }
                }
            }
        }

        void b(Graphics graphics) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMaximumFractionDigits(2);
            Ilv3DVector ilv3DVector = this.getCenter(true);
            Ilv3DVector ilv3DVector2 = this.getNormal(true).copy();
            ilv3DVector2.scale(40.0);
            ilv3DVector2.add(ilv3DVector);
            Ilv3DUtil.a(graphics, ilv3DVector);
            Ilv3DUtil.a(graphics, ilv3DVector, numberFormat.format(this.getNormal((boolean)true).z));
            IlvStyle.createStroked(Color.red).drawLine(graphics, ilv3DVector.x, ilv3DVector.y, ilv3DVector2.x, ilv3DVector2.y);
        }

        void a(Graphics graphics, int n2, int n3, IlvStyle ilvStyle) {
            Ilv3DVector ilv3DVector = this.getVertex(n2);
            Ilv3DVector ilv3DVector2 = this.getVertex(n3);
            ilvStyle.drawLine(graphics, ilv3DVector.x, ilv3DVector.y, ilv3DVector2.x, ilv3DVector2.y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void b(Graphics graphics, int n2, int n3, IlvStyle ilvStyle) {
            Object object = IlvArrayPool.getDoubleCoordsLock();
            synchronized (object) {
                double[][] dArray = this.a(n2, n3, false, true);
                int n4 = n3 - n2 + 1;
                ilvStyle.drawPolyline(graphics, dArray[0], dArray[1], n4);
            }
        }

        double[][] a() {
            return this.a(0, this.d.length - 1, true, true);
        }

        private double[][] a(int n2, int n3, boolean bl, boolean bl2) {
            Object object;
            int n4;
            int n5 = n3 - n2 + 1;
            int n6 = n4 = bl ? n5 + 1 : n5;
            if (bl2) {
                object = IlvArrayPool.allocDoubleCoords(n4);
            } else {
                double[][] dArrayArray = new double[2][];
                dArrayArray[0] = new double[n4];
                object = dArrayArray;
                dArrayArray[1] = new double[n4];
            }
            double[][] dArray = object;
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            int n7 = 0;
            int n8 = n2;
            while (n8 <= n3) {
                Ilv3DVector ilv3DVector = this.getVertex(n8);
                dArray2[n7] = ilv3DVector.x;
                dArray3[n7] = ilv3DVector.y;
                ++n8;
                ++n7;
            }
            if (bl) {
                dArray2[n7] = dArray2[0];
                dArray3[n7] = dArray3[0];
            }
            return dArray;
        }

        IlvStyle b() {
            IlvStyle ilvStyle;
            IlvStyle ilvStyle2 = ilvStyle = this.c == null ? IlvPolyhedron.this.getStyle() : this.c;
            if (ilvStyle == null) {
                return null;
            }
            if (IlvPolyhedron.this.getRenderingMode() == 1) {
                return ilvStyle;
            }
            if (IlvPolyhedron.this.getRenderingMode() == 2) {
                Paint paint = ilvStyle.getFillPaint();
                if (paint instanceof IlvPattern) {
                    IlvPattern ilvPattern = (IlvPattern)paint;
                    Color color = ilvPattern.getBackground();
                    if (color == null) {
                        return ilvStyle;
                    }
                    color = Ilv3DUtil.computeFaceColor(this.getNormal(true), IlvPolyhedron.this.getScene().getLightVector(), color, IlvPolyhedron.this.getScene().getAmbientLight(), !IlvPolyhedron.this.isCulling());
                    ilvPattern = new IlvPattern(ilvPattern.getType(), ilvPattern.getForeground(), color);
                    return ilvStyle.setFillPaint(ilvPattern);
                }
                if (paint instanceof Color) {
                    return ilvStyle.setFillPaint(Ilv3DUtil.computeFaceColor(this.getNormal(true), IlvPolyhedron.this.getScene().getLightVector(), (Color)paint, IlvPolyhedron.this.getScene().getAmbientLight(), !IlvPolyhedron.this.isCulling()));
                }
                return ilvStyle;
            }
            if (IlvPolyhedron.this.getRenderingMode() == 0 && ilvStyle.isFillOn()) {
                return IlvStyle.createStroked(ilvStyle.getFillPaint());
            }
            return ilvStyle;
        }

        public final Ilv3DVector getCenter(boolean bl) {
            Ilv3DVector[] ilv3DVectorArray = bl ? IlvPolyhedron.this.getVerticesT() : IlvPolyhedron.this.getVertices();
            return Ilv3DUtil.computeCenter(ilv3DVectorArray, this.d, null);
        }

        public final Ilv3DVector getNormal(boolean bl) {
            return bl ? this.b : this.a;
        }

        void a(Ilv3DVector ilv3DVector) {
            this.a = ilv3DVector;
            if (this.b == null) {
                this.b = this.a.copy();
            }
        }

        void a(Ilv3DMatrix ilv3DMatrix) {
            this.b = ilv3DMatrix.transform(this.a, this.b);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("@");
            stringBuffer.append(System.identityHashCode(this));
            stringBuffer.append(" {");
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                stringBuffer.append("\n  ");
                stringBuffer.append(IlvPolyhedron.this.getVertices()[this.d[i2]]);
            }
            stringBuffer.append("\n}");
            return stringBuffer.toString();
        }
    }
}

