/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvHandlesSelection;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvRegion;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvGraphicHandleInteractor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.Serializable;

public class IlvGraphicHandleSelection
extends IlvHandlesSelection
implements IlvGraphicBag {
    private IlvSelection a;
    private IlvRect b = null;
    private IlvTransformer c = null;
    private IlvTransformer d = null;

    public IlvGraphicHandleSelection(IlvGraphic ilvGraphic, IlvSelection ilvSelection) {
        super(ilvGraphic);
        this.setSelection(ilvSelection);
    }

    public void setSelection(IlvSelection ilvSelection) {
        if (this.getSelection() != null) {
            this.getSelection().setGraphicBag(null);
        }
        this.a = ilvSelection;
        if (ilvSelection != null) {
            ilvSelection.setGraphicBag(this);
        }
    }

    public final IlvSelection getSelection() {
        return this.a;
    }

    public boolean isVisible() {
        return this.a.isVisible() && super.isVisible();
    }

    public boolean isOptimizedDrawingEnabled() {
        return this.a.isOptimizedDrawingEnabled();
    }

    public boolean zoomable() {
        return false;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        this.drawWithoutHandles(graphics, ilvTransformer);
        super.draw(graphics, ilvTransformer);
    }

    public void drawWithoutHandles(Graphics graphics, IlvTransformer ilvTransformer) {
        Serializable serializable;
        if (!(this.a instanceof IlvHandlesSelection)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        IlvTransformer ilvTransformer2 = this.getVirtualToRealViewTransformer(ilvTransformer);
        if (ilvTransformer2 != null) {
            serializable = ilvTransformer2.getAffineTransform(null);
            graphics2D.transform((AffineTransform)serializable);
        }
        if (this.a instanceof IlvHandlesSelection) {
            serializable = (IlvHandlesSelection)this.a;
            ((IlvHandlesSelection)serializable).drawWithoutHandles(graphics, this.getVirtualViewTransformer(ilvTransformer));
        } else {
            this.a.draw(graphics, this.getVirtualViewTransformer(ilvTransformer));
        }
        if (ilvTransformer2 != null) {
            graphics2D.setTransform(affineTransform);
        }
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = super.boundingBox(ilvTransformer);
        IlvRect ilvRect2 = this.a.boundingBox(this.getVirtualViewTransformer(ilvTransformer));
        ilvRect2.x -= 1.0f;
        ilvRect2.y -= 1.0f;
        ilvRect2.width += 2.0f;
        ilvRect2.height += 2.0f;
        IlvTransformer ilvTransformer2 = this.getVirtualToRealViewTransformer(ilvTransformer);
        if (ilvTransformer2 != null) {
            ilvTransformer2.boundingBox(ilvRect2, false);
        }
        ilvRect.add(ilvRect2);
        return ilvRect;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getVirtualViewTransformer(ilvTransformer);
        IlvTransformer ilvTransformer3 = this.getVirtualToRealViewTransformer(ilvTransformer);
        IlvPoint ilvPoint3 = new IlvPoint(ilvPoint2);
        if (ilvTransformer3 != null) {
            ilvTransformer3.inverse(ilvPoint3);
        }
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint3);
        if (ilvTransformer2 != null) {
            ilvTransformer2.inverse(ilvPoint4);
        }
        return this.a.contains(ilvPoint4, ilvPoint3, ilvTransformer2);
    }

    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getVirtualViewTransformer(ilvTransformer);
        IlvTransformer ilvTransformer3 = this.getVirtualToRealViewTransformer(ilvTransformer);
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        if (ilvTransformer3 != null) {
            ilvTransformer3.boundingBox(ilvRect3, true);
        }
        IlvRect ilvRect4 = new IlvRect(ilvRect3);
        if (ilvTransformer2 != null) {
            ilvTransformer2.boundingBox(ilvRect4, true);
        }
        return this.a.intersects(ilvRect4, ilvRect3, ilvTransformer2);
    }

    public boolean inside(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getVirtualViewTransformer(ilvTransformer);
        IlvTransformer ilvTransformer3 = this.getVirtualToRealViewTransformer(ilvTransformer);
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        if (ilvTransformer3 != null) {
            ilvTransformer3.boundingBox(ilvRect3, true);
        }
        IlvRect ilvRect4 = new IlvRect(ilvRect3);
        if (ilvTransformer2 != null) {
            ilvTransformer2.boundingBox(ilvRect4, true);
        }
        return this.a.inside(ilvRect4, ilvRect3, ilvTransformer2);
    }

    public void setForeground(Color color) {
        this.a.setForeground(color);
    }

    public void setBackground(Color color) {
        this.a.setBackground(color);
    }

    public boolean isPersistent() {
        return this.a.isPersistent();
    }

    public void onEnter(IlvObjectInteractorContext ilvObjectInteractorContext) {
        super.onEnter(ilvObjectInteractorContext);
        this.a.onEnter(this.a(ilvObjectInteractorContext));
    }

    public void onExit(IlvObjectInteractorContext ilvObjectInteractorContext) {
        super.onExit(ilvObjectInteractorContext);
        this.a.onExit(this.a(ilvObjectInteractorContext));
        IlvObjectInteractor ilvObjectInteractor = this.getAndAssociateObjectInteractor();
        if (ilvObjectInteractor instanceof IlvGraphicHandleInteractor) {
            ((IlvGraphicHandleInteractor)ilvObjectInteractor).a();
        }
    }

    IlvObjectInteractorContext a(IlvObjectInteractorContext ilvObjectInteractorContext) {
        IlvObjectInteractor ilvObjectInteractor = this.getAndAssociateObjectInteractor();
        if (ilvObjectInteractor instanceof IlvGraphicHandleInteractor) {
            return ((IlvGraphicHandleInteractor)ilvObjectInteractor).a(this, ilvObjectInteractorContext);
        }
        return new IlvGraphicHandleInteractor.ObjectInteractorContext(ilvObjectInteractorContext, this.getVirtualViewTransformer(ilvObjectInteractorContext.getTransformer()), this.getVirtualToRealViewTransformer(ilvObjectInteractorContext.getTransformer()));
    }

    public int getHandleCardinal() {
        if (this.a instanceof IlvHandlesSelection) {
            return ((IlvHandlesSelection)this.a).getHandleCardinal();
        }
        return 4;
    }

    public IlvPoint getHandle(int n2, IlvTransformer ilvTransformer) {
        if (this.a instanceof IlvHandlesSelection) {
            IlvHandlesSelection ilvHandlesSelection = (IlvHandlesSelection)this.a;
            IlvTransformer ilvTransformer2 = this.c;
            IlvTransformer ilvTransformer3 = this.d;
            if (ilvTransformer2 == null) {
                ilvTransformer2 = this.getVirtualViewTransformer(ilvTransformer);
            }
            if (ilvTransformer3 == null) {
                ilvTransformer3 = this.getVirtualToRealViewTransformer(ilvTransformer);
            }
            IlvPoint ilvPoint = ilvHandlesSelection.getHandle(n2, ilvTransformer2);
            if (ilvTransformer3 != null) {
                ilvTransformer3.apply(ilvPoint);
            }
            return ilvPoint;
        }
        IlvRect ilvRect = this.b;
        if (ilvRect == null) {
            ilvRect = this.a(ilvTransformer);
        }
        switch (n2) {
            case 0: {
                return new IlvPoint(ilvRect.x, ilvRect.y);
            }
            case 1: {
                return new IlvPoint(ilvRect.x + ilvRect.width, ilvRect.y);
            }
            case 2: {
                return new IlvPoint(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height);
            }
            case 4: {
                return new IlvPoint(ilvRect.x, ilvRect.y + ilvRect.height);
            }
        }
        return null;
    }

    private IlvRect a(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.getObject().boundingBox(ilvTransformer);
        this.a(ilvRect);
        return ilvRect;
    }

    private void a(IlvRect ilvRect) {
        float f2 = 16.0f;
        if (ilvRect.width < f2) {
            ilvRect.x -= (f2 - ilvRect.width) / 2.0f;
            ilvRect.width = f2;
        }
        if (ilvRect.height < f2) {
            ilvRect.y -= (f2 - ilvRect.height) / 2.0f;
            ilvRect.height = f2;
        }
    }

    protected void beforeLoopAllHandles(IlvTransformer ilvTransformer) {
        if (this.a instanceof IlvHandlesSelection) {
            this.c = this.getVirtualViewTransformer(ilvTransformer);
            this.d = this.getVirtualToRealViewTransformer(ilvTransformer);
        } else {
            this.b = this.a(ilvTransformer);
        }
    }

    protected void afterLoopAllHandles() {
        this.b = null;
        this.c = null;
        this.d = null;
    }

    protected IlvTransformer getVirtualViewTransformer(IlvTransformer ilvTransformer) {
        return ilvTransformer;
    }

    protected IlvTransformer getVirtualToRealViewTransformer(IlvTransformer ilvTransformer) {
        return null;
    }

    public String getDefaultInteractor() {
        return IlvGraphicHandleInteractor.class.getName();
    }

    public void addObject(IlvGraphic ilvGraphic, boolean bl) {
        if (this.getSelection() != null) {
            throw new RuntimeException("This bag is full");
        }
        if (this.getGraphicBag() != null) {
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicHandleSelection.this.setSelection((IlvSelection)object);
                }
            }, ilvGraphic, bl);
        } else {
            this.setSelection((IlvSelection)ilvGraphic);
        }
    }

    public void removeObject(IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic != this.getSelection()) {
            throw new RuntimeException("Object is not in this bag");
        }
        if (this.getGraphicBag() != null) {
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicHandleSelection.this.setSelection(null);
                }
            }, null, bl);
        } else {
            this.setSelection(null);
        }
    }

    public IlvGraphicEnumeration getObjects() {
        return new IlvGraphicEnumeration(){
            IlvGraphic a;
            {
                this.a = IlvGraphicHandleSelection.this.getSelection();
            }

            public boolean hasMoreElements() {
                return this.a != null;
            }

            public IlvGraphic nextElement() {
                IlvGraphic ilvGraphic = this.a;
                this.a = null;
                return ilvGraphic;
            }
        };
    }

    public void reDrawObj(IlvGraphic ilvGraphic) {
        this.reDraw();
    }

    public void reDrawRegion(IlvRegion ilvRegion) {
        this.reDraw();
    }

    public void reshapeObject(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        if (ilvGraphic != this.getSelection()) {
            throw new RuntimeException("Object is not in this bag");
        }
        if (this.getGraphicBag() != null) {
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicHandleSelection.this.getSelection().moveResize((IlvRect)object);
                }
            }, ilvRect, bl);
        } else {
            ilvGraphic.moveResize(ilvRect);
        }
    }

    public void moveObject(IlvGraphic ilvGraphic, float f2, float f3, boolean bl) {
        if (ilvGraphic != this.getSelection()) {
            throw new RuntimeException("Object is not in this bag");
        }
        if (this.getGraphicBag() != null) {
            final float f4 = f2;
            final float f5 = f3;
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicHandleSelection.this.getSelection().move(f4, f5);
                }
            }, null, bl);
        } else {
            ilvGraphic.move(f2, f3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyToObject(IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        if (ilvGraphic != this.getSelection()) {
            throw new RuntimeException("Object is not in this bag");
        }
        boolean bl2 = ilvGraphic.setInApplyToObject(true);
        try {
            if (bl2 && this.getGraphicBag() != null) {
                final IlvApplyObject ilvApplyObject2 = ilvApplyObject;
                this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        ilvApplyObject2.apply(IlvGraphicHandleSelection.this.getSelection(), object);
                    }
                }, object, bl);
            } else {
                ilvApplyObject.apply(ilvGraphic, object);
            }
        }
        finally {
            ilvGraphic.setInApplyToObject(false);
        }
    }

    public boolean setObjectName(IlvGraphic ilvGraphic, String string) {
        if (ilvGraphic != this.getSelection()) {
            return false;
        }
        ilvGraphic.setName(string);
        return true;
    }

    public IlvGraphic getObject(String string) {
        if (string == this.getSelection().getName() || string != null && string.equals(this.getSelection().getName())) {
            return this.getSelection();
        }
        return null;
    }
}

