/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvOneLinkImage;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;

public class IlvOneSplineLinkImage
extends IlvOneLinkImage {
    private float a = 0.0f;
    private float b = 0.0f;

    public IlvOneSplineLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        this(ilvGraphic, ilvGraphic2, 0, bl);
    }

    public IlvOneSplineLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, int n2, boolean bl) {
        super(ilvGraphic, ilvGraphic2, n2, bl);
    }

    public IlvOneSplineLinkImage(IlvOneSplineLinkImage ilvOneSplineLinkImage) {
        super(ilvOneSplineLinkImage);
    }

    public IlvOneSplineLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
    }

    public IlvGraphic copy() {
        return new IlvOneSplineLinkImage(this);
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.a(ilvTransformer)) {
            super.draw(graphics, ilvTransformer);
            return;
        }
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        float f2 = this.getLineWidth();
        float[] fArray = this.getLineStyle();
        graphics.setColor(this.getForeground());
        if (f2 == 0.0f && fArray == null) {
            IlvGraphicUtil.DrawBezier(graphics, ilvPointArray, ilvPointArray.length, 0.0f, 0, 0, null, null);
        } else {
            float f3 = this.getMaximumLineWidth();
            fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f2, f3, ilvTransformer);
            f2 = IlvStrokeInfo.zoomedLineWidth(f2, f3, ilvTransformer, false);
            IlvGraphicUtil.DrawBezier(graphics, ilvPointArray, ilvPointArray.length, f2, 0, this.getEndCap(), fArray, ilvTransformer, true);
        }
        this.drawArrow(graphics, ilvPointArray[2], ilvPointArray[3], ilvTransformer);
    }

    public IlvPoint[] getLinkPoints(IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = new IlvPoint[4];
        IlvPoint[] ilvPointArray2 = super.getLinkPoints(ilvTransformer);
        ilvPointArray[0] = ilvPointArray2[0];
        ilvPointArray[1] = ilvPointArray2[1];
        ilvPointArray[2] = ilvPointArray2[2];
        ilvPointArray[3] = new IlvPoint();
        if (this.a(ilvTransformer)) {
            ilvPointArray[1].x = ilvPointArray[0].x;
            ilvPointArray[1].y = ilvPointArray[0].y;
            ilvPointArray[3].x = ilvPointArray[2].x;
            ilvPointArray[3].y = ilvPointArray[2].y;
            ilvPointArray[2].x = ilvPointArray[0].x;
            ilvPointArray[2].y = ilvPointArray[0].y;
        } else {
            float f2 = ilvPointArray[2].x - ilvPointArray[0].x;
            float f3 = ilvPointArray[2].y - ilvPointArray[0].y;
            ilvPointArray[1].translate(this.b * f2, this.a * f3);
            ilvPointArray[3].x = ilvPointArray[2].x;
            ilvPointArray[3].y = ilvPointArray[2].y;
            ilvPointArray[2].x = ilvPointArray[1].x;
            ilvPointArray[2].y = ilvPointArray[1].y;
        }
        return ilvPointArray;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.a(ilvTransformer)) {
            return super.contains(ilvPoint, ilvPoint2, ilvTransformer);
        }
        float f2 = this.getLineWidth();
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        if (f2 <= 1.0f) {
            return IlvGraphicUtil.PointInBezier(ilvPoint2, ilvPointArray, ilvPointArray.length, 0.0f, 0, 0, null);
        }
        f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, false);
        double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        return IlvGraphicUtil.PointInBezier(ilvPoint2, ilvPointArray, ilvPointArray.length, (float)((double)f2 * d2), 0, this.getEndCap(), null);
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (this.a(ilvTransformer)) {
            return super.boundingBox(ilvTransformer);
        }
        float f2 = this.getLineWidth();
        IlvRect ilvRect = new IlvRect();
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        if (f2 == 0.0f) {
            ilvRect.x = Math.min(Math.min(ilvPointArray[0].x, ilvPointArray[1].x), ilvPointArray[3].x);
            ilvRect.y = Math.min(Math.min(ilvPointArray[0].y, ilvPointArray[1].y), ilvPointArray[3].y);
            float f3 = Math.max(Math.max(ilvPointArray[0].x, ilvPointArray[1].x), ilvPointArray[3].x);
            ilvRect.width = f3 - ilvRect.x;
            f3 = Math.max(Math.max(ilvPointArray[0].y, ilvPointArray[1].y), ilvPointArray[3].y);
            ilvRect.height = f3 - ilvRect.y;
        } else {
            f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, true);
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            IlvGraphicUtil.BezierBoundingBox(ilvRect, ilvPointArray, ilvPointArray.length, (float)((double)f2 * d2), 0, this.getEndCap(), null);
        }
        if (this.isOriented()) {
            ilvRect.add(this.arrowBBox(ilvPointArray[2], ilvPointArray[3], ilvTransformer));
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }
}

