/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvReliefRectangle;
import ilog.views.graphic.IlvShadowRectangle;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.NoSuchElementException;

public class IlvRectangle
extends IlvGraphic {
    public static final int TOP_LEFT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int TOP_RIGHT = 4;
    public static final int BOTTOM_RIGHT = 8;
    protected final IlvRect drawrect;
    private Color a;
    private Color b;
    private int c;
    private int d;
    private int e;
    private RoundRect f;
    private static final int g = 2;
    private static final int h = 4;
    private static final int i = 8;
    private static final int j = 15;
    private static final double k = 0.7853981633974483;
    private static final double l = 1.0 - Math.cos(0.7853981633974483);
    private static final double m = Math.tan(0.7853981633974483);
    private static final double n = Math.sqrt(1.0 + m * m) - 1.0 + l;
    private static final double o = 1.3333333333333333 * l * m / n;
    private static final double p = (1.0 - o) / 2.0;
    private static final double[][] q = new double[][]{{0.0, 0.0, 0.0, 0.5}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -p, 0.0, p, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -p, 1.0, 0.0, 1.0, 0.0, 1.0, -p, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, p, 1.0, -p, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, p, 0.0, 0.0, 0.0, 0.0, 0.0, p, 0.0, 0.0, 0.0, 0.5}, new double[0]};
    private static final int[] r = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3, 4};
    private static final int[] s = new int[]{1, 2, 2, 8, 8, 4, 4, 1, 1};

    public IlvRectangle() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f));
    }

    public IlvRectangle(IlvRect ilvRect) {
        this.drawrect = new IlvRect();
        this.d = 2;
        this.e = 15;
        this.f = null;
        this.drawrect.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
    }

    public IlvRectangle(IlvRect ilvRect, boolean bl, boolean bl2) {
        this(ilvRect);
        this.setStrokeOn(bl);
        this.setFillOn(bl2);
    }

    public IlvRectangle(IlvRect ilvRect, boolean bl, boolean bl2, int n2) {
        this(ilvRect, bl, bl2);
        this.setRadius(n2);
    }

    public IlvRectangle(IlvRectangle ilvRectangle) {
        super(ilvRectangle);
        this.drawrect = new IlvRect();
        this.d = 2;
        this.e = 15;
        this.f = null;
        this.drawrect.reshape(ilvRectangle.drawrect.x, ilvRectangle.drawrect.y, ilvRectangle.drawrect.width, ilvRectangle.drawrect.height);
        this.setForeground(ilvRectangle.getForeground());
        this.setBackground(ilvRectangle.getBackground());
        if (ilvRectangle.getRadius() != 0) {
            this.setRadius(ilvRectangle.getRadius());
        }
        this.d = ilvRectangle.d;
        this.e = ilvRectangle.e;
    }

    public IlvRectangle(IlvInputStream ilvInputStream) throws IlvReadFileException {
        block7: {
            super(ilvInputStream);
            this.drawrect = new IlvRect();
            this.d = 2;
            this.e = 15;
            this.f = null;
            this.setForeground(ilvInputStream.readColor("foreground"));
            IlvRect ilvRect = ilvInputStream.readRect("rectangle");
            this.drawrect.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
            try {
                int n2 = ilvInputStream.readInt("radius");
                if (n2 != 0) {
                    this.setRadius(n2);
                }
                try {
                    this.setBackground(ilvInputStream.readColor("background"));
                    this.d = ilvInputStream.readInt("flags");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                    // empty catch block
                }
                try {
                    this.e = ilvInputStream.readInt("corners");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException) {}
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                if (!(this instanceof IlvReliefRectangle) && !(this instanceof IlvShadowRectangle)) break block7;
                this.setBackground(ilvInputStream.readColor("background"));
                this.d |= 4;
            }
        }
    }

    public IlvGraphic copy() {
        return new IlvRectangle(this);
    }

    public final IlvRect getDefinitionRect() {
        return new IlvRect(this.drawrect);
    }

    public void setDefinitionRect(IlvRect ilvRect) {
        this.drawrect.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        if (this.drawrect.width < 1.0E-20f) {
            this.drawrect.width = 1.0E-20f;
        }
        if (this.drawrect.height < 1.0E-20f) {
            this.drawrect.height = 1.0E-20f;
        }
    }

    public void moveResize(IlvRect ilvRect) {
        this.setDefinitionRect(ilvRect);
    }

    public void translate(float f2, float f3) {
        this.drawrect.x += f2;
        this.drawrect.y += f3;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        int n2;
        float f2 = this.a(ilvTransformer);
        if (this.isFillOn()) {
            graphics.setColor(this.getBackground());
            if (f2 != 0.0f) {
                n2 = (int)Math.floor(2.0f * f2);
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    ilvRect = new IlvRect();
                    ilvRect.reshape(this.drawrect.x, this.drawrect.y, this.drawrect.width, this.drawrect.height);
                    ilvTransformer.applyFloor(ilvRect);
                    if (this.getCorners() == 15) {
                        graphics.fillRoundRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width + 1, (int)ilvRect.height + 1, n2, n2);
                    } else {
                        ((Graphics2D)graphics).fill(this.a(ilvRect, ilvTransformer));
                    }
                } else if (this.getCorners() == 15) {
                    graphics.fillRoundRect(this.drawrect.xFloor(), this.drawrect.yFloor(), this.drawrect.widthFloor() + 1, this.drawrect.heightFloor() + 1, n2, n2);
                } else {
                    ((Graphics2D)graphics).fill(this.a(this.drawrect, ilvTransformer));
                }
            } else if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                IlvRect ilvRect2 = new IlvRect();
                ilvRect2.reshape(this.drawrect.x, this.drawrect.y, this.drawrect.width, this.drawrect.height);
                ilvTransformer.applyFloor(ilvRect2);
                graphics.fillRect((int)ilvRect2.x, (int)ilvRect2.y, (int)ilvRect2.width + 1, (int)ilvRect2.height + 1);
            } else {
                graphics.fillRect(this.drawrect.xFloor(), this.drawrect.yFloor(), this.drawrect.widthFloor() + 1, this.drawrect.heightFloor() + 1);
            }
        }
        if (this.isStrokeOn()) {
            graphics.setColor(this.getForeground());
            if (f2 != 0.0f) {
                n2 = (int)Math.floor(2.0f * f2);
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    ilvRect = new IlvRect();
                    ilvRect.reshape(this.drawrect.x, this.drawrect.y, this.drawrect.width, this.drawrect.height);
                    ilvTransformer.applyFloor(ilvRect);
                    if (this.getCorners() == 15) {
                        graphics.drawRoundRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height, n2, n2);
                    } else {
                        ((Graphics2D)graphics).draw(this.a(ilvRect, ilvTransformer));
                    }
                } else if (this.getCorners() == 15) {
                    graphics.drawRoundRect(this.drawrect.xFloor(), this.drawrect.yFloor(), this.drawrect.widthFloor(), this.drawrect.heightFloor(), n2, n2);
                } else {
                    ((Graphics2D)graphics).draw(this.a(this.drawrect, ilvTransformer));
                }
            } else if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                IlvRect ilvRect3 = new IlvRect();
                ilvRect3.reshape(this.drawrect.x, this.drawrect.y, this.drawrect.width, this.drawrect.height);
                ilvTransformer.applyFloor(ilvRect3);
                graphics.drawRect((int)ilvRect3.x, (int)ilvRect3.y, (int)ilvRect3.width, (int)ilvRect3.height);
            } else {
                graphics.drawRect(this.drawrect.xFloor(), this.drawrect.yFloor(), this.drawrect.widthFloor(), this.drawrect.heightFloor());
            }
        }
    }

    private Shape a(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        if (this.f == null) {
            this.f = new RoundRect(ilvRect, ilvTransformer);
        } else {
            this.f.a(ilvRect, ilvTransformer);
        }
        return this.f;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.isFillOn()) {
            IlvRect ilvRect = new IlvRect(this.drawrect);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvRect);
            }
            return ilvRect.inside(ilvPoint2.x, ilvPoint2.y);
        }
        if (this.isStrokeOn()) {
            float f2 = IlvUtil.GetDeltaLine();
            IlvRect ilvRect = new IlvRect(this.drawrect);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvRect);
            }
            if (!(ilvPoint2.x >= ilvRect.x - f2 && ilvPoint2.x <= ilvRect.x + ilvRect.width + f2 && ilvPoint2.y >= ilvRect.y - f2 && ilvPoint2.y <= ilvRect.y + ilvRect.height + f2)) {
                return false;
            }
            IlvPoint ilvPoint3 = new IlvPoint(ilvRect.x, ilvRect.y);
            IlvPoint ilvPoint4 = new IlvPoint(ilvRect.x + ilvRect.width, ilvRect.y);
            IlvPoint ilvPoint5 = new IlvPoint(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height);
            IlvPoint ilvPoint6 = new IlvPoint(ilvRect.x, ilvRect.y + ilvRect.height);
            return IlvUtil.PointInLine(ilvPoint2, ilvPoint3, ilvPoint4, false) || IlvUtil.PointInLine(ilvPoint2, ilvPoint4, ilvPoint5, false) || IlvUtil.PointInLine(ilvPoint2, ilvPoint5, ilvPoint6, false) || IlvUtil.PointInLine(ilvPoint2, ilvPoint3, ilvPoint6, false);
        }
        return false;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(this.drawrect);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvRect);
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        return ilvRect;
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer == null || ilvTransformer.isIdentity()) {
            return;
        }
        ilvTransformer.apply(this.drawrect);
        if (this.drawrect.width < 1.0E-20f) {
            this.drawrect.width = 1.0E-20f;
        }
        if (this.drawrect.height < 1.0E-20f) {
            this.drawrect.height = 1.0E-20f;
        }
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        int n2;
        int n3;
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        float f2 = this.getRadius();
        if (this.isCornersZoomable() && ilvTransformer != null) {
            f2 = (float)((double)this.getRadius() * ilvTransformer.zoomFactor());
        }
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        int n4 = this.getCorners();
        float f3 = ilvRect.x;
        float f4 = ilvRect.y;
        float f5 = ilvRect.width;
        float f6 = ilvRect.height;
        float f7 = Math.min(2.0f * f2, f5);
        float f8 = Math.min(2.0f * f2, f6);
        IlvRect ilvRect2 = new IlvRect(f3, f4, f7, f8);
        IlvPoint[] ilvPointArray = new IlvPoint[16];
        ilvPointArray[0] = new IlvPoint(f3 + 0.5f * f7, f4);
        ilvPointArray[1] = IlvClippingUtil.ArcStartPoint(ilvRect2, 90.0);
        ilvPointArray[2] = IlvClippingUtil.ArcEndPoint(ilvRect2, 90.0, 90.0);
        ilvPointArray[3] = new IlvPoint(f3, f4 + 0.5f * f8);
        ilvPointArray[4] = new IlvPoint(f3, f4 + f6 - 0.5f * f8);
        ilvRect2.y += f6 - f8;
        ilvPointArray[5] = IlvClippingUtil.ArcStartPoint(ilvRect2, 180.0);
        ilvPointArray[6] = IlvClippingUtil.ArcEndPoint(ilvRect2, 180.0, 90.0);
        ilvPointArray[7] = new IlvPoint(f3 + 0.5f * f7, f4 + f6);
        ilvPointArray[8] = new IlvPoint(f3 + f5 - 0.5f * f7, f4 + f6);
        ilvRect2.x += f5 - f7;
        ilvPointArray[9] = IlvClippingUtil.ArcStartPoint(ilvRect2, 270.0);
        ilvPointArray[10] = IlvClippingUtil.ArcEndPoint(ilvRect2, 270.0, 90.0);
        ilvPointArray[11] = new IlvPoint(f3 + f5, f4 + f6 - 0.5f * f8);
        ilvPointArray[12] = new IlvPoint(f3 + f5, f4 + 0.5f * f8);
        ilvRect2.y -= f6 - f8;
        ilvPointArray[13] = IlvClippingUtil.ArcStartPoint(ilvRect2, 0.0);
        ilvPointArray[14] = IlvClippingUtil.ArcEndPoint(ilvRect2, 0.0, 90.0);
        ilvPointArray[15] = new IlvPoint(f3 + f5 - 0.5f * f7, f4);
        IlvPoint[] ilvPointArray2 = new IlvPoint[24];
        int n5 = IlvClippingUtil.LineIntersectsPolyPoints(ilvPoint, ilvPoint2, ilvPointArray, true, ilvPointArray2);
        IlvPoint[] ilvPointArray3 = new IlvPoint[2];
        ilvRect2.reshape(f3, f4, f7, f8);
        if ((n4 & 1) != 0) {
            n3 = IlvClippingUtil.LineIntersectsArc(ilvPoint, ilvPoint2, ilvRect2, 90.0, 90.0, ilvPointArray3);
            for (n2 = 0; n2 < n3; ++n2) {
                ilvPointArray2[n5++] = ilvPointArray3[n2];
            }
        } else {
            ilvPointArray2[n5++] = IlvClippingUtil.getClippedPoint(ilvRect2, ilvPoint, ilvPoint2);
        }
        ilvRect2.y += f6 - f8;
        if ((n4 & 2) != 0) {
            n3 = IlvClippingUtil.LineIntersectsArc(ilvPoint, ilvPoint2, ilvRect2, 180.0, 90.0, ilvPointArray3);
            for (n2 = 0; n2 < n3; ++n2) {
                ilvPointArray2[n5++] = ilvPointArray3[n2];
            }
        } else {
            ilvPointArray2[n5++] = IlvClippingUtil.getClippedPoint(ilvRect2, ilvPoint, ilvPoint2);
        }
        ilvRect2.x += f5 - f7;
        if ((n4 & 8) != 0) {
            n3 = IlvClippingUtil.LineIntersectsArc(ilvPoint, ilvPoint2, ilvRect2, 270.0, 90.0, ilvPointArray3);
            for (n2 = 0; n2 < n3; ++n2) {
                ilvPointArray2[n5++] = ilvPointArray3[n2];
            }
        } else {
            ilvPointArray2[n5++] = IlvClippingUtil.getClippedPoint(ilvRect2, ilvPoint, ilvPoint2);
        }
        ilvRect2.y -= f6 - f8;
        if ((n4 & 4) != 0) {
            n3 = IlvClippingUtil.LineIntersectsArc(ilvPoint, ilvPoint2, ilvRect2, 0.0, 90.0, ilvPointArray3);
            for (n2 = 0; n2 < n3; ++n2) {
                ilvPointArray2[n5++] = ilvPointArray3[n2];
            }
        } else {
            ilvPointArray2[n5++] = IlvClippingUtil.getClippedPoint(ilvRect2, ilvPoint, ilvPoint2);
        }
        return IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray2, n5);
    }

    public void setForeground(Color color) {
        this.a = color;
    }

    public Color getForeground() {
        if (this.a == null) {
            return Color.black;
        }
        return this.a;
    }

    public void setBackground(Color color) {
        this.b = color;
    }

    public Color getBackground() {
        if (this.b == null) {
            return Color.black;
        }
        return this.b;
    }

    public void setRadius(int n2) {
        this.c = n2;
    }

    public int getRadius() {
        return this.c;
    }

    private float a(IlvTransformer ilvTransformer) {
        if (!this.isCornersZoomable() || ilvTransformer == null || ilvTransformer.isIdentity()) {
            return this.getRadius();
        }
        return (float)((double)this.getRadius() * ilvTransformer.zoomFactor());
    }

    public boolean isFillOn() {
        return (this.d & 4) != 0;
    }

    public void setFillOn(boolean bl) {
        this.d = bl ? (this.d |= 4) : (this.d &= 0xFFFFFFFB);
    }

    public boolean isStrokeOn() {
        return (this.d & 2) != 0;
    }

    public void setStrokeOn(boolean bl) {
        this.d = bl ? (this.d |= 2) : (this.d &= 0xFFFFFFFD);
    }

    public int getCorners() {
        return this.e;
    }

    public void setCorners(int n2) {
        this.e = n2;
    }

    public boolean isCornersZoomable() {
        return (this.d & 8) != 0;
    }

    public void setCornersZoomable(boolean bl) {
        this.d = bl ? (this.d |= 8) : (this.d &= 0xFFFFFFF7);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("rectangle", this.drawrect);
        ilvOutputStream.write("radius", this.getRadius());
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("flags", this.d);
        ilvOutputStream.write("corners", this.e);
    }

    final class RoundRect
    implements Shape {
        private Rectangle2D a;
        private IlvTransformer b;

        RoundRect(Rectangle2D.Float float_, IlvTransformer ilvTransformer) {
            this.a = new Rectangle2D.Float(float_.x, float_.y, float_.width, float_.height);
            this.b = ilvTransformer;
        }

        void a(Rectangle2D.Float float_, IlvTransformer ilvTransformer) {
            if (!this.a.equals(float_)) {
                this.a.setFrame(float_);
            }
            this.b = ilvTransformer;
        }

        public Rectangle getBounds() {
            return this.a.getBounds();
        }

        public Rectangle2D getBounds2D() {
            return this.a;
        }

        public boolean contains(double d2, double d3) {
            return false;
        }

        public boolean contains(Point2D point2D) {
            return false;
        }

        public boolean intersects(double d2, double d3, double d4, double d5) {
            return false;
        }

        public boolean intersects(Rectangle2D rectangle2D) {
            return false;
        }

        public boolean contains(double d2, double d3, double d4, double d5) {
            return false;
        }

        public boolean contains(Rectangle2D rectangle2D) {
            return false;
        }

        public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
            return new FlatteningPathIterator(this.getPathIterator(affineTransform), d2);
        }

        public PathIterator getPathIterator(AffineTransform affineTransform) {
            return new RoundRectIterator(affineTransform, this.b);
        }

        final class RoundRectIterator
        implements PathIterator {
            private int a;
            private AffineTransform b;
            private IlvTransformer c;

            RoundRectIterator(AffineTransform affineTransform, IlvTransformer ilvTransformer) {
                this.b = affineTransform;
                this.c = ilvTransformer;
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.a >= q.length;
            }

            public void next() {
                ++this.a;
            }

            public int currentSegment(float[] fArray) {
                if (this.isDone()) {
                    throw new NoSuchElementException("roundrect iterator out of bounds");
                }
                double[] dArray = q[this.a];
                int n2 = 0;
                for (int i2 = 0; i2 < dArray.length; i2 += 4) {
                    fArray[n2++] = (float)(RoundRect.this.a.getX() + dArray[i2 + 0] * RoundRect.this.a.getWidth() + dArray[i2 + 1] * (double)this.a(this.c) * 2.0);
                    fArray[n2++] = (float)(RoundRect.this.a.getY() + dArray[i2 + 2] * RoundRect.this.a.getHeight() + dArray[i2 + 3] * (double)this.a(this.c) * 2.0);
                }
                if (this.b != null) {
                    this.b.transform(fArray, 0, fArray, 0, n2 / 2);
                }
                return r[this.a];
            }

            public int currentSegment(double[] dArray) {
                if (this.isDone()) {
                    throw new NoSuchElementException("roundrect iterator out of bounds");
                }
                double[] dArray2 = q[this.a];
                int n2 = 0;
                for (int i2 = 0; i2 < dArray2.length; i2 += 4) {
                    dArray[n2++] = RoundRect.this.a.getX() + dArray2[i2 + 0] * RoundRect.this.a.getWidth() + dArray2[i2 + 1] * (double)this.a(this.c) * 2.0;
                    dArray[n2++] = RoundRect.this.a.getY() + dArray2[i2 + 2] * RoundRect.this.a.getHeight() + dArray2[i2 + 3] * (double)this.a(this.c) * 2.0;
                }
                if (this.b != null) {
                    this.b.transform(dArray, 0, dArray, 0, n2 / 2);
                }
                return r[this.a];
            }

            private float a(IlvTransformer ilvTransformer) {
                if ((IlvRectangle.this.getCorners() & s[this.a]) == s[this.a]) {
                    return IlvRectangle.this.a(ilvTransformer);
                }
                return 0.0f;
            }
        }
    }
}

