/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvReliefRectangle;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;

public class IlvReliefLabel
extends IlvReliefRectangle
implements IlvFontInterface,
IlvLabelInterface {
    private String a = null;
    private Font b = IlvToolkit.defaultFont;
    private IlvRect c;

    public IlvReliefLabel() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f), "");
    }

    public IlvReliefLabel(IlvRect ilvRect, String string) {
        super(ilvRect);
        this.setLabel(string);
    }

    public IlvReliefLabel(IlvRect ilvRect, String string, int n2) {
        super(ilvRect, n2);
        this.setLabel(string);
    }

    public IlvReliefLabel(IlvPoint ilvPoint, String string, int n2) {
        this(new IlvRect(ilvPoint.x, ilvPoint.y, 10.0f, 10.0f), string, n2);
        this.fitToLabel();
    }

    public IlvReliefLabel(IlvReliefLabel ilvReliefLabel) {
        super(ilvReliefLabel);
        this.setLabel(ilvReliefLabel.getLabel());
        this.setFont(ilvReliefLabel.getFont());
        this.setAntialiasing(ilvReliefLabel.isAntialiasing());
    }

    public IlvReliefLabel(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.b = ilvInputStream.readFont("font");
        this.setLabel(ilvInputStream.readString("label"));
        try {
            this.setAntialiasing(ilvInputStream.readBoolean("antialiasing"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public final void setLabel(String string) {
        if (this.a == string && this.c != null) {
            return;
        }
        if (this.a == null || string == null || !string.equals(this.a)) {
            this.a = string;
            this.a();
        }
    }

    public void fitToLabel() {
        float f2 = this.getThickness();
        this.drawrect.resize(this.c.width + 4.0f * f2, this.c.height + 4.0f * f2);
    }

    public final String getLabel() {
        return this.a;
    }

    public boolean supportMultiline() {
        return false;
    }

    private void a() {
        this.c = IlvGraphicUtil.GetStringBounds(this.getLabel(), this.getFont(), this.isAntialiasing());
    }

    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(this.drawrect);
        int n2 = this.getThickness();
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvRect);
        }
        if (ilvRect.width > (float)(2 * n2) && ilvRect.height > (float)(2 * n2)) {
            ilvRect.x += (float)n2;
            ilvRect.y += (float)n2;
            ilvRect.height -= (float)(2 * n2);
            ilvRect.width -= (float)(2 * n2);
            IlvRect ilvRect2 = this.c;
            ilvRect.x += ilvRect.width / 2.0f - ilvRect2.width / 2.0f;
            ilvRect.y += (ilvRect.height - ilvRect2.height) / 2.0f;
            ilvRect.height = ilvRect2.height;
            ilvRect.width = ilvRect2.width;
        }
        return ilvRect;
    }

    public final void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (font == this.b) {
            return;
        }
        this.b = font;
        this.a();
    }

    public final Font getFont() {
        return this.b;
    }

    public final boolean isAntialiasing() {
        return this.getProperty("__ILVAntialiasing") != null;
    }

    public final void setAntialiasing(boolean bl) {
        if (bl == this.isAntialiasing()) {
            return;
        }
        this.setProperty("__ILVAntialiasing", bl ? new Boolean(true) : null);
        this.a();
    }

    public IlvGraphic copy() {
        return new IlvReliefLabel(this);
    }

    protected void drawContent(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
        this.drawLabel(graphics, ilvRect, ilvTransformer);
    }

    public void drawLabel(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
        Rectangle rectangle;
        String string = this.getLabel();
        if (string == null) {
            return;
        }
        Shape shape = graphics.getClip();
        Rectangle rectangle2 = shape != null ? shape.getBounds() : null;
        Rectangle rectangle3 = rectangle = rectangle2 != null ? rectangle2.intersection(new Rectangle((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height)) : new Rectangle((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        if (rectangle.width != 0 && rectangle.height != 0) {
            boolean bl = this.isAntialiasing();
            Font font = this.getFont();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            IlvRect ilvRect2 = this.c;
            int n2 = (int)Math.floor(ilvRect.x) + (int)Math.floor(ilvRect.width) / 2 - (int)Math.floor(ilvRect2.width) / 2;
            int n3 = (int)Math.floor(ilvRect.y) + ((int)Math.floor(ilvRect.height) + (int)Math.floor(ilvRect2.height)) / 2;
            graphics.setFont(font);
            graphics.setColor(this.getForeground());
            IlvGraphicUtil.DrawString(graphics, string, n2, n3, bl);
            graphics.setClip(shape);
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("font", this.getFont());
        ilvOutputStream.write("label", this.getLabel());
        if (this.isAntialiasing()) {
            ilvOutputStream.write("antialiasing", this.isAntialiasing());
        }
    }

    public String toString() {
        String string = this.getLabel();
        return super.toString() + (string != null ? " Label: " + string : " (no label)");
    }
}

