/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvReliefRectangle
extends IlvRectangle {
    private static final int a = 2;
    private int b = 2;

    public IlvReliefRectangle() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f));
    }

    public IlvReliefRectangle(IlvRect ilvRect) {
        super(ilvRect);
        super.setFillOn(true);
    }

    public IlvReliefRectangle(IlvRect ilvRect, int n2) {
        super(ilvRect);
        this.setThickness(Math.max(0, n2));
        super.setFillOn(true);
    }

    public IlvReliefRectangle(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setThickness(ilvInputStream.readInt("thickness"));
    }

    public IlvReliefRectangle(IlvReliefRectangle ilvReliefRectangle) {
        super(ilvReliefRectangle);
        this.setThickness(ilvReliefRectangle.b);
    }

    public int getThickness() {
        return this.b;
    }

    public void setThickness(int n2) {
        this.b = Math.max(n2, 0);
    }

    public IlvGraphic copy() {
        return new IlvReliefRectangle(this);
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(this.drawrect);
        int n2 = this.getThickness();
        graphics.setColor(this.getBackground());
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.applyFloor(ilvRect);
        } else {
            ilvRect.floor();
        }
        graphics.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width + 1, (int)ilvRect.height + 1);
        for (int i2 = 0; i2 < n2 && (int)ilvRect.width - 2 * i2 > 0 && (int)ilvRect.height - 2 * i2 > 0; ++i2) {
            graphics.draw3DRect((int)ilvRect.x + i2, (int)ilvRect.y + i2, (int)ilvRect.width - 2 * i2, (int)ilvRect.height - 2 * i2, true);
        }
        if (ilvRect.width > (float)(2 * n2) && ilvRect.height > (float)(2 * n2)) {
            ilvRect.x = (int)ilvRect.x + n2;
            ilvRect.y = (int)ilvRect.y + n2;
            ilvRect.height = (int)ilvRect.height - 2 * n2;
            ilvRect.width = (int)ilvRect.width - 2 * n2;
            this.drawContent(graphics, ilvRect, ilvTransformer);
        }
    }

    protected void drawContent(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
    }

    public final void setRadius(int n2) {
        throw new RuntimeException("could not change radius for IlvReliefRectangle");
    }

    public final void setStrokeOn(boolean bl) {
        throw new RuntimeException("could not change stroke on/off for IlvReliefRectangle");
    }

    public final void setFillOn(boolean bl) {
        throw new RuntimeException("could not change fill on/off for IlvReliefRectangle");
    }

    public final void setCorners(int n2) {
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("thickness", this.getThickness());
    }
}

