/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class IlvZoomableLabel
extends IlvGraphic
implements IlvFontInterface,
IlvLabelInterface {
    private static final short a = 1;
    private static final short b = 2;
    private static final short c = 4;
    private static final short d = 8;
    private static final short e = 16;
    private static final short f = 32;
    private static final short g = 64;
    private static final short h = 128;
    private static final short i = 256;
    private static final short j = 512;
    private static final short k = 1024;
    private static final short l = 2048;
    private IlvTransformer m;
    private FontRenderContext n;
    private String o = "";
    private Font p = IlvToolkit.defaultFont;
    private short q;
    private Paint r;
    private Paint s;
    private Stroke t;
    private Paint u;
    private Paint v;
    private IlvRect w = new IlvRect();
    private Shape x;
    private Shape y;
    private static Stroke z;
    private static AffineTransform aa;
    private transient String[] ab;
    private transient String[] ac;
    private float ad;
    private float ae;
    private float af;
    private float ag;
    private float ah;
    private int ai = 1;
    private Paint aj;
    private Paint ak;
    private IlvRect al = new IlvRect();
    private static final String am = "'()$[]|;_yg";
    private static boolean an;

    public IlvZoomableLabel() {
        this(new IlvPoint(0.0f, 0.0f), "");
    }

    public IlvZoomableLabel(IlvPoint ilvPoint, String string, boolean bl) {
        this.a(bl);
        this.b(true);
        this.m = new IlvTransformer(ilvPoint);
        this.setFillOn(true);
        this.n = this.r();
        this.setLabel(string);
    }

    public IlvZoomableLabel(IlvPoint ilvPoint, String string) {
        this(ilvPoint, string, true);
    }

    public IlvZoomableLabel(IlvZoomableLabel ilvZoomableLabel) {
        super(ilvZoomableLabel);
        this.o = ilvZoomableLabel.o;
        this.p = ilvZoomableLabel.p;
        this.m = new IlvTransformer(ilvZoomableLabel.m);
        this.q = ilvZoomableLabel.q;
        this.n = new FontRenderContext(ilvZoomableLabel.n.getTransform(), ilvZoomableLabel.isAntialiasing(), ilvZoomableLabel.isFractionalMetrics());
        this.t = ilvZoomableLabel.t;
        this.setFillPaint(ilvZoomableLabel.s);
        this.setStrokePaint(ilvZoomableLabel.v);
        this.setClip(ilvZoomableLabel.getClip());
        this.ad = ilvZoomableLabel.ad;
        this.ae = ilvZoomableLabel.ae;
        this.af = ilvZoomableLabel.af;
        this.ag = ilvZoomableLabel.ag;
        this.ah = ilvZoomableLabel.ah;
        this.ai = ilvZoomableLabel.ai;
        this.setBackgroundPaint(ilvZoomableLabel.ak);
        this.c(false);
        this.f(false);
    }

    public IlvZoomableLabel(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        try {
            this.m = ilvInputStream.readTransformer("transform");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.setFillOn(true);
            this.b(true);
            this.a(true);
            this.setFillPaint(ilvInputStream.readColor("foreground"));
            this.setFont(ilvInputStream.readFont("font"));
            ilvInputStream.readPoint("center");
            this.o = ilvInputStream.readString("label");
            try {
                if (ilvInputStream.readBoolean("antialiasing")) {
                    this.q = (short)(this.q | 8);
                }
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException2) {
                // empty catch block
            }
            this.m = ilvInputStream.readTransformer("transform");
            Font font = this.getFont();
            this.n = this.r();
            Rectangle2D rectangle2D = font.getStringBounds(this.o, this.n);
            LineMetrics lineMetrics = font.getLineMetrics(this.o, this.n);
            float f2 = (float)rectangle2D.getWidth();
            float f3 = lineMetrics.getAscent() + lineMetrics.getDescent();
            IlvRect ilvRect = new IlvRect(0.0f, 0.0f, f2, f3);
            this.m.boundingBox(ilvRect, false);
            this.setCenter(new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f));
            this.c(false);
            this.f(false);
            return;
        }
        this.setFont(ilvInputStream.readFont("font"));
        try {
            this.o = ilvInputStream.readString("label");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.ab = ilvInputStream.readStringArray("labels");
            this.ac = new String[this.ab.length];
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.ab.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.ac[i2] = IlvZoomableLabel.b(this.ab[i2]);
                stringBuffer.append(this.ab[i2]);
                if (i2 == this.ab.length - 1) continue;
                stringBuffer.append('\n');
            }
            this.o = stringBuffer.toString();
        }
        this.q = ilvInputStream.readShort("flags");
        this.n = this.r();
        try {
            this.setStroke(ilvInputStream.readStroke("stroke"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            try {
                this.setStroke((Stroke)((Object)ilvInputStream.readPersistentObject("pstroke")));
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException3) {
                // empty catch block
            }
        }
        this.setStrokePaint(IlvUtility2D.readStrokePaint(ilvInputStream));
        this.setFillPaint(IlvUtility2D.readPaint(ilvInputStream));
        try {
            this.setClip(ilvInputStream.readShape("clip", "clipRule"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ad = ilvInputStream.readFloat("multilineSpacing");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ae = ilvInputStream.readFloat("leftMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.af = ilvInputStream.readFloat("rightMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ag = ilvInputStream.readFloat("topMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ah = ilvInputStream.readFloat("bottomMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ai = ilvInputStream.readInt("justification");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setBackgroundPaint(IlvUtility2D.readPaint(ilvInputStream, "backColor", "b"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.c(false);
        this.f(false);
    }

    public void setCenter(IlvPoint ilvPoint) {
        IlvRect ilvRect = this.boundingBox();
        this.translate(ilvPoint.x - ilvRect.x - ilvRect.width / 2.0f, ilvPoint.y - ilvRect.y - ilvRect.height / 2.0f);
    }

    public IlvPoint getCenter() {
        IlvRect ilvRect = this.boundingBox();
        return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
    }

    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        return this.boundingBox(ilvTransformer);
    }

    private void a() {
        boolean bl;
        boolean bl2 = this.m.getx11() == 0.0 && this.m.getx12() == 0.0;
        boolean bl3 = bl = this.m.getx21() == 0.0 && this.m.getx22() == 0.0;
        if (bl2 || bl) {
            this.m.setValues(bl2 ? 1.0 : this.m.getx11(), this.m.getx12(), this.m.getx21(), bl ? 1.0 : this.m.getx22());
        }
    }

    public void resize(float f2, float f3) {
        this.a();
        if (!this.isStrokeOn() && !this.isBorderOn()) {
            super.resize(f2, f3);
            return;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            IlvRect ilvRect = this.boundingBox(null);
            if (ilvRect.width == f2 && ilvRect.height == f3) break;
            float f4 = Math.max(0.0f, f2 + this.w.width - ilvRect.width);
            float f5 = Math.max(0.0f, f3 + this.w.height - ilvRect.height);
            this.scale((double)f4 / (double)Math.max(1.0E-20f, ilvRect.width), (double)f5 / (double)Math.max(1.0E-20f, ilvRect.height));
        }
    }

    public void moveResize(IlvRect ilvRect) {
        IlvRect ilvRect2;
        this.a();
        if (!this.isStrokeOn() && !this.isBorderOn()) {
            super.moveResize(ilvRect);
            return;
        }
        for (int i2 = 0; i2 < 4 && !(ilvRect2 = this.boundingBox(null)).equals(ilvRect); ++i2) {
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvRect ilvRect3 = new IlvRect(ilvRect);
            IlvRect ilvRect4 = new IlvRect(this.w.x, this.w.y, this.w.width, this.w.height);
            ilvRect3.x += ilvRect4.x - ilvRect2.x;
            ilvRect3.y += ilvRect4.y - ilvRect2.y;
            ilvRect3.width += ilvRect4.width - ilvRect2.width;
            ilvRect3.height += ilvRect4.height - ilvRect2.height;
            if (ilvRect3.width < 0.0f) {
                ilvRect3.width = 0.0f;
            }
            if (ilvRect3.height < 0.0f) {
                ilvRect3.height = 0.0f;
            }
            IlvTransformer.computeTransformer(ilvRect4, ilvRect3, ilvTransformer);
            this.applyTransform(ilvTransformer);
        }
    }

    public IlvTransformer getTransformer() {
        return new IlvTransformer(this.m);
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (!this.j()) {
            this.n();
        }
        IlvRect ilvRect = new IlvRect(this.w);
        if (!this.g()) {
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                IlvTransformer ilvTransformer2 = this.getTransformer();
                ilvTransformer2.compose(ilvTransformer);
                ilvTransformer2.boundingBox(ilvRect, false);
            } else {
                this.m.boundingBox(ilvRect, false);
            }
        } else if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.boundingBox(ilvRect, false);
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        return ilvRect;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.getClip() != null && !IlvGraphicUtil.PointInShape(ilvPoint, this.getClip())) {
            return false;
        }
        return super.contains(ilvPoint, ilvPoint2, ilvTransformer);
    }

    public IlvGraphic copy() {
        return new IlvZoomableLabel(this);
    }

    public String getLabel() {
        return this.o;
    }

    public void setLabel(String string) {
        this.o = string != null ? string : "";
        this.ab = null;
        this.ac = null;
        if (this.o.indexOf(10) != -1) {
            this.g(true);
        } else {
            this.g(false);
        }
        this.c(false);
        this.f(false);
    }

    public boolean supportMultiline() {
        return true;
    }

    public final boolean isAntialiasing() {
        return (this.q & 8) != 0;
    }

    public void setAntialiasing(boolean bl) {
        if (bl != this.isAntialiasing()) {
            this.q = bl ? (short)(this.q | 8) : (short)(this.q & 0xFFFFFFF7);
            this.n = this.r();
            this.c(false);
            this.f(false);
        }
    }

    public final boolean isFractionalMetrics() {
        return (this.q & 0x80) != 0;
    }

    public void setFractionalMetrics(boolean bl) {
        if (bl != this.isFractionalMetrics()) {
            this.q = bl ? (short)(this.q | 0x80) : (short)(this.q & 0xFFFFFF7F);
            this.n = this.r();
            this.c(false);
            this.f(false);
        }
    }

    public Font getFont() {
        return this.p;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = IlvToolkit.defaultFont;
        }
        if (this.p == null || !this.p.equals(font)) {
            this.p = font;
            this.n = this.r();
            this.c(false);
            this.f(false);
        }
    }

    public Shape getClip() {
        return (Shape)this.getProperty("__ClipProperty");
    }

    public void setClip(Shape shape) {
        this.setProperty("__ClipProperty", shape);
    }

    public void setForeground(Color color) {
        this.setFillPaint(color);
    }

    public Paint getFillPaint() {
        if (this.s == null) {
            return Color.black;
        }
        return this.s;
    }

    public void setFillPaint(Paint paint) {
        if ((paint == null || paint instanceof Color) && !this.isStrokeOn()) {
            if (!this.d()) {
                this.b(true);
                this.c(false);
            }
        } else if (this.d()) {
            this.b(false);
            this.c(false);
        }
        this.s = paint;
        this.r = this.a(this.x, this.getFillPaint());
    }

    public Paint getStrokePaint() {
        if (this.v == null) {
            return Color.black;
        }
        return this.v;
    }

    public void setStrokePaint(Paint paint) {
        this.v = paint;
        if (this.isBorderOn()) {
            Shape shape = this.a((Shape)this.al, this.m);
            this.u = this.a(shape, this.getStrokePaint());
        } else {
            this.u = this.a(this.x, this.getStrokePaint());
        }
    }

    public boolean isFillOn() {
        return (this.q & 4) != 0;
    }

    public void setFillOn(boolean bl) {
        this.q = bl ? (short)(this.q | 4) : (short)(this.q & 0xFFFFFFFB);
    }

    public boolean isStrokeOn() {
        return (this.q & 2) != 0;
    }

    public void setStrokeOn(boolean bl) {
        if (bl) {
            this.q = (short)(this.q | 2);
            this.b(false);
        } else {
            this.q = (short)(this.q & 0xFFFFFFFD);
            if (this.r == null || this.r instanceof Color) {
                this.b(true);
            }
        }
        this.c(false);
    }

    public Stroke getStroke() {
        return this.t;
    }

    public void setStroke(Stroke stroke) {
        this.t = stroke;
        this.c(false);
    }

    public void setBackgroundPaint(Paint paint) {
        this.ak = paint;
        Shape shape = this.a((Shape)this.al, this.m);
        this.aj = this.a(shape, this.getBackgroundPaint());
    }

    public Paint getBackgroundPaint() {
        if (this.ak == null) {
            return Color.white;
        }
        return this.ak;
    }

    public boolean isBackgroundOn() {
        return (this.q & 0x100) != 0;
    }

    public void setBackgroundOn(boolean bl) {
        this.q = bl ? (short)(this.q | 0x100) : (short)(this.q & 0xFFFFFEFF);
        this.c(false);
    }

    public boolean isBorderOn() {
        return (this.q & 0x200) != 0;
    }

    public void setBorderOn(boolean bl) {
        if (bl) {
            this.q = (short)(this.q | 0x200);
            Shape shape = this.a((Shape)this.al, this.m);
            this.u = this.a(shape, this.getStrokePaint());
        } else {
            this.q = (short)(this.q & 0xFFFFFDFF);
            this.u = this.a(this.x, this.getStrokePaint());
        }
        this.c(false);
    }

    public boolean isPaintAbsolute() {
        return (this.q & 0x10) != 0;
    }

    public void setPaintAbsolute(boolean bl) {
        if (bl) {
            this.q = (short)(this.q | 0x10);
            this.r = this.getFillPaint();
            this.u = this.getStrokePaint();
        } else {
            this.q = (short)(this.q & 0xFFFFFFEF);
            this.b();
        }
    }

    private void b() {
        Shape shape = null;
        if (this.isBackgroundOn() || this.isBorderOn()) {
            shape = this.a((Shape)this.al, this.m);
        }
        if (this.isBackgroundOn()) {
            this.aj = this.a(shape, this.getBackgroundPaint());
        }
        this.r = this.a(this.x, this.getFillPaint());
        this.u = this.isBorderOn() ? this.a(shape, this.getStrokePaint()) : this.a(this.x, this.getStrokePaint());
    }

    private Paint a(Shape shape, Paint paint) {
        if (this.isPaintAbsolute() || shape == null) {
            return paint;
        }
        return this.adaptPaint(shape, paint);
    }

    protected Paint adaptPaint(Shape shape, Paint paint) {
        return IlvUtility2D.AdaptPaint(shape, paint);
    }

    public void setLeftMargin(float f2) {
        if (this.ae != f2 && f2 >= 0.0f) {
            this.ae = f2;
            this.c(false);
        }
    }

    public float getLeftMargin() {
        return this.ae;
    }

    public void setRightMargin(float f2) {
        if (this.af != f2 && f2 >= 0.0f) {
            this.af = f2;
            this.c(false);
        }
    }

    public float getRightMargin() {
        return this.af;
    }

    public void setTopMargin(float f2) {
        if (this.ag != f2 && f2 >= 0.0f) {
            this.ag = f2;
            this.c(false);
        }
    }

    public float getTopMargin() {
        return this.ag;
    }

    public void setBottomMargin(float f2) {
        if (this.ah != f2 && f2 >= 0.0f) {
            this.ah = f2;
            this.c(false);
        }
    }

    public float getBottomMargin() {
        return this.ah;
    }

    public void setJustification(int n2) {
        if (this.ai != n2) {
            this.ai = n2;
            this.c(false);
        }
    }

    public final int getJustification() {
        return this.ai;
    }

    public final void setMultilineSpacing(float f2) {
        if (this.ad != f2) {
            this.ad = f2;
            this.c(false);
        }
    }

    public final float getMultilineSpacing() {
        return this.ad;
    }

    private boolean c() {
        return (this.q & 0x20) != 0;
    }

    private void a(boolean bl) {
        this.q = bl ? (short)(this.q | 0x20) : (short)(this.q & 0xFFFFFFDF);
    }

    private boolean d() {
        return (this.q & 0x40) != 0;
    }

    private void b(boolean bl) {
        this.q = bl ? (short)(this.q | 0x40) : (short)(this.q & 0xFFFFFFBF);
    }

    private boolean e() {
        return this.c() && this.d() && this.m();
    }

    private boolean f() {
        return this.d() && this.m();
    }

    private boolean g() {
        return !this.f() || !this.c() && !this.m.isTranslation();
    }

    private boolean j() {
        return (this.q & 1) != 0;
    }

    private void c(boolean bl) {
        this.q = bl ? (short)(this.q | 1) : (short)(this.q & 0xFFFFFFFE);
    }

    private boolean k() {
        return (this.q & 0x800) != 0;
    }

    private void f(boolean bl) {
        this.q = bl ? (short)(this.q | 0x800) : (short)(this.q & 0xFFFFF7FF);
    }

    private boolean l() {
        return (this.q & 0x400) != 0;
    }

    private void g(boolean bl) {
        this.q = bl ? (short)(this.q | 0x400) : (short)(this.q & 0xFFFFFBFF);
    }

    private boolean m() {
        return !this.l() && !this.isBackgroundOn() && !this.isBorderOn();
    }

    private void n() {
        if (this.m()) {
            this.o();
        } else {
            this.p();
        }
        this.c(true);
        this.b();
    }

    private void o() {
        boolean bl;
        String string = this.getLabel();
        boolean bl2 = bl = !this.m.isIdentity() && this.g();
        if (string == null) {
            this.w.setRect(this.a(".").getBounds2D());
            if (bl) {
                this.m.apply(this.w);
            }
            this.x = new GeneralPath();
        } else {
            if (!this.k()) {
                this.y = this.a(this.getLabel());
                this.f(true);
            }
            if (this.a(this.y)) {
                this.w.setRect(this.a(".").getBounds2D());
                if (bl) {
                    this.m.apply(this.w);
                }
                this.x = this.y;
            } else {
                this.x = bl ? this.a(this.y, this.m) : this.y;
                Rectangle2D rectangle2D = this.x.getBounds2D();
                this.w.setRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
                if (this.isStrokeOn()) {
                    Shape shape = this.b(this.x);
                    this.w.add(shape.getBounds2D());
                }
            }
        }
    }

    private synchronized void p() {
        Shape shape;
        float f2;
        int n2;
        this.q();
        String[] stringArray = this.ac;
        String[] stringArray2 = this.ab;
        int n3 = stringArray.length;
        Rectangle2D.Float[] floatArray = new Rectangle2D.Float[n3];
        Shape[] shapeArray = new Shape[n3];
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float f3 = 0.0f;
        float f4 = this.getFont().getLineMetrics(am, this.n).getHeight() + this.getMultilineSpacing();
        Shape shape2 = this.a(am);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        for (n2 = 0; n2 < n3; ++n2) {
            floatArray[n2] = new Rectangle2D.Float();
            floatArray[n2].setRect(rectangle2D);
            floatArray[n2].y += f3;
            floatArray[n2].width = 0.0f;
            if (stringArray[n2].length() > 0) {
                Shape shape3 = this.a(stringArray[n2]);
                float_.setRect(shape3.getBounds2D());
                float_.y += f3;
                Rectangle2D.union(floatArray[n2], float_, floatArray[n2]);
                f2 = this.getFont().getLineMetrics(stringArray[n2], this.n).getHeight() + this.getMultilineSpacing();
                shapeArray[n2] = stringArray[n2] == stringArray2[n2] ? shape3 : this.a(stringArray2[n2]);
            } else {
                shapeArray[n2] = null;
                f2 = f4;
            }
            f3 += f2;
        }
        this.al.setRect(this.a(".").getBounds2D());
        for (n2 = 0; n2 < n3; ++n2) {
            Rectangle2D.union(this.al, floatArray[n2], this.al);
        }
        if (n3 == 1) {
            this.x = shapeArray[0] != null ? this.a(shapeArray[0], this.m) : new GeneralPath();
        } else {
            int n4 = this.getJustification();
            IlvPoint ilvPoint = new IlvPoint();
            IlvTransformer ilvTransformer = new IlvTransformer(this.m);
            GeneralPath generalPath = new GeneralPath();
            for (n2 = 0; n2 < n3; ++n2) {
                if (shapeArray[n2] != null) {
                    float f5 = floatArray[n2].x + floatArray[n2].width - this.al.x;
                    f2 = 0.0f;
                    switch (n4) {
                        case 2: {
                            f2 = Math.max(this.al.width - f5, 0.0f);
                            break;
                        }
                        case 16: {
                            f2 = 0.5f * Math.max(this.al.width - f5, 0.0f);
                            break;
                        }
                        default: {
                            f2 = 0.0f;
                        }
                    }
                    if (f2 != 0.0f) {
                        ilvPoint.x = f2;
                        ilvPoint.y = 0.0f;
                        ilvTransformer.deltaApply(ilvPoint);
                        ilvTransformer.translate(ilvPoint.x, ilvPoint.y);
                    }
                    shape = this.a(shapeArray[n2], ilvTransformer);
                    generalPath.append(shape, false);
                    if (f2 != 0.0f) {
                        ilvTransformer.translate(-ilvPoint.x, -ilvPoint.y);
                    }
                    f2 = this.getFont().getLineMetrics(stringArray[n2], this.n).getHeight() + this.getMultilineSpacing();
                } else {
                    f2 = f4;
                }
                if (f2 == 0.0f) continue;
                ilvPoint.x = 0.0f;
                ilvPoint.y = f2;
                ilvTransformer.deltaApply(ilvPoint);
                ilvTransformer.translate(ilvPoint.x, ilvPoint.y);
            }
            this.x = generalPath;
        }
        boolean bl = false;
        if (!this.a(this.x)) {
            this.w.setRect(this.x.getBounds2D());
            if (this.isStrokeOn()) {
                shape = this.b(this.x);
                this.w.add(shape.getBounds2D());
            }
            bl = true;
        }
        this.al.setRect(this.al.getX() - (double)this.ae, this.al.getY() - (double)this.ag, this.al.getWidth() + (double)this.ae + (double)this.af, this.al.getHeight() + (double)this.ag + (double)this.ah);
        shape = this.a((Shape)this.al, this.m);
        if (this.isBorderOn()) {
            shape = this.b(shape);
        }
        if (!bl) {
            this.w.setRect(shape.getBounds2D());
        } else {
            Rectangle2D.union(this.w, shape.getBounds2D(), this.w);
        }
    }

    private boolean a(Shape shape) {
        if (shape == null) {
            return true;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        return pathIterator.isDone();
    }

    private Shape a(String string) {
        Font font = this.getFont();
        if (string == null || string.length() == 0) {
            GlyphVector glyphVector = font.createGlyphVector(this.n, "");
            return glyphVector.getOutline();
        }
        TextLayout textLayout = new TextLayout(string, font, this.n);
        return textLayout.getOutline(null);
    }

    private Shape b(Shape shape) {
        Stroke stroke = this.getStroke();
        if (stroke == null) {
            if (z == null) {
                z = new BasicStroke(1.0f);
            }
            stroke = z;
        }
        return stroke.createStrokedShape(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Shape a(Shape shape, IlvTransformer ilvTransformer) {
        Shape shape2 = shape;
        if (ilvTransformer == null) return shape2;
        if (ilvTransformer.isIdentity()) return shape2;
        Class<IlvZoomableLabel> clazz = IlvZoomableLabel.class;
        synchronized (IlvZoomableLabel.class) {
            if (ilvTransformer.isTranslation()) {
                aa.setToTranslation(ilvTransformer.getx0(), ilvTransformer.gety0());
                return aa.createTransformedShape(shape);
            } else {
                aa.setTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
            }
            return aa.createTransformedShape(shape);
        }
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.getLabel() == null) {
            return;
        }
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        if (ilvRect.width < 1.0f && ilvRect.height < 1.0f) {
            return;
        }
        if (this.m()) {
            this.a(graphics, ilvTransformer, this.getLabel());
        } else {
            this.a(graphics, ilvTransformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Graphics graphics, IlvTransformer ilvTransformer, String string) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = null;
        Stroke stroke = null;
        Shape shape = null;
        Shape shape2 = this.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        boolean bl = this.e() || this.d() && this.m.isTranslation() && (ilvTransformer == null || ilvTransformer.isTranslation());
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        Class<IlvZoomableLabel> clazz = IlvZoomableLabel.class;
        synchronized (IlvZoomableLabel.class) {
            if (!(shape2 == null && (bl || this.f() && this.m.isTranslation()))) {
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    aa.setTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
                } else {
                    aa.setToIdentity();
                }
                if (shape2 != null) {
                    shape = graphics2D.getClip();
                    shape2 = aa.createTransformedShape(shape2);
                }
            }
            if (bl || !bl && this.f() && this.m.isTranslation()) {
                IlvTransformer ilvTransformer2 = null;
                ilvTransformer2 = this.getTransformer();
                ilvTransformer2.compose(ilvTransformer);
                if (!ilvTransformer2.isIdentity()) {
                    aa.setTransform(ilvTransformer2.getx11(), ilvTransformer2.getx21(), ilvTransformer2.getx12(), ilvTransformer2.getx22(), ilvTransformer2.getx0(), ilvTransformer2.gety0());
                } else {
                    aa.setToIdentity();
                }
            }
            if (this.isAntialiasing()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            if (this.isFractionalMetrics()) {
                object3 = graphics2D.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            if (!bl && this.x != null) {
                if (shape2 != null) {
                    graphics2D.clip(shape2);
                }
                graphics2D.transform(aa);
                if (this.isFillOn()) {
                    graphics2D.setPaint(this.r);
                    graphics2D.fill(this.x);
                }
                if (this.isStrokeOn()) {
                    stroke = graphics2D.getStroke();
                    if (this.t != null) {
                        graphics2D.setStroke(this.t);
                    }
                    graphics2D.setPaint(this.u);
                    graphics2D.draw(this.x);
                    if (this.t != null) {
                        graphics2D.setStroke(stroke);
                    }
                }
                graphics2D.setPaint(paint);
                graphics2D.setTransform(affineTransform);
            } else if (this.isFillOn()) {
                paint = graphics2D.getPaint();
                if (shape2 != null) {
                    graphics2D.clip(shape2);
                }
                graphics2D.transform(aa);
                graphics2D.setFont(this.getFont());
                graphics2D.setColor((Color)this.r);
                if (string.length() > 0) {
                    graphics2D.drawString(string, 0, 0);
                }
            }
            // ** MonitorExit[var14_14] (shouldn't be in output)
            graphics2D.setTransform(affineTransform);
            if (shape2 != null) {
                graphics2D.setClip(shape);
            }
            graphics2D.setPaint(paint);
            if (object != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
            if (object2 != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
            }
            if (object3 != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, object3);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void a(Graphics graphics, IlvTransformer ilvTransformer) {
        boolean bl;
        Shape shape;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isBackgroundOn() || this.isBorderOn()) {
            Shape shape2 = this.getClip();
            shape = graphics2D.getClip();
            Stroke stroke = graphics2D.getStroke();
            AffineTransform affineTransform = graphics2D.getTransform();
            Class<IlvZoomableLabel> clazz = IlvZoomableLabel.class;
            // MONITORENTER : ilog.views.graphic.IlvZoomableLabel.class
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                aa.setTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
            } else {
                aa.setToIdentity();
            }
            if (shape2 != null) {
                shape2 = aa.createTransformedShape(shape2);
                graphics2D.clip(shape2);
            }
            graphics2D.transform(aa);
            Shape shape3 = this.a((Shape)this.al, this.m);
            if (this.isBackgroundOn()) {
                graphics2D.setPaint(this.aj);
                graphics2D.fill(shape3);
            }
            if (this.isBorderOn()) {
                graphics2D.setPaint(this.u);
                if (this.t != null) {
                    graphics2D.setStroke(this.t);
                }
                graphics2D.draw(shape3);
            }
            // MONITOREXIT : clazz
            graphics2D.setTransform(affineTransform);
            graphics2D.clip(shape);
            graphics2D.setStroke(stroke);
        }
        boolean bl2 = bl = this.d() && this.m.isTranslation() && (ilvTransformer == null || ilvTransformer.isTranslation());
        if (!bl) {
            this.a(graphics, ilvTransformer, null);
            return;
        }
        shape = new Rectangle2D.Float();
        int n2 = this.getJustification();
        float f2 = this.al.width - this.ae - this.af;
        float f3 = 0.0f;
        float f4 = 0.0f;
        IlvTransformer ilvTransformer2 = new IlvTransformer(ilvTransformer);
        float f5 = this.getFont().getLineMetrics(am, this.n).getHeight() + this.getMultilineSpacing();
        int n3 = this.ab.length;
        int n4 = 0;
        while (n4 < n3) {
            float f6;
            if (this.ab[n4].length() > 0) {
                ((Rectangle2D.Float)shape).setRect(this.a(this.ac[n4]).getBounds2D());
                ((Rectangle2D.Float)shape).y += f3;
                float f7 = ((Rectangle2D.Float)shape).x + ((Rectangle2D.Float)shape).width - this.al.x - this.ae;
                f4 = 0.0f;
                if (n3 > 1) {
                    switch (n2) {
                        case 2: {
                            f4 = Math.max(f2 - f7, 0.0f);
                            break;
                        }
                        case 16: {
                            f4 = 0.5f * Math.max(f2 - f7, 0.0f);
                            break;
                        }
                        default: {
                            f4 = 0.0f;
                        }
                    }
                    ilvTransformer2.translate(f4, 0.0);
                }
                this.a(graphics, ilvTransformer2, this.ab[n4]);
                f6 = this.getFont().getLineMetrics(this.ac[n4], this.n).getHeight() + this.getMultilineSpacing();
            } else {
                f4 = 0.0f;
                f6 = f5;
            }
            ilvTransformer2.translate(-f4, f6);
            f3 += f6;
            ++n4;
        }
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        boolean bl = this.g();
        if (this.getClip() != null) {
            this.setClip(IlvGraphicUtil.CreateTransformedShape(this.getClip(), ilvTransformer));
        }
        this.m.compose(ilvTransformer);
        if (this.g() || bl) {
            this.c(false);
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("transform", this.m);
        ilvOutputStream.write("font", this.p);
        if (this.l()) {
            ilvOutputStream.write("labels", this.ab);
        } else {
            ilvOutputStream.write("label", this.o);
        }
        ilvOutputStream.write("flags", this.q);
        Stroke stroke = this.getStroke();
        if (stroke != null) {
            if (stroke instanceof IlvPersistentObject) {
                ilvOutputStream.write("pstroke", (IlvPersistentObject)((Object)stroke));
            } else if (stroke instanceof BasicStroke) {
                ilvOutputStream.write("stroke", (BasicStroke)stroke);
            }
        }
        IlvUtility2D.writeStrokePaint(ilvOutputStream, this.getStrokePaint());
        IlvUtility2D.writePaint(ilvOutputStream, this.getFillPaint());
        if (this.getClip() != null) {
            ilvOutputStream.write("clip", "clipRule", this.getClip());
        }
        if (this.ad != 0.0f) {
            ilvOutputStream.write("multilineSpacing", this.ad);
        }
        if (this.ae != 0.0f) {
            ilvOutputStream.write("leftMargin", this.ae);
        }
        if (this.af != 0.0f) {
            ilvOutputStream.write("rightMargin", this.af);
        }
        if (this.ag != 0.0f) {
            ilvOutputStream.write("topMargin", this.ag);
        }
        if (this.ah != 0.0f) {
            ilvOutputStream.write("bottomMargin", this.ah);
        }
        if (this.ai != 0) {
            ilvOutputStream.write("justification", this.ai);
        }
        if (this.ak != null) {
            IlvUtility2D.writePaint(ilvOutputStream, this.getBackgroundPaint(), "backColor", "b", Color.white);
        }
    }

    public String toString() {
        String string = this.getLabel();
        if (string == null) {
            string = "[null string]";
        } else if (string.length() == 0) {
            string = "[empty string]";
        }
        return super.toString() + " Label: " + string;
    }

    private void q() {
        int n2;
        if (this.ab != null) {
            return;
        }
        String string = this.getLabel();
        if (string.indexOf(10) < 0) {
            this.ab = new String[1];
            this.ac = new String[1];
            this.ab[0] = string;
            this.ac[0] = IlvZoomableLabel.b(string);
            return;
        }
        int n3 = 1;
        int n4 = string.length();
        for (n2 = 0; n2 < n4; ++n2) {
            if (string.charAt(n2) != '\n') continue;
            ++n3;
        }
        this.ab = new String[n3];
        this.ac = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.ac[n2] = "";
            this.ab[n2] = "";
        }
        String string2 = null;
        n2 = string.indexOf(10);
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1);
            string = string.substring(0, n2);
        }
        int n5 = 0;
        while (string != null) {
            this.ab[n5] = string;
            this.ac[n5] = IlvZoomableLabel.b(string);
            ++n5;
            if (string2 == null) break;
            string = string2;
            n2 = string.indexOf(10);
            if (n2 >= 0) {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
                continue;
            }
            string2 = null;
        }
    }

    private static String b(String string) {
        if (string == null) {
            return string;
        }
        if (!string.endsWith(" ")) {
            return string;
        }
        char[] cArray = string.toCharArray();
        for (int i2 = cArray.length - 1; i2 >= 0 && cArray[i2] == ' '; --i2) {
            cArray[i2] = 95;
        }
        return new String(cArray);
    }

    private FontRenderContext r() {
        char c2;
        FontRenderContext fontRenderContext = new FontRenderContext(null, this.isAntialiasing(), this.isFractionalMetrics());
        if (!IlvZoomableLabel.IsTransformerDependentRendering()) {
            return fontRenderContext;
        }
        AffineTransform affineTransform = new AffineTransform();
        Font font = this.getFont();
        if (font.canDisplay(c2 = '\u6211')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\uf910')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u3070')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u30f0')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\uff96')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\uac30')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\ua07b')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u1859')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u05d0')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u0634')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u072c')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u07a7')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u09e0')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u0bf1')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u042f')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '\u2665')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '[')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        if (font.canDisplay(c2 = '8')) {
            fontRenderContext = this.a(fontRenderContext, c2, font, affineTransform);
        }
        return fontRenderContext;
    }

    private FontRenderContext a(FontRenderContext fontRenderContext, char c2, Font font, AffineTransform affineTransform) {
        TextLayout textLayout;
        Rectangle2D rectangle2D;
        double d2 = affineTransform.getScaleX();
        String string = "" + c2;
        for (int i2 = 0; i2 < 8 && (rectangle2D = (textLayout = new TextLayout(string, font, fontRenderContext)).getBounds()).getHeight() != 0.0 && !(rectangle2D.getHeight() * d2 >= 100.0); ++i2) {
            d2 *= 2.0;
            affineTransform.scale(2.0, 2.0);
            fontRenderContext = new FontRenderContext(affineTransform, this.isAntialiasing(), this.isFractionalMetrics());
        }
        return fontRenderContext;
    }

    public static void SetTransformerDependentRendering(boolean bl) {
        an = bl;
    }

    public static boolean IsTransformerDependentRendering() {
        return an;
    }

    static {
        aa = new AffineTransform();
        an = false;
    }
}

