/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite;

import ilog.views.IlvApplyObject;
import ilog.views.IlvDefinitionRectInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.event.adapter.IlvManagerSelectionDispatcher;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.composite.IlvComposite;
import ilog.views.graphic.composite.IlvEventMap;
import ilog.views.graphic.composite.IlvMouseGesture;
import ilog.views.graphic.composite.decoration.IlvHotSpot;
import ilog.views.graphic.composite.internal.IlvBaseBorderSelection;
import ilog.views.graphic.composite.internal.IlvBaseHandleSelection;
import ilog.views.graphic.composite.internal.IlvCompositePart;
import ilog.views.graphic.composite.internal.IlvCompositeSelectionDispatcher;
import ilog.views.graphic.composite.internal.IlvEmptyPersistentGraphic;
import ilog.views.graphic.composite.internal.IlvEmptyPersistentObject;
import ilog.views.graphic.composite.internal.IlvInvisibleSelection;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import ilog.views.graphic.composite.layout.IlvAttachmentBounds;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLayout;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.internal.IlvBoundingBoxCache;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;

public class IlvCompositeGraphic
extends IlvGraphicSet
implements IlvComposite,
IlvAttachmentBounds,
ManagerSelectionListener,
IlvHotSpot,
IlvDefinitionRectInterface {
    private IlvLayoutManager a;
    private IlvGraphic[] b;
    private IlvAttachable[] c;
    private boolean d = false;
    private Object[] e;
    private IlvRect f = new IlvRect(0.0f, 0.0f, 1.0E-20f, 1.0E-20f);
    private IlvEventMap[] g;
    private IlvEventMap h;
    private IlvComposite i;
    private int j;
    private double[] k;
    private boolean[] l;
    private int m;
    private Map n = new HashMap();
    private IlvAttachable o = new IlvAttachableGraphic(this, null);
    private int p = 0;
    private boolean q = true;
    private boolean r = false;
    private static boolean s = false;
    private final IlvBoundingBoxCache t = new IlvBoundingBoxCache();
    public static final int BaseHandleSelection = 0;
    public static final int BaseBorderSelection = 1;
    public static final int InvisibleSelection = 2;
    public static final int CompositeHandleSelection = 3;
    public static final int ResizingComposite = 0;
    public static final int ResizingBase = 1;
    public static final int TransformationModeAll = 1;
    public static final int TransformationModeBaseOnly = 0;
    private boolean u = false;
    private boolean v = true;
    private IlvApplyObject w = new IlvApplyObject(){

        public void apply(IlvGraphic ilvGraphic, Object object) {
            IlvGraphic ilvGraphic2 = (IlvGraphic)object;
            if (ilvGraphic2.getGraphicBag() != null) {
                ilvGraphic2.getGraphicBag().removeObject(ilvGraphic2, false);
            }
            ((IlvGraphicSet)ilvGraphic).addObjectAt(ilvGraphic2, -1, false);
        }
    };

    public IlvCompositeGraphic() {
        this(new IlvAttachmentLayout());
    }

    public IlvCompositeGraphic(IlvLayoutManager ilvLayoutManager) {
        this.setLayout(ilvLayoutManager);
    }

    public IlvCompositeGraphic(IlvCompositeGraphic ilvCompositeGraphic) {
        super(ilvCompositeGraphic);
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            this.removeObject(ilvGraphicEnumeration.nextElement(), false);
        }
        if (ilvCompositeGraphic.b != null) {
            for (int i2 = 0; i2 < ilvCompositeGraphic.b.length; ++i2) {
                if (ilvCompositeGraphic.b[i2] == null) continue;
                this.setChildren(i2, ilvCompositeGraphic.b[i2].copy());
            }
        }
        try {
            if (ilvCompositeGraphic.a != null) {
                this.setLayout((IlvLayoutManager)ilvCompositeGraphic.a.clone());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
        if (ilvCompositeGraphic.e != null) {
            for (int i3 = 0; i3 < ilvCompositeGraphic.e.length; ++i3) {
                if (ilvCompositeGraphic.e[i3] == null) continue;
                this.setConstraints(i3, ((IlvAttachmentConstraint)ilvCompositeGraphic.e[i3]).clone());
            }
        }
        if (ilvCompositeGraphic.h != null) {
            this.setEventMap((IlvEventMap)ilvCompositeGraphic.h.clone());
        }
        if (ilvCompositeGraphic.g != null) {
            for (int i4 = 0; i4 < ilvCompositeGraphic.g.length; ++i4) {
                if (ilvCompositeGraphic.g[i4] == null) continue;
                this.setEventMaps(i4, (IlvEventMap)ilvCompositeGraphic.g[i4].clone());
            }
        }
        this.setSelectionType(ilvCompositeGraphic.j);
        this.setResizingPolicy(ilvCompositeGraphic.m);
        this.setTransformationMode(ilvCompositeGraphic.p);
        this.setSensitive(ilvCompositeGraphic.q);
        if (ilvCompositeGraphic.k != null) {
            int n2 = ilvCompositeGraphic.k.length;
            this.k = new double[n2];
            System.arraycopy(ilvCompositeGraphic.k, 0, this.k, 0, n2);
        }
        if (ilvCompositeGraphic.l != null) {
            int n3 = ilvCompositeGraphic.l.length;
            this.l = new boolean[n3];
            System.arraycopy(ilvCompositeGraphic.l, 0, this.l, 0, n3);
        }
    }

    public IlvCompositeGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        int n2;
        IlvPersistentObject[] ilvPersistentObjectArray;
        try {
            ilvPersistentObjectArray = ilvInputStream.readObjects("children");
            for (n2 = 0; n2 < ilvPersistentObjectArray.length; ++n2) {
                if (ilvPersistentObjectArray[n2] instanceof IlvEmptyPersistentGraphic) continue;
                this.setChildren(n2, (IlvGraphic)ilvPersistentObjectArray[n2]);
            }
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLayout((IlvLayoutManager)ilvInputStream.readPersistentObject("layout"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            ilvPersistentObjectArray = ilvInputStream.readPersistentObjects("constraints");
            for (n2 = 0; n2 < ilvPersistentObjectArray.length; ++n2) {
                if (ilvPersistentObjectArray[n2] instanceof IlvEmptyPersistentObject) continue;
                this.setConstraints(n2, ilvPersistentObjectArray[n2]);
            }
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.setSelectionType(ilvInputStream.readInt("selectionType"));
        try {
            this.setVisibilityThresholds(ilvInputStream.readDoubleArray("visibilityThresholds"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLinkClippables(ilvInputStream.readBooleanArray("linkClippables"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.setResizingPolicy(ilvInputStream.readInt("resizingPolicy"));
        try {
            this.setTransformationMode(ilvInputStream.readInt("transformationMode"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setSensitive(ilvInputStream.readBoolean("sensitive"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvCompositeGraphic(this);
    }

    public boolean isValid() {
        return this.d;
    }

    public void invalidate() {
        this.d = false;
        this.a();
        if (this.i != null && this.i.isValid()) {
            this.i.invalidate();
        }
    }

    private void a() {
        this.t.setInvalid();
    }

    public void validate() {
        this.d = true;
    }

    public void setLayout(IlvLayoutManager ilvLayoutManager) {
        this.a = ilvLayoutManager;
        this.invalidate();
    }

    public IlvLayoutManager getLayout() {
        return this.a;
    }

    public void setChildren(IlvGraphic[] ilvGraphicArray) {
        this.d();
        this.b = ilvGraphicArray;
        if (ilvGraphicArray != null) {
            this.c = new IlvAttachableGraphic[ilvGraphicArray.length];
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                this.c[i2] = this.getAttachableGraphic(ilvGraphicArray[i2]);
                if (!(ilvGraphicArray[i2] instanceof IlvCompositeGraphic)) continue;
                ((IlvCompositeGraphic)ilvGraphicArray[i2]).a(this);
            }
        }
        this.invalidate();
    }

    public void setChildren(int n2, IlvGraphic ilvGraphic) {
        if (n2 < 0) {
            throw new IllegalArgumentException("bad index range");
        }
        if (this.b == null) {
            this.b = new IlvGraphic[n2 + 1];
            this.c = new IlvAttachableGraphic[n2 + 1];
        } else if (n2 >= this.b.length) {
            IlvGraphic[] ilvGraphicArray = new IlvGraphic[n2 + 1];
            IlvAttachableGraphic[] ilvAttachableGraphicArray = new IlvAttachableGraphic[n2 + 1];
            System.arraycopy(this.b, 0, ilvGraphicArray, 0, this.b.length);
            this.b = ilvGraphicArray;
            System.arraycopy(this.c, 0, ilvAttachableGraphicArray, 0, this.c.length);
            this.c = ilvAttachableGraphicArray;
        }
        if (this.b[n2] == ilvGraphic) {
            return;
        }
        this.removeChild(n2);
        if (ilvGraphic == null) {
            if (this.isEmpty()) {
                this.b = null;
                this.c = null;
            }
            return;
        }
        this.b[n2] = ilvGraphic;
        this.c[n2] = this.getAttachableGraphic(ilvGraphic);
        if (ilvGraphic instanceof IlvCompositeGraphic) {
            ((IlvCompositeGraphic)ilvGraphic).a(this);
        }
        this.invalidate();
    }

    public IlvGraphic getChildren(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("bad index range");
        }
        if (this.b == null || n2 >= this.b.length) {
            return null;
        }
        return this.b[n2];
    }

    void a(IlvComposite ilvComposite) {
        this.i = ilvComposite;
    }

    public IlvComposite getParent() {
        return this.i;
    }

    public IlvComposite getRoot() {
        IlvComposite ilvComposite = this;
        while (ilvComposite.getParent() != null) {
            ilvComposite = ilvComposite.getParent();
        }
        return ilvComposite;
    }

    public IlvGraphic[] getChildren() {
        return this.b;
    }

    public void setConstraints(Object[] objectArray) {
        this.e = objectArray;
        this.a();
    }

    public void setConstraints(int n2, Object object) {
        if (n2 < 0) {
            throw new IllegalArgumentException("bad index range");
        }
        if (this.e == null) {
            this.e = new Object[n2 + 1];
        } else if (n2 >= this.e.length) {
            Object[] objectArray = new Object[n2 + 1];
            System.arraycopy(this.e, 0, objectArray, 0, this.e.length);
            this.e = objectArray;
        }
        this.e[n2] = object;
        this.a();
    }

    public Object[] getConstraints() {
        return this.e;
    }

    public Object getConstraints(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("bad index range");
        }
        if (this.e == null || n2 >= this.e.length) {
            return null;
        }
        return this.e[n2];
    }

    public IlvAttachable[] getAttachables() {
        return this.c;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        if (this.isEmpty()) {
            IlvRect ilvRect2 = new IlvRect(this.f);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvRect2);
            }
            return ilvRect2;
        }
        if (this.a != null && !this.isValid()) {
            this.doLayout();
        }
        if ((ilvRect = this.t.get(ilvTransformer)) != null) {
            return new IlvRect(ilvRect);
        }
        IlvRect ilvRect3 = null;
        double d2 = ilvTransformer != null ? Math.abs(ilvTransformer.zoomFactor()) : 1.0;
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        if (ilvGraphicArray != null) {
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                IlvGraphic ilvGraphic = ilvGraphicArray[i2];
                if (ilvGraphic == null) continue;
                if (ilvRect3 == null) {
                    ilvRect3 = ilvGraphic.boundingBox(ilvTransformer);
                }
                if (s && !this.b(i2) || d2 < this.getVisibilityThresholds(i2) || !ilvGraphic.isVisible() || ilvGraphic instanceof IlvCompositeGraphic && ((IlvCompositeGraphic)ilvGraphic).isEmpty()) continue;
                IlvRect ilvRect4 = ilvGraphic.boundingBox(ilvTransformer);
                if (ilvRect == null) {
                    ilvRect = ilvRect4;
                    continue;
                }
                ilvRect.add(ilvRect4);
            }
        }
        if (ilvRect == null) {
            ilvRect = ilvRect3;
        }
        if (ilvRect == null) {
            ilvRect = new IlvRect();
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        this.t.put(ilvTransformer, ilvRect);
        return new IlvRect(ilvRect);
    }

    public boolean zoomable() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.a != null && !this.isValid()) {
            this.doLayout();
        }
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        boolean bl = true;
        boolean bl2 = false;
        if (ilvGraphicArray != null) {
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                if (this.getVisibilityThresholds(i2) > 0.0) {
                    return false;
                }
                IlvGraphic ilvGraphic = ilvGraphicArray[i2];
                if (ilvGraphic == null) continue;
                if (!bl2) {
                    bl = ilvGraphic.zoomable();
                    bl2 = true;
                }
                if (s && !this.b(i2) || ilvGraphic.zoomable()) continue;
                return false;
            }
        }
        return bl;
    }

    public void moveResize(IlvRect ilvRect) {
        if (ilvRect.width < 1.0E-20f || ilvRect.height < 1.0E-20f) {
            ilvRect = new IlvRect(ilvRect);
            if (ilvRect.width < 1.0E-20f) {
                ilvRect.width = 1.0E-20f;
            }
            if (ilvRect.height < 1.0E-20f) {
                ilvRect.height = 1.0E-20f;
            }
        }
        this.a();
        if (this.a == null || !this.a.resizeFirstChildOnly() || this.getTransformationMode() == 1) {
            this.a(ilvRect);
        } else {
            switch (this.getResizingPolicy()) {
                case 1: {
                    IlvRect ilvRect2 = IlvCompositeGraphic.a(this.getChildren(0));
                    IlvTransformer ilvTransformer = new IlvTransformer();
                    IlvTransformer.computeTransformer(ilvRect2, ilvRect, ilvTransformer);
                    if (ilvTransformer.isBad()) break;
                    this.applyTransform(ilvTransformer);
                    break;
                }
                case 0: {
                    float f2;
                    if (this.getChildren(0) == null) break;
                    boolean bl = false;
                    boolean bl2 = false;
                    IlvGraphic[] ilvGraphicArray = this.getChildren();
                    ilvRect = new IlvRect(ilvRect);
                    IlvCompositeGraphic.b(ilvGraphicArray[0], ilvRect);
                    this.invalidate();
                    IlvRect ilvRect3 = this.getAttachmentBounds();
                    IlvRect ilvRect4 = IlvCompositeGraphic.a(ilvGraphicArray[0]);
                    IlvLayoutManager ilvLayoutManager = this.getLayout();
                    if (ilvLayoutManager instanceof IlvAttachmentLayout) {
                        for (int i2 = 1; i2 < ilvGraphicArray.length; ++i2) {
                            if (ilvGraphicArray[i2] == null) continue;
                            IlvRect ilvRect5 = IlvCompositeGraphic.a(ilvGraphicArray[i2]);
                            IlvAttachmentLocation ilvAttachmentLocation = ((IlvAttachmentConstraint)this.getConstraints(i2)).getAnchor();
                            f2 = 0.0f;
                            if (IlvAttachmentLocation.TopLeft.equals(ilvAttachmentLocation) || IlvAttachmentLocation.LeftCenter.equals(ilvAttachmentLocation) || IlvAttachmentLocation.BottomLeft.equals(ilvAttachmentLocation)) {
                                f2 = Math.abs(ilvRect3.x - ilvRect5.x) + ilvRect5.width;
                            }
                            if (f2 > ilvRect.width) {
                                bl = true;
                            }
                            float f3 = 0.0f;
                            if (IlvAttachmentLocation.TopLeft.equals(ilvAttachmentLocation) || IlvAttachmentLocation.TopCenter.equals(ilvAttachmentLocation) || IlvAttachmentLocation.TopRight.equals(ilvAttachmentLocation)) {
                                f3 = Math.abs(ilvRect3.y - ilvRect5.y) + ilvRect5.height;
                            }
                            if (!(f3 > ilvRect.height)) continue;
                            bl2 = true;
                        }
                    }
                    float f4 = 0.0f;
                    float f5 = 0.0f;
                    if (!bl) {
                        f4 = ilvRect4.x - ilvRect3.x;
                        f5 = ilvRect3.x + ilvRect3.width - ilvRect4.x - ilvRect4.width;
                    }
                    float f6 = 0.0f;
                    f2 = 0.0f;
                    if (!bl2) {
                        f6 = ilvRect4.y - ilvRect3.y;
                        f2 = ilvRect3.y + ilvRect3.height - ilvRect4.y - ilvRect4.height;
                    }
                    if (f4 != 0.0f || f5 != 0.0f || f6 != 0.0f || f2 != 0.0f) {
                        ilvRect.width -= f4 + f5;
                        ilvRect.height -= f6 + f2;
                        ilvRect.translate(f4, f6);
                    }
                    IlvTransformer ilvTransformer = new IlvTransformer();
                    IlvTransformer.computeTransformer(ilvRect4, ilvRect, ilvTransformer);
                    if (ilvTransformer.isBad()) break;
                    this.applyTransform(ilvTransformer);
                }
            }
        }
    }

    private void a(IlvRect ilvRect) {
        IlvRect ilvRect2 = this.getAttachmentBounds();
        if (!ilvRect2.equals(ilvRect)) {
            ilvRect2 = IlvCompositeGraphic.b(ilvRect2);
            ilvRect = IlvCompositeGraphic.b(ilvRect);
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvTransformer.computeTransformer(ilvRect2, ilvRect, ilvTransformer);
            if (!ilvTransformer.isBad()) {
                this.applyTransform(ilvTransformer);
            }
        }
        IlvCompositeGraphic.a(this, ilvRect, true, true);
    }

    private static void a(IlvCompositeGraphic ilvCompositeGraphic, IlvRect ilvRect, boolean bl, boolean bl2) {
        IlvRect ilvRect2 = ilvCompositeGraphic.getAttachmentBounds();
        float f2 = 0.0f;
        if (bl) {
            f2 = Math.max(f2, Math.abs(ilvRect2.x - ilvRect.x));
            f2 = Math.max(f2, Math.abs(ilvRect2.x + ilvRect2.width - ilvRect.x - ilvRect.width));
            f2 = Math.max(f2, Math.abs(ilvRect2.width - ilvRect.width));
            ilvRect2.x = ilvRect.x;
            ilvRect2.width = ilvRect.width;
        }
        if (bl2) {
            f2 = Math.max(f2, Math.abs(ilvRect2.y - ilvRect.y));
            f2 = Math.max(f2, Math.abs(ilvRect2.y + ilvRect2.height - ilvRect.y - ilvRect.height));
            f2 = Math.max(f2, Math.abs(ilvRect2.height - ilvRect.height));
            ilvRect2.y = ilvRect.y;
            ilvRect2.height = ilvRect.height;
        }
        if (f2 > 0.5f) {
            IlvCompositeGraphic.a(ilvCompositeGraphic, ilvRect2);
        }
    }

    private static void a(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        IlvCompositeGraphic.b(ilvRect2);
        for (int i2 = 0; i2 < 4; ++i2) {
            IlvRect ilvRect3 = IlvCompositeGraphic.a(ilvGraphic);
            if (ilvRect3.equals(ilvRect2)) {
                return;
            }
            IlvCompositeGraphic.b(ilvRect3);
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvTransformer.computeTransformer(ilvRect3, ilvRect2, ilvTransformer);
            if (ilvTransformer.isBad()) {
                return;
            }
            ilvGraphic.applyTransform(ilvTransformer);
        }
    }

    private static IlvRect b(IlvRect ilvRect) {
        if (ilvRect.width >= 0.1f && ilvRect.height >= 0.1f) {
            return ilvRect;
        }
        ilvRect = new IlvRect(ilvRect);
        if (ilvRect.width < 0.1f) {
            ilvRect.width = 0.1f;
        }
        if (ilvRect.height < 0.1f) {
            ilvRect.height = 0.1f;
        }
        return ilvRect;
    }

    private static IlvRect a(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvDefinitionRectInterface) {
            return ((IlvDefinitionRectInterface)((Object)ilvGraphic)).getDefinitionRect();
        }
        if (ilvGraphic instanceof IlvGeneralPath) {
            return ((IlvGeneralPath)ilvGraphic).getShapeBounds(null);
        }
        return ilvGraphic.boundingBox(null);
    }

    private static void b(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        if (ilvGraphic instanceof IlvDefinitionRectInterface) {
            ((IlvDefinitionRectInterface)((Object)ilvGraphic)).setDefinitionRect(ilvRect);
        } else if (ilvGraphic instanceof IlvGeneralPath) {
            ((IlvGeneralPath)ilvGraphic).setShapeBounds(ilvRect);
        } else {
            ilvGraphic.resize(ilvRect.width, ilvRect.height);
        }
    }

    public void resize(float f2, float f3) {
        if (f2 < 1.0E-20f) {
            f2 = 1.0E-20f;
        }
        if (f3 < 1.0E-20f) {
            f3 = 1.0E-20f;
        }
        this.a();
        if (this.a == null || !this.a.resizeFirstChildOnly() || this.getTransformationMode() == 1) {
            this.a(f2, f3);
        } else {
            switch (this.getResizingPolicy()) {
                case 0: {
                    IlvRect ilvRect = this.getChildren(0).boundingBox(null);
                    IlvRect ilvRect2 = this.boundingBox(null);
                    float f4 = ilvRect.x - ilvRect2.x;
                    float f5 = ilvRect2.x + ilvRect2.width - ilvRect.x - ilvRect.width;
                    float f6 = ilvRect.y - ilvRect2.y;
                    float f7 = ilvRect2.y + ilvRect2.height - ilvRect.y - ilvRect.height;
                    this.scale((double)(f2 -= f5 + f4) / (double)Math.max(1.0E-20f, ilvRect.width), (double)(f3 -= f7 + f6) / (double)Math.max(1.0E-20f, ilvRect.height));
                    break;
                }
                case 1: {
                    IlvRect ilvRect = this.getChildren(0).boundingBox(null);
                    this.scale((double)f2 / (double)Math.max(1.0E-20f, ilvRect.width), (double)f3 / (double)Math.max(1.0E-20f, ilvRect.height));
                }
            }
        }
    }

    private void a(float f2, float f3) {
        IlvRect ilvRect = this.getAttachmentBounds();
        this.scale((double)f2 / (double)Math.max(1.0E-20f, ilvRect.width), (double)f3 / (double)Math.max(1.0E-20f, ilvRect.height));
    }

    public void scale(double d2, double d3) {
        IlvRect ilvRect = this.getAttachmentBounds();
        double d4 = (1.0 - d2) * (double)ilvRect.x;
        double d5 = (1.0 - d3) * (double)ilvRect.y;
        IlvTransformer ilvTransformer = new IlvTransformer(d2, 0.0, 0.0, d3, d4, d5);
        if (!ilvTransformer.isBad()) {
            this.applyTransform(ilvTransformer);
        }
    }

    public void setResizingPolicy(int n2) {
        if (n2 != this.m) {
            this.m = n2;
            this.a();
        }
    }

    public int getResizingPolicy() {
        return this.m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCore(Graphics2D graphics2D, IlvTransformer ilvTransformer) {
        if (this.a != null && !this.isValid()) {
            this.doLayout();
        }
        Shape shape = null;
        Shape shape2 = this.getClip();
        if (shape2 != null) {
            shape = IlvGraphicUtil.AddClip(graphics2D, IlvGraphicUtil.CreateTransformedShape(shape2, ilvTransformer));
        }
        try {
            Shape shape3 = graphics2D.getClip();
            Rectangle rectangle = shape3 != null ? shape3.getBounds() : null;
            IlvRect ilvRect = rectangle != null ? new IlvRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : null;
            double d2 = ilvTransformer != null ? Math.abs(ilvTransformer.zoomFactor()) : 1.0;
            IlvGraphic[] ilvGraphicArray = this.getChildren();
            if (ilvGraphicArray == null) {
                return;
            }
            if (ilvRect != null) {
                IlvRect ilvRect2 = new IlvRect(ilvRect);
                if (ilvTransformer != null) {
                    ilvTransformer.boundingBox(ilvRect2, true);
                }
                for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                    IlvGraphic ilvGraphic;
                    if (!this.b(i2) || d2 < this.getVisibilityThresholds(i2) || (ilvGraphic = ilvGraphicArray[i2]) == null || !ilvGraphic.isVisible() || !ilvGraphic.intersects(ilvRect2, ilvRect, ilvTransformer)) continue;
                    ilvGraphic.draw(graphics2D, ilvTransformer);
                }
            } else {
                for (int i3 = 0; i3 < ilvGraphicArray.length; ++i3) {
                    IlvGraphic ilvGraphic;
                    if (!this.b(i3) || d2 < this.getVisibilityThresholds(i3) || (ilvGraphic = ilvGraphicArray[i3]) == null || !ilvGraphic.isVisible()) continue;
                    ilvGraphic.draw(graphics2D, ilvTransformer);
                }
            }
        }
        finally {
            if (shape2 != null) {
                graphics2D.setClip(shape);
            }
        }
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        if (!ilvRect.contains(ilvPoint2.x, ilvPoint2.y)) {
            return false;
        }
        if (this.getClip() != null && !IlvGraphicUtil.PointInShape(ilvPoint, this.getClip())) {
            return false;
        }
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        if (ilvGraphicArray == null) {
            return false;
        }
        double d2 = ilvTransformer != null ? Math.abs(ilvTransformer.zoomFactor()) : 1.0;
        for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
            IlvGraphic ilvGraphic;
            if (!this.b(i2) || d2 < this.getVisibilityThresholds(i2) || (ilvGraphic = ilvGraphicArray[i2]) == null || !ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
            return true;
        }
        return false;
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        this.boundingBox();
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        if (ilvGraphicArray == null) {
            return new IlvPoint(ilvPoint);
        }
        int n2 = ilvGraphicArray.length;
        if (n2 == 0) {
            return new IlvPoint(ilvPoint);
        }
        double d2 = ilvTransformer != null ? Math.abs(ilvTransformer.zoomFactor()) : 1.0;
        IlvPoint[] ilvPointArray = new IlvPoint[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGraphic ilvGraphic;
            if (d2 < this.getVisibilityThresholds(i2) || !this.getLinkClippables(i2) || (ilvGraphic = ilvGraphicArray[i2]) == null || !ilvGraphic.isVisible()) continue;
            ilvPointArray[n3++] = ilvGraphic.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
        }
        if (n3 == 0) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint ilvPoint3 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, n3);
        Shape shape = this.getClip();
        if (shape == null) {
            return ilvPoint3;
        }
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint3);
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvPoint4);
        }
        if (IlvGraphicUtil.PointInShape(ilvPoint4, shape)) {
            return ilvPoint3;
        }
        return IlvClippingUtil.getClippedPoint(shape.getPathIterator(null), ilvTransformer, 0.0f, ilvPoint, ilvPoint2);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (!this.r) {
            this.r = true;
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(this.f);
            }
            if (ilvTransformer != null && !ilvTransformer.isTranslation() && this.a != null && this.a.resizeFirstChildOnly() && this.getTransformationMode() == 0) {
                this.invalidate();
                this.a(ilvTransformer);
            } else {
                if (ilvTransformer != null && !ilvTransformer.isTranslation()) {
                    this.invalidate();
                } else {
                    this.a();
                }
                IlvGraphic[] ilvGraphicArray = this.getChildren();
                for (int i2 = 0; ilvGraphicArray != null && i2 < ilvGraphicArray.length; ++i2) {
                    IlvGraphic ilvGraphic;
                    if (!this.b(i2) || (ilvGraphic = ilvGraphicArray[i2]) == null) continue;
                    ilvGraphic.applyTransform(ilvTransformer);
                }
            }
            this.r = false;
        }
    }

    private void a(IlvTransformer ilvTransformer) {
        this.getChildren(0).applyTransform(ilvTransformer);
    }

    public void setLayoutEnabled(boolean bl, boolean bl2) {
        this.v = bl2;
        this.u = !bl;
    }

    public void doLayout() {
        if (this.u) {
            return;
        }
        if (this.b == null) {
            return;
        }
        this.u = true;
        this.b();
        if (this.a != null) {
            this.a.reset();
            this.a.attach(this.o);
            this.a.layoutGroup(this.o);
        }
        if (this.v) {
            IlvGraphicBag ilvGraphicBag = this;
            while (ilvGraphicBag.getGraphicBag() != null) {
                if (!((ilvGraphicBag = ilvGraphicBag.getGraphicBag()) instanceof IlvCompositeGraphic)) continue;
                ((IlvCompositeGraphic)ilvGraphicBag).doLayout();
                break;
            }
        }
        this.u = false;
        this.d = true;
        this.a();
    }

    private void b() {
        if (this.getGraphicBag() != null) {
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvCompositeGraphic.this.c();
                }
            }, null, false);
        } else {
            this.c();
        }
    }

    private void c() {
        if (this.b == null) {
            return;
        }
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (this.b[i2] instanceof IlvCompositeGraphic) {
                ((IlvCompositeGraphic)this.b[i2]).doLayout();
            }
            this.a(i2);
        }
    }

    private void a(int n2) {
        if (this.b == null || this.b[n2] == null) {
            return;
        }
        IlvGraphic ilvGraphic = this.getGraphicBag(n2);
        if (ilvGraphic instanceof IlvCompositePart && ilvGraphic.getGraphicBag() != null) {
            ilvGraphic.getGraphicBag().applyToObject(ilvGraphic, this.w, this.b[n2], false);
        } else {
            this.w.apply(ilvGraphic, this.b[n2]);
        }
    }

    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        IlvGraphicBag ilvGraphicBag2 = this.getGraphicBag();
        if (ilvGraphicBag != ilvGraphicBag2) {
            IlvManagerSelectionDispatcher ilvManagerSelectionDispatcher;
            if (ilvGraphicBag2 != null && (ilvManagerSelectionDispatcher = IlvManagerSelectionDispatcher.Get(ilvGraphicBag2, false, IlvCompositeSelectionDispatcher.TEMPLATE)) != null) {
                ilvManagerSelectionDispatcher.notifyRemove();
            }
            if (ilvGraphicBag != null && (ilvManagerSelectionDispatcher = IlvManagerSelectionDispatcher.Get(ilvGraphicBag, true, IlvCompositeSelectionDispatcher.TEMPLATE)) != null) {
                ilvManagerSelectionDispatcher.notifyAdd();
            }
        }
        super.setGraphicBag(ilvGraphicBag);
        this.invalidate();
    }

    private void d() {
        if (this.b == null) {
            return;
        }
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.removeChild(i2);
        }
        this.b = null;
        this.c = null;
    }

    protected void removeChild(int n2) {
        final IlvGraphic ilvGraphic = this.b[n2];
        if (ilvGraphic == null) {
            return;
        }
        this.b[n2] = null;
        this.c[n2] = null;
        this.n.remove(ilvGraphic);
        if (ilvGraphic.getGraphicBag() == null) {
            return;
        }
        IlvGraphic ilvGraphic2 = this.getGraphicBag(n2);
        if (ilvGraphic2.getGraphicBag() == null) {
            ilvGraphic.getGraphicBag().removeObject(ilvGraphic, false);
        } else {
            ilvGraphic2.getGraphicBag().applyToObject(ilvGraphic2, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic2, Object object) {
                    ilvGraphic.getGraphicBag().removeObject(ilvGraphic, false);
                }
            }, null, true);
        }
    }

    protected IlvGraphic getGraphicBag(int n2) {
        return this;
    }

    protected int getLayers(int n2) {
        return -1;
    }

    private boolean b(int n2) {
        return this.getLayers(n2) == -1;
    }

    public IlvRect getAttachmentBounds() {
        if (this.a != null && !this.isValid()) {
            this.doLayout();
        }
        IlvRect ilvRect = null;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!ilvGraphic.isVisible() || ilvGraphic instanceof IlvCompositeGraphic && ((IlvCompositeGraphic)ilvGraphic).isEmpty()) continue;
            IlvRect ilvRect2 = ilvGraphic instanceof IlvAttachmentBounds ? ((IlvAttachmentBounds)((Object)ilvGraphic)).getAttachmentBounds() : (ilvGraphic instanceof IlvGeneralPath ? ((IlvGeneralPath)ilvGraphic).getShapeBounds(null) : (ilvGraphic instanceof IlvDefinitionRectInterface ? ((IlvDefinitionRectInterface)((Object)ilvGraphic)).getDefinitionRect() : ilvGraphic.boundingBox(null)));
            if (ilvRect == null) {
                ilvRect = ilvRect2;
                continue;
            }
            ilvRect.add(ilvRect2);
        }
        if (ilvRect == null) {
            ilvRect = new IlvRect();
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }

    public int addChild(IlvGraphic ilvGraphic) {
        int n2 = 0;
        if (this.b != null) {
            n2 = this.b.length;
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                if (this.b[i2] != null) continue;
                n2 = i2;
                break;
            }
        }
        this.setChildren(n2, ilvGraphic);
        return n2;
    }

    public IlvEventMap[] getEventMaps() {
        return this.g;
    }

    public void setEventMaps(IlvEventMap[] ilvEventMapArray) {
        this.g = ilvEventMapArray;
    }

    public void setEventMaps(int n2, IlvEventMap ilvEventMap) {
        if (n2 < 0) {
            throw new IllegalArgumentException("bad index range");
        }
        if (this.g == null) {
            this.g = new IlvEventMap[n2 + 1];
        } else if (n2 >= this.g.length) {
            IlvEventMap[] ilvEventMapArray = new IlvEventMap[n2 + 1];
            System.arraycopy(this.g, 0, ilvEventMapArray, 0, this.g.length);
            this.g = ilvEventMapArray;
        }
        this.g[n2] = ilvEventMap;
    }

    public IlvEventMap getEventMaps(int n2) {
        IlvEventMap ilvEventMap;
        if (this.g != null && n2 < this.g.length && (ilvEventMap = this.g[n2]) != null) {
            return ilvEventMap;
        }
        return new IlvEventMap();
    }

    public void setEventMap(IlvEventMap ilvEventMap) {
        this.h = ilvEventMap;
    }

    public IlvEventMap getEventMap() {
        if (this.h != null) {
            return this.h;
        }
        return new IlvEventMap();
    }

    public void selectionChanged(ManagerSelectionChangedEvent managerSelectionChangedEvent) {
    }

    public IlvGraphic getObject(String string) {
        String string2 = this.getName();
        if (string2 != null && string2.equals(string)) {
            return this;
        }
        IlvGraphic ilvGraphic = super.getObject(string);
        if (ilvGraphic != null) {
            return ilvGraphic;
        }
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        if (ilvGraphicArray != null) {
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                Object object;
                IlvGraphic ilvGraphic2 = ilvGraphicArray[i2];
                if (ilvGraphic2 == null) continue;
                if (ilvGraphic2 instanceof IlvGraphicBag) {
                    object = (IlvGraphicBag)((Object)ilvGraphic2);
                    ilvGraphic = object.getObject(string);
                    if (ilvGraphic == null) continue;
                    return ilvGraphic;
                }
                object = ilvGraphic2.getName();
                if (object == null || !((String)object).equals(string)) continue;
                return ilvGraphic2;
            }
        }
        return null;
    }

    public void setSelectionType(int n2) {
        this.j = n2;
    }

    public int getSelectionType() {
        return this.j;
    }

    public IlvSelection makeSelection() {
        if (this.a == null || !this.a.resizeFirstChildOnly()) {
            return super.makeSelection();
        }
        switch (this.j) {
            case 1: {
                return new IlvBaseBorderSelection(this);
            }
            case 2: {
                return new IlvInvisibleSelection(this);
            }
            case 0: {
                return new IlvBaseHandleSelection(this);
            }
            case 3: {
                return super.makeSelection();
            }
        }
        return super.makeSelection();
    }

    public Action getAction(int n2, IlvMouseGesture ilvMouseGesture) {
        IlvEventMap ilvEventMap = null;
        IlvEventMap[] ilvEventMapArray = this.getEventMaps();
        if (n2 > -1 && ilvEventMapArray != null && n2 < ilvEventMapArray.length) {
            ilvEventMap = ilvEventMapArray[n2];
        } else if (n2 == -1) {
            ilvEventMap = this.getEventMap();
        }
        if (ilvEventMap != null) {
            return ilvEventMap.getAction(ilvMouseGesture);
        }
        return null;
    }

    public boolean hasActions(int n2) {
        IlvPersistentObject ilvPersistentObject;
        if (n2 > -1 ? !((IlvGraphic)(ilvPersistentObject = this.getChildren(n2))).isVisible() : !this.isVisible()) {
            return false;
        }
        ilvPersistentObject = null;
        IlvEventMap[] ilvEventMapArray = this.getEventMaps();
        if (n2 > -1 && ilvEventMapArray != null && n2 < ilvEventMapArray.length) {
            ilvPersistentObject = ilvEventMapArray[n2];
        } else if (n2 == -1) {
            ilvPersistentObject = this.getEventMap();
        }
        if (ilvPersistentObject != null) {
            return !IlvCompositeGraphic.a(((IlvEventMap)ilvPersistentObject).getActions());
        }
        return false;
    }

    private static boolean a(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return IlvCompositeGraphic.a(this.b);
    }

    public IlvPoint getHotSpot() {
        if (this.b != null && this.b[0] instanceof IlvHotSpot) {
            return ((IlvHotSpot)((Object)this.b[0])).getHotSpot();
        }
        return null;
    }

    public void reshapeObject(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        super.reshapeObject(ilvGraphic, ilvRect, bl);
        this.invalidate();
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        Object[] objectArray;
        int n2;
        IlvGraphicVector ilvGraphicVector = this.list;
        this.list = new IlvGraphicVector();
        super.write(ilvOutputStream);
        this.list = ilvGraphicVector;
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        int n3 = n2 = ilvGraphicArray != null ? ilvGraphicArray.length : 0;
        if (ilvGraphicArray != null && n2 > 0) {
            objectArray = new IlvGraphic[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = ilvGraphicArray[i2] == null ? IlvEmptyPersistentGraphic.instance() : ilvGraphicArray[i2];
            }
            ilvOutputStream.write("children", (IlvGraphic[])objectArray);
        }
        if (this.a != null) {
            ilvOutputStream.write("layout", this.a);
        }
        if (ilvGraphicArray != null && (objectArray = this.getConstraints()) != null) {
            IlvPersistentObject[] ilvPersistentObjectArray = new IlvPersistentObject[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                ilvPersistentObjectArray[i3] = objectArray[i3] instanceof IlvPersistentObject ? (IlvPersistentObject)objectArray[i3] : IlvEmptyPersistentObject.instance();
            }
            ilvOutputStream.write("constraints", ilvPersistentObjectArray);
        }
        ilvOutputStream.write("selectionType", this.j);
        objectArray = this.getVisibilityThresholds();
        if (objectArray != null) {
            ilvOutputStream.write("visibilityThresholds", this.k);
        }
        if (this.l != null) {
            ilvOutputStream.write("linkClippables", this.l);
        }
        ilvOutputStream.write("resizingPolicy", this.m);
        ilvOutputStream.write("transformationMode", this.p);
        ilvOutputStream.write("sensitive", this.isSensitive());
    }

    public void setLinkClippables(boolean[] blArray) {
        if (this.l != blArray) {
            this.l = blArray;
        }
    }

    public boolean[] getLinkClippables() {
        return this.l;
    }

    public void setLinkClippables(int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("bad index range");
        }
        if (this.l == null) {
            this.l = new boolean[n2 + 1];
            for (int i2 = 0; i2 < this.l.length; ++i2) {
                this.l[i2] = true;
            }
        } else if (n2 >= this.l.length) {
            boolean[] blArray = new boolean[n2 + 1];
            for (int i3 = 0; i3 < blArray.length; ++i3) {
                blArray[i3] = true;
            }
            System.arraycopy(this.l, 0, blArray, 0, this.l.length);
            this.l = blArray;
        }
        this.l[n2] = bl;
    }

    public boolean getLinkClippables(int n2) {
        if (this.l != null && n2 < this.l.length) {
            return this.l[n2];
        }
        return true;
    }

    public void setVisibilityThresholds(double[] dArray) {
        if (this.k != dArray) {
            this.k = dArray;
            this.a();
        }
    }

    public double[] getVisibilityThresholds() {
        return this.k;
    }

    public void setVisibilityThresholds(int n2, double d2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("bad index range");
        }
        if (this.k == null) {
            this.k = new double[n2 + 1];
            for (int i2 = 0; i2 < this.k.length; ++i2) {
                this.k[i2] = 0.0;
            }
        } else if (n2 >= this.k.length) {
            double[] dArray = new double[n2 + 1];
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                dArray[i3] = 0.0;
            }
            System.arraycopy(this.k, 0, dArray, 0, this.k.length);
            this.k = dArray;
        }
        this.k[n2] = d2;
        this.a();
    }

    public double getVisibilityThresholds(int n2) {
        if (this.k != null && n2 < this.k.length) {
            return this.k[n2];
        }
        return 0.0;
    }

    public IlvAttachableGraphic getAttachableGraphic(IlvGraphic ilvGraphic) {
        IlvAttachableGraphic ilvAttachableGraphic = (IlvAttachableGraphic)this.n.get(ilvGraphic);
        if (ilvAttachableGraphic != null) {
            return ilvAttachableGraphic;
        }
        ilvAttachableGraphic = new IlvAttachableGraphic(ilvGraphic, this);
        this.n.put(ilvGraphic, ilvAttachableGraphic);
        return ilvAttachableGraphic;
    }

    public void setLabel(String string) {
        IlvLabelInterface ilvLabelInterface = this.b(this);
        if (ilvLabelInterface == null) {
            return;
        }
        ilvLabelInterface.setLabel(string);
        this.a();
    }

    public String getLabel() {
        IlvLabelInterface ilvLabelInterface = this.b(this);
        if (ilvLabelInterface == null) {
            return null;
        }
        return ilvLabelInterface.getLabel();
    }

    public boolean supportMultiline() {
        IlvLabelInterface ilvLabelInterface = this.b(this);
        if (ilvLabelInterface != null) {
            return ilvLabelInterface.supportMultiline();
        }
        return false;
    }

    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        IlvLabelInterface ilvLabelInterface = this.b(this);
        if (ilvLabelInterface != null) {
            return ilvLabelInterface.getLabelBBox(ilvTransformer);
        }
        return null;
    }

    private IlvLabelInterface b(IlvComposite ilvComposite) {
        IlvGraphic[] ilvGraphicArray = ilvComposite.getChildren();
        if (ilvGraphicArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
            IlvLabelInterface ilvLabelInterface;
            if (ilvGraphicArray[i2] == null) continue;
            if (ilvGraphicArray[i2] instanceof IlvLabelInterface) {
                return (IlvLabelInterface)((Object)ilvGraphicArray[i2]);
            }
            if (!(ilvGraphicArray[i2] instanceof IlvComposite) || (ilvLabelInterface = this.b((IlvComposite)((Object)ilvGraphicArray[i2]))) == null) continue;
            return ilvLabelInterface;
        }
        return null;
    }

    public void setTransformationMode(int n2) {
        this.p = n2;
    }

    public int getTransformationMode() {
        return this.p;
    }

    public void rotate(IlvPoint ilvPoint, double d2) {
        this.e();
        super.rotate(ilvPoint, d2);
        this.validate();
    }

    private void e() {
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        if (ilvGraphicArray != null) {
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                if (!(ilvGraphicArray[i2] instanceof IlvCompositeGraphic)) continue;
                ((IlvCompositeGraphic)ilvGraphicArray[i2]).e();
            }
        }
        if (this.getTransformationMode() != 1) {
            this.setTransformationMode(1);
            this.setResizingPolicy(0);
        }
    }

    public IlvRect getDefinitionRect() {
        return this.getAttachmentBounds();
    }

    public void setDefinitionRect(IlvRect ilvRect) {
        this.moveResize(ilvRect);
    }

    public IlvTransformer getDefinitionTransformer() {
        return null;
    }

    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        if (ilvGraphicArray != null) {
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                IlvGraphic ilvGraphic = ilvGraphicArray[i2];
                if (ilvGraphic == null || !ilvGraphic.isVisible()) continue;
                return true;
            }
        }
        return false;
    }

    public static IlvRect getAttachmentBounds(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvAttachmentBounds) {
            return ((IlvAttachmentBounds)((Object)ilvGraphic)).getAttachmentBounds();
        }
        if (ilvGraphic instanceof IlvGeneralPath) {
            return ((IlvGeneralPath)ilvGraphic).getShapeBounds(null);
        }
        if (ilvGraphic instanceof IlvDefinitionRectInterface) {
            return ((IlvDefinitionRectInterface)((Object)ilvGraphic)).getDefinitionRect();
        }
        return ilvGraphic.boundingBox();
    }

    public void setSensitive(boolean bl) {
        this.q = bl;
    }

    public boolean isSensitive() {
        return this.q;
    }

    public static void setJViews80BoundingBoxCompatibility(boolean bl) {
        s = bl;
    }

    public static boolean isJViews80BoundingBoxCompatibility() {
        return s;
    }
}

