/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.internal;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.internal.IlvLineSegment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class IlvPolyPoints
implements Serializable {
    protected int _numsegments = 0;
    protected IlvLineSegment[] _segments = null;
    protected IlvPoint[] _points = null;
    static final long serialVersionUID = -3050828890023879427L;

    protected IlvPolyPoints() {
    }

    public int getNumberOfSegments() {
        return this._numsegments;
    }

    public IlvLineSegment getSegment(int n2) {
        return this._segments[n2];
    }

    public IlvLineSegment[] getSegments() {
        return this._segments;
    }

    public abstract int getNumberOfPoints();

    public IlvPoint getPoint(int n2) {
        return this._points[n2];
    }

    public IlvPoint[] getPoints() {
        return this._points;
    }

    public IlvPoint[] getPointsCloned() {
        int n2 = this._points.length;
        IlvPoint[] ilvPointArray = new IlvPoint[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ilvPointArray[i2] = (IlvPoint)this._points[i2].clone();
        }
        return ilvPointArray;
    }

    public int getClosestSegment(IlvPoint ilvPoint) {
        if (this._numsegments <= 0) {
            throw new Error("cannot call getClosestSegment() on empty IlvPolyPoints");
        }
        float f2 = 1.0E35f;
        int n2 = 0;
        for (int i2 = 0; i2 < this._numsegments; ++i2) {
            float f3 = this._segments[i2].sqdist(ilvPoint);
            if (!(f3 < f2)) continue;
            f2 = f3;
            n2 = i2;
        }
        return n2;
    }

    public Rectangle getBounds() {
        int n2 = this.getNumberOfPoints();
        if (n2 == 0) {
            return null;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvPoint ilvPoint = this._points[i2];
            if ((float)n3 > ilvPoint.x) {
                n3 = (int)Math.floor(ilvPoint.x);
            }
            if ((float)n4 < ilvPoint.x) {
                n4 = (int)Math.ceil(ilvPoint.x);
            }
            if ((float)n5 > ilvPoint.y) {
                n5 = (int)Math.floor(ilvPoint.y);
            }
            if (!((float)n6 < ilvPoint.y)) continue;
            n6 = (int)Math.ceil(ilvPoint.y);
        }
        return new Rectangle(n3, n5, n4 - n3, n6 - n5);
    }

    public Rectangle2D getBounds2D() {
        int n2 = this.getNumberOfPoints();
        if (n2 == 0) {
            return null;
        }
        float f2 = 1.0E35f;
        float f3 = -1.0E35f;
        float f4 = 1.0E35f;
        float f5 = -1.0E35f;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvPoint ilvPoint = this._points[i2];
            if (f2 > ilvPoint.x) {
                f2 = ilvPoint.x;
            }
            if (f3 < ilvPoint.x) {
                f3 = ilvPoint.x;
            }
            if (f4 > ilvPoint.y) {
                f4 = ilvPoint.y;
            }
            if (!(f5 < ilvPoint.y)) continue;
            f5 = ilvPoint.y;
        }
        return new IlvRect(f2, f4, f3 - f2, f5 - f4);
    }

    public IlvPoint getGravity0() {
        int n2 = this.getNumberOfPoints();
        if (n2 <= 0) {
            throw new Error("cannot call getGravity0() on empty IlvPolyPoints");
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvPoint ilvPoint = this._points[i2];
            f2 += ilvPoint.x;
            f3 += ilvPoint.y;
        }
        return new IlvPoint(f2 / (float)n2, f3 / (float)n2);
    }

    public IlvPoint getGravity1() {
        int n2 = this.getNumberOfSegments();
        if (n2 <= 0) {
            throw new Error("cannot call getGravity1() on empty IlvPolyPoints");
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvLineSegment ilvLineSegment = this._segments[i2];
            float f5 = ilvLineSegment.length();
            f2 += (ilvLineSegment.getFrom().x + ilvLineSegment.getTo().x) * f5;
            f3 += (ilvLineSegment.getFrom().y + ilvLineSegment.getTo().y) * f5;
            f4 += f5;
        }
        if ((double)f4 >= 1.0E-10) {
            f4 = 2.0f * f4;
            return new IlvPoint(f2 / f4, f3 / f4);
        }
        return this.getGravity0();
    }

    public abstract PointAndDirection getMedian();

    public abstract TwoPolylines computeThickLinkShape(float var1);

    public abstract void setNumberOfSegments(int var1);

    public abstract void setSegment(int var1, IlvPoint var2, IlvPoint var3);

    public abstract void applyTransform(IlvTransformer var1);

    public abstract void reverse();

    public abstract void insertPoint(int var1, IlvPoint var2);

    public abstract void insertPoint(IlvPoint var1);

    public abstract void movePoint(int var1, IlvPoint var2);

    public abstract void removePoint(int var1);

    public abstract void removeRedundantPoints();

    static boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
        if (ilvPoint.x == ilvPoint3.x) {
            return ilvPoint.x == ilvPoint2.x && (ilvPoint.y <= ilvPoint2.y && ilvPoint2.y <= ilvPoint3.y || ilvPoint.y >= ilvPoint2.y && ilvPoint2.y >= ilvPoint3.y);
        }
        if (ilvPoint.y == ilvPoint3.y) {
            return ilvPoint.y == ilvPoint2.y && (ilvPoint.x <= ilvPoint2.x && ilvPoint2.x <= ilvPoint3.x || ilvPoint.x >= ilvPoint2.x && ilvPoint2.x >= ilvPoint3.x);
        }
        return (ilvPoint.x - ilvPoint2.x) * (ilvPoint3.y - ilvPoint2.y) == (ilvPoint.y - ilvPoint2.y) * (ilvPoint3.x - ilvPoint2.x) && (ilvPoint.x <= ilvPoint2.x && ilvPoint2.x <= ilvPoint3.x || ilvPoint.x >= ilvPoint2.x && ilvPoint2.x >= ilvPoint3.x) && (ilvPoint.y <= ilvPoint2.y && ilvPoint2.y <= ilvPoint3.y || ilvPoint.y >= ilvPoint2.y && ilvPoint2.y >= ilvPoint3.y);
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            IlvPolyPoints ilvPolyPoints = (IlvPolyPoints)object;
            if (this.getNumberOfSegments() == ilvPolyPoints.getNumberOfSegments()) {
                IlvPoint[] ilvPointArray = ilvPolyPoints.getPoints();
                int n2 = this._points.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this._points[i2].equals(ilvPointArray[i2])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n2 = this._points.length;
        int n3 = -n2 << 3;
        int n4 = this.getClass().hashCode();
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += Float.floatToIntBits(this._points[i2].x);
            n4 += Float.floatToIntBits(this._points[i2].y);
        }
        return n3 + (n4 << 1);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(2);
        if (this._points == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this._points.length);
            for (int i2 = 0; i2 < this._points.length; ++i2) {
                objectOutputStream.writeObject(this._points[i2]);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte by = objectInputStream.readByte();
        if (by == 1) {
            this._points = (IlvPoint[])objectInputStream.readObject();
        } else if (by == 2) {
            this._points = new IlvPoint[objectInputStream.readInt()];
            for (int i2 = 0; i2 < this._points.length; ++i2) {
                this._points[i2] = (IlvPoint)objectInputStream.readObject();
            }
        } else {
            throw new InvalidClassException("Unsupported version " + by + " in readObject of class " + this.getClass());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        int n2 = this._points.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append("-");
            }
            stringBuffer.append("(");
            stringBuffer.append(this._points[i2].x);
            stringBuffer.append(",");
            stringBuffer.append(this._points[i2].y);
            stringBuffer.append(")");
        }
        if (this.getNumberOfSegments() == n2) {
            stringBuffer.append("-");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static class PointAndDirection {
        public IlvPoint point;
        public int direction;
        public float slope;

        PointAndDirection(IlvPoint ilvPoint, int n2, float f2) {
            this.point = ilvPoint;
            this.direction = n2;
            this.slope = f2;
        }

        public String toString() {
            return this.getClass().getName() + "[point=(" + this.point.x + "," + this.point.y + "), direction=" + this.direction + ", slope=" + this.slope + "]";
        }
    }

    public static class TwoPolylines {
        public IlvPolyPoints leftparallel;
        public IlvPolyPoints rightparallel;

        TwoPolylines(IlvPolyPoints ilvPolyPoints, IlvPolyPoints ilvPolyPoints2) {
            this.leftparallel = ilvPolyPoints;
            this.rightparallel = ilvPolyPoints2;
        }

        public String toString() {
            return this.getClass().getName() + "[leftparallel=" + this.leftparallel + ", rightparallel=" + this.rightparallel + "]";
        }
    }
}

